﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_CatalogoCajasController :  BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SistemaArchivos_CatalogoCajas
        public ActionResult Index()
        {
            return View(db.ArchivoConcentracion_ctCajas.OrderByDescending(x=> x.IdCaja).ToList());
        }

        // GET: SistemaArchivos_CatalogoCajas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctCajas archivoConcentracion_ctCajas = db.ArchivoConcentracion_ctCajas.Find(id);
            if (archivoConcentracion_ctCajas == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctCajas);
        }

        // GET: SistemaArchivos_CatalogoCajas/Create
        public ActionResult Create()
        {
           
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoCajas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdCaja,Caja")] ArchivoConcentracion_ctCajas archivoConcentracion_ctCajas)
        {



           

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ctCajas.Where(g => g.IdCaja == archivoConcentracion_ctCajas.IdCaja).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                                                   
                            db.ArchivoConcentracion_ctCajas.Add(archivoConcentracion_ctCajas);
                            db.SaveChanges();

                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        
                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoCajas/Edit/5
        public ActionResult Edit(int id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctCajas archivoConcentracion_ctCajas = db.ArchivoConcentracion_ctCajas.Find(id);
            if (archivoConcentracion_ctCajas == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctCajas);
        }

        // POST: SistemaArchivos_CatalogoCajas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCaja,Caja")] ArchivoConcentracion_ctCajas archivoConcentracion_ctCajas)
        {
           

            if (ModelState.IsValid)
            {

                try
                {

                    
                        db.Entry(archivoConcentracion_ctCajas).State = EntityState.Modified;
                        db.SaveChanges();

                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoCajas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ctCajas archivoConcentracion_ctCajas = db.ArchivoConcentracion_ctCajas.Find(id);
            if (archivoConcentracion_ctCajas == null)
            {
                return HttpNotFound();
            }
            return View(archivoConcentracion_ctCajas);
        }

        // POST: SistemaArchivos_CatalogoCajas/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ArchivoConcentracion_ctCajas archivoConcentracion_ctCajas = db.ArchivoConcentracion_ctCajas.Find(id);
            db.ArchivoConcentracion_ctCajas.Remove(archivoConcentracion_ctCajas);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
