﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;

namespace Nova.Controllers.Kardex
{
    public class Kardex_SolicitudesContratoController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";


        string queryexpediente = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";

        string queryseguimiento = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral 
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral) z on  x.IdKardex= z.IdKardex";



        string queryubicacionfisica = @"SELECT EstructuraOrganica FROM bdNova.dbo.Catalogos_ctEstructuraOrganica
                                        WHERE EsVigente= 1";

        string queryrelacionlaboral = @" SELECT RelacionConvenioLaboral FROM bdNova.dbo.Convenios_stRelacionConvenioLaboral";





        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            //dp.Close();
            return View(kardex_GradoAcademico.ToList()); 
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        public ActionResult Details()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
            string query = string.Format(@"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, n.EstructuraOrganica as EstructuraOrganicaAdscripcion, p.Categoria, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
											g.AreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,
											m.Nombre as NombreCubrir, m.ApellidoPaterno as ApellidoPaternoCubrir,  m.ApellidoMaterno  as ApellidoMaternoCubrir,
                                             m.Categoria as CategoriaCubrir, a.NumeroOficio, q.EsAceptable, w.RelacionLaboral, a.Observaciones,b.Curp,m.TelefonoCelular,ka.IdTrabajador,
                                             (SELECT  top 1 zz.NivelEstudioDescripcion FROM Kardex_GradoAcademico zz
												INNER JOIN  Kardex_NivelEstudio yy on zz.IdKardexNivelEstudio = yy.IdKardexNivelEstudio
												where zz.Idkardex = a.IdKardexCandidato
											    order by Orden desc) as NivelEstudio
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion q on a.IdKardexCandidato = q.IdKardex and q.IdAreaConocimiento = a.IdAreaConocimiento
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
                                            left join  Kardex_ctTrabajador ka on b.IdKardex= ka.IdKardex
											inner join  Catalogos_ctEstructuraOrganica n on a.IdEstructuraOrganicaAdscripcion= n.IdEstructuraOrganica
											inner join  Plazas_ctCategoria p on a.IdCategoriaAspirante = p .IdCategoria 
											left join  vwDatosAspirantesTrabajadores m on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = m.IdConvenioLaboralTrabajadorCategoria 
											inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
                                            where  a.CicloEscolar = '{0}'", CicloEscolar);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosContratos = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            string querycicloescolar = @" select CicloEscolar from Kardex_SolicitudEvaluaciones
                                            group by CicloEscolar";

            var ciclosescolares = (List<TodosCiclosEscolares>)dp.connection.Query<TodosCiclosEscolares>(querycicloescolar);

            IEnumerable<SelectListItem> selectList = from s in ciclosescolares
                                                     select new SelectListItem
                                                     {
                                                         Value = s.CicloEscolar.ToString(),
                                                         Text = s.CicloEscolar
                                                     };

            if (selectList.Count() > 0)
            {
                var ciclos = selectList.Where(x => x.Value == CicloEscolar).FirstOrDefault();

                if (ciclos == null)
                {
                    ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text");
                }

                else
                {
                    ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text", selectList.Where(x => x.Value == CicloEscolar).FirstOrDefault().Value);
                }
            }
            else { ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text"); }



            dp.Close();
            return View(kardex_DatosContratos);
        }
        public ActionResult SolicitudesXls(string IdCicloEscolar)
        //String[] proyectos,
        {
            string Filtro = string.Empty;



            if (IdCicloEscolar != "")
            {
                Filtro = "where a.CicloEscolar ='" + IdCicloEscolar + "'";
            }
            if (IdCicloEscolar == "")
            {
                Filtro = "";
            }


            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            string query = string.Format(@"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, n.EstructuraOrganica as EstructuraOrganicaAdscripcion, p.Categoria, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
											g.AreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,
											m.Nombre as NombreCubrir, m.ApellidoPaterno as ApellidoPaternoCubrir,  m.ApellidoMaterno  as ApellidoMaternoCubrir,
                                             m.Categoria as CategoriaCubrir, a.NumeroOficio, q.EsAceptable, w.RelacionLaboral, a.Observaciones,b.CURP,m.TelefonoCelular,ka.IdTrabajador,
                                             (SELECT  top 1 zz.NivelEstudioDescripcion FROM Kardex_GradoAcademico zz
												INNER JOIN  Kardex_NivelEstudio yy on zz.IdKardexNivelEstudio = yy.IdKardexNivelEstudio
												where zz.Idkardex = a.IdKardexCandidato
											    order by Orden desc) as NivelEstudio
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion q on a.IdKardexCandidato = q.IdKardex and q.IdAreaConocimiento = a.IdAreaConocimiento
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
                                            left join  Kardex_ctTrabajador ka on b.IdKardex= ka.IdKardex
											inner join  Catalogos_ctEstructuraOrganica n on a.IdEstructuraOrganicaAdscripcion= n.IdEstructuraOrganica
											inner join  Plazas_ctCategoria p on a.IdCategoriaAspirante = p .IdCategoria 
											left join  vwDatosAspirantesTrabajadores m on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = m.IdConvenioLaboralTrabajadorCategoria 
											inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
                                            " + Filtro + " order by a.IdKardexSolicitudEvaluacion DESC ");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var result = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);


            string modalidad = "Reporte" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }


        public ActionResult Evaluacion(int? IdKardex)
        {
            var DatosTrabajador = db.Kardex_ctDatosPersonales.Where(a => a.IdKardex == IdKardex);


            ViewBag.NombreCompleto = DatosTrabajador.FirstOrDefault().Nombre + ' ' + DatosTrabajador.FirstOrDefault().ApellidoPaterno + ' ' + DatosTrabajador.FirstOrDefault().ApellidoMaterno;

            

            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string query;

            query = @" select top 10 IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno , Telefono,CorreoElectronico from  vwDatosAspirantesTrabajadores
                                 where EstatusTrabajador = 'ALTA' and  IdModalidadEstudio>0 and ConvenioLaboral='BASE'";
            var Trabajadores = (List<TrabajadoresEvaluaciones>)dpcg.connection.Query<TrabajadoresEvaluaciones>(query);

            dpcg.Close();

            ViewBag.IdTipoSuplencia = new SelectList(db.Nomina_SuplenciaTipo, "IdTipoSuplencia", "TipoSuplencia");
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(a => a.EsVigente == true && a.IdModalidadEstudio > 0), "IdEstructuraOrganica", "EstructuraOrganica");
            

            IEnumerable<SelectListItem> selectList = from s in Trabajadores
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdConvenioLaboralTrabajadorCategoria.ToString(),
                                                         Text = s.Nombre.ToString() + ' ' + s.ApellidoPaterno + ' ' + s.ApellidoMaterno
                                                     };
            ViewBag.IdConvenioLaboralTrabajadorCategoriaaCubrir = new SelectList(selectList, "Value", "Text");
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;

            return PartialView();
        }


        [HttpPost]
        public ActionResult SolicitudesCandidatos(string IdCicloEscolar)
        {

            string Filtro = string.Empty;



            if (IdCicloEscolar != "" )
            {
                Filtro = "where a.CicloEscolar ='" + IdCicloEscolar + "'";
            }
           if (IdCicloEscolar == "")
            {
                Filtro = "";
            }


            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string querybuscar = @" select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, n.EstructuraOrganica as EstructuraOrganicaAdscripcion, p.Categoria, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
											g.AreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,
											m.Nombre as NombreCubrir, m.ApellidoPaterno as ApellidoPaternoCubrir,  m.ApellidoMaterno  as ApellidoMaternoCubrir,
                                             m.Categoria as CategoriaCubrir, a.NumeroOficio, q.EsAceptable, w.RelacionLaboral, a.Observaciones
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion q on a.IdKardexCandidato = q.IdKardex and q.IdAreaConocimiento = a.IdAreaConocimiento
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
											inner join  Catalogos_ctEstructuraOrganica n on a.IdEstructuraOrganicaAdscripcion= n.IdEstructuraOrganica
											inner join  Plazas_ctCategoria p on a.IdCategoriaAspirante = p .IdCategoria 
											left join  vwDatosAspirantesTrabajadores m on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = m.IdConvenioLaboralTrabajadorCategoria 
											inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
                                            " + Filtro + " order by a.IdKardexSolicitudEvaluacion DESC ";

            var DatosTrabajador = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(querybuscar, new { IdCicloEscolar });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdCicloEscolar = IdCicloEscolar;
            dp.Close();
            return View(DatosTrabajador);
        }



        public ActionResult VerDetails(int id)
        {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryexpediente);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = id;
            dp.Close();
            var Expediente = kardex_DocumentosExpediente.Where(z => z.IdKardex == id);

            ViewBag.NombreTrabajador = Expediente.FirstOrDefault().Nombre + " " + Expediente.FirstOrDefault().ApellidoPaterno + " " + Expediente.FirstOrDefault().ApellidoMaterno;
                
            return View(Expediente);
            //return View(kardex_DocumentosExpediente.Where(z => z.IdKardex == IdKardex));
        }






        public ActionResult Expedientes()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            var ubicacionfisica = (List<UbicacionSeguimiento>)dp.connection.Query<UbicacionSeguimiento>(queryubicacionfisica);

            IEnumerable<SelectListItem> selectList = from s in ubicacionfisica
                                                     select new SelectListItem
                                                     {
                                                         Value = s.EstructuraOrganica.ToString(),
                                                         Text = s.EstructuraOrganica
                                                     };
            ViewBag.IdUbicacionFisica = new SelectList(selectList, "Value", "Text");

            var relacionlaboral = (List<RelacionLaboralSeguimiento>)dp.connection.Query<RelacionLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaboral
                                                     select new SelectListItem
                                                     {
                                                         Value = s.RelacionConvenioLaboral.ToString(),
                                                         Text = s.RelacionConvenioLaboral
                                                     };
            ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");






            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        public ActionResult ExpedientesCentro()
        {
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            int idcltc = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            short? idModalidad = new bdNovaEntities().vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == IdKardex).FirstOrDefault().IdModalidadEstudio;
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idcltc);
            int nivel = (short)convenio.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.OrdenEstructuraOrganica;
            if (idModalidad == 0 && nivel < 5 || idModalidad > 0 && nivel < 11)
            {
         
                 //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
                //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
                ViewBag.Controlador = "KardexGradoAcademico";
                ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
                ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
                ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
                //ViewBag.IdKardex = id;

                string UbicacionFisica = kardex_DocumentosExpedienteSeguimiento.Where(x => x.IdKardex == IdKardex).FirstOrDefault().UbicacionFisica;
                ViewBag.IdKardex = IdKardex;

                var ubicacionfisica = (List<UbicacionSeguimiento>)dp.connection.Query<UbicacionSeguimiento>(queryubicacionfisica);

                IEnumerable<SelectListItem> selectList = from s in ubicacionfisica.Where(z => z.EstructuraOrganica == UbicacionFisica)
                                                         select new SelectListItem
                                                         {
                                                             Value = s.EstructuraOrganica.ToString(),
                                                             Text = s.EstructuraOrganica
                                                         };
                ViewBag.IdUbicacionFisica = new SelectList(selectList, "Value", "Text");

                var relacionlaboral = (List<RelacionLaboralSeguimiento>)dp.connection.Query<RelacionLaboralSeguimiento>(queryrelacionlaboral);

                IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaboral
                                                                 select new SelectListItem
                                                                 {
                                                                     Value = s.RelacionConvenioLaboral.ToString(),
                                                                     Text = s.RelacionConvenioLaboral
                                                                 };
                ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");






                dp.Close();
            }
            else { throw new Exception("El usaurio no tiene los permisos necesarios"); }

            return View(kardex_DocumentosExpedienteSeguimiento);
        }



        public ActionResult SeguimientoExpedientes()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        [HttpPost]
        public ActionResult ExpedientesTrabajadores(string IdUbicacionFisica, string IdRelacionLaboral)
        {
            
            string Filtro = string.Empty;



            if (IdUbicacionFisica != "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica != "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral == "")
            {
                Filtro = "" ;
            }


            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string querybuscar = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, x.Sexo, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral,a.Sexo    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral, a.Sexo)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral ,b.Sexo
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral,b.Sexo) z on  x.IdKardex= z.IdKardex
                                    " + Filtro + " order by x.IdKardex DESC ";




            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querybuscar, new { IdUbicacionFisica, IdRelacionLaboral });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        [HttpPost]
        public ActionResult ExpedientesTrabajadoresCentro(string IdUbicacionFisica, string IdRelacionLaboral)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            string UbicacionFisica = kardex_DocumentosExpediente.Where(x => x.IdKardex == IdKardex).FirstOrDefault().UbicacionFisica;

            string Filtro = string.Empty;



            if (IdUbicacionFisica != "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + UbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
                
            }
            if (IdUbicacionFisica != "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + UbicacionFisica + "'";
            }


            
            
            string querybuscar = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, x.Sexo, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral, a.Sexo    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral, a.Sexo)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral ,b.Sexo
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral,b.Sexo) z on  x.IdKardex= z.IdKardex
                                  " + Filtro + " order by x.IdKardex DESC ";


            
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querybuscar, new { IdUbicacionFisica, IdRelacionLaboral });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        // GET: KardexGradoAcademico/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

             string querytipodocumento;

            querytipodocumento = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral and Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                 from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";
            var todastipodocumento = (List<Kardex_TipoDocumento>)dpcg.connection.Query<Kardex_TipoDocumento>(querytipodocumento, new { IdConvenioLaboral, IdKardex });

            dpcg.Close();
            
            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumento, "IdKardexTipoDocumento", "DocumentoExpediente");
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar");
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente,int IdCicloEscolar, HttpPostedFileBase upload)
        {


            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademicoFotografia.AbreviaturaProfesion = kardex_GradoAcademicoFotografia.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademicoFotografia.NivelEstudioDescripcion = kardex_GradoAcademicoFotografia.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;

            //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            if (ModelState.IsValid)
            {

                //var RegistrosRepetidos = db.Kardex_DocumentosExpediente.Where(g => g.IdKardexDocumentosExpediente == kardex_DocumentosExpediente.IdKardexDocumentosExpediente).ToArray();
                //int valor = RegistrosRepetidos.Count();
                //if (valor > 0)
                //{


                //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                //}

            

                //else
                //{
                                       
                    try
                    {
                        if (upload != null && upload.ContentLength > 0)

                        {

                            byte[] imagenData = null;
                            string tipoarchivo = "";
                            using (var binaryArchivo = new BinaryReader(upload.InputStream))
                            {
                                imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                                tipoarchivo = upload.ContentType;
                            }
                            //kardex_GradoAcademicoFotografia.Archivo = imagenData;
                            //kardex_GradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                            //kardex_GradoAcademicoFotografia.NombreArchivo = upload.FileName;

                       
                            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                                //Escribir Datos de los archivos
                                    string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar) " +
                                     "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "')";


                                var rowsAffectedDoc=  dp.connection.Execute(sqlQueryDoc);

                                string sql = @"SELECT Max(IdKardexDocumentosExpediente)
                                                FROM bdNova.dbo.Kardex_DocumentosExpediente";
                                int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                                //Escribir archivo 

                                string sql01 = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                     "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";

                                DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));
                               
                                var parameters = new {IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo= upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = idKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sql01, parameters);

                               

                                dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }
                       
                        else 
                        {
                            
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                            //Escribir Datos de los archivos
                            string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar) " +
                             "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "')";
                            var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                            dp.Close();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        }
                       
                        
                    }

                    
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }






        public FileResult VerInfo(int idgradoacademico)
        {
            var archivosanexo = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == idgradoacademico).FirstOrDefault();

            if (archivosanexo.TipoDocumento == "application/pdf")
            {
                return File(archivosanexo.Archivo, "application/pdf");

            }
            else if (archivosanexo.TipoDocumento == "application/msword")
            {
                return File(archivosanexo.Archivo, "application/msword");
            }

            else if (archivosanexo.TipoDocumento == "image/jpeg")
            {
                return File(archivosanexo.Archivo, "image/jpeg");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.ms-excel")
            {
                return File(archivosanexo.Archivo, "application/vnd.ms-excel");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }

            return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }


        public FileResult DescargarInfo(int idkardexdocumentosexpedientetrabajador)
        {
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string queryexpedientetrabajador;

            queryexpedientetrabajador = @"select* from bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
            where bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador.IdKardexDocumentosExpedienteTrabajador = @idkardexdocumentosexpedientetrabajador";
            var todosexpedientes = (List<Kardex_DocumentosExpedienteTrabajador>)dpcg.connection.Query<Kardex_DocumentosExpedienteTrabajador>(queryexpedientetrabajador, new { idkardexdocumentosexpedientetrabajador });
            dpcg.Close();

            if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/pdf")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/pdf", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".pdf");

            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/msword")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/msword", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".doc");
            }

            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "image/jpeg")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "image/jpeg", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".jpg");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.ms-excel")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.ms-excel", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xls");
            }


            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/octet-stream")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/octet-stream", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".zip");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".docx");
            }
            
            return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xlsx");

            //string modalidad = "Poa_Mir" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


        }

        // GET: KardexGradoAcademico/Edit/5
        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
                        where a.IdKardex = {0}
                        ", IdKardex);
          
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexDocumentosExpediente = id;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
    
            string querytipodocumento;

            querytipodocumento = @"Select * from (Select * from bdNova.dbo.Kardex_TipoDocumento Tp
                                     where Tp.IdKardexTipoDocumento in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                           from bdNova.dbo.Kardex_DocumentosExpediente )) a
                                    inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardexTipoDocumento = b.IdKardexTipoDocumento
                                    where b.IdKardex=@IdKardex";

            var todastipodocumento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querytipodocumento, new { IdKardex });

            int TipoDocumento = todastipodocumento.Where(z=> z.IdKardexDocumentosExpediente== id).FirstOrDefault().IdKardexTipoDocumento;


            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumentos;

            //querytipodocumento = @"Select * from bdNova.dbo.Kardex_TipoDocumento Tp where 
            //                     Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                     from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            querytipodocumentos = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral ";


            var todastipodocumentos = (List<Kardex_TipoDocumento>)dp.connection.Query<Kardex_TipoDocumento>(querytipodocumentos, new { IdConvenioLaboral });




            string queryciclo;

            queryciclo = @"select a.IdCicloEscolar, b.CicloEscolar from bdCtlEscSeg.dbo.ctCicloescolar a
                            inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.Nombre=b.CicloEscolar
                            where b.IdKardexDocumentosExpediente=@id";

            var todasciclo = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryciclo, new { id });

            int idciclo = todasciclo.FirstOrDefault().IdCicloEscolar;



            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            var valorkardex_DocumentosExpediente = kardex_DocumentosExpediente.Where(z=> z.IdKardex==id).FirstOrDefault();
            if (kardex_DocumentosExpediente == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_GradoAcademico.IdKardex);
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumentos.ToList(), "IdKardexTipoDocumento", "DocumentoExpediente", todastipodocumentos.Where(x=> x.IdKardexTipoDocumento == TipoDocumento).FirstOrDefault().IdKardexTipoDocumento);
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar", Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(a=> a.IdCicloEscolar == idciclo).FirstOrDefault().IdCicloEscolar);
            dp.Close();
            return PartialView();
        
            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente, int IdCicloEscolar, HttpPostedFileBase upload)
        {
                string msj = "El Grado académico ha sido editado existosamente!";
          
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademico.AbreviaturaProfesion=kardex_GradoAcademico.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademico.NivelEstudioDescripcion=kardex_GradoAcademico.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;
            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

            if (ModelState.IsValid)
            {
             
                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
                        //kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;


                           using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos
                                    

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = "+ IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar+"' WHERE IdKardexDocumentosExpediente = "+ kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            
                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);
                         


                            string sql = @"SELECT IdKardexDocumentosExpediente
                                           FROM bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
										   where IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                            ////Escribir archivo 
                            
                            if (idKardexDocumentosExpediente != 0)
                            {
                                var rowsAffectedDocFile = dp.connection.Execute("UPDATE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador SET IdKardex=@IdKardex, Archivo= @Archivo, TipoDocumento = @TipoDocumento, NombreArchivo=@NombreArchivo, FechaRegistro=@FechaRegistro, IdKardexDocumentosExpediente=@IdKardexDocumentosExpediente WHERE IdKardexDocumentosExpediente = @IdKardexDocumentosExpediente01", new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente, IdKardexDocumentosExpediente01 = kardex_DocumentosExpediente.IdKardexDocumentosExpediente });
                            }
                            else
                            {
                                string sqlinsert = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                   "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";                                

                                var parameters = new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sqlinsert, parameters);

                            }
                            
                            


                            dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }

                    else 
                    {
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = " + IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar + "' WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);


                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });
                        }

                            


                    }
                       
                   
                       
                        
                    }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    Kardex_SolicitudEvaluaciones kardex_solicitudeval = db.Kardex_SolicitudEvaluaciones.Find(id);
                    db.Kardex_SolicitudEvaluaciones.Remove(kardex_solicitudeval);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
