﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;
using DevExpress.XtraSpreadsheet.Import.Xls;
using DotNet.Highcharts.Helpers;
using Nova.Libraries;


namespace Nova.Controllers.Kardex
{
    public class Kardex_SolicitudEvaluacionesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";


        string queryexpediente = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";

        string queryseguimiento = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral 
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral) z on  x.IdKardex= z.IdKardex";



        string queryubicacionfisica = @"SELECT EstructuraOrganica FROM bdNova.dbo.Catalogos_ctEstructuraOrganica
                                        WHERE EsVigente= 1";

        string queryrelacionlaboral = @" SELECT RelacionConvenioLaboral FROM bdNova.dbo.Convenios_stRelacionConvenioLaboral";





        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            //dp.Close();
            return View(kardex_GradoAcademico.ToList()); 
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        public ActionResult Details()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"  select top 10 IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno ,CURP, TelefonoCelular,CorreoElectronico, 
                                (select Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z  where z.Idkardex = y.IdKardex order by 1 desc ) as GradoAcademico
                                from  vwDatosAspirantesTrabajadores y
                                where IdKardex in  (Select  IdKardex from  Kardex_ctDatosPersonales where EsAltaSindicato = 1 )						
                                order by IdKardex desc 
                        ");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosSindicato = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DatosSindicato);
        }


        public ActionResult Evaluacion(int? IdKardex)
        {
            var DatosTrabajador = db.Kardex_ctDatosPersonales.Where(a => a.IdKardex == IdKardex);

            ViewBag.IdKardexCandidato = IdKardex;
            ViewBag.NombreCompletoCandidato = DatosTrabajador.FirstOrDefault().Nombre + ' ' + DatosTrabajador.FirstOrDefault().ApellidoPaterno + ' ' + DatosTrabajador.FirstOrDefault().ApellidoMaterno;

            

            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string query;

            query = @" select  IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno , Telefono,CorreoElectronico from  vwDatosAspirantesTrabajadores
                                 where EstatusTrabajador = 'ALTA'  and  IdModalidadEstudio>0 and ConvenioLaboral='BASE' and (RestringirMenu is null or Incidencia like '%INCAPACIDAD%')
                                order by IdKardex desc ";
            var Trabajadores = (List<TrabajadoresEvaluaciones>)dpcg.connection.Query<TrabajadoresEvaluaciones>(query);

            dpcg.Close();

            ViewBag.IdTipoSuplencia = new SelectList(db.Nomina_SuplenciaTipo.Where(a=> a.EsSolicitudevaluacion == true), "IdTipoSuplencia", "TipoSuplencia");
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(a => a.EsVigente == true && a.IdModalidadEstudio > 0), "IdEstructuraOrganica", "EstructuraOrganica");
            

            IEnumerable<SelectListItem> selectList = from s in Trabajadores
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdConvenioLaboralTrabajadorCategoria.ToString(),
                                                         Text = s.Nombre.ToString() + ' ' + s.ApellidoPaterno + ' ' + s.ApellidoMaterno
                                                     };
            ViewBag.IdConvenioLaboralTrabajadorCategoriaaCubrir = new SelectList(selectList, "Value", "Text");
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;

            return PartialView();
        }


        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Evaluacion([Bind(Include = "IdKardexSolicitudEvaluacion,FechaSolicitud,IdConvenioLaboralTrabajadorCategoriaRegistro,IdEstructuraOrganica,IdTipoSuplencia,IdKardexCandidato,IdConvenioLaboralTrabajadorCategoriaaCubrir,FechaInicio,FechaTermino,NumeroOficio,Observaciones,IdEstatusContratacion,CicloEscolar")] Kardex_SolicitudEvaluaciones Kardex_solicitudevaluaciones)
        {
            int IdCLTCR = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            Kardex_SolicitudEvaluaciones solicitudeval = new Kardex_SolicitudEvaluaciones();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            if (ModelState.IsValid)
            {

                //var RegistrosRepetidos = db.Kardex_SolicitudEvaluaciones.Where(g => g.IdKardexSolicitudEvaluacion == Kardex_solicitudevaluaciones.IdKardexSolicitudEvaluacion).ToArray();
                //int valor = RegistrosRepetidos.Count();
                //if (valor > 0)
                //{


                //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                //}

                //else
                //{

                    try
                    {
                      using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {
                                solicitudeval.FechaSolicitud = DateTime.Now;
                                solicitudeval.IdConvenioLaboralTrabajadorCategoriaRegistro = IdCLTCR;
                                solicitudeval.IdEstructuraOrganica = Kardex_solicitudevaluaciones.IdEstructuraOrganica;
                                solicitudeval.IdTipoSuplencia = Kardex_solicitudevaluaciones.IdTipoSuplencia;
                                solicitudeval.IdKardexCandidato = Kardex_solicitudevaluaciones.IdKardexCandidato; 
                                solicitudeval.IdConvenioLaboralTrabajadorCategoriaaCubrir = Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir;
                                solicitudeval.FechaInicio = Kardex_solicitudevaluaciones.FechaInicio;
                                solicitudeval.FechaTermino = Kardex_solicitudevaluaciones.FechaTermino;
                                solicitudeval.NumeroOficio = Kardex_solicitudevaluaciones.NumeroOficio;
                                solicitudeval.Observaciones = Kardex_solicitudevaluaciones.Observaciones;
                                solicitudeval.IdEstatusContratacion = 1;
                                solicitudeval.CicloEscolar= Kardex_solicitudevaluaciones.CicloEscolar;

                                db.Kardex_SolicitudEvaluaciones.Add(solicitudeval);
                                db.SaveChanges();

                                
                                trans.Complete();


                            }

                    return JsonView(true, "El archivo es agregado satisfactoriamente");


                }
                catch (Exception e)
                    {

                        return JsonView(false,  ExceptionExtensions.GetOriginalException(e).Message );
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }
            else 
            {
                return Json(new { Valid = false, Message = "Es necesario requisitar todos los datos  " });

            }
            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }



       


        public ActionResult VerDetails(int id)
        {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryexpediente);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = id;
            dp.Close();
            var Expediente = kardex_DocumentosExpediente.Where(z => z.IdKardex == id);

            ViewBag.NombreTrabajador = Expediente.FirstOrDefault().Nombre + " " + Expediente.FirstOrDefault().ApellidoPaterno + " " + Expediente.FirstOrDefault().ApellidoMaterno;
                
            return View(Expediente);
            //return View(kardex_DocumentosExpediente.Where(z => z.IdKardex == IdKardex));
        }


      
        // GET: KardexGradoAcademico/Create
        public ActionResult Create()
        {
           
                    
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
           
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardex, Nombre, ApellidoPaterno, ApellidoMaterno,CURP,Telefono, CorreoElectronico, IdKardexNivelEstudio,NivelEstudioDescripcion,AbreviaturaProfesion")] Nova.Models.Kardex_ctDatosPersonalesCandidato kardex_ctdatospersonalescandidato)
        {
            //IdKardex, IdeEmpleadoAnt, CURP, Nombre, ApellidoPaterno, ApellidoMaterno, FechaNacimiento, Sexo, RFC, Calle, NumeroInterior, Letra, NumeroExterior, Colonia, CodigoPostal, IdLocalidadVive, IdMunicipioVive, IdEstadoVive, Telefono, TelefonoCelular, CorreoElectronico, IdLocalidadNacimiento, IdMunicipioNacimiento, IdEstadoNacimiento, IdPais, LaboraFisicamente, Id, ProcesoCompletado, SinNumero, NSS, IdTipoSangre, FechaUltimaActualizacion, EsDocente, Padecimientos, Alergias, IdEstadoCivil, CorreoElectronicoGmail, AceptaAviso, FechaDatosContacto, IdDiscapacidad, IdLenguasIndigenas, IdPueblosIndigenas, EsAltaSindicato,IdKardexNivelEstudio
            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();
            
            Nova.Models.Kardex_ctDatosPersonales kardex_ctDatosPersonales = new Nova.Models.Kardex_ctDatosPersonales();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
                        //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            if (ModelState.IsValid)
            {

                //var RegistrosRepetidos = db.Kardex_DocumentosExpediente.Where(g => g.IdKardexDocumentosExpediente == kardex_DocumentosExpediente.IdKardexDocumentosExpediente).ToArray();
                //int valor = RegistrosRepetidos.Count();
                //if (valor > 0)
                //{


                //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                //}



                //else
                //{

                    try
                {
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {

                       
                        kardex_ctDatosPersonales.IdeEmpleadoAnt = 0;
                        kardex_ctDatosPersonales.CURP = kardex_ctdatospersonalescandidato.CURP;
                        kardex_ctDatosPersonales.Nombre = kardex_ctdatospersonalescandidato.Nombre;
                        kardex_ctDatosPersonales.ApellidoPaterno = kardex_ctdatospersonalescandidato.ApellidoPaterno;
                        kardex_ctDatosPersonales.ApellidoMaterno = kardex_ctdatospersonalescandidato.ApellidoMaterno;
                        kardex_ctDatosPersonales.FechaNacimiento = DateTime.Now; 
                        kardex_ctDatosPersonales.Sexo = "x";
                        kardex_ctDatosPersonales.RFC = "MAEJ860512123";
                        kardex_ctDatosPersonales.Calle = "X";
                        kardex_ctDatosPersonales.NumeroInterior = 0;
                        kardex_ctDatosPersonales.Letra = "";
                        kardex_ctDatosPersonales.NumeroExterior = 0;
                        kardex_ctDatosPersonales.Colonia = "X";
                        kardex_ctDatosPersonales.CodigoPostal = 0;
                        kardex_ctDatosPersonales.IdLocalidadVive = 0;
                        kardex_ctDatosPersonales.IdMunicipioVive = 0;
                        kardex_ctDatosPersonales.IdEstadoVive = 0;
                        kardex_ctDatosPersonales.Telefono = "";
                        kardex_ctDatosPersonales.TelefonoCelular = kardex_ctdatospersonalescandidato.Telefono;
                        kardex_ctDatosPersonales.CorreoElectronico = kardex_ctdatospersonalescandidato.CorreoElectronico;
                        kardex_ctDatosPersonales.IdLocalidadNacimiento = 0;
                        kardex_ctDatosPersonales.IdMunicipioNacimiento = 0;
                        kardex_ctDatosPersonales.IdEstadoNacimiento = 0;
                        kardex_ctDatosPersonales.IdPais = 154;
                        kardex_ctDatosPersonales.LaboraFisicamente = "";
                        kardex_ctDatosPersonales.Id = 0;
                        kardex_ctDatosPersonales.ProcesoCompletado = false;
                        kardex_ctDatosPersonales.SinNumero = false;
                        kardex_ctDatosPersonales.NSS = "";
                        kardex_ctDatosPersonales.IdTipoSangre = 0;
                        kardex_ctDatosPersonales.FechaUltimaActualizacion = DateTime.Now; 
                        kardex_ctDatosPersonales.EsDocente = false;
                        kardex_ctDatosPersonales.Padecimientos = "";
                        kardex_ctDatosPersonales.Alergias = "";
                        kardex_ctDatosPersonales.IdEstadoCivil = 1;
                        kardex_ctDatosPersonales.CorreoElectronicoGmail = "";
                        kardex_ctDatosPersonales.AceptaAviso = false;
                        kardex_ctDatosPersonales.FechaDatosContacto = DateTime.Now; 
                        kardex_ctDatosPersonales.IdDiscapacidad =13;
                        kardex_ctDatosPersonales.IdLenguasIndigenas = 12;
                        kardex_ctDatosPersonales.IdPueblosIndigenas = 14;
                        kardex_ctDatosPersonales.EsAltaSindicato = true;                     
                        db.Kardex_ctDatosPersonales.Add(kardex_ctDatosPersonales);
                        db.SaveChanges();

                        kardex_GradoAcademico.IdKardex = kardex_ctDatosPersonales.IdKardex;
                        kardex_GradoAcademico.IdKardexNivelEstudio = Convert.ToInt16( kardex_ctdatospersonalescandidato.IdKardexNivelEstudio);
                        kardex_GradoAcademico.NivelEstudioDescripcion = kardex_ctdatospersonalescandidato.NivelEstudioDescripcion; ;
                        kardex_GradoAcademico.NumeroCedulaProfesional = 0;
                        kardex_GradoAcademico.AbreviaturaProfesion = kardex_ctdatospersonalescandidato.AbreviaturaProfesion; ;
                        kardex_GradoAcademico.NombreInstiitucionEscolar = "";
                        kardex_GradoAcademico.AñoTermino = 0;
                        db.Kardex_GradoAcademico.Add(kardex_GradoAcademico);
                        db.SaveChanges();

                        trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                     
                       
                        
                    }

                    
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }




        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
                        where a.IdKardex = {0}
                        ", IdKardex);
          
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexDocumentosExpediente = id;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
    
            string querytipodocumento;

            querytipodocumento = @"Select * from (Select * from bdNova.dbo.Kardex_TipoDocumento Tp
                                     where Tp.IdKardexTipoDocumento in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                           from bdNova.dbo.Kardex_DocumentosExpediente )) a
                                    inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardexTipoDocumento = b.IdKardexTipoDocumento
                                    where b.IdKardex=@IdKardex";

            var todastipodocumento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querytipodocumento, new { IdKardex });

            int TipoDocumento = todastipodocumento.Where(z=> z.IdKardexDocumentosExpediente== id).FirstOrDefault().IdKardexTipoDocumento;


            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumentos;

            //querytipodocumento = @"Select * from bdNova.dbo.Kardex_TipoDocumento Tp where 
            //                     Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                     from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            querytipodocumentos = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral ";


            var todastipodocumentos = (List<Kardex_TipoDocumento>)dp.connection.Query<Kardex_TipoDocumento>(querytipodocumentos, new { IdConvenioLaboral });




            string queryciclo;

            queryciclo = @"select a.IdCicloEscolar, b.CicloEscolar from bdCtlEscSeg.dbo.ctCicloescolar a
                            inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.Nombre=b.CicloEscolar
                            where b.IdKardexDocumentosExpediente=@id";

            var todasciclo = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryciclo, new { id });

            int idciclo = todasciclo.FirstOrDefault().IdCicloEscolar;



            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            var valorkardex_DocumentosExpediente = kardex_DocumentosExpediente.Where(z=> z.IdKardex==id).FirstOrDefault();
            if (kardex_DocumentosExpediente == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_GradoAcademico.IdKardex);
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumentos.ToList(), "IdKardexTipoDocumento", "DocumentoExpediente", todastipodocumentos.Where(x=> x.IdKardexTipoDocumento == TipoDocumento).FirstOrDefault().IdKardexTipoDocumento);
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar", Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(a=> a.IdCicloEscolar == idciclo).FirstOrDefault().IdCicloEscolar);
            dp.Close();
            return PartialView();
        
            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente, int IdCicloEscolar, HttpPostedFileBase upload)
        {
                string msj = "El Grado académico ha sido editado existosamente!";
          
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademico.AbreviaturaProfesion=kardex_GradoAcademico.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademico.NivelEstudioDescripcion=kardex_GradoAcademico.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;
            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

            if (ModelState.IsValid)
            {
             
                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
                        //kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;


                           using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos
                                    

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = "+ IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar+"' WHERE IdKardexDocumentosExpediente = "+ kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            
                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);
                         


                            string sql = @"SELECT IdKardexDocumentosExpediente
                                           FROM bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
										   where IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                            ////Escribir archivo 
                            
                            if (idKardexDocumentosExpediente != 0)
                            {
                                var rowsAffectedDocFile = dp.connection.Execute("UPDATE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador SET IdKardex=@IdKardex, Archivo= @Archivo, TipoDocumento = @TipoDocumento, NombreArchivo=@NombreArchivo, FechaRegistro=@FechaRegistro, IdKardexDocumentosExpediente=@IdKardexDocumentosExpediente WHERE IdKardexDocumentosExpediente = @IdKardexDocumentosExpediente01", new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente, IdKardexDocumentosExpediente01 = kardex_DocumentosExpediente.IdKardexDocumentosExpediente });
                            }
                            else
                            {
                                string sqlinsert = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                   "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";                                

                                var parameters = new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sqlinsert, parameters);

                            }
                            
                            


                            dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }

                    else 
                    {
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = " + IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar + "' WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);


                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });
                        }

                            


                    }
                       
                   
                       
                        
                    }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    Nova.Models.Kardex_ctDatosPersonales kardex_ctDatosPersonales = db.Kardex_ctDatosPersonales.Find(id);
                    db.Kardex_ctDatosPersonales.Remove(kardex_ctDatosPersonales);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });


              

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
