﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;



namespace Nova.Controllers.Kardex
{
    public class Kardex_CandidatoGradoAcademicoController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select  a.IdKardexGradoAcademico,a.IdKardex,a.IdKardexNivelEstudio, a.NivelEstudioDescripcion,a.NumeroCedulaProfesional,a.AbreviaturaProfesion,a.NombreInstiitucionEscolar,
                        b.IdGradoAcademicoFotografia,b.Archivo,b.TipoDocumento, b.NombreArchivo,b.FechaRegistro, c.KardexNivelEstudio,d.Nombre,d.ApellidoPaterno,d.ApellidoMaterno
                        from Kardex_GradoAcademico a
                        left join  Kardex_stGradoAcademicoFotografia b  on a.IdKardexGradoAcademico=b.IdKardexGradoAcademico
                        left join  Kardex_ctDatosPersonales d on a.IdKardex = d.IdKardex
                        left join  Kardex_NivelEstudio c on a.IdKardexNivelEstudio = c.IdKardexNivelEstudio";




        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            
            //dp.Close();
            return View(kardex_GradoAcademico.ToList());
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        [AllowAnonymous]
        public ActionResult Details(string token)
        {

            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            ViewBag.Token = token;
            //int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            int IdKardex = model.IdKardexCandidato;


          
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper = (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            //dp.Close();
            var kardex_licenciatura = db.Kardex_GradoAcademico.Where(y =>  y.IdKardex == IdKardex  && y.Kardex_NivelEstudio.KardexNivelEstudio == "LICENCIATURA").ToList();
            ViewBag.LicenciaturaExiste = kardex_licenciatura.Count();
            return View(kardex_GradoAcademico.OrderBy(z => z.Kardex_NivelEstudio.Orden));
        }

        // GET: KardexGradoAcademico/Create
        [AllowAnonymous]
        public ActionResult Create(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            ViewBag.Token = token;
            //int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            int IdKardex = model.IdKardexCandidato;
           
            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [AllowAnonymous]
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardexGradoAcademico,IdKardex,IdKardexNivelEstudio,NivelEstudioDescripcion,NumeroCedulaProfesional,AbreviaturaProfesion,NombreInstiitucionEscolar,AñoTermino,NombreArchivo,FechaRegistro")] Kardex_GradoAcademicoFotografia kardex_GradoAcademicoFotografia, HttpPostedFileBase upload)
        {


            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            kardex_GradoAcademicoFotografia.AbreviaturaProfesion = kardex_GradoAcademicoFotografia.AbreviaturaProfesion.ToUpper();
            kardex_GradoAcademicoFotografia.NivelEstudioDescripcion = kardex_GradoAcademicoFotografia.NivelEstudioDescripcion.ToUpper();


            //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.Kardex_stGradoAcademicoFotografia.Where(g => g.IdGradoAcademicoFotografia == kardex_GradoAcademicoFotografia.IdGradoAcademicoFotografia).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                        if (upload != null && upload.ContentLength > 0)
                        {
                            byte[] imagenData = null;
                            string tipoarchivo = "";
                            using (var binaryArchivo = new BinaryReader(upload.InputStream))
                            {
                                imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                                tipoarchivo = upload.ContentType;

                            }
                            kardex_GradoAcademicoFotografia.Archivo = imagenData;
                            kardex_GradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                            kardex_GradoAcademicoFotografia.NombreArchivo = upload.FileName;


                            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {
                                kardex_GradoAcademico.IdKardex = kardex_GradoAcademicoFotografia.IdKardex;
                                kardex_GradoAcademico.IdKardexNivelEstudio = kardex_GradoAcademicoFotografia.IdKardexNivelEstudio;
                                kardex_GradoAcademico.NivelEstudioDescripcion = kardex_GradoAcademicoFotografia.NivelEstudioDescripcion;
                                kardex_GradoAcademico.NumeroCedulaProfesional = kardex_GradoAcademicoFotografia.NumeroCedulaProfesional;
                                kardex_GradoAcademico.AbreviaturaProfesion = kardex_GradoAcademicoFotografia.AbreviaturaProfesion;
                                kardex_GradoAcademico.NombreInstiitucionEscolar = kardex_GradoAcademicoFotografia.NombreInstiitucionEscolar;
                                kardex_GradoAcademico.AñoTermino = kardex_GradoAcademicoFotografia.AñoTermino;
                                db.Kardex_GradoAcademico.Add(kardex_GradoAcademico);
                                db.SaveChanges();

                                kardex_stGradoAcademicoFotografia.IdKardex = kardex_GradoAcademicoFotografia.IdKardex;
                                kardex_stGradoAcademicoFotografia.Archivo = kardex_GradoAcademicoFotografia.Archivo;
                                kardex_stGradoAcademicoFotografia.TipoDocumento = kardex_GradoAcademicoFotografia.TipoDocumento;
                                kardex_stGradoAcademicoFotografia.NombreArchivo = kardex_GradoAcademicoFotografia.NombreArchivo;
                                kardex_stGradoAcademicoFotografia.FechaRegistro = DateTime.Now;
                                kardex_stGradoAcademicoFotografia.IdKardexGradoAcademico = kardex_GradoAcademico.IdKardexGradoAcademico;
                                db.Kardex_stGradoAcademicoFotografia.Add(kardex_stGradoAcademicoFotografia);
                                db.SaveChanges();

                                trans.Complete();


                            }

                        }
                        else
                        {
                            kardex_GradoAcademico.IdKardex = kardex_GradoAcademicoFotografia.IdKardex;
                            kardex_GradoAcademico.IdKardexNivelEstudio = kardex_GradoAcademicoFotografia.IdKardexNivelEstudio;
                            kardex_GradoAcademico.NivelEstudioDescripcion = kardex_GradoAcademicoFotografia.NivelEstudioDescripcion;
                            kardex_GradoAcademico.NumeroCedulaProfesional = kardex_GradoAcademicoFotografia.NumeroCedulaProfesional;
                            kardex_GradoAcademico.AbreviaturaProfesion = kardex_GradoAcademicoFotografia.AbreviaturaProfesion;
                            kardex_GradoAcademico.NombreInstiitucionEscolar = kardex_GradoAcademicoFotografia.NombreInstiitucionEscolar;
                            kardex_GradoAcademico.AñoTermino = kardex_GradoAcademicoFotografia.AñoTermino;
                            db.Kardex_GradoAcademico.Add(kardex_GradoAcademico);
                            db.SaveChanges();

                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        }
                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }





        [AllowAnonymous]
        public FileResult VerInfo(int idgradoacademico)
        {
            var archivosanexo = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == idgradoacademico).FirstOrDefault();

            if (archivosanexo.TipoDocumento == "application/pdf")
            {
                return File(archivosanexo.Archivo, "application/pdf");

            }
            else if (archivosanexo.TipoDocumento == "application/msword")
            {
                return File(archivosanexo.Archivo, "application/msword");
            }

            else if (archivosanexo.TipoDocumento == "image/jpeg")
            {
                return File(archivosanexo.Archivo, "image/jpeg");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.ms-excel")
            {
                return File(archivosanexo.Archivo, "application/vnd.ms-excel");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }

            return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }

        [AllowAnonymous]
        public FileResult DescargarInfo(int idgradoacademico)
        {
            var archivosanexo = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == idgradoacademico).FirstOrDefault();

            if (archivosanexo.TipoDocumento == "application/pdf")
            {
                return File(archivosanexo.Archivo, "application/pdf", "Descarga_" + archivosanexo.Kardex_ctDatosPersonales.Nombre + archivosanexo.Kardex_ctDatosPersonales.ApellidoPaterno + archivosanexo.Kardex_ctDatosPersonales.ApellidoMaterno + ".pdf");

            }
            else if (archivosanexo.TipoDocumento == "application/msword")
            {
                return File(archivosanexo.Archivo, "application/msword", "Descarga_" + archivosanexo.Kardex_ctDatosPersonales.Nombre + archivosanexo.Kardex_ctDatosPersonales.ApellidoPaterno + archivosanexo.Kardex_ctDatosPersonales.ApellidoMaterno + ".doc");
            }

            else if (archivosanexo.TipoDocumento == "image/jpeg")
            {
                return File(archivosanexo.Archivo, "image/jpeg", "Descarga_" + archivosanexo.Kardex_ctDatosPersonales.Nombre + archivosanexo.Kardex_ctDatosPersonales.ApellidoPaterno + archivosanexo.Kardex_ctDatosPersonales.ApellidoMaterno + ".jpg");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.ms-excel")
            {
                return File(archivosanexo.Archivo, "application/vnd.ms-excel", "Descarga_" + archivosanexo.Kardex_ctDatosPersonales.Nombre + archivosanexo.Kardex_ctDatosPersonales.ApellidoPaterno + archivosanexo.Kardex_ctDatosPersonales.ApellidoMaterno + ".xls");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Descarga_" + archivosanexo.Kardex_ctDatosPersonales.Nombre + archivosanexo.Kardex_ctDatosPersonales.ApellidoPaterno + archivosanexo.Kardex_ctDatosPersonales.ApellidoMaterno + ".docx");
            }

            return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Descarga_" + archivosanexo.Kardex_ctDatosPersonales.Nombre + archivosanexo.Kardex_ctDatosPersonales.ApellidoPaterno + archivosanexo.Kardex_ctDatosPersonales.ApellidoMaterno + ".xlsx");

            //string modalidad = "Poa_Mir" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


        }

        // GET: KardexGradoAcademico/Edit/5
        [AllowAnonymous]
        public ActionResult Edit(int id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_GradoAcademico.IdKardex);
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio", kardex_GradoAcademico.IdKardexNivelEstudio);
            return PartialView(kardex_GradoAcademico);

            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [AllowAnonymous]
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardexGradoAcademico,IdKardex,IdKardexNivelEstudio,NivelEstudioDescripcion,NumeroCedulaProfesional,AbreviaturaProfesion,NombreInstiitucionEscolar,AñoTermino")] Kardex_GradoAcademico kardex_GradoAcademico, HttpPostedFileBase upload)
        {
            string msj = "El Grado académico ha sido editado existosamente!";

            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            kardex_GradoAcademico.AbreviaturaProfesion = kardex_GradoAcademico.AbreviaturaProfesion.ToUpper();
            kardex_GradoAcademico.NivelEstudioDescripcion = kardex_GradoAcademico.NivelEstudioDescripcion.ToUpper();

            if (ModelState.IsValid)
            {

                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
                        //kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;


                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            db.Entry(kardex_GradoAcademico).State = EntityState.Modified;
                            db.SaveChanges();

                            var kardexFotografia = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == kardex_GradoAcademico.IdKardexGradoAcademico).FirstOrDefault();
                            if (kardexFotografia == null)
                            {
                                kardex_stGradoAcademicoFotografia.IdKardex = kardex_GradoAcademico.IdKardex;
                                kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                                kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                                kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;
                                kardex_stGradoAcademicoFotografia.FechaRegistro = DateTime.Now;
                                kardex_stGradoAcademicoFotografia.IdKardexGradoAcademico = kardex_GradoAcademico.IdKardexGradoAcademico;
                                db.Kardex_stGradoAcademicoFotografia.Add(kardex_stGradoAcademicoFotografia);
                                db.SaveChanges();
                            }
                            else
                            {
                                kardexFotografia.IdKardex = kardex_GradoAcademico.IdKardex;
                                kardexFotografia.Archivo = imagenData;
                                kardexFotografia.TipoDocumento = tipoarchivo;
                                kardexFotografia.NombreArchivo = upload.FileName;
                                kardexFotografia.FechaRegistro = DateTime.Now;
                                kardexFotografia.IdKardexGradoAcademico = kardex_GradoAcademico.IdKardexGradoAcademico;
                                db.Entry(kardexFotografia).State = EntityState.Modified;
                                db.SaveChanges();

                            }



                            trans.Complete();


                        }

                    }
                    else
                    {
                        db.Entry(kardex_GradoAcademico).State = EntityState.Modified;
                        db.SaveChanges();

                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    }








                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        [AllowAnonymous]
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }
        [AllowAnonymous]
        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El Grado académico ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
