﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.Sindicato;
using Rotativa;
using Rotativa.Options;
using Nova.Libraries;
using Nova.Models.IngresoPersonal;
using System.Data.Entity.Validation;

namespace Nova.Controllers.Sindicato
{
    public class CandidatoController : BaseController
    {
        private bdNovaEntities dbNova = new bdNovaEntities();
        // GET: Candidato
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult ListaPersonalSindicato()
        {
            bdNovaEntities bd = new bdNovaEntities();
            var model = bd.Kardex_SolicitudEvaluaciones.ToList();
            return View(model);
        }
        public ActionResult ReenviaEmail(long idks)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var item = bd.Kardex_SolicitudEvaluaciones.Find(idks);
            UrlEncryptor crip = new UrlEncryptor(new { Id = item.IdKardexSolicitudEvaluacion });
            //string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
            string baseUrl = "https://" + Request.Url.Host
                + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
            try
            {
                Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, item.IdKardexSolicitudEvaluacion);
            }
            catch (Exception e)
            {
                throw new Exception(ExceptionExtensions.GetOriginalException(e).Message);
            }
         
            return View(item);
        }

        [AllowAnonymous]
        public ActionResult DatosPersonales(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            int IdKardex = model.IdKardexCandidato;
            ViewBag.IdKardexSolicitudEvaluacion = model.IdKardexSolicitudEvaluacion;
            ViewBag.adscripcion = ""; //Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;

            ViewBag.IdKardex = IdKardex;
            ViewBag.IdPais = new SelectList(dbNova.Catalogos_ctPais, "IdPais", "Pais");

            ViewBag.TipoSangre = new SelectList(dbNova.Catalogos_ctTipoSangre, "IdTipoSangre", "Tipo");
            ViewBag.Discapacidades = new SelectList(dbNova.Catalogos_ctDiscapacidades, "IdDiscapacidad", "Discapacidad");
            ViewBag.LenguasIndigenas = new SelectList(dbNova.Catalogos_ctLenguasIndigenas, "IdLenguasIndigenas", "LenguasIndigenas");
            ViewBag.PueblosIndigenas = new SelectList(dbNova.Catalogos_ctPueblosIndigenas, "IdPueblosIndigenas", "PueblosIndigenas");
            ViewBag.dllEstadoCivil = new SelectList(dbNova.Kardex_EstadoCivil, "IdEstadoCivil", "EstadoCivil");
            Kardex_ctDatosPersonales kardex_ctdatospersonales = dbNova.Kardex_ctDatosPersonales.Find(IdKardex);
            Kardex_ctDatosPersonalesFotografias kdpk = dbNova.Kardex_ctDatosPersonalesFotografias.Where(z => z.IdKardex == IdKardex).FirstOrDefault();
            if (kdpk != null)
                ViewBag.urlimage = kdpk.Fotografia;

            ViewBag.IdLocalidadNacimientoText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoNacimiento, kardex_ctdatospersonales.IdMunicipioNacimiento, kardex_ctdatospersonales.IdLocalidadNacimiento);


            ViewBag.IdLocalidadViveText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoVive, kardex_ctdatospersonales.IdMunicipioVive, kardex_ctdatospersonales.IdLocalidadVive);


            if (kardex_ctdatospersonales == null)
            {
                return HttpNotFound();
            }
            return View("EditPerfil", kardex_ctdatospersonales);


        }
        public ActionResult ExpedienteElectronico(int id)
        {

            return View();
        }


        [AllowAnonymous]
        [HttpPost]
        public ActionResult EditPerfil(Kardex_ctDatosPersonales kardex_ctdatospersonales, long idKardexSolicitudEvaluacion = 0)
        {
            ViewBag.IdKardexSolicitudEvaluacion = idKardexSolicitudEvaluacion;
            Int32 idk = kardex_ctdatospersonales.IdKardex;

            byte[] foto = dbNova.Kardex_ctDatosPersonalesFotografias.Where(e => e.IdKardex == idk).Select(f => f.Fotografia).SingleOrDefault();

            ViewBag.adscripcion = "";//Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;

            kardex_ctdatospersonales.ProcesoCompletado = true;

            ViewBag.TipoSangre = new SelectList(dbNova.Catalogos_ctTipoSangre, "IdTipoSangre", "Tipo");
            ViewBag.Discapacidades = new SelectList(dbNova.Catalogos_ctDiscapacidades, "IdDiscapacidad", "Discapacidad");
            ViewBag.LenguasIndigenas = new SelectList(dbNova.Catalogos_ctLenguasIndigenas, "IdLenguasIndigenas", "LenguasIndigenas");
            ViewBag.PueblosIndigenas = new SelectList(dbNova.Catalogos_ctPueblosIndigenas, "IdPueblosIndigenas", "PueblosIndigenas");

            ViewBag.IdPais = new SelectList(dbNova.Catalogos_ctPais, "IdPais", "Pais");
            ViewBag.IdKardex = kardex_ctdatospersonales.IdKardex;
            ViewBag.dllEstadoCivil = new SelectList(dbNova.Kardex_EstadoCivil, "IdEstadoCivil", "EstadoCivil");
            ViewBag.urlimage = "";
            ViewBag.IdLocalidadNacimientoText = "";
            ViewBag.IdLocalidadViveText = "";

            if (Request["IdLocalidadNacimientoText"] != "")
                ViewBag.IdLocalidadNacimientoText = Request["IdLocalidadNacimientoText"];

            if (Request["IdLocalidadViveText"] != "")
                ViewBag.IdLocalidadViveText = Request["IdLocalidadViveText"];


            if (kardex_ctdatospersonales.ValidaModelo().IsValid)
            {

                if (ModelState.IsValid)
                {
                    TransactionOptions transactionoptions1 = new TransactionOptions();
                    transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;

                    try
                    {

                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                        {

                            string cambiomail = "";
                            if (Request["hfemailoriginal"] != kardex_ctdatospersonales.CorreoElectronico)
                            {
                                cambiomail = " Estimado Usuario ha cambiado su correo electronico, por lo que deberá de volver a ACTIVAR SU CUENTA, para poder ingresar nuevamente al sistema";

                                dbNova.Entry(kardex_ctdatospersonales).State = System.Data.Entity.EntityState.Modified;
                                dbNova.SaveChanges();

                                var usuariokardex = dbNova.UsuarioKardex.Where(r => r.IdKardex == kardex_ctdatospersonales.IdKardex).FirstOrDefault();
                                if (usuariokardex != null)
                                {
                                    var aspnetusers = dbNova.AspNetUsers.Where(r => r.Id == usuariokardex.Id).FirstOrDefault();
                                    var permisos = dbNova.GrupoRolAplicacionUsuarioKardex.Where(r => r.IdUsuarioKardex == usuariokardex.IdUsuarioKardex).ToList();


                                    dbNova.GrupoRolAplicacionUsuarioKardex.RemoveRange(dbNova.GrupoRolAplicacionUsuarioKardex.Where(r => r.IdUsuarioKardex == usuariokardex.IdUsuarioKardex));


                                    dbNova.Entry(usuariokardex).State = System.Data.Entity.EntityState.Deleted;
                                    dbNova.Entry(aspnetusers).State = System.Data.Entity.EntityState.Deleted;



                                    dbNova.SaveChanges();


                                }

                            }
                            else
                            {
                                dbNova.Entry(kardex_ctdatospersonales).State = System.Data.Entity.EntityState.Modified;
                                //dbNova.Kardex_ctDatosPersonales.Add(kardex_ctdatospersonales);
                                dbNova.SaveChanges();

                            }
                            Kardex_ctDatosPersonalesFotografias kdpk = new Kardex_ctDatosPersonalesFotografias();
                            bool EsFotoNueva = false;
                            var fotoKardex = dbNova.Kardex_ctDatosPersonalesFotografias.Where(z => z.IdKardex == kardex_ctdatospersonales.IdKardex).FirstOrDefault();

                            if (fotoKardex != null)
                                kdpk.IdKardex = fotoKardex.IdKardex;
                            else
                            {
                                kdpk.IdKardex = kardex_ctdatospersonales.IdKardex;
                                EsFotoNueva = true;
                            }


                            if (Request.Files[0].FileName != "")
                            {

                                var image = new System.Web.Helpers.WebImage(Request.Files[0].InputStream);


                                var Height = image.Height;
                                var Width = image.Width;

                                decimal Top = 0;
                                decimal Left = 0;
                                decimal Bottom = 0;
                                decimal Right = 0;

                                if (Request["hfimgcrop_top"] != "")
                                {
                                    Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                                    Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                                    Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                                    Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);

                                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                                }


                                //      width: Math.round(rx * boundx) + 'px',
                                //height: Math.round(ry * boundy) + 'px',
                                //marginLeft: '-' + Math.round(rx * c.x) + 'px',
                                //marginTop: '-' + Math.round(ry * c.y) + 'px'



                                //image.Resize(220, 228, true, true);

                                image.Resize(600, 600, true, true);


                                kdpk.Fotografia = image.GetBytes();
                            }
                            else

                            //if (Request["hfUrlImage"] != null)
                            //    if (Request["hfUrlImage"] != "")
                            //    {
                            //        kardex_ctdatospersonales.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                            //        ViewBag.urlimage = Request["hfUrlImage"];
                            //    }
                            {

                                kdpk.Fotografia = foto;
                            }

                            if (EsFotoNueva)
                            {
                                dbNova.Kardex_ctDatosPersonalesFotografias.Add(kdpk);
                                dbNova.SaveChanges();

                            }
                            else
                            {
                                fotoKardex.Fotografia = kdpk.Fotografia;

                                dbNova.Entry(fotoKardex).State = System.Data.Entity.EntityState.Modified;
                                dbNova.SaveChanges();

                            }
                            //Seguridad.Identidad.ResetSingleton();
                            //string codificado = Cifrado.Encrypt(kardex_ctdatospersonales.CorreoElectronico + kardex_ctdatospersonales.IdKardex.ToString());


                            MessageBox.Show(ViewData, TipoMensaje.Information, "Los datos Personales se han grabado exitosamente." + cambiomail);
                            Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(idKardexSolicitudEvaluacion, AspiranteTareasContratacion.DatosPersonales);
                            scope.Complete();

                        }
                    }
                    catch (Exception ex)
                    {

                        throw new Exception(ExceptionExtensions.GetOriginalException(ex).Message);
                    }

                    // return RedirectToAction("Paso2", "DatosPersonales", new { id = kardex_ctdatospersonales.IdKardex, email = kardex_ctdatospersonales.CorreoElectronico, check = codificado ,isPost="1"});
                    return View("EditPerfil", kardex_ctdatospersonales);
                    //return RedirectToAction("Perfil");
                }
                else
                {
                    var errors = ModelState.Select(x => x.Value.Errors)
                             .Where(y => y.Count > 0)
                             .ToList();
                }
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_ctdatospersonales.ValidaModelo().Mensaje);


            return View("EditPerfil", kardex_ctdatospersonales);
        }


        public ActionResult ImprimirOficioPresentacion(int id = 0)
        {
            //var Vista = "ImprimirOficioPresentacionPlantel";
            var Vista = "ImprimirOficioPresentacion";
            DatosOficioPresentacion datos = new DatosOficioPresentacion();

            var model = datos.GetDatosContrato(id);

            if (model.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                model.EsPorNecesidadCentro = true;

            //switch (model.RelacionLaboral)
            //{
            //    case "DOCENTE":
            //        if (model.IdModalidadEstudio == 2)
            //           Vista = "ImprimirOficioPresentacionEmsad";
            //        break;
            //    case "ADMINISTRATIVO":
            //        Vista = "ImprimirOficioPresentacionAdministrativo";
            //        model.HorasSemanaMes = 35;
            //        break;
            //    default:
            //        break;
            //}

            
            return new ViewAsPdf(Vista, model);
            // return View();
        }


        public ActionResult ImprimirResultadoEvaluacion(int id = 0)
        {
            var Vista = "ImprimirResultadoEvaluacionAdministrativo";
            DatosOficioPresentacion datos = new DatosOficioPresentacion();

            var model = datos.GetDatosContrato(id);

            if (model.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                model.EsPorNecesidadCentro = true;

            switch (model.RelacionLaboral)
            {
                case "DOCENTE":
                    if (model.IdModalidadEstudio == 2)
                        Vista = "ImprimirResultadoEvaluacionAdministrativo";
                    break;
                case "ADMINISTRATIVO":
                    Vista = "ImprimirResultadoEvaluacionAdministrativo";
                    model.HorasSemanaMes = 35;
                    break;
                default:
                    break;
            }
            return new ViewAsPdf(Vista, model);
            // return View();
        }

        [AllowAnonymous]
        public ActionResult PreguntasAdicionalesContrato(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            int IdKardex = model.IdKardexCandidato;

            var preguntas = dbNova.Kardex_PreguntaAdicionalContrato.Where(x => x.Kardex_KardexEncuesta.IdKardexEncuesta == 2).ToList();
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexSolicitudEvaluacion = model.IdKardexSolicitudEvaluacion;
            return View(preguntas);
        }

        [AllowAnonymous]
        public ActionResult PreguntasEncuestaSatisfaccion(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            int IdKardex = model.IdKardexCandidato;

            var preguntasContestadas = dbNova.Kardex_PreguntaAdicionalContratoRespuesta.Where(x => x.IdKardexSolicitudEvaluacion == model.IdKardexSolicitudEvaluacion && x.Kardex_PreguntaAdicionalContrato.Kardex_KardexEncuesta.IdKardexEncuesta == 3).ToList();

            if (preguntasContestadas.Count > 0)
                throw new ArgumentException("El token ya no es válido!");

            var preguntas = dbNova.Kardex_PreguntaAdicionalContrato.Where(x => x.Kardex_KardexEncuesta.IdKardexEncuesta == 3).ToList();

            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexSolicitudEvaluacion = model.IdKardexSolicitudEvaluacion;
            return View(preguntas);
        }

        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult PreguntasAdicionalesContrato(IEnumerable<Kardex_PreguntaAdicionalContratoRespuesta> respuestas, int? idK, int? idKS)
        {
            int idKardex = idK.HasValue ? idK.Value : 0;
            Kardex_SolicitudEvaluaciones evaluacion = new Kardex_SolicitudEvaluaciones();

            if (idKS.HasValue)
            {
                evaluacion = dbNova.Kardex_SolicitudEvaluaciones.Find(idKS);
            }
            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope())
                {
                    try
                    {


                        foreach (var item in respuestas)
                        {
                            item.IdKardex = idKardex;
                            if (idKS.HasValue)
                                item.IdKardexSolicitudEvaluacion = idKS.Value;
                            item.CicloEscolar = evaluacion.CicloEscolar;
                            item.FechaRegistro = System.DateTime.Now;
                        }


                        dbNova.Kardex_PreguntaAdicionalContratoRespuesta.AddRange(respuestas);
                        dbNova.SaveChanges();
                        var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(idKS.Value, AspiranteTareasContratacion.InformacionAdicional);

                        trans.Complete();
                       
                        return Json(new { success = true, message = "Registro guardado con éxito!" });


                    }
                    catch (DbEntityValidationException ex)
                    {

                        foreach (var entityValidationErrors in ex.EntityValidationErrors)
                        {
                            foreach (var validationError in entityValidationErrors.ValidationErrors)
                            {
                                ModelState.AddModelError(
                                    validationError.PropertyName,
                                    validationError.ErrorMessage
                                );
                            }
                        }

                        string messages = string.Join("; ", ModelState.Values
                                             .SelectMany(x => x.Errors)
                                             .Select(x => x.ErrorMessage));

                        return Json(new { success = false, message = messages });

                    }
                    catch (Exception ex)
                    {
                        trans.Dispose();
                        var mensaje = ExceptionExtensions.GetOriginalException(ex).Message;


                        if (mensaje.Contains("No se puede insertar una fila de clave duplicada"))

                        {
                            var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(idKS.Value, AspiranteTareasContratacion.InformacionAdicional);

                            mensaje = "El token ya no es válido o el cuestionario ya fue contestado !";
                        }

                        return Json(new { success = false, message = mensaje });

                    }
                    finally
                    {
                        
                    }

                }
            }
            else
            {
                var errors = ModelState.Values.SelectMany(v => v.Errors)
                                              .Select(e => e.ErrorMessage)
                                              .ToList();
                return Json(new { success = false, message = errors });
            }

        }

        [AllowAnonymous]
        public ActionResult ImprimirPreguntasAdicionalesContrato(string token)
        {
            var evaluacion = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            ViewBag.DatosCandidato = dbNova.Kardex_ctDatosPersonales.Find(evaluacion.IdKardexCandidato);
            var model = dbNova.Kardex_PreguntaAdicionalContratoRespuesta.Where(i => i.IdKardexSolicitudEvaluacion == evaluacion.IdKardexSolicitudEvaluacion).ToList();
            return new ViewAsPdf(model);
            //return View(model);
        }
    }
}