﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class SieSubcategoriaEventosController : Controller
    {
        //
        // GET: /SieSubcategoriaEvento/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSieSubcategoriaEventos()
        {
            var model = db.SieSubcategoriaEvento;
            return PartialView("_pvSieSubcategoriaEventos", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieSubcategoriaEventosAddNew(Nova.Models.SieSubcategoriaEvento item)
        {
            var model = db.SieSubcategoriaEvento;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSieSubcategoriaEventos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieSubcategoriaEventosUpdate(Nova.Models.SieSubcategoriaEvento item)
        {
            var model = db.SieSubcategoriaEvento;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdSubCategoriaEvento == item.IdSubCategoriaEvento);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvSieSubcategoriaEventos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieSubcategoriaEventosDelete(System.Int16 IdSubCategoriaEvento)
        {
            var model = db.SieSubcategoriaEvento;
            if (IdSubCategoriaEvento != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdSubCategoriaEvento == IdSubCategoriaEvento);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvSieSubcategoriaEventos", model.ToList());
        }
    }
}
