﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class SieJustificacionController : Controller
    {
        //
        // GET: /SieJustificacion/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSieJustificacion()
        {
            var model = db.SieJustificacion;
            return PartialView("_pvSieJustificacion", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieJustificacionAddNew(Nova.Models.SieJustificacion item)
        {
            var model = db.SieJustificacion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSieJustificacion", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieJustificacionUpdate(Nova.Models.SieJustificacion item)
        {
            var model = db.SieJustificacion;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdJustificacion == item.IdJustificacion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvSieJustificacion", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieJustificacionDelete(System.Int16 IdJustificacion)
        {
            var model = db.SieJustificacion;
            if (IdJustificacion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdJustificacion == IdJustificacion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvSieJustificacion", model.ToList());
        }
    }
}
