﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SieInasistenciasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SieInasistencias
        public ActionResult Index()
        {
            var sieInasistencias = db.SieInasistencias.Include(s => s.SieJustificacion);
            return View(sieInasistencias.ToList());
        }

        // GET: SieInasistencias/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieInasistencias sieInasistencias = db.SieInasistencias.Find(id);
            if (sieInasistencias == null)
            {
                return HttpNotFound();
            }
            return View(sieInasistencias);
        }

        // GET: SieInasistencias/Create
        public ActionResult Create()
        {
            ViewBag.IdJustificacion = new SelectList(db.SieJustificacion, "IdJustificacion", "Justificacion");
            return View();
        }

        // POST: SieInasistencias/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdInAsistencias,FechaInAsistencia,IdTrabajador,HorasNoLaboradas,Observaciones,IdJustificacion")] SieInasistencias sieInasistencias)
        {
            if (ModelState.IsValid)
            {
                db.SieInasistencias.Add(sieInasistencias);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdJustificacion = new SelectList(db.SieJustificacion, "IdJustificacion", "Justificacion", sieInasistencias.IdJustificacion);
            return View(sieInasistencias);
        }

        // GET: SieInasistencias/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieInasistencias sieInasistencias = db.SieInasistencias.Find(id);
            if (sieInasistencias == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdJustificacion = new SelectList(db.SieJustificacion, "IdJustificacion", "Justificacion", sieInasistencias.IdJustificacion);
            return View(sieInasistencias);
        }

        // POST: SieInasistencias/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdInAsistencias,FechaInAsistencia,IdTrabajador,HorasNoLaboradas,Observaciones,IdJustificacion")] SieInasistencias sieInasistencias)
        {
            if (ModelState.IsValid)
            {
                db.Entry(sieInasistencias).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdJustificacion = new SelectList(db.SieJustificacion, "IdJustificacion", "Justificacion", sieInasistencias.IdJustificacion);
            return View(sieInasistencias);
        }

        // GET: SieInasistencias/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieInasistencias sieInasistencias = db.SieInasistencias.Find(id);
            if (sieInasistencias == null)
            {
                return HttpNotFound();
            }
            return View(sieInasistencias);
        }

        // POST: SieInasistencias/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            SieInasistencias sieInasistencias = db.SieInasistencias.Find(id);
            db.SieInasistencias.Remove(sieInasistencias);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
