﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;

namespace Nova.Controllers
{
    public class SieEventosController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SieEventos
        public ActionResult Index()
        {

            //throw new Exception("El usuario no es válido para esta operación");
            //var xx = (from a in db.SieEventos
            //          where a.IdEstructuraOrganicaInformo == 66
            //          select new SieEventos { a.AreaAtendio, a.AreaDelegada, a.AreaEntero, a.AreaInformo, a.Atendio, a.Descripcion, a.EfectosDerivados, a.Entero, a.FechaAtendido, a.FechaDelegacion, a.FechaEnterado, a.FechaInforme, a.IdCategoriaEvento, a.IdEstructuraOrganicaAtendio, a.IdEstructuraOrganicaDelegada, a.IdEstructuraOrganicaInformo, a.IdEvento, a.IdKardexAtendio, a.IdKardexEntero, a.IdKardexInformo, a.IdSubcategoriaEvento, a.Informo, a.OtrosAspectos, a.Solucion }).ToList();


            //var sieEventos = db.SieEventos.Include(s => s.SieCategoriaEventos).Include(s => s.SieSubcategoriaEvento);
            string usuariofiltro =  HttpContext.Session["NombreUsuario"].ToString();
            var sieEventos = db.SieEventos.Where(x => x.Informo == usuariofiltro);

            return View(sieEventos.ToList());
        }
        public ActionResult IndexEnterar()
        {
            string areaactual = HttpContext.Session["AreaUsuario"].ToString();
            //if (areaactual == "DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN")
            //{
                var sieEventos1 = db.SieEventos.Include(s => s.SieCategoriaEventos).Include(s => s.SieSubcategoriaEvento);
                return View(sieEventos1.ToList());

            //}
            //else
            //{
            //    var sieEventos = db.SieEventos.Where(x=>x.AreaDelegada==areaactual);
            //    return View(sieEventos.ToList());

            //}

        }
        public ActionResult IndexDelegar()
        {
            string areaactual = HttpContext.Session["AreaUsuario"].ToString();
                var sieEventos = db.SieEventos.Where(x => x.AreaDelegada == areaactual);
                return View(sieEventos.ToList());


        }

        public ActionResult IndexAtender()
        {
            var sieEventos = db.SieEventos.Include(s => s.SieCategoriaEventos).Include(s => s.SieSubcategoriaEvento);
            return View(sieEventos.ToList());
        }
        public ActionResult Enterar(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieEventos sieEventos = db.SieEventos.Find(id);

            if (sieEventos == null)
            {
                return HttpNotFound();
            }
            if (!(sieEventos.FechaEnterado == null))
            {
                //MessageBox.Show(ViewData, TipoMensaje.Information, "El evento ya ha sido marcado como enterado");
                throw new Exception("El evento ya ha sido marcado como enterado");
            }
            else 
            {
            sieEventos.FechaEnterado = DateTime.Now.Date;
            sieEventos.IdKardexEntero = (int)HttpContext.Session["IdKardex"];
            sieEventos.Entero = (string)HttpContext.Session["NombreUsuario"];
            sieEventos.AreaEntero= (string)HttpContext.Session["AreaUsuario"];
            db.Entry(sieEventos).State = System.Data.Entity.EntityState.Modified;
            db.SaveChanges();

            }

            return RedirectToAction("IndexEnterar");
        }
        public ActionResult Atender(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieEventos sieEventos = db.SieEventos.Find(id);

            if (sieEventos == null)
            {
                return HttpNotFound();
            }
            if (sieEventos.FechaEnterado == null)
            {
                throw new Exception("El evento no ha sido enterado");
            }

            //if (!(sieEventos.FechaAtendido == null))
            //{
            //    throw new Exception("El evento ya ha sido atendido");
            //}
            //if (sieEventos.AreaDelegada != null)
            //{
            //    if (sieEventos.AreaDelegada != HttpContext.Session["AreaUsuario"].ToString())
            //    {
            //        throw new Exception("El evento ya ha sido delegado a otra área para su atención");

            //    }

            //}
            return View(sieEventos);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Atender([Bind(Include = "IdEvento,IdEstructuraOrganicaInformo,AreaInformo,IdCategoriaEvento,IdSubcategoriaEvento,FechaInforme,IdKardexInformo,Informo,Descripcion,EfectosDerivados,IdKardexEntero,Entero,AreaEntero,FechaEnterado,IdKardexAtendio,Atendio,FechaAtendido,IdEstructuraOrganicaAtendio,AreaAtendio,Solucion,OtrosAspectos")] SieEventos sieEventos)
        {

            sieEventos.FechaAtendido = DateTime.Now.Date;
            sieEventos.IdEstructuraOrganicaAtendio = (short) HttpContext.Session["IdEstructuraOrganicaFisica"];
            sieEventos.IdKardexAtendio = (int)HttpContext.Session["IdKardex"];
            sieEventos.Atendio = (string)HttpContext.Session["NombreUsuario"];
            sieEventos.AreaAtendio = (string)HttpContext.Session["AreaUsuario"];
            if (sieEventos.FechaEnterado == null)
            {
                sieEventos.FechaEnterado = DateTime.Now.Date;
                sieEventos.IdKardexEntero = (int)HttpContext.Session["IdKardex"];
                sieEventos.Entero = (string)HttpContext.Session["NombreUsuario"];
                sieEventos.AreaEntero = (string)HttpContext.Session["AreaUsuario"];
            }
            if (sieEventos.FechaDelegacion == null)
            {
                sieEventos.FechaDelegacion = DateTime.Now.Date;
                sieEventos.IdEstructuraOrganicaDelegada =  (short)HttpContext.Session["IdEstructuraOrganicaFisica"];
                sieEventos.AreaDelegada = (string)HttpContext.Session["AreaUsuario"];
            }

            if (ModelState.IsValid)
            {
                db.Entry(sieEventos).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                if ((string)HttpContext.Session["AreaUsuario"] == "DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN")
                return RedirectToAction("IndexEnterar");
                else return RedirectToAction("IndexDelegar");

            }
            return View(sieEventos);
        }
        public ActionResult Delegar(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieEventos sieEventos = db.SieEventos.Find(id);

            if (sieEventos == null)
            {
                return HttpNotFound();
            }
            if (sieEventos.FechaEnterado == null)
            {
                throw new Exception("Necesita enterarse para delegar el evento");

            }
            if (sieEventos.AreaAtendio != null)
            {
                throw new Exception("El evento ya ha sido atendido, no se puede delegar");
            }
            Arbol.ShowEstructuraOrganica(ViewData);
            return View(sieEventos);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delegar([Bind(Include = "IdEvento,IdEstructuraOrganicaInformo,AreaInformo,IdCategoriaEvento,IdSubcategoriaEvento,FechaInforme,IdKardexInformo,Informo,Descripcion,EfectosDerivados,IdKardexEntero,Entero,AreaEntero,FechaEnterado,IdKardexAtendio,Atendio,FechaAtendido,IdEstructuraOrganicaAtendio,AreaAtendio,Solucion,OtrosAspectos")] SieEventos sieEventos)
        {
            string area = Request.Form["area"];
            if (area == null)
            {
                ModelState.AddModelError("IdEstructuraOrganicaInformo", "Debe seleccionar un área funcional a la que se delegará el documento");

            }
            else
            {
                sieEventos.FechaDelegacion = DateTime.Now.Date;
                sieEventos.IdEstructuraOrganicaDelegada = Convert.ToSByte(area);
                sieEventos.AreaDelegada = db.Catalogos_ctEstructuraOrganica.Find(sieEventos.IdEstructuraOrganicaDelegada).EstructuraOrganica;

            }
            if (ModelState.IsValid)
            {
                db.Entry(sieEventos).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("IndexEnterar");
            }
            Nova.Models.Arbol.ShowEstructuraOrganica(ViewData);

            return View(sieEventos);
        }


        // GET: SieEventos/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieEventos sieEventos = db.SieEventos.Find(id);
            if (sieEventos == null)
            {
                return HttpNotFound();
            }
            return View(sieEventos);
        }

        // GET: SieEventos/Create
        public ActionResult Create()
        {
            ViewBag.IdCategoriaEvento = new SelectList(db.SieCategoriaEventos, "IdCategoriaEvento", "CategoriaEvento");
            ViewBag.IdSubcategoriaEvento = new SelectList(db.SieSubcategoriaEvento, "IdSubCategoriaEvento", "SubCategoriaEvento");
            return View();
        }

        // POST: SieEventos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdEvento,IdEstructuraOrganicaInformo,AreaInformo,IdCategoriaEvento,IdSubcategoriaEvento,FechaInforme,IdKardexInformo,Informo,Descripcion,EfectosDerivados,IdKardexEntero,Entero,AreaEntero,FechaEnterado,IdKardexAtendio,Atendio,FechaAtendido,IdEstructuraOrganicaAtendio,AreaAtendio,Solucion,OtrosAspectos")] SieEventos sieEventos)
        {
            sieEventos.IdKardexInformo =(int) HttpContext.Session["IdKardex"];
            sieEventos.IdEstructuraOrganicaInformo = (short) HttpContext.Session["IdEstructuraOrganicaFisica"];
            sieEventos.AreaInformo = (string) HttpContext.Session["AreaUsuario"];
            sieEventos.FechaInforme = DateTime.Now.Date;
            sieEventos.Informo = (string)HttpContext.Session["NombreUsuario"];
            if (ModelState.IsValid)
            {

                db.SieEventos.Add(sieEventos);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdCategoriaEvento = new SelectList(db.SieCategoriaEventos, "IdCategoriaEvento", "CategoriaEvento", sieEventos.IdCategoriaEvento);
            ViewBag.IdSubcategoriaEvento = new SelectList(db.SieSubcategoriaEvento, "IdSubCategoriaEvento", "SubCategoriaEvento", sieEventos.IdSubcategoriaEvento);
            return View(sieEventos);
        }

        // GET: SieEventos/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieEventos sieEventos = db.SieEventos.Find(id);
            if (sieEventos == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdCategoriaEvento = new SelectList(db.SieCategoriaEventos, "IdCategoriaEvento", "CategoriaEvento", sieEventos.IdCategoriaEvento);
            ViewBag.IdSubcategoriaEvento = new SelectList(db.SieSubcategoriaEvento, "IdSubCategoriaEvento", "SubCategoriaEvento", sieEventos.IdSubcategoriaEvento);
            return View(sieEventos);
        }

        // POST: SieEventos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdEvento,IdEstructuraOrganicaInformo,AreaInformo,IdCategoriaEvento,IdSubcategoriaEvento,FechaInforme,IdKardexInformo,Informo,Descripcion,EfectosDerivados,IdKardexEntero,Entero,AreaEntero,FechaEnterado,IdKardexAtendio,Atendio,FechaAtendido,IdEstructuraOrganicaAtendio,AreaAtendio,Solucion,OtrosAspectos")] SieEventos sieEventos)
        {
            if (ModelState.IsValid)
            {
                db.Entry(sieEventos).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdCategoriaEvento = new SelectList(db.SieCategoriaEventos, "IdCategoriaEvento", "CategoriaEvento", sieEventos.IdCategoriaEvento);
            ViewBag.IdSubcategoriaEvento = new SelectList(db.SieSubcategoriaEvento, "IdSubCategoriaEvento", "SubCategoriaEvento", sieEventos.IdSubcategoriaEvento);
            return View(sieEventos);
        }

        // GET: SieEventos/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieEventos sieEventos = db.SieEventos.Find(id);

            if (sieEventos == null)
            {
                return HttpNotFound();
            }
            return View(sieEventos);
        }

        // POST: SieEventos/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(short id)
        {
            SieEventos sieEventos = db.SieEventos.Find(id);
            if (sieEventos.FechaEnterado == null)
            {
                db.SieEventos.Remove(sieEventos);
                db.SaveChanges();

            }
            else
            {
                throw new Exception("No es posible borrar el evento porque ya ha sido enterado");
                //MessageBox.Show(ViewData, TipoMensaje.Information, "No es posible borrar el evento porque ya ha sido enterado");
 
            }
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
