﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using DevExpress.Web;
using DevExpress.Web.Mvc;
using System.Web.UI;
using Rotativa;

namespace Nova.Controllers
{
    public class SieDocumentoFechasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SieDocumentoFechas
        public ActionResult Index()
        {
            var sieDocumentoFecha = db.SieDocumentoFecha.Include(s => s.SieDocumento);
            return View(sieDocumentoFecha.ToList());
        }

        // GET: SieDocumentoFechas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieDocumentoFecha sieDocumentoFecha = db.SieDocumentoFecha.Find(id);
            if (sieDocumentoFecha == null)
            {
                return HttpNotFound();
            }
            return View(sieDocumentoFecha);
        }
        public ActionResult getArchivo(int id)
        {
            SieDocumentoFecha sieDocumentoFecha = db.SieDocumentoFecha.Find(id);
            string ext = sieDocumentoFecha.ExtensionArchivo;
            string ct = "";
            byte[] image = SieDocumentoFecha.getArchivo(id);
            if (image == null)
                return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
            else
                switch (ext)
                {
                    case "xls": ct = "application/vnd.ms-excel";
                        break;
                    default:
                        break;
                }
                return File(image, ct);
        }

        // GET: SieDocumentoFechas/Create
        public ActionResult Create()
        {
            ViewBag.IdDocumento = new SelectList(db.SieDocumento, "IdDocumento", "Documento");
            return View();
        }

        // POST: SieDocumentoFechas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdDocumentoFecha,IdDocumento,FechaInicio,FechaTermino,ArchivoAsignado,NombreArchivo,ExtensionArchivo")] SieDocumentoFecha sieDocumentoFecha)
        {
            ViewBag.urlimage = "";
            if (Request.Files[0].FileName != "")
            {
                sieDocumentoFecha.ArchivoAsignado = StreamHelpers.ReadFully(Request.Files[0].InputStream);
                string nombrearchivoextension = Request.Files[0].FileName;
            string[] nombrearchivo = nombrearchivoextension.Split(new Char [] {'.' });
                sieDocumentoFecha.NombreArchivo = nombrearchivo[0];
                sieDocumentoFecha.ExtensionArchivo = nombrearchivo[1];
            }
            else
                if (Request["hfUrlImage"] != null)
                    if (Request["hfUrlImage"] != "")
                    {
                        sieDocumentoFecha.ArchivoAsignado = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                        ViewBag.urlimage = Request["hfUrlImage"];
                    }
            if (sieDocumentoFecha.ValidaModelo().IsValid)
            {


                if (ModelState.IsValid)
                {
                    db.SieDocumentoFecha.Add(sieDocumentoFecha);
                    db.SaveChanges();
                    //MessageBox.Show(ViewData, TipoMensaje.Success, "Registro Grabado con éxito ");
                  return  RedirectToAction("Index", "SieDocumentoFechas");
                }
                else
                {
                    var errors = ModelState.Select(x => x.Value.Errors)
                                .Where(y => y.Count > 0)
                                .ToList();
                }

            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, sieDocumentoFecha.ValidaModelo().Mensaje);
            ViewBag.IdDocumento = new SelectList(db.SieDocumento, "IdDocumento", "Documento", sieDocumentoFecha.IdDocumento);

            return View(sieDocumentoFecha);
        }

        // GET: SieDocumentoFechas/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieDocumentoFecha sieDocumentoFecha = db.SieDocumentoFecha.Find(id);
            if (sieDocumentoFecha == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdDocumento = new SelectList(db.SieDocumento, "IdDocumento", "Documento", sieDocumentoFecha.IdDocumento);
            return View(sieDocumentoFecha);
        }

        // POST: SieDocumentoFechas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdDocumentoFecha,IdDocumento,FechaInicio,FechaTermino,ArchivoAsignado,NombreArchivo,ExtensionArchivo")] SieDocumentoFecha sieDocumentoFecha)
        {
            if (ModelState.IsValid)
            {
                db.Entry(sieDocumentoFecha).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdDocumento = new SelectList(db.SieDocumento, "IdDocumento", "Documento", sieDocumentoFecha.IdDocumento);
            return View(sieDocumentoFecha);
        }

        // GET: SieDocumentoFechas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieDocumentoFecha sieDocumentoFecha = db.SieDocumentoFecha.Find(id);
            if (sieDocumentoFecha == null)
            {
                return HttpNotFound();
            }
            return View(sieDocumentoFecha);
        }

        // POST: SieDocumentoFechas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            SieDocumentoFecha sieDocumentoFecha = db.SieDocumentoFecha.Find(id);
            db.SieDocumentoFecha.Remove(sieDocumentoFecha);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
