﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;

namespace PruebaUpload.Controllers
{
    public class SieDocumentoEstructurasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SieDocumentoEstructuras
        public ActionResult Index()
        {

                var sieDocumentoEstructura = db.SieDocumentoEstructura.Include(s => s.SieDocumentoFecha).Include(s => s.Catalogos_ctEstructuraOrganica);
                return View(sieDocumentoEstructura.ToList());


        }
        public ActionResult IndexEmsad()
        {

            string areaactual = HttpContext.Session["AreaUsuario"].ToString();
            short ideo = (short)HttpContext.Session["IdEstructuraOrganicaFisica"];
                var sieDocumentoEstructura = db.SieDocumentoEstructura.Where(s => s.IdEstructuraOrganica == ideo).Include(s => s.SieDocumentoFecha).Include(s => s.Catalogos_ctEstructuraOrganica);
                return View("IndexEmsad", sieDocumentoEstructura.ToList());


        }

        // GET: SieDocumentoEstructuras/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieDocumentoEstructura sieDocumentoEstructura = db.SieDocumentoEstructura.Find(id);
            if (sieDocumentoEstructura == null)
            {
                return HttpNotFound();
            }
            return View(sieDocumentoEstructura);
        }

        // GET: SieDocumentoEstructuras/Create
        public ActionResult Create()
        {
            //ViewBag.IdDocumentoFecha = new SelectList(db.SieDocumentoFecha, "IdDocumentoFecha", "NombreArchivo");
            ViewBag.IdDocumentoFecha = new SelectList((from s in db.SieDocumentoFecha.ToList() select new { IdDocumentoFecha = s.IdDocumentoFecha, NombreArchivo = s.SieDocumento.Documento + " | " + s.FechaInicio+ " | " + s.FechaTermino }), "IdDocumentoFecha", "NombreArchivo");
            Arbol.ShowEstructuraOrganicaChk(ViewData);
            return View();
        }
        public FileContentResult descargarEmsad(int id)
        {
            byte[] fileData;
            string fileName;
            string extension;
            //create object of LINQ to SQL class
            bdNovaEntities d = new bdNovaEntities();
            var archivo = d.SieDocumentoEstructura.Where(a => a.IdDocumentoEstructura == id);
            byte[] w = archivo.Select(s => s.SieDocumentoFecha.ArchivoAsignado).SingleOrDefault();

            //only one record will be returned from database as expression uses condtion on primary field
            //so get first record from returned values and retrive file content (binary) and filename 
            fileData = (byte[])w.ToArray();
            fileName = archivo.First().SieDocumentoFecha.NombreArchivo;
            //return file and provide byte file content and file name
            extension = archivo.First().SieDocumentoFecha.ExtensionArchivo;
            return File(fileData, "application/" + extension, fileName + "." + extension);
            //byte[] image = SieDocumentoEstructuras.getArchivoReportado(id);
            //if (image == null)
            //    return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
            //else

            //    return File(image, "image/jpg");
        }
        public FileContentResult descargarAministrador(int id)
        {
            byte[] fileData;
            string fileName;
            string extension;
            //create object of LINQ to SQL class
            bdNovaEntities d = new bdNovaEntities();
            var archivo = d.SieDocumentoEstructura.Where(a => a.IdDocumentoEstructura == id);
            if (archivo.First().FechaReporte == null)
            {
                throw new Exception("No existe un archivo reportado por el área " );
            }
            byte[] w = archivo.Select(s => s.ArchivoReportado).SingleOrDefault();

            //only one record will be returned from database as expression uses condtion on primary field
            //so get first record from returned values and retrive file content (binary) and filename 
            fileData = (byte[])w.ToArray();
            fileName = archivo.First().NombreArchivoReportado;
            //return file and provide byte file content and file name
            extension = archivo.First().ExtensionArchivoReportado;
            return File(fileData, "application/" + extension, fileName + "." + extension);
            //byte[] image = SieDocumentoEstructuras.getArchivoReportado(id);
            //if (image == null)
            //    return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
            //else

            //    return File(image, "image/jpg");
        }

        // POST: SieDocumentoEstructuras/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdDocumentoEstructura,IdDocumentoFecha,IdEstructuraOrganica,FechaAsignacion,ArchivoReportado,FechaReporte")] SieDocumentoEstructura sieDocumentoEstructura)
        {
            string[] area = Request.Form.AllKeys;
            List<short> listValues = new List<short>();
            foreach (string key in Request.Form.AllKeys)
            {
                if (key.StartsWith("Area_"))
                {
                    listValues.Add(Convert.ToInt16(Request.Form[key]));
                }
            }
            if (listValues.Count() == 0)
            {
                ModelState.AddModelError("IdDocumentoFecha", "Debe seleccionar por lo menos un área funcional a la que se asignará el documento");

            }
            for (int i = 0; i < listValues.Count(); i++)
            {
                SieDocumentoEstructura de = new SieDocumentoEstructura();
                de.FechaAsignacion = DateTime.Now;
                de.IdDocumentoFecha = sieDocumentoEstructura.IdDocumentoFecha;
                de.IdEstructuraOrganica = listValues[i];
                db.SieDocumentoEstructura.Add(de);
            }
             if (ModelState.IsValid)
             {
                 db.SaveChanges();
                 return RedirectToAction("Index");
             }

            ViewBag.IdDocumentoFecha = new SelectList((from s in db.SieDocumentoFecha.ToList() select new { IdDocumentoFecha = s.IdDocumentoFecha, NombreArchivo = s.SieDocumento.Documento + " | " + s.FechaInicio + " | " + s.FechaTermino }), "IdDocumentoFecha", "NombreArchivo");
            Nova.Libraries.Arbol.ShowEstructuraOrganicaChk(ViewData);
            return View(sieDocumentoEstructura);
            //return View();

        }

        // GET: SieDocumentoEstructuras/Edit/5
        public ActionResult Subir(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieDocumentoEstructura sieDocumentoEstructura = db.SieDocumentoEstructura.Find(id);
            if (sieDocumentoEstructura == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdDocumentoFecha = new SelectList(db.SieDocumentoFecha, "IdDocumentoFecha", "NombreArchivo", sieDocumentoEstructura.IdDocumentoFecha);
            return View(sieDocumentoEstructura);
        }

        // POST: SieDocumentoEstructuras/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Subir([Bind(Include = "IdDocumentoEstructura,IdDocumentoFecha,IdEstructuraOrganica,FechaAsignacion,ArchivoReportado,FechaReporte")] SieDocumentoEstructura sieDocumentoEstructura)
        {
            if (Request.Files[0].FileName != "")
            {
                sieDocumentoEstructura.ArchivoReportado = StreamHelpers.ReadFully(Request.Files[0].InputStream);
                string nombrearchivoextension = Request.Files[0].FileName;
                string[] nombrearchivo = nombrearchivoextension.Split(new Char[] { '.' });
                sieDocumentoEstructura.NombreArchivoReportado = nombrearchivo[0];
                sieDocumentoEstructura.ExtensionArchivoReportado = nombrearchivo[1];

                sieDocumentoEstructura.FechaReporte = DateTime.Now;
                if (ModelState.IsValid)
                {
                    db.Entry(sieDocumentoEstructura).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
                else
                {
                    ModelState.AddModelError("ArchivoReportado", "Los datos del archivo reportado están incompletos");

                }

            }
            else
            {
                ModelState.AddModelError("ArchivoReportado", "Debe seleccionar un archivo");
            }

            //ViewBag.IdDocumentoFecha = new SelectList(db.SieDocumentoFecha, "IdDocumentoFecha", "NombreArchivo", sieDocumentoEstructura.IdDocumentoFecha);
            return View(sieDocumentoEstructura);
        }

        // GET: SieDocumentoEstructuras/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            SieDocumentoEstructura sieDocumentoEstructura = db.SieDocumentoEstructura.Find(id);
            if (sieDocumentoEstructura == null)
            {
                return HttpNotFound();
            }
            if (sieDocumentoEstructura.FechaReporte != null)
            {
                throw new Exception("No es posible borrar la asignación del documento porque este ya ha sido reportado");

            }
            return View(sieDocumentoEstructura);
        }

        // POST: SieDocumentoEstructuras/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            SieDocumentoEstructura sieDocumentoEstructura = db.SieDocumentoEstructura.Find(id);
            db.SieDocumentoEstructura.Remove(sieDocumentoEstructura);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
