﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class SieDocumentoController : Controller
    {
        //
        // GET: /SieDocumento/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSieDocumento()
        {
            var model = db.SieDocumento;
            return PartialView("_pvSieDocumento", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieDocumentoAddNew(Nova.Models.SieDocumento item)
        {
            var model = db.SieDocumento;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSieDocumento", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieDocumentoUpdate(Nova.Models.SieDocumento item)
        {
            var model = db.SieDocumento;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdDocumento == item.IdDocumento);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvSieDocumento", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieDocumentoDelete(System.Int16 IdDocumento)
        {
            var model = db.SieDocumento;
            if (IdDocumento != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdDocumento == IdDocumento);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvSieDocumento", model.ToList());
        }
    }
}
