﻿using Dapper;
using log4net;
using Nova.Libraries;
using Nova.Models;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Net.Mail;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.RelojChecador
{
    public class RelojChecadorController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();
        // static HttpClient client = new HttpClient();

        private static readonly ILog log = LogManager.GetLogger(typeof(MvcApplication));


        //// GET: RelojChecador
        //public async Task<ActionResult> Index()
        //{
        //    return View(await db.Nomina_RelojChecadorAsistencia.ToListAsync());
        //}

        //// GET: RelojChecador/Details/5
        //public async Task<ActionResult> Details(long? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Nomina_RelojChecadorAsistencia nomina_RelojChecadorAsistencia = await db.Nomina_RelojChecadorAsistencia.FindAsync(id);
        //    if (nomina_RelojChecadorAsistencia == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(nomina_RelojChecadorAsistencia);
        //}

        // GET: RelojChecador/Create
        [Authorize]
        public ActionResult SubirArchivo()
        {
            return View();
        }

        // GET: RelojChecador/Create
        [AllowAnonymous]
        public JsonResult ProcesarIncidencias(short id)
        {
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            var t = rc.ProcesarIncidencias(id);

            return Json(t, JsonRequestBehavior.AllowGet);
        }

        //[AllowAnonymous]
        //public JsonResult GenerarFaltasPersonalSinAsistencias(short id,string fecha)
        //{
        //    Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
        //    DateTime f = DateTime.Parse(fecha);
        //     rc.GenerarFaltasPersonalSinAsistencias(f,id,true);

        //    return Json(true, JsonRequestBehavior.AllowGet);
        //}

      

        //[AllowAnonymous]
        //public JsonResult CerrarMes(short idEstructuraOrganicaReloj, string fi)
        //{
        //    Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador(true);
        //     rc.CierreMes(idEstructuraOrganicaReloj,fi,null,null);

        //    return Json("true", JsonRequestBehavior.AllowGet);
        //}

        [AllowAnonymous]
        public JsonResult ActulizarTablaControl()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string sql = @"insert into [Nomina_RelojChecadorControl]
select IdEstructuraOrganica,GETDATE()-1 fr,1 tr,1 tt,0 pf,0 pic
 from Nomina_RelojChecadorAreas
 WHERE IdEstructuraOrganica NOT IN (
 SELECT 
      [IdEstructuraOrganica]
  FROM [Nomina_RelojChecadorControl]   where CONVERT(nvarchar(10), FechaRegistro, 112)=CONVERT(nvarchar(10), GETDATE()-1  , 112)
 )";

           var r= dp.connection.Execute(sql, null, null, 0, null);

            dp.Close();
            return Json(r, JsonRequestBehavior.AllowGet);
        }


        [AllowAnonymous]
        public JsonResult ProcesarIncidenciasTesting(short idEstructuraOrganicaReloj, string fi, string ff)
        {
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();

            var relojes = db.Nomina_RelojChecadorAreas.ToList();

            bool r = false;
           
                r = rc.ProcesarIncidenciasTesting( idEstructuraOrganicaReloj,  fi,  ff);
             


            return Json(r, JsonRequestBehavior.AllowGet);
        }

        public static bool SendMail(string userEmail, string TituloCorreo, string mail)
        {
            string mailusuario = userEmail;




            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            //msg.To.Add(mailusuario);
            msg.To.Add("juan.carlos.manuel@cecyteo.edu.mx");
           
            msg.Subject = TituloCorreo;
            msg.IsBodyHtml = true;


            //UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);



            msg.Body = mail;
            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;




            try
            {
                client.Send(msg);

            }
            catch (Exception)
            {
                return false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }

            return true;
        }
        // GET: se procesan todos los relojes
        [AllowAnonymous]
        public JsonResult ProcesarAsistencias()
        {
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            
            //no tiene que ver con el reloj pero al ejecutarse todos los dias en la madrugada
            //se aprovecha para acutliuzar las plazas vacantes
            rc.ActualizaPlazasQueTerminanHoy();
            DateTime fechaminima = DateTime.Parse("2024-03-01");
            var areasquemandaninfo = db.Nomina_RelojChecadorControl.Where(a =>
              DbFunctions.TruncateTime(a.FechaRegistro) > DbFunctions.TruncateTime(fechaminima))
                .GroupBy(q=> q.IdEstructuraOrganica ).Select(q=> q.Key).ToList();
            /////
            ///
            var relojes =db.Nomina_RelojChecadorAreas.AsNoTracking()
                .Where(w=> areasquemandaninfo.Contains(w.IdEstructuraOrganica))
                .OrderBy(a=> a.IdEstructuraOrganica).ToList();
            int totalr = relojes.Count();
           // log.Info($"Inicia proceso total de relojes: { totalr}");
            bool r = false;
            int nreloj = 0;
            
            DateTime HoraInicioProceso = DateTime.Now;

            foreach (var item in relojes)
            {
                nreloj++;
                log.Info($"Procesando {item.IdEstructuraOrganica} - {item.EstructuraOrganica} {nreloj} de {totalr}");
                r = rc.ProcesarIncidencias(item.IdEstructuraOrganica);
            }

            DateTime HoraFinProceso = DateTime.Now;
            TimeSpan difference = HoraFinProceso - HoraInicioProceso;
            double seconds = Math.Round(difference.TotalSeconds, 2);

            TimeSpan t = TimeSpan.FromSeconds(seconds);
            SendMail("",$"{DateTime.Now.ToString("yyyy-MM-dd")} PROCESAR ASISTENCIAS",$" Se procesaron {nreloj} de {totalr} en un total de {t.ToString()}");

            return Json(r, JsonRequestBehavior.AllowGet);
        }

        [AllowAnonymous]
        public JsonResult testingporfechaTodos(string fi, string ff)
        {

            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            DateTime fechaInicio = DateTime.Parse(fi);
            DateTime fechaTermino = DateTime.Parse(ff);
            List<DateTime> listaFechas = Enumerable.Range(0, 1 + fechaTermino.Subtract(fechaInicio).Days)
            .Select(offset => fechaInicio.AddDays(offset))
            .ToList();

            bdNovaEntities bd = new bdNovaEntities();
            var todasAreasUsuario = db.Nomina_RelojChecadorAreas.ToList();
            bool r = false;
            foreach (var AreasUsuario in todasAreasUsuario)
            {

             
            // var AreasUsuario = db.Nomina_RelojChecadorAreas.ToList();

            var areasdetrabajo = bd.Nomina_RelojChecadorAreasEstructuraOrganica
                .Where(s => s.IdRelojChecadorAreas == AreasUsuario.IdRelojChecadorAreas ).ToList();

            //  var areasdatos = bd.Nomina_RelojChecadorControl.Where(s =>  areasdetrabajo.Contains(s.IdEstructuraOrganica)).GroupBy(a => a.IdEstructuraOrganica).Select(f => new { IdEstructuraOrganica = f.Key }).ToList();

            log.Info($"empezo {DateTime.Now}");

          
            foreach (var area in areasdetrabajo)
            {

                var empleados = bd.vwDatosAspirantesTrabajadores.Where(a => a.IdEstructuraOrganicaFisica == area.IdEstructuraOrganica
          && a.ConvenioLaboral=="CONTRATO" && a.EstatusTrabajador == "ALTA").Take(1).ToList();
                int totalempleados = empleados.Count();
                int empiter = 0;
                    bool yaprocesofaltas = false;
                foreach (var ele in empleados)
                {

                    empiter = empiter + 1;
                    foreach (var item in listaFechas)
                    {
                        log.Info($"fecha { item.ToString("yyyy-MM-dd")} ({empiter}/{totalempleados}) trabajador: {ele.IdTrabajador} area: {ele.UbicacionFisica}");
                        r = rc.ProcesarIncidenciasTestingId((int)ele.IdTrabajador, item.ToString("yyyy-MM-dd"), AreasUsuario.IdEstructuraOrganica, ref yaprocesofaltas ,false);

                    }
                }

            }

            log.Info($"termino: {DateTime.Now}");

        }
            return Json(r, JsonRequestBehavior.AllowGet);
        }

        [AllowAnonymous]
        public JsonResult Retardosporfecha(string f,int idt)
        {
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            DateTime fechaInicio = DateTime.Parse(f);
             rc.CreaFaltasPorRetardosYPases(fechaInicio,idt);
            return Json(true, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public JsonResult ReprocesarPorfechayreloj(int idreloj)
        { 
            
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
 
           

            bdNovaEntities bd = new bdNovaEntities();
            var Nomina_RelojChecadorAreas = bd.Nomina_RelojChecadorAreas.ToList();


            var AreasUsuario = db.Nomina_RelojChecadorAreas.Where(q =>
             q.IdEstructuraOrganica == idreloj).ToList();

           
           
              

            log.Info($"empezo {DateTime.Now}");

            bool r = false;
            foreach (var area in AreasUsuario)
            {

     
                      //  log.Info($"fecha {item.ToString("yyyy-MM-dd")} ({empiter}/{totalempleados}) trabajador: {ele.IdTrabajador} area: {ele.UbicacionFisica}");
                    //    yaprocesofaltasunavez = false;
                        r = rc.ProcesarIncidencias(area.IdEstructuraOrganica);

                     
                 

            }

            log.Info($"termino: {DateTime.Now}");

            return Json(new
            {
                success = true,
                message = $"Asistencias procesadas para el reloj {idreloj} "
                ,
                JsonRequestBehavior.AllowGet
            });
            //return Json(r, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public JsonResult ReprocesarPorfechayrelojantes(string fi, string ff, short idreloj)
        {
            DateTime fechai = DateTime.Parse(fi);
            DateTime fechat = DateTime.Parse(ff);
  //          TransactionOptions transactionoptions1 = new TransactionOptions();
  //          transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
           
  //          using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
  //          {
  //              DapperQuery dp = new DapperQuery("bdNovaEntities");
  //             string query2 = $@" select *  from 
  // [IncidenciaPermiso_stIncidenciaTrabajador]
  //where IdTipoIncidencia in (2,8) and EsFaltaDirecta=0 and 
  //FechaInicio>='{fechai.ToString("yyyyMMdd")}' and FechaInicio<='{fechat.ToString("yyyyMMdd")}'
  //and IdConvenioLaboralTrabajadorCategoria in(
  //select IdConvenioLaboralTrabajadorCategoria
  //FROM  [Nomina_RelojChecadorAsistencia]
  //where  IdEstructuraOrganica={idreloj} and FechaAsistencia>='{fechai.ToString("yyyyMMdd")}' and FechaAsistencia<='{fechat.ToString("yyyyMMdd")}'
  
  //)";
  //              var ss = dp.connection.Execute(query2);

  //              string query3 = $@" delete
  //FROM  [Nomina_RelojChecadorAsistencia]
  //where  IdEstructuraOrganica={idreloj} and FechaAsistencia>='{fechai.ToString("yyyyMMdd")}' and FechaAsistencia<='{fechat.ToString("yyyyMMdd")}'";
  //              var del = dp.connection.Execute(query3);



  //              scope.Complete();
  //          }
                Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            DateTime fechaInicio = DateTime.Parse(fi);
            DateTime fechaTermino = DateTime.Parse(ff);
            List<DateTime> listaFechas = Enumerable.Range(0, 1 + fechaTermino.Subtract(fechaInicio).Days)
            .Select(offset => fechaInicio.AddDays(offset))
            .ToList();

            bdNovaEntities bd = new bdNovaEntities();
            var Nomina_RelojChecadorAreas = bd.Nomina_RelojChecadorAreas.ToList();


            var AreasUsuario = db.Nomina_RelojChecadorAreas.Where(q =>
             q.IdEstructuraOrganica == idreloj).FirstOrDefault();

            var relojVinculadoaOtro = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica == idreloj).FirstOrDefault();
            List<short> areasInvoucradas = new List<short>();

            List<Nomina_RelojChecadorControl> control = new List<Nomina_RelojChecadorControl>();
      
            var areasporgrupo = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica == idreloj).Select(s => s.IdEstructuraOrganica).ToArray();
            areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(w => areasporgrupo.Contains(w.Nomina_RelojChecadorAreas.IdEstructuraOrganica)).Select(a => a.IdEstructuraOrganica).ToList();

            var areasdetrabajo = bd.Nomina_RelojChecadorAreasEstructuraOrganica
                .Where(s => areasInvoucradas.Contains(s.IdEstructuraOrganica)).ToList();

          
            log.Info($"empezo {DateTime.Now}");

            bool r = false;
            foreach (var area in areasdetrabajo)
            {

                var empleados = bd.vwDatosAspirantesTrabajadoresHistorial.Where(a => a.IdEstructuraOrganicaFisica == area.IdEstructuraOrganica
            && (a.FechaTermino == null || a.FechaTermino.Value.Year >= DateTime.Now.Year - 1)).ToList();



                int totalempleados = empleados.Count();
                int empiter = 0;
                bool yaprocesofaltasunavez = false;
                foreach (var ele in empleados)
                {

                    empiter = empiter + 1;
                    var usahorarios = true;
                

                    foreach (var item in listaFechas)
                    {



                        log.Info($"fecha {item.ToString("yyyy-MM-dd")} ({empiter}/{totalempleados}) trabajador: {ele.IdTrabajador} area: {ele.UbicacionFisica}");
                        yaprocesofaltasunavez = false;
                        r = rc.ProcesarIncidenciasTestingId((int)ele.IdTrabajador, item.ToString("yyyy-MM-dd"), idreloj, ref yaprocesofaltasunavez, usahorarios);

                    }
                }

            }

            log.Info($"termino: {DateTime.Now}");

            return Json(new
            {
                success = true,
                message = $"Asistencias procesadas para el reloj {idreloj} desde {fechai.ToShortDateString()} hasta {fechat.ToShortDateString()}"
                ,JsonRequestBehavior.AllowGet
            });
            //return Json(r, JsonRequestBehavior.AllowGet);
        }

        [AllowAnonymous]
        public JsonResult testingporfechayreloj( string fi, string ff, short idreloj)
        {

            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            DateTime fechaInicio = DateTime.Parse(fi);
            DateTime fechaTermino = DateTime.Parse(ff);
            List<DateTime> listaFechas = Enumerable.Range(0, 1 + fechaTermino.Subtract(fechaInicio).Days)
            .Select(offset => fechaInicio.AddDays(offset))
            .ToList();

            bdNovaEntities bd = new bdNovaEntities();
            var Nomina_RelojChecadorAreas = bd.Nomina_RelojChecadorAreas.ToList();

         
            var AreasUsuario = db.Nomina_RelojChecadorAreas.Where(q =>
             q.IdEstructuraOrganica == idreloj).FirstOrDefault();

            var relojVinculadoaOtro = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica == idreloj).FirstOrDefault();
            List<short> areasInvoucradas = new List<short>();

            List<Nomina_RelojChecadorControl> control = new List<Nomina_RelojChecadorControl>();
            //bool haygrupos = false;
            //if (relojVinculadoaOtro != null)
            //{
            //    if (relojVinculadoaOtro.IdRelojAreasGrupo != null)
            //        haygrupos = true;
            //}

            //bool ProcesoDeFaltasCompletado = false;
            //bool totalareasengrupocompletado = false;

            //if (haygrupos)
            //{
            //    var areasporgrupo = Nomina_RelojChecadorAreas.Where(s => s.IdRelojAreasGrupo == relojVinculadoaOtro.IdRelojAreasGrupo).Select(s => s.IdEstructuraOrganica).ToArray();
            //    areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(s => areasporgrupo.Contains(s.Nomina_RelojChecadorAreas.IdEstructuraOrganica)).Select(a => a.IdEstructuraOrganica).ToList();
            //}
            //else
            //{
            //    var areasporgrupo = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica==idreloj).Select(s => s.IdEstructuraOrganica).ToArray();
            //    areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(w => areasporgrupo.Contains(w.Nomina_RelojChecadorAreas.IdEstructuraOrganica)).Select(a => a.IdEstructuraOrganica).ToList();
            //}

            var areasporgrupo = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica == idreloj).Select(s => s.IdEstructuraOrganica).ToArray();
            areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(w => areasporgrupo.Contains(w.Nomina_RelojChecadorAreas.IdEstructuraOrganica)).Select(a => a.IdEstructuraOrganica).ToList();

            var areasdetrabajo = bd.Nomina_RelojChecadorAreasEstructuraOrganica
                .Where(s => areasInvoucradas.Contains(s.IdEstructuraOrganica) ).ToList();

          //  var areasdatos = bd.Nomina_RelojChecadorControl.Where(s =>  areasdetrabajo.Contains(s.IdEstructuraOrganica)).GroupBy(a => a.IdEstructuraOrganica).Select(f => new { IdEstructuraOrganica = f.Key }).ToList();

            log.Info($"empezo {DateTime.Now}");

            bool r = false;
            foreach (var area in areasdetrabajo )
            {

                var empleados = bd.vwDatosAspirantesTrabajadoresHistorial.Where(a => a.IdEstructuraOrganicaFisica == area.IdEstructuraOrganica
            && (a.FechaTermino==null || a.FechaTermino.Value.Year>=DateTime.Now.Year-1)).ToList();


                
                int totalempleados = empleados.Count();
                int empiter = 0;
                bool yaprocesofaltasunavez = false;
                foreach (var ele in empleados)
                {

                    empiter=empiter+1;
                    var usahorarios = true;
                    //if (ele.RelacionLaboral == "DOCENTE")
                    //{ usahorarios = true; }

                    
                    foreach (var item in listaFechas)
                    {
                         
                              

                        log.Info($"fecha { item.ToString("yyyy-MM-dd")} ({empiter}/{totalempleados}) trabajador: {ele.IdTrabajador} area: {ele.UbicacionFisica}");
                        yaprocesofaltasunavez = false;
                        r = rc.ProcesarIncidenciasTestingId((int)ele.IdTrabajador, item.ToString("yyyy-MM-dd"), idreloj, ref yaprocesofaltasunavez, usahorarios);

                    }
                }

            }

            log.Info($"termino: {DateTime.Now}");

            return Json(r, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public JsonResult testingporfecha(int id, string fi,string ff, short idr)
        {
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
            DateTime fechaInicio = DateTime.Parse(fi);
            DateTime fechaTermino = DateTime.Parse(ff);
            List<DateTime> listaFechas = Enumerable.Range(0, 1 + fechaTermino.Subtract(fechaInicio).Days)
            .Select(offset => fechaInicio.AddDays(offset))
            .ToList();

            bool r = false;

            foreach (var item in listaFechas)
            {
                 r = false;
                r = rc.ProcesarIncidenciasTestingId(id, item.ToString("yyyy-MM-dd"), idr, ref r,true);

            }



            return Json(r, JsonRequestBehavior.AllowGet);
        }


        [AllowAnonymous]
        public JsonResult testing(int id,string fecha,short idr)
        {
            Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();

          

            bool r = false;
           
                r = rc.ProcesarIncidenciasTestingId(id,fecha, idr,ref r);
            


            return Json(r, JsonRequestBehavior.AllowGet);
        }
        // GET: RelojChecador/Create
        //public ActionResult PruebaIncidencia(int id,int anio,int mes ,int dia)
        //{
        //   Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
        //    rc.CrearIncidencia(1889, new DateTime(anio,mes,dia),4);
        //    return View();
        //}
        // POST: RelojChecador/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        //[HttpPost]
        //[ValidateAntiForgeryToken]
        //public async Task<ActionResult> Create([Bind(Include = "IdRelojChecadorAsistencia,IdEstructuraOrganica,IdModalidadEstudio,iGLCount,IdTrabajador,idwVerifyMode,idwInOutMode,FechaAsistencia,Workcode")] Nomina_RelojChecadorAsistencia nomina_RelojChecadorAsistencia)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        db.Nomina_RelojChecadorAsistencia.Add(nomina_RelojChecadorAsistencia);
        //        await db.SaveChangesAsync();
        //        return RedirectToAction("Index");
        //    }

        //    return View(nomina_RelojChecadorAsistencia);
        //}

        //// GET: RelojChecador/Edit/5
        //public async Task<ActionResult> Edit(long? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Nomina_RelojChecadorAsistencia nomina_RelojChecadorAsistencia = await db.Nomina_RelojChecadorAsistencia.FindAsync(id);
        //    if (nomina_RelojChecadorAsistencia == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(nomina_RelojChecadorAsistencia);
        //}

        // POST: RelojChecador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        //[HttpPost]
        //[ValidateAntiForgeryToken]
        //public async Task<ActionResult> Edit([Bind(Include = "IdRelojChecadorAsistencia,IdEstructuraOrganica,IdModalidadEstudio,iGLCount,IdTrabajador,idwVerifyMode,idwInOutMode,FechaAsistencia,Workcode")] Nomina_RelojChecadorAsistencia nomina_RelojChecadorAsistencia)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        db.Entry(nomina_RelojChecadorAsistencia).State = EntityState.Modified;
        //        await db.SaveChangesAsync();
        //        return RedirectToAction("Index");
        //    }
        //    return View(nomina_RelojChecadorAsistencia);
        //}

        //// GET: RelojChecador/Delete/5
        //public async Task<ActionResult> Delete(long? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Nomina_RelojChecadorAsistencia nomina_RelojChecadorAsistencia = await db.Nomina_RelojChecadorAsistencia.FindAsync(id);
        //    if (nomina_RelojChecadorAsistencia == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(nomina_RelojChecadorAsistencia);
        //}

        //// POST: RelojChecador/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        //public async Task<ActionResult> DeleteConfirmed(long id)
        //{
        //    Nomina_RelojChecadorAsistencia nomina_RelojChecadorAsistencia = await db.Nomina_RelojChecadorAsistencia.FindAsync(id);
        //    db.Nomina_RelojChecadorAsistencia.Remove(nomina_RelojChecadorAsistencia);
        //    await db.SaveChangesAsync();
        //    return RedirectToAction("Index");
        //}

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


        static async Task<Uri> CreateRecord(Nomina_RelojChecadorAsistencia record)
        {
            using (var client = new HttpClient())
            {
                var modeProduction = System.Convert.ToBoolean(ConfigurationManager.AppSettings["ModeProduction"]);
                string uri = "";
                if (modeProduction)
                    uri = "http://nova.sytes.net:81/services/";
                   // uri = "http://192.168.1.218:81/services/";
                else
                    uri = "https://localhost:44339/";

                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(
                    new MediaTypeWithQualityHeaderValue("application/json"));


                HttpResponseMessage response = await client.PostAsJsonAsync(
                uri+"api/RelojChecadorAsistencias", record);
                response.EnsureSuccessStatusCode();

                // return URI of the created resource.
                return response.Headers.Location;
            }
        }

        static async Task<Nomina_RelojChecadorAsistencia> ValidaQueNoExistaRegistro(string path)
        {
            Nomina_RelojChecadorAsistencia asistencia = null;


            using (var client = new HttpClient())
            {

                var modeProduction=System.Convert.ToBoolean(ConfigurationManager.AppSettings["ModeProduction"]);
                string uri = "";
                if (modeProduction)
                    //string uri = "http://nova.sytes.net:81/services/";
                    uri = "http://192.168.1.218:81/services/";
                    else
                    uri = "https://localhost:44339/";

                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(
                    new MediaTypeWithQualityHeaderValue("application/json"));


                // HttpResponseMessage response = await client.PostAsJsonAsync(
                //uri + "api/RelojChecadorControl", asistencia);
                // response.EnsureSuccessStatusCode();

                // return URI of the created resource.
                //  return response.Headers.Location;

                HttpResponseMessage response = await client.GetAsync(uri+path);



                if (response.IsSuccessStatusCode)
                {
                    asistencia = await response.Content.ReadAsAsync<Nomina_RelojChecadorAsistencia>();
                }

            }



            return asistencia;
        }
        static async Task<Uri> CreateLastSending(Nomina_RelojChecadorControl record)
        {
            using (var client = new HttpClient())
            {
                var modeProduction = System.Convert.ToBoolean(ConfigurationManager.AppSettings["ModeProduction"]);
                string uri = "";
                if (modeProduction)
                    //string uri = "http://nova.sytes.net:81/services/";
                    uri = "http://192.168.1.218:81/services/";
                else
                    uri = "https://localhost:44339/";

                
                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(
                    new MediaTypeWithQualityHeaderValue("application/json"));


                HttpResponseMessage response = await client.PostAsJsonAsync(
               uri+ "api/RelojChecadorControl", record);
                response.EnsureSuccessStatusCode();

                // return URI of the created resource.
                return response.Headers.Location;
            }
        }

        private List<Nomina_RelojChecadorAsistencia> getDataFile(HttpPostedFileBase postedFile)
        {

            var streamfile = new StreamReader(postedFile.InputStream);
            var streamline = string.Empty;
            var counter = 0;
            var createddate = DateTime.Now;
            Nova.Models.RelojChecador ubicaciones = new Nova.Models.RelojChecador();
            int IdEstructuraOrganica = 0;
            int trabajadoresInsertados = 0;
            List<Nomina_RelojChecadorAsistencia> ListaAsistencia = new List<Nomina_RelojChecadorAsistencia>();


            try
            {
                while ((streamline = streamfile.ReadLine()) != null)
                {
                    counter++;
                    var datos = CryptorEngine.Decrypt(streamline, true);

                    string[] values = datos.Split(',');


                    IdEstructuraOrganica = Libraries.ConvertToInt.ConvertToInt32(values[0]);
                    var esta = ubicaciones.CatalogoEstructuraOrganica.Where(b => b.IdEstructuraOrganica == IdEstructuraOrganica).FirstOrDefault();

                    if (esta != null)
                    {
                        Nomina_RelojChecadorAsistencia Asistencia = new Nomina_RelojChecadorAsistencia();


                        DateTime fechaasistencia = DateTime.Parse(values[6]);




                        Asistencia.FechaAsistencia = fechaasistencia;
                        Asistencia.IdEstructuraOrganica = Libraries.ConvertToInt.ConvertToInt16(values[0]);
                        Asistencia.IdModalidadEstudio = Libraries.ConvertToInt.ConvertToInt16(values[1]);
                        Asistencia.IdTrabajador = Libraries.ConvertToInt.ConvertToInt32(values[3]);
                        Asistencia.idwInOutMode = Libraries.ConvertToInt.ConvertToInt32(values[5]);
                        Asistencia.idwVerifyMode = Libraries.ConvertToInt.ConvertToInt32(values[4]);
                        Asistencia.iGLCount = Libraries.ConvertToInt.ConvertToInt32(values[2]);
                        Asistencia.Workcode = Libraries.ConvertToInt.ConvertToInt32(values[7]);
                        ListaAsistencia.Add(Asistencia);



                    }
                    else
                        throw new ApplicationException("El Archivo no se puede procesar, asegurese que es el archivo generado por la aplicación oficial ");

                }



            }
            catch (Exception ex)
            {
                throw new ApplicationException("El Archivo no es válido ");
            }

            return ListaAsistencia;
        }

        [HttpPost]
        [Authorize]
        public async Task<ActionResult> UploadFileAsync(HttpPostedFileBase postedFile)
        {
            if (postedFile != null && postedFile.ContentLength > 0)
            {
                string mensajefinal = "";
                List<Nomina_RelojChecadorAsistencia> Universo = getDataFile(postedFile);
                var ideo = Universo[0].IdEstructuraOrganica;
                var SubUniverso = Universo.GroupBy(s => s.FechaAsistencia.Date).OrderBy(v => v.Key).Select(q => new { FechaAsistencia = q.Key }).ToList();
                var ultimafechabd = db.Nomina_RelojChecadorControl.Where(z => z.IdEstructuraOrganica == ideo).OrderByDescending(w => w.FechaRegistro).FirstOrDefault();

                foreach (var registro in SubUniverso)
                {


                    List<Nomina_RelojChecadorAsistencia> ListaInsertados = new List<Nomina_RelojChecadorAsistencia>();
                    // var registromasactual = Universo.OrderByDescending(x => x.FechaAsistencia).FirstOrDefault();
                    var registromasactual = Universo.Where(x => x.FechaAsistencia.Date == registro.FechaAsistencia.Date).FirstOrDefault();



                    var fechaarchivo = new DateTime(registromasactual.FechaAsistencia.Year, registromasactual.FechaAsistencia.Month, registromasactual.FechaAsistencia.Day);
                    var fechabd = new DateTime(ultimafechabd.FechaRegistro.Year, ultimafechabd.FechaRegistro.Month, ultimafechabd.FechaRegistro.Day);

                    if (fechabd >= fechaarchivo)
                    { throw new ApplicationException("El archivo que intenta cargar, ya ha sido procesado con anterioridad, revise su información"); }

                    int Insertados = 0;
                    DateTime Fecharegistroactual = new DateTime();
                    var datosaprocesar = Universo.Where(w => w.FechaAsistencia.Date == registro.FechaAsistencia.Date).ToList();
                    foreach (var item in datosaprocesar)
                    {
                        Nomina_RelojChecadorAsistencia Asistencia = new Nomina_RelojChecadorAsistencia();


                        Fecharegistroactual = item.FechaAsistencia;

                        Asistencia.FechaAsistencia = item.FechaAsistencia;
                        Asistencia.IdEstructuraOrganica = item.IdEstructuraOrganica;
                        Asistencia.IdModalidadEstudio = item.IdModalidadEstudio;
                        Asistencia.IdTrabajador = item.IdTrabajador;
                        Asistencia.idwInOutMode = item.idwInOutMode;
                        Asistencia.idwVerifyMode = item.idwVerifyMode;
                        Asistencia.iGLCount = item.iGLCount;
                        Asistencia.Workcode = item.Workcode;

                        try
                        {

                            Nomina_RelojChecadorAsistencia ExisteRegistro = new Nomina_RelojChecadorAsistencia();

                            ExisteRegistro = await ValidaQueNoExistaRegistro( "api/AsistenciasTrabajador/" + item.IdTrabajador.ToString() + "/" + item.IdEstructuraOrganica.ToString() + "/" + item.FechaAsistencia.Year.ToString() + "/" + item.FechaAsistencia.Month.ToString() + "/" + item.FechaAsistencia.Day.ToString() + "/" + item.FechaAsistencia.Hour.ToString() + "/" + item.FechaAsistencia.Minute.ToString() + "/" + item.FechaAsistencia.Second.ToString());

                            if (ExisteRegistro == null)
                            {
                                var url = await CreateRecord(Asistencia);
                                
                            }
                            
                            Insertados++;
                            ListaInsertados.Add(Asistencia);
                        }
                        catch (Exception ex)
                        {


                        }

                    }


                    if (Insertados > 0)
                    {


                        Nomina_RelojChecadorControl UltimoAccesoControl = new Nomina_RelojChecadorControl();
                        UltimoAccesoControl.FechaRegistro = Fecharegistroactual;
                        UltimoAccesoControl.IdEstructuraOrganica = (short)ideo;
                        UltimoAccesoControl.TotalRegistros = Insertados;

                        var totaltrabajadores = ListaInsertados.GroupBy(x => x.IdTrabajador).Select(b => b.Key).ToList();
                        UltimoAccesoControl.TotalTrabajadores = totaltrabajadores.Count;

                        var r = await CreateLastSending(UltimoAccesoControl);
                        ViewBag.Error = false;
                        mensajefinal = mensajefinal+
                         @"<p></p><div><h2>Se ha completado Exitosamente la operación para el dia: "+Fecharegistroactual.Date +@" </h2>
                        <p>Total de Registros:" + Insertados + @" </p>
                        <p> Total de Trabajadores:" + UltimoAccesoControl.TotalTrabajadores + " </ p > </div>";
                        ProcesarIncidencias(ideo);
                    }
                    else
                    {
                        ViewBag.Error = true;
                        ViewBag.Message = " No se ha insertado ningún trabajador por que el archivo ya haya sido procesado";
                    }



                }


                //  }




                ViewBag.Message = mensajefinal;
            }
            
            return View();
        }

    }
}