﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;

namespace Nova.Controllers
{
    public class RelacionConvenioLaboralController : Controller
    {
        //
        // GET: /RelacionConvenioLaboral/

        public ActionResult Index()
        {
            return View();
        }


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvRelacionConvenioLaboral()
        {
            var model = db.Convenios_stRelacionConvenioLaboral;
            return PartialView("_pvRelacionConvenioLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvRelacionConvenioLaboralAddNew(Nova.Models.Convenios_stRelacionConvenioLaboral item)
        {
            var model = db.Convenios_stRelacionConvenioLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvRelacionConvenioLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvRelacionConvenioLaboralUpdate(Nova.Models.Convenios_stRelacionConvenioLaboral item)
        {
            var model = db.Convenios_stRelacionConvenioLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdRelacionConvenioLaboral == item.IdRelacionConvenioLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvRelacionConvenioLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvRelacionConvenioLaboralDelete(System.Int16 IdRelacionConvenioLaboral)
        {
            var model = db.Convenios_stRelacionConvenioLaboral;
            if (IdRelacionConvenioLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdRelacionConvenioLaboral == IdRelacionConvenioLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvRelacionConvenioLaboral", model.ToList());
        }
    }
}
