﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers
{
    public class ProcesosActividadController : Controller
    {
        //
        // GET: /ProcesosActividad/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvProcesosActividad()
        {
            var model = db.Procesos_ctProcesosActividad;
            return PartialView("__pvgvProcesosActividad", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvProcesosActividadAddNew(Nova.Models.Procesos_ctProcesosActividad item)
        {
            var model = db.Procesos_ctProcesosActividad;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message; 
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors." + ModelState.Values.SelectMany(m => m.Errors)
                                  .Select(g => g.ErrorMessage).ToList().FirstOrDefault().ToString();

            return PartialView("__pvgvProcesosActividad", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvProcesosActividadUpdate(Nova.Models.Procesos_ctProcesosActividad item)
        {
            var model = db.Procesos_ctProcesosActividad;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdProcesosActividad == item.IdProcesosActividad);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvProcesosActividad", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvProcesosActividadDelete(System.Int16 IdProcesosActividad)
        {
            var model = db.Procesos_ctProcesosActividad;
            if (IdProcesosActividad != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdProcesosActividad == IdProcesosActividad);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message; 
                }
            }
            return PartialView("__pvgvProcesosActividad", model.ToList());
        }
    }
}
