﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.ProcesoTrabajador
{
    public class ProcesoTrabajadorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: ProcesoTrabajador
        public ActionResult Index(int IdAmonestacionTrabajador)
        {
            
             var ft = (from a in db.Juridico_stAmonestacionTrabajador
                     where a.IdAmonestacionTrabajador == IdAmonestacionTrabajador
                      select new
                      {
                          
                             FechaTerminoAmonestación = a.FechaTerminoAmonestacion
                      });

             foreach (var item in ft)
            {


               Session["FechaTerminoAmonestacion"] = item.FechaTerminoAmonestación.ToString();
               
                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
            }
              
            Session["IdAmonestacionTrabajador"] = IdAmonestacionTrabajador;


            var lista_ProcesoAmonestacionTrabajador = db.Juridico_stProcesoTrabajador.Where(z => z.IdAmonestacionTrabajador == IdAmonestacionTrabajador).ToList();
            var juridico_stProcesoTrabajador = db.Juridico_stProcesoTrabajador.Include(j => j.Juridico_ctProceso).Include(j => j.Juridico_stAmonestacionTrabajador);
            return View(lista_ProcesoAmonestacionTrabajador.ToList());
        }

        // GET: ProcesoTrabajador/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stProcesoTrabajador juridico_stProcesoTrabajador = db.Juridico_stProcesoTrabajador.Find(id);
            if (juridico_stProcesoTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(juridico_stProcesoTrabajador);
        }

        // GET: ProcesoTrabajador/Create
        [HttpPost]
        public ActionResult Crear()
        {
             Juridico_stProcesoTrabajador model = new Juridico_stProcesoTrabajador ();
             model.IdAmonestacionTrabajador = Nova.Libraries.ConvertToInt.ConvertToInt16 (Session["IdAmonestacionTrabajador"].ToString());
            ViewBag.IdProceso = new SelectList(db.Juridico_ctProceso, "IdProceso", "Proceso");
            ViewBag.IdAmonestacionTrabajador = Session["IdAmonestacionTrabajador"];
            ViewBag.IdAmonestacionTrabajador = new SelectList(db.Juridico_stAmonestacionTrabajador.Where (a=> a.IdAmonestacionTrabajador == model.IdAmonestacionTrabajador ), "IdAmonestacionTrabajador", "Amonestacion");
           
            
            return View("Create", model);
        }

        // POST: ProcesoTrabajador/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProcesoTrabajador,IdAmonestacionTrabajador,IdProceso,Proceso,ObservacionProceso,FechaInicioProceso,FechaTerminoProceso")] Juridico_stProcesoTrabajador juridico_stProcesoTrabajador)
        {
            int IdAmonestacionTrabajador = (int)Session["IdAmonestacionTrabajador"]; 
            if (ModelState.IsValid)
            {
                juridico_stProcesoTrabajador.IdAmonestacionTrabajador = (short)IdAmonestacionTrabajador;
                db.Juridico_stProcesoTrabajador.Add(juridico_stProcesoTrabajador);
                db.SaveChanges();
                return RedirectToAction("Index", new { IdAmonestacionTrabajador = IdAmonestacionTrabajador });
                //return RedirectToAction("Index");
            }

            ViewBag.IdProceso = new SelectList(db.Juridico_ctProceso, "IdProceso", "Proceso", juridico_stProcesoTrabajador.IdProceso);
            ViewBag.IdAmonestacionTrabajador = new SelectList(db.Juridico_stAmonestacionTrabajador, "IdAmonestacionTrabajador", "Amonestacion", juridico_stProcesoTrabajador.IdAmonestacionTrabajador);
            return View(juridico_stProcesoTrabajador);
        }

        // GET: ProcesoTrabajador/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stProcesoTrabajador juridico_stProcesoTrabajador = db.Juridico_stProcesoTrabajador.Find(id);
            if (juridico_stProcesoTrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdProceso = new SelectList(db.Juridico_ctProceso, "IdProceso", "Proceso", juridico_stProcesoTrabajador.IdProceso);
            ViewBag.IdAmonestacionTrabajador = new SelectList(db.Juridico_stAmonestacionTrabajador, "IdAmonestacionTrabajador", "Amonestacion", juridico_stProcesoTrabajador.IdAmonestacionTrabajador);
            return View(juridico_stProcesoTrabajador);
        }

        // POST: ProcesoTrabajador/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProcesoTrabajador,IdAmonestacionTrabajador,IdProceso,Proceso,ObservacionProceso,FechaInicioProceso,FechaTerminoProceso")] Juridico_stProcesoTrabajador juridico_stProcesoTrabajador)
        {
            int IdAmonestacionTrabajador = (int)Session["IdAmonestacionTrabajador"]; 
            if (ModelState.IsValid)
            {
                juridico_stProcesoTrabajador.IdAmonestacionTrabajador = (short) IdAmonestacionTrabajador;
                db.Entry(juridico_stProcesoTrabajador).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index", new { IdAmonestacionTrabajador = IdAmonestacionTrabajador });
                //return RedirectToAction("Index");
            }
            ViewBag.IdProceso = new SelectList(db.Juridico_ctProceso, "IdProceso", "Proceso", juridico_stProcesoTrabajador.IdProceso);
            ViewBag.IdAmonestacionTrabajador = new SelectList(db.Juridico_stAmonestacionTrabajador, "IdAmonestacionTrabajador", "Amonestacion", juridico_stProcesoTrabajador.IdAmonestacionTrabajador);
            return View(juridico_stProcesoTrabajador);
        }

        // GET: ProcesoTrabajador/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stProcesoTrabajador juridico_stProcesoTrabajador = db.Juridico_stProcesoTrabajador.Find(id);
            if (juridico_stProcesoTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(juridico_stProcesoTrabajador);
        }

        // POST: ProcesoTrabajador/Delete/5
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(short id)
        {
            Juridico_stProcesoTrabajador juridico_stProcesoTrabajador = db.Juridico_stProcesoTrabajador.Find(id);
            db.Juridico_stProcesoTrabajador.Remove(juridico_stProcesoTrabajador);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
