﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SiteTipoArticuloController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /TipoArticulo/
        public ActionResult Index()
        {
            return View(db.Portal_TipoArticulo.ToList());
        }

        // GET: /TipoArticulo/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_TipoArticulo portal_tipocategoria = db.Portal_TipoArticulo.Find(id);
            if (portal_tipocategoria == null)
            {
                return HttpNotFound();
            }
            return View(portal_tipocategoria);
        }

        // GET: /TipoArticulo/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: /TipoArticulo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdTipoArticulo,TipoArticulo")] Portal_TipoArticulo portal_tipoarticulo)
        {

            if (ModelState.IsValid)
            {
                db.Portal_TipoArticulo.Add(portal_tipoarticulo);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(portal_tipoarticulo);
        }

        // GET: /TipoArticulo/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_TipoArticulo portal_tipoarticulo = db.Portal_TipoArticulo.Find(id);
            if (portal_tipoarticulo == null)
            {
                return HttpNotFound();
            }
            return View(portal_tipoarticulo);
        }

        // POST: /TipoArticulo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdTipoArticulo,TipoArticulo")] Portal_TipoArticulo portal_tipocategoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(portal_tipocategoria).State = System.Data.Entity.EntityState.Modified; //EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(portal_tipocategoria);
        }

        // GET: /TipoArticulo/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_TipoArticulo portal_tipoarticulo = db.Portal_TipoArticulo.Find(id);
            if (portal_tipoarticulo == null)
            {
                return HttpNotFound();
            }
            return View(portal_tipoarticulo);
        }

        // POST: /TipoArticulo/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Portal_TipoArticulo portal_tipoarticulo = db.Portal_TipoArticulo.Find(id);
            db.Portal_TipoArticulo.Remove(portal_tipoarticulo);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
