﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.IO;
//using System.Configuration;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Web;
using System.Web.Mvc;

using System.Data;
using System.Data.Entity;
using Seguridad;
using Nova.Models.ARIES;
using Dapper;

namespace Nova.Controllers
{
    [AllowAnonymous]
    public class SiteController : Controller
    {
        bdAriesEntities bdAries = new bdAriesEntities();
        bdNovaEntities bdNova = new bdNovaEntities();
        bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index()
        {
            string fecha = DateTime.Now.Year + "-" + DateTime.Now.Month + "-" + DateTime.Now.Day;

            string query = @"SELECT url
                           FROM ENCyTEC_ctConferencias
            where Fecha= @fecha and  Activa= 1";

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string url = dp.connection.ExecuteScalar<string>(query, new { fecha });

            dp.Close();
            ViewBag.URL = url;

            ViewBag.SepRss = Nova.Models.SepRssReader.GetFeed();
            EnviarCorreosPoa();
            return View();
        }

        public ActionResult Transparencia2023()
        {
            return View();
        }
        public ActionResult Transparencia2023Ok()
        {
            return View();
        }
        public ActionResult ObligacionesTransparencia()
        {
            return View();
        }



        public ActionResult Index2()
        {
            ViewBag.SepRss = Nova.Models.SepRssReader.GetFeed();
            EnviarCorreosPoa();
            return View();
        }
        public ActionResult IndexPrueba()
        {
            ViewBag.SepRss = Nova.Models.SepRssReader.GetFeed();
            EnviarCorreosPoa();
            return View();
        }
        public ActionResult Index3()
        {
            ViewBag.SepRss = Nova.Models.SepRssReader.GetFeed();
            EnviarCorreosPoa();
            return View();
        }
        public ActionResult Covid()
        {
            return View();
        }

        public ActionResult Construccion()
        {
            return View();
        }
        public ActionResult Mir2021()
        {
            return View();
        }
        public ActionResult Mir2022()
        {
            return View();
        }
        public ActionResult SistemaNacionalArchivos()
        {
            return View();
        }
        public ActionResult EncuentroNacional2021()
        {
            return View();
        }
        public ActionResult ENCyTEC22()
        {
            string fecha = DateTime.Now.Year + "-" + DateTime.Now.Month + "-" + DateTime.Now.Day;

            string query = @"SELECT url
                           FROM ENCyTEC_ctConferencias
            where Fecha= @fecha and  Activa= 1";

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string url = dp.connection.ExecuteScalar<string>(query, new { fecha });

            dp.Close();
            ViewBag.URL = url;

            return View();
        }
        public ActionResult ENCyTEC23()
        {
            string fecha = DateTime.Now.Year + "-" + DateTime.Now.Month + "-" + DateTime.Now.Day;

            string query = @"SELECT url
                           FROM ENCyTEC_ctConferencias
            where Fecha= @fecha and  Activa= 1";

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string url = dp.connection.ExecuteScalar<string>(query, new { fecha });

            dp.Close();
            ViewBag.URL = url;

            return View();
        }
        public ActionResult ContactoEncuentro()
        {
            return View();
        }
        public ActionResult ContactoEncuentro23()
        {
            return View();
        }
        public ActionResult Conferencias2021()
        {
            return View();
        }
        public ActionResult CapacitacionVirtual()
        {
            return View();
        }
        public ActionResult Talleres2021()
        {
            return View();
        }
        public ActionResult GuiaInscripciones()
        {
            return View();
        }
        
        public ActionResult Programa2021()
        {
            return View();
        }
        public ActionResult Expositores2021()
        {
            return View();
        }
        public ActionResult Actividades2021()
        {
            return View();
        }
        public ActionResult EducacionDual()
        {
            return View();
        }

        public ActionResult AntecedentesDual()
        {
            return View();

        }
        public ActionResult ActoresDual()
        {
            return View();

        }

        public ActionResult Dual()
        {
            return View();
        }
        public ActionResult BeneficiosDual()
        {
            return View();

        }
        public ActionResult RequisitosDual()
        {
            return View();

        }
        public ActionResult CaracteristicasDual()
        {
            return View();

        }

        public ActionResult SisIntIndicadores()
        {
            return View();
        }

        
        public ActionResult Mecatronica()
        {
            return View();
        }

        public ActionResult BolsaTrabajo()
        {
            return View();
        }

        public ActionResult ControlInterno()
        {
            return View();
        }

        public ActionResult AdministracionRiesgos()
        {
            return View();
        }
        public ActionResult Clausura()
        {
            return View();
        }

        public ActionResult Team()
        {
            return View();
        }

        public ActionResult EticaIntegridad()
        {
            return View();
        }
        public ActionResult AccionesGobierno()
        {
            return View();
        }


        public ActionResult OfertaEducativa(string m = null, int e = 0, string c = null, decimal longitud = 0, decimal latitud = 0)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var plazas = bd.Plazas_stDistribucionPlazaCategoria.Where(w =>
                  w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" A \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" B \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" C \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR \"A\"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR \"B\"").Select(v => v.IdDistribucionPlazaCategoria).ToArray();


            //List<Convenios_stConvenioLaboralTrabajadorCategoria> model = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => plazas.Contains(f.IdDistribucionPlazaCategoria)).ToList();
            ViewBag.ConvenioLaboralTrabajadorCategoria = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => plazas.Contains(f.IdDistribucionPlazaCategoria)).ToList();
            //return View(model);

            if (m == null)
            {
                ViewBag.ModalEstudio = "plantel";
                if (c == "" || c == null)
                {
                    ViewBag.CentroEducativo = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("PLANTEL NÚM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
                }
            }
            else if (m != null || m != "")
            {
                if (m == "plantel")
                {
                    ViewBag.ModalEstudio = "plantel";
                    if (c == "" || c == null)
                    {
                        ViewBag.CentroEducativo = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("PLANTEL NÚM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
                    }
                }
                else if (m == "emsad")
                {
                    ViewBag.ModalEstudio = "emsad";
                    if (c == "" || c == null)
                    {
                        ViewBag.CentroEducativo = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("EMSAD NÚM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
                        var eq = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("EMSAD NÚM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.IdCampusEquivalencia).FirstOrDefault();
                        ViewBag.EquivalenciaActive = eq;
                    }
                }
            }



            if (e != 0)
            {
                ViewBag.CentroEducativo = c;
                ViewBag.EquivalenciaActive = e;
                ViewBag.Longitud = longitud;
                ViewBag.Latitud = latitud;
            }



            return View();

        }




        public ActionResult Servicios()
        {
            return View();
        }
        public ActionResult ServicioSocial()
        {
            return View();
        }

        public ActionResult About()
        {
            return View();
        }
        public ActionResult Planteles()
        {
            return View();
        }
        public ActionResult Plantel()
        {

            return View();
        }
        public ActionResult Emsads()
        {
            return View();
        }
        public ActionResult Emsad()
        {
            return View();
        }
        public ActionResult Inscripciones()
        {
            return View();
        }
        public ActionResult Preinscripciones()
        {
            return View();
        }
        public ActionResult Reinscripciones()
        {
            return View();
        }
        public ActionResult Convenios()
        {
            return View();
        }
        public ActionResult ComunicacionSocial ()
        {
            return View();
        }
        public ActionResult Articulo21()
        {
            return View();
        }
        public ActionResult Articulo70()
        {
            return View();
        }
        public ActionResult Articulo702018()
        {
            return View();
        }
        public ActionResult Articulo702019()
        {
            return View();
        }
        public ActionResult Articulo702020()
        {
            return View();
        }
        public ActionResult Articulo702021()
        {
            return View();
        }
        public ActionResult Articulo702022()
        {
            return View();
        }
        public ActionResult Articulo702023()
        {
            return View();
        }
        public ActionResult Articulo71()
        {
            return View();
        }
        public ActionResult Articulo80()
        {
            return View();
        }
        public ActionResult Articulo81()
        {
            return View();
        }
        public ActionResult Antivirus()
        {
            return View();
        }
        public ActionResult Becas()
        {
            return View();
        }
        public ActionResult Vinculacion()
        {
            return View();
        }
        public ActionResult Calendarios()
        {
            return View();
        }
        public ActionResult Administracion()
        {
            return View();
        }
        public ActionResult InfoFinanciera()
        {
            return View();
        }
        public ActionResult InfoPresupuestal()
        {
            return View();
        }
        public ActionResult InfoProgramatica()
        {
            return View();
        }
        public ActionResult InfoFinancieraTransparencia()
        {
            return View();
        }
        public ActionResult DisciplinaFinanciera()
        {
            return View();
        }
        public ActionResult ApoyosSubsidios()
        {
            return View();
        }
        public ActionResult GobiernoAbierto()
        {
            return View();
        }
        public ActionResult BibliotecaVirtual()
        {
            return View();
        }

        public ActionResult Contact()
        {
            return View();
        }
        public ActionResult Obligaciones()
        {
            return View();
        }
        public ActionResult Transparencia()
        {
            return View();
        }
        public ActionResult SaludEmocional()
        {
            return View();
        }
        public ActionResult Sugerencias()
        {
            return View();
        }
        public ActionResult DatosGenerales()
        {
            return View();
        }
        public ActionResult FraccionI()
        {
            return View();
        }
        public ActionResult LeyGeneralSistemaCarrera()
        {
            return View();
        }
        public ActionResult Privacidad()
        {
            return View();
        }
        public ActionResult Capacitacion()
        {
            return View();
        }

        public ActionResult Multimedia()
        {
            return View();
        }

        public JsonResult ContactoNacional22(Mail mail)
        {
            JsonResult json = new JsonResult();
            if (ModelState.IsValid)
            {
                string MailTo = "nsantos@cecyteo.edu.mx";
                try
                {
                    SendMail.Paramether(mail.fname, mail.lname, mail.email, mail.subject, mail.message, MailTo);
                }
                catch (Exception)
                {


                }

            }

            return json;
        }

        public JsonResult SugerenciasMail(Mail mail)
        {
            JsonResult json = new JsonResult();
            if (ModelState.IsValid)
            {
                string MailTo = "quejasysugerencias@cecyteo.edu.mx";
                try
                {
                    SendMail.Paramether(mail.fname, mail.lname, mail.email, mail.subject, mail.message, MailTo);
                }
                catch (Exception)
                {


                }

            }

            return json;
        }
        public JsonResult ContactoDirectorio(Mail mail)
        {
            JsonResult json = new JsonResult();
            if (ModelState.IsValid)
            {
                string Directorio = System.Convert.ToString(Request["mailto"]);
                try
                {
                    SendMail.Paramether(mail.fname, mail.lname, mail.email, mail.subject, mail.message, Directorio);
                }
                catch (Exception)
                {


                }

            }

            return json;
        }

        public ActionResult Search()
        {
            String palabra = System.Convert.ToString(Request["search"]);
            ViewBag.palabra = palabra;
            return View();
        }

        public ActionResult Contenido(int id)
        {
            ViewBag.Contenido = id;
            return View();
        }



        public ActionResult Noticias(int? id, int? page)
        {

            ViewBag.Contenido = id;
            if (page != null)
            {
                ViewBag.Page = page;
            }
            else
            {
                ViewBag.Page = 1;
            }

            return View();
        }


        public ActionResult NoticiasTipo(String categoria = null)
        {
            ViewBag.Categoria = categoria;
            //ViewBag.Fecha = fecha;
            return View();
        }
        public ActionResult NoticiasFecha(int? anio, int? mes)
        {
            ViewBag.Anio = anio;
            ViewBag.Mes = mes;
            return View();
        }
        public ActionResult CarrerasTecnicas(int id)
        {
            ViewBag.CTid = id;
            return View();
        }
        public ActionResult Carreras()
        {
            return View();
        }

        public ActionResult Avisos(int id)
        {

            ViewBag.Aviso = id;
            return View();
        }
        public ActionResult Convocatorias(int id)
        {

            ViewBag.Conv = id;
            return View();
        }
        public ActionResult ConvocatoriaEspecial()
        {
            return View();
        }
        public ActionResult ResultadoConvocatoriaEspecial()
        {
            return View();
        }
        public ActionResult Cuadro()
        {


            return PartialView("CuadroHonor");
        }

        public ActionResult ConvocatoriasDisponibles()
        {
            var model = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles().ToList();
            if (model.Count()==0)
                throw new ApplicationException ("No existen convocatorias disponibles por el momento");
            return View(model);
        }

        public ActionResult ConvocatoriasDisponiblesPrevio(int id)
        {

            return View("ConvocatoriasDisponibles", Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponiblesPrevia(id).ToList());
        }

        public ActionResult getFotografia(string id)
        {
            CuadroHonor cuadro = CuadroHonor.Instance;

            string tipo = "jpg";
            byte[] image = PortalNovaAries.getFotografia(id, ref tipo, cuadro.alumnosDestacados);
            //string tipo = PortalNovaAries.getTipoFotografia(id);
            if (image != null)
                return File(image, tipo);
            else
                return null;
        }

        public ActionResult getFotografiaDirectivos(string id)
        {

            byte[] image = null;
            int director = 3829;
            string tipo = "jpg";

            if(id != director.ToString())
                image = PortalNovaAries.getFotografiaDirectivos(id);

            if (image == null)
                //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                return File("~/App_Themes/Nova/img/user.jpg", "image/jpg");
            else
                return File(image, tipo);

        }

        //public FileResult Download(string path)
        //{
        //    byte[] fileBytes = System.IO.File.ReadAllBytes("~/Content/Site/FilesUpload/" + path);

        //    return File(fileBytes, System.Net.Mime.MediaTypeNames.Application.Octet, path);
        //}

        public ActionResult Download(string fileName)
        {
            string fullpath = Request.MapPath("~/Content/Site/FilesUpload/" + fileName);
            return File(Nova.Models.Formatos.getByteFile(fullpath), System.Net.Mime.MediaTypeNames.Application.Octet, fileName);
        }

        byte[] GetFile(string s)
        {
            System.IO.FileStream fs = System.IO.File.OpenRead(s);
            byte[] data = new byte[fs.Length];
            int br = fs.Read(data, 0, data.Length);
            if (br != fs.Length)
                throw new System.IO.IOException(s);
            return data;
        }

        public JsonResult getPlanEstudios(int id)
        {
            try
            {
                List<PlanesEstudio> planes = new List<PlanesEstudio>();
                Int32 planVigente = bdAries.ctPlanEstudio.Where(t => t.IdStatusPlan == t.ctStatusPlan.IdStatusPlan && t.ctStatusPlan.Nombre == "VIGENTE" && t.IdCarrera == id).OrderByDescending(o => o.IdPlanEstudio).Select(s => s.IdPlanEstudio).FirstOrDefault();
                var details = bdAries.stPlanEstudioAsignatura.Where(t => t.IdAsignatura == t.ctAsignatura.IdAsignatura && t.IdPlanEstudio == planVigente).OrderBy(o => new { o.IdValorCiclo, o.Orden }).ToList();

                foreach (var item in details)
                {
                    PlanesEstudio lista = new PlanesEstudio();
                    lista.IdValorCiclo = item.IdValorCiclo;
                    lista.Orden = Convert.ToInt32(item.Orden);
                    lista.ClaveAsignatura = item.ClaveAsignatura;
                    lista.IdAsignatura = item.ctAsignatura.IdAsignatura;
                    lista.Nombre = item.ctAsignatura.Nombre;
                    lista.Creditos = item.ctAsignatura.Creditos;
                    lista.Componente = item.ctAsignatura.ctTipoComponente.Nombre;
                    planes.Add(lista);
                }

                return Json(new { Results = planes }, JsonRequestBehavior.AllowGet);
            }
            catch (Exception)
            {
                throw;
            }
        }

        //nota:
        //este metodo no se encuentra en la vista previa
        public void CountViewArticles(int id)
        {
            var modelItem = bdNova.Portal_Articulos.First(x => x.IdArticulo == id);
            if (modelItem != null)
            {
                modelItem.Visitas = bdNova.Portal_Articulos.Where(t => t.IdArticulo == id).Select(f => f.Visitas).FirstOrDefault() + 1;
                this.UpdateModel(modelItem);
                bdNova.SaveChanges();
            }

        }

        public void EnviarCorreosPoa()
        {
            var MesesRepetidas = db.Poa_NotificacionRetraso.Where(g => g.IdMes == DateTime.Now.Month).ToArray();
            int valormesrepetido = MesesRepetidas.Count();
            if (valormesrepetido == 0)
            {

                List<Poa_Calendario> ListaIndicadores = new List<Poa_Calendario>();
                List<string> CalendarioElementos = new List<string>() { "Programado", "Realizado" };
                ListaIndicadores = db.Poa_Calendario.Include("Poa_Indicadores").Where(c => c.IdMes == DateTime.Now.Month && CalendarioElementos.Contains(c.Poa_CalendarioElemento.CalendarioElemento)).ToList();
                var model = ListaIndicadores.OrderBy(x => x.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Numero).ThenBy(x => x.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria);

                var UsuariosModel = model.GroupBy(t => t.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria).ToList();
                List<int> IdUsuarios = new List<int>();
                foreach (var listItem in UsuariosModel)
                {
                    IdUsuarios.Add(listItem.FirstOrDefault().Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria);
                }


                foreach (var item in model.GroupBy(s => s.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria))
                {
                    int idclt = item.FirstOrDefault().Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria;
                    List<int> IdIndicadoresProgramados = new List<int>();
                    IdIndicadoresProgramados = model.Where(t => t.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria == idclt && t.Poa_CalendarioElemento.CalendarioElemento == "Programado").Select(i => i.IdIndicadores).ToList();
                    var RealizadoUsuario = model.Where(x => x.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && x.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria == idclt).Count();
                    var ProgramadoUsuario = IdIndicadoresProgramados.Count();
                    var PendientesUsuario = ProgramadoUsuario - model.Where(x => x.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && IdIndicadoresProgramados.Contains(x.IdIndicadores)).Count();
                    List<int> IdIndicadoresRealizados = new List<int>();
                    IdIndicadoresRealizados = model.Where(y => y.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && IdIndicadoresProgramados.Contains(y.IdIndicadores)).Select(t => t.IdIndicadores).ToList();
                    List<int> IdIndicadoresImprimir = new List<int>();
                    IdIndicadoresImprimir = IdIndicadoresProgramados.Except(IdIndicadoresRealizados).ToList();

                    int idConvenioUsuario = item.FirstOrDefault().Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria;
                    int idConvenioTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Include(t => t.Convenios_stConvenioLaboralTrabajador).Where(t => t.IdConvenioLaboralTrabajadorCategoria == idConvenioUsuario).Select(t => t.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    string CorreoUsuario = db.Kardex_ctTrabajador.Include(t => t.Kardex_ctDatosPersonales).Where(t => t.IdTrabajador == idConvenioTrabajador).Select(t => t.Kardex_ctDatosPersonales.CorreoElectronico).FirstOrDefault();




                    List<string> IndicadoresString = db.Poa_Indicadores.Where(a => IdIndicadoresImprimir.Contains(a.IdIndicadores)).Select(s => s.Indicador).ToList();

                    int dias = DateTime.Now.Day;

                    if (dias == 20 || dias == 25)
                    {
                        SendCorreoElectronico(CorreoUsuario, IndicadoresString);
                        //CorreoUsuario
                    }

                }

                Poa_NotificacionRetraso notificaciones = new Poa_NotificacionRetraso();
                notificaciones.IdMes = DateTime.Now.Month;
                notificaciones.Año = Convert.ToInt16(DateTime.Now.Year);
                db.Poa_NotificacionRetraso.Add(notificaciones);
                db.SaveChanges();
            }

        }


        public void SendCorreoElectronico(string corretoTo, List<string> indicadores)
        {
            string templateIndicadores = @"<br/><h3> Lista de indicadores pendientes:</h3> <br/>";

            foreach (var item in indicadores)
            {
                templateIndicadores = templateIndicadores + @"<a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: bold; font-family:Arial, sans-serif '> " + "  " + item + "  " + @" </a><br/>";
            }



            MailMessage msg = new MailMessage();
            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            string correoprestamo = corretoTo;
            //item.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
            //string tituloprestamo = "Retraso en manejo de información";
            msg.To.Add(correoprestamo);
            //msg.To.Add("aflores@cecyteo.edu.mx");
            //msg.To.Add("pzafra@cecyteo.edu.mx");

            msg.Subject = "Sistema NOVA";
            msg.IsBodyHtml = true;
            string cuerpo = @"<!doctype html>
                                                        <html xmlns='http://www.w3.org/1999/xhtml'>
                                                        <head>

                                                        <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

                                                        <title>Reporte de Retraso de Manejo de Información</title>

                                                        <style type='text/css'>
	                                                        .ReadMsgBody {width: 100%; background-color: #ffffff;}
	                                                        .ExternalClass {width: 100%; background-color: #ffffff;}
	                                                        body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
	                                                        table {border-collapse: collapse;}

	                                                        @media only screen and (max-width: 640px)  {
					                                                        body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					                                                        body[yahoo] .center {text-align: center!important;}
			                                                        }

	                                                        @media only screen and (max-width: 479px) {
					                                                        body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					                                                        body[yahoo] .center {text-align: center!important;}
			                                                        }

                                                        </style>
                                                        </head>

                                                        <body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

                                                        <!-- Wrapper -->
                                                        <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	                                                        <tr>
		                                                        <td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			                                                        <!-- Start Header-->
			                                                        <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				                                                        <tr>
					                                                        <td width='100%' bgcolor='#ffffff'>

                                                                                    <!-- Logo -->
                                                                                    <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td style='padding:10px 20px' class='center'>
                                                                                                <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table><!-- End Logo -->

                                                                                    <!-- Nav -->
                                                                                    <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table><!-- End Nav -->

					                                                        </td>
				                                                        </tr>
			                                                        </table><!-- End Header -->

		


                                                        <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


                                                                    <!-- 2 Column Images & Text Side by SIde -->
                                                                    <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#4D5B69' style='margin:0 auto;'>
                                                                        <tr>
                                                                            <td style='padding:10px 0'>
                                                                                    <table align='left' width='29%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td valign='top' align='center' class='center' style='padding-top:20px;color:#fff;' >
                                                                                                 <h1 style='text-align:center;' >Sistema NOVA</h1>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>
                                                                                    <table align='right' width='69%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                                                                                <table>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                    
                                                                                                        </td>
                                                                                                        <td valign='middle' style='padding:0 10px 10px 0'>
                                                                                                        <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>Estimado usuario: se le recuerda que es necesario reportar el avance de metas, la fecha límite es el 26 del presente mes.</a>
                                                                                                        <br />            
                                                                                                                        " + "  " + templateIndicadores + "  " + @"                                                                            
                                                                                                        
                                                                                                        <br />                                                                                                   
                                                                                                        <a href='#' style='text-decoration: none; font-size: 10px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>" + " Favor de resolver sus inconsistencias en un periodo corto de tiempo, recuerde que si persiste  el retraso recibirá usted un nuevo aviso" + " " + @" </a>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                                                                                                <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                             
                                                                                                    <br/><br/>

                                            

                                                                                                </p>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>

                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                                                                        </tr>
                                                                    </table><!-- End 2 Column Images & Text Side by SIde -->


                                                        <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			                                                        <!-- Two Column (Images Stacked over Text) -->
			 
 
       
 

                                                        <div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


			                                                        <!-- 4 Columns -->
			                                                        <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				                                                        <tr>
					                                                        <td bgcolor='#14B9D6' style='padding:30px 0'>
                                                                                <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                                                                                    <tr>
                                                                                        <td>
                                                                                                <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='font-size: 11px; color: #4D5B69; color:#4D5B69; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                                                                           Departamento de Sistemas, Redes y Soporte Técnico | 
                                                                                                            <a href='www.cecyteo.edu.mx/nova' style='color:#4D5B69;text-decoration:none;'>NOVA - " + DateTime.Now.Year + @"</a><br/>

                                                                                                            <br/><br/>
                                                   

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                                                                                                <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='font-size: 11px; color: #4D5B69; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                                                                             Todos los Derechos Reservados - Cecyteo  

                                                                                                            <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>

                                                   
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                        		                                                        </td>
                        	                                                        </tr>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                    </table><!-- End 4 Columns -->

		                                                        </td>
	                                                        </tr>
                                                        </table> <!-- End Wrapper -->
                                                        <div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
                                                        - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                                                        </div>
                                                        </body>
                                                        </html>";

            msg.Body = cuerpo;
            //msg.Body = "Favor de pasar a entregar la pelicula:" +  " " + tituloprestamo + " "+ "ya que el tiempo del prestamo ha vencido";
            SmtpClient client = new SmtpClient();

            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false; 
            client.Send(msg);
            //Cinedebates_stPrestamos prestamo = db.Cinedebates_stPrestamos.Where(b => b.FechaEntrega == null && b.Notificacion == false && b.IdPrestamo == item.IdPrestamo).FirstOrDefault();
            //prestamo.Notificacion = true;
            //db.Entry(prestamo).State = System.Data.Entity.EntityState.Modified;
            //db.SaveChanges();
        }




    }
}