﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Web.Helpers;
using System.IO;

namespace Nova.Controllers
{
    public class SiteCicloEscolarController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /SiteCicloEscolar/
        public ActionResult Index()
        {
            return View(db.Portal_CicloEscolar.OrderByDescending(t => t.IdCicloEscolar).ToList());
        }

        // GET: /SiteCicloEscolar/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_CicloEscolar portal_cicloescolar = db.Portal_CicloEscolar.Find(id);
            if (portal_cicloescolar == null)
            {
                return HttpNotFound();
            }
            return View(portal_cicloescolar);
        }

        // GET: /SiteCicloEscolar/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: /SiteCicloEscolar/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdCicloEscolar,NombreCicloEscolar,FechaInicioCiclo,FechaTerminoCiclo,EntregaFichaInicio,EntregaFichaFin,InicioInscripcionReinscripcion,FinInscripcionReinscripcion,RequisitosNuevoIngreso,CalendarioUrl")] Portal_CicloEscolar portal_cicloescolar)
        {
            String fileName = Request.Files[0].FileName;
            string ext = "";
            if (fileName != "" && fileName != null)
            {


                if (ModelState.IsValid)
                {

                    ext = fileName.Substring(fileName.LastIndexOf(".") + 1).ToLower();

                    if (portal_cicloescolar.ValidaExtension(ext).IsValid)
                    {
                        try
                        {
                            var Calendario = Request.Files[0];

                            String ruta = Server.MapPath("~/Content/Site/Calendar");
                            if (!Directory.Exists(ruta))
                            {
                                Directory.CreateDirectory(ruta);
                            }

                            var CalendarioPath = Path.Combine(Server.MapPath("~/Content/Site/Calendar/"), Path.GetFileName(fileName));
                            Calendario.SaveAs(CalendarioPath);


                            portal_cicloescolar.CalendarioUrl = fileName;
                            db.Portal_CicloEscolar.Add(portal_cicloescolar);
                            db.SaveChanges();
                            return RedirectToAction("Index");



                        }
                        catch (Exception e)
                        {
                            ModelState.AddModelError("", e);
                        }


                    }
                    else
                    {
                        ModelState.AddModelError("CalendarioUrl", "Conflicto con la extensión del archivo");
                    }



                }





            }
            else
            {
                ModelState.AddModelError("CalendarioUrl", "Seleccione un archivo");
            }


            return View(portal_cicloescolar);
        }

        // GET: /SiteCicloEscolar/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_CicloEscolar portal_cicloescolar = db.Portal_CicloEscolar.Find(id);
            if (portal_cicloescolar == null)
            {
                return HttpNotFound();
            }
            ViewBag.NameCalendario = portal_cicloescolar.CalendarioUrl;
            return View(portal_cicloescolar);
        }

        // POST: /SiteCicloEscolar/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCicloEscolar,NombreCicloEscolar,FechaInicioCiclo,FechaTerminoCiclo,EntregaFichaInicio,EntregaFichaFin,InicioInscripcionReinscripcion,FinInscripcionReinscripcion,RequisitosNuevoIngreso,CalendarioUrl")] Portal_CicloEscolar portal_cicloescolar)
        {
            var id = portal_cicloescolar.IdCicloEscolar;
            var calendar = db.Portal_CicloEscolar.Where(t => t.IdCicloEscolar == id).Select(s => s.CalendarioUrl).FirstOrDefault();

            String fileName = Request.Files[0].FileName;
            string ext = "";
            //ModelState["CalendarioUrl"].Errors.Clear();
            if (fileName != "")
            {
                ext = fileName.Substring(fileName.LastIndexOf(".") + 1).ToLower();

                if (portal_cicloescolar.ValidaExtension(ext).IsValid)
                {
                    try
                    {
                        var Calendario = Request.Files[0];

                        String ruta = Server.MapPath("~/Content/Site/Calendar");
                        if (!Directory.Exists(ruta))
                        {
                            Directory.CreateDirectory(ruta);
                        }

                        if (portal_cicloescolar.EliminarFile(ruta + "/" + calendar).IsValid)
                        {
                            var CalendarioPath = Path.Combine(Server.MapPath("~/Content/Site/Calendar/"), Path.GetFileName(fileName));
                            Calendario.SaveAs(CalendarioPath);


                            portal_cicloescolar.CalendarioUrl = fileName;
                        }


                    }
                    catch (Exception e)
                    {
                        ModelState.AddModelError("", "" + e);
                    }
                }
            }
            else
            {
                portal_cicloescolar.CalendarioUrl = calendar;
            }



            if (ModelState.IsValid)
            {
                db.Entry(portal_cicloescolar).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(portal_cicloescolar);
        }

        // GET: /SiteCicloEscolar/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_CicloEscolar portal_cicloescolar = db.Portal_CicloEscolar.Find(id);
            if (portal_cicloescolar == null)
            {
                return HttpNotFound();
            }
            return View(portal_cicloescolar);
        }

        // POST: /SiteCicloEscolar/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Portal_CicloEscolar portal_cicloescolar = db.Portal_CicloEscolar.Find(id);
            db.Portal_CicloEscolar.Remove(portal_cicloescolar);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
