﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SiteCategoriasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /Categorias/
        public ActionResult Index()
        {
            return View(db.Portal_Categoria.ToList());
        }

        // GET: /Categorias/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Categoria portal_categoria = db.Portal_Categoria.Find(id);
            if (portal_categoria == null)
            {
                return HttpNotFound();
            }
            return View(portal_categoria);
        }

        // GET: /Categorias/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: /Categorias/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdCategoria,Categoria")] Portal_Categoria portal_categoria)
        {
            if (ModelState.IsValid)
            {
                db.Portal_Categoria.Add(portal_categoria);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(portal_categoria);
        }

        // GET: /Categorias/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Categoria portal_categoria = db.Portal_Categoria.Find(id);
            if (portal_categoria == null)
            {
                return HttpNotFound();
            }
            return View(portal_categoria);
        }

        // POST: /Categorias/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCategoria,Categoria")] Portal_Categoria portal_categoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(portal_categoria).State = System.Data.Entity.EntityState.Modified;//EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(portal_categoria);
        }

        // GET: /Categorias/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Categoria portal_categoria = db.Portal_Categoria.Find(id);
            if (portal_categoria == null)
            {
                return HttpNotFound();
            }
            return View(portal_categoria);
        }

        // POST: /Categorias/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Portal_Categoria portal_categoria = db.Portal_Categoria.Find(id);
            db.Portal_Categoria.Remove(portal_categoria);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
