﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using Seguridad;
using Dapper;
//using Nova.Libraries;

namespace Nova.Controllers.POA
{
    public class PoaViaticosPasajesReportController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select 
MAX(ff.Numero) as NumeroProyecto
,ff.Proyecto
,max(k.EstructuraOrganica) EstructuraOrganica
,max(c.Indicador) Indicador
,d.ResumenNarrativo
,a.Dias,a.NumeroPersonas , a2.OrigenDestino
,a2.Tarifa
,a.ViajeRedondoPersona
,SUM(case when  b.idmes=1 then  (NumeroVisitas) ELSE 0 end ) Enero
,SUM(case when  b.idmes=2 then  (NumeroVisitas) else 0 end)  Febrero
,SUM(case when  b.idmes=3 then  (NumeroVisitas) else 0 end)   Marzo
,SUM(case when  b.idmes=4 then  (NumeroVisitas) else 0 end)   Abril
,SUM(case when  b.idmes=5 then  (NumeroVisitas) else 0 end)   Mayo
,SUM(case when  b.idmes=6 then  (NumeroVisitas) else 0 end)   Junio
,SUM(case when  b.idmes=7 then  (NumeroVisitas) else 0 end)   Julio
,SUM(case when  b.idmes=8 then  (NumeroVisitas) else 0 end)   Agosto
,SUM(case when  b.idmes=9 then  (NumeroVisitas) else 0 end)   Septiembre
,SUM(case when  b.idmes=10 then (NumeroVisitas) else 0 end)   Octubre
,SUM(case when  b.idmes=11 then (NumeroVisitas) else 0 end)   Noviembre
,SUM(case when  b.idmes=12 then (NumeroVisitas) else 0 end)  Diciembre
,SUM(case when (b.idmes)=1 then (a.TotalViaticos)  ELSE 0 end ) pEnero
,SUM(case when  b.idmes=2 then  (a.TotalViaticos) else 0 end)  pFebrero
,SUM(case when  b.idmes=3 then  (a.TotalViaticos) else 0 end)   pMarzo
,SUM(case when  b.idmes=4 then  (a.TotalViaticos) else 0 end)   pAbril
,SUM(case when  b.idmes=5 then  (a.TotalViaticos) else 0 end)   pMayo
,SUM(case when  b.idmes=6 then  (a.TotalViaticos) else 0 end)   pJunio
,SUM(case when  b.idmes=7 then  (a.TotalViaticos) else 0 end)   pJulio
,SUM(case when  b.idmes=8 then  (a.TotalViaticos) else 0 end)   pAgosto
,SUM(case when  b.idmes=9 then  (a.TotalViaticos) else 0 end)   pSeptiembre
,SUM(case when  b.idmes=10 then (a.TotalViaticos) else 0 end)   pOctubre
,SUM(case when  b.idmes=11 then (a.TotalViaticos) else 0 end)   pNoviembre
,SUM(case when  b.idmes=12 then (a.TotalViaticos) else 0 end)  pDiciembre
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN NumeroVisitas ELSE 0 END) as TotalVisitas
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN (a.TotalViaticos) ELSE 0 END) as ImporteTotalViaticos


,SUM(case when a3.TipoPasaje in ('Vehículo oficial') then 0 else 0 end) ImportePeaje
,SUM(case when a3.TipoPasaje in ('Vehículo oficial') then 0 else 0 end) ImporteTotalPeaje

,a.ImporteBoleto
,SUM(case when b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then a.TotalPasaje else 0 end) TotalPasaje
,a3.TipoPasaje
,MAX(case when c.PresupuestoCerrado=0 then 0 else 1 end) PresupuestoCerrado
 
--select *
from Poa_ViaticosPasajes a
inner join Poa_OrigenDestino a2 on a2.IdOrigenDestino = a.IdOrigenDestino
inner join Poa_TipoPasaje a3 on a3.IdTipoPasaje = a.IdTipoPasaje
inner join Poa_Calendario b on b.IdCalendario = a.IdCalendario
inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir in @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol and e.AñoArbol in @anio
inner join Poa_ProyectosAño f on f.IdProyectos=e.IdProyectos and f.AñoProyectos in @anio
INNER JOIN Poa_Proyectos ff on ff.IdProyectos = f.IdProyectos
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria=d.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica=j.IdEstructuraOrganica
where d.AñoMir in @anio
and ff.Proyecto in @proyecto
and k.EstructuraOrganica in @area
group by a2.OrigenDestino, a.Dias, a.NumeroPersonas, c.IdIndicadores, ff.Proyecto
,a.ViajeRedondoPersona, a3.TipoPasaje
,d.ResumenNarrativo, a2.Tarifa, a.ViajeRedondoPersona,a.ImporteBoleto
order by max(ff.Numero),max(EstructuraOrganica)
";

        string queryUser = @"select 
MAX(ff.Numero) as NumeroProyecto
,ff.Proyecto
,max(k.EstructuraOrganica) EstructuraOrganica
,max(c.Indicador) Indicador
,d.ResumenNarrativo
,a.Dias,a.NumeroPersonas , a2.OrigenDestino
,a2.Tarifa
,a.ViajeRedondoPersona
,SUM(case when  b.idmes=1 then  (NumeroVisitas) ELSE 0 end ) Enero
,SUM(case when  b.idmes=2 then  (NumeroVisitas) else 0 end)  Febrero
,SUM(case when  b.idmes=3 then  (NumeroVisitas) else 0 end)   Marzo
,SUM(case when  b.idmes=4 then  (NumeroVisitas) else 0 end)   Abril
,SUM(case when  b.idmes=5 then  (NumeroVisitas) else 0 end)   Mayo
,SUM(case when  b.idmes=6 then  (NumeroVisitas) else 0 end)   Junio
,SUM(case when  b.idmes=7 then  (NumeroVisitas) else 0 end)   Julio
,SUM(case when  b.idmes=8 then  (NumeroVisitas) else 0 end)   Agosto
,SUM(case when  b.idmes=9 then  (NumeroVisitas) else 0 end)   Septiembre
,SUM(case when  b.idmes=10 then (NumeroVisitas) else 0 end)   Octubre
,SUM(case when  b.idmes=11 then (NumeroVisitas) else 0 end)   Noviembre
,SUM(case when  b.idmes=12 then (NumeroVisitas) else 0 end)  Diciembre
,SUM(case when (b.idmes)=1 then (a.TotalViaticos)  ELSE 0 end ) pEnero
,SUM(case when  b.idmes=2 then  (a.TotalViaticos) else 0 end)  pFebrero
,SUM(case when  b.idmes=3 then  (a.TotalViaticos) else 0 end)   pMarzo
,SUM(case when  b.idmes=4 then  (a.TotalViaticos) else 0 end)   pAbril
,SUM(case when  b.idmes=5 then  (a.TotalViaticos) else 0 end)   pMayo
,SUM(case when  b.idmes=6 then  (a.TotalViaticos) else 0 end)   pJunio
,SUM(case when  b.idmes=7 then  (a.TotalViaticos) else 0 end)   pJulio
,SUM(case when  b.idmes=8 then  (a.TotalViaticos) else 0 end)   pAgosto
,SUM(case when  b.idmes=9 then  (a.TotalViaticos) else 0 end)   pSeptiembre
,SUM(case when  b.idmes=10 then (a.TotalViaticos) else 0 end)   pOctubre
,SUM(case when  b.idmes=11 then (a.TotalViaticos) else 0 end)   pNoviembre
,SUM(case when  b.idmes=12 then (a.TotalViaticos) else 0 end)  pDiciembre
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN NumeroVisitas ELSE 0 END) as TotalVisitas
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN (a.TotalViaticos) ELSE 0 END) as ImporteTotalViaticos


,SUM(case when a3.TipoPasaje in ('Vehículo oficial') then 0 else 0 end) ImportePeaje
,SUM(case when a3.TipoPasaje in ('Vehículo oficial') then 0 else 0 end) ImporteTotalPeaje

,a.ImporteBoleto
,SUM(case when b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then a.TotalPasaje else 0 end) TotalPasaje
,a3.TipoPasaje
,MAX(case when c.PresupuestoCerrado=0 then 0 else 1 end) PresupuestoCerrado

--select *
from Poa_ViaticosPasajes a
inner join Poa_OrigenDestino a2 on a2.IdOrigenDestino = a.IdOrigenDestino
inner join Poa_TipoPasaje a3 on a3.IdTipoPasaje = a.IdTipoPasaje
inner join Poa_Calendario b on b.IdCalendario = a.IdCalendario
inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir in @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol and e.AñoArbol in @anio
inner join Poa_ProyectosAño f on f.IdProyectos=e.IdProyectos and f.AñoProyectos in @anio
INNER JOIN Poa_Proyectos ff on ff.IdProyectos = f.IdProyectos
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria=d.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica=j.IdEstructuraOrganica
where d.AñoMir in @anio
and ff.Proyecto in @proyecto
and k.EstructuraOrganica in @area
and d.IdConvenioLaboralTrabajadorCategoria = @idusuario
group by a2.OrigenDestino, a.Dias, a.NumeroPersonas, c.IdIndicadores, ff.Proyecto
,a.ViajeRedondoPersona, a3.TipoPasaje
,d.ResumenNarrativo, a2.Tarifa, a.ViajeRedondoPersona,a.ImporteBoleto

";


//        string queryResponsable = @"select MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) from Poa_ProyectosAño a
//inner join Poa_ProyectosAñoAreas b on b.IdProyectosAño = a.IdProyectosAño and a.Año = (select top 1 Año from Poa_SistemaAñoVigente)
//inner join Catalogos_ctEstructuraOrganica c on c.IdEstructuraOrganica = b.IdEstructuraOrganica and c.EstructuraOrganica = @areaSingle
//inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
//inner join Poa_ProyectoArbol E ON E.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
//INNER JOIN Plazas_stDistribucionPlazaCategoria F ON F.IdDistribucionPlazaCategoria = d.IdDistribucionPlazaCategoria
//inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
//inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
//inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
//inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
//inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
//inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
//group by d.IdConvenioLaboralTrabajadorCategoria";

        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };


        public ActionResult Index()
        {

            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaViaticosPasajesReport");
            }

            return View();
        }


        // GET: PoaViaticosPasajesReport
        public ActionResult Admin()
        {
            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Index", "PoaProductosReporte");
            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by b.Numero";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


            string queryAreas = @" select c.EstructuraOrganica 
  from Poa_ProyectoArbol a
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult ViaticosPasajesView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReportViaticosPasajes> result = new List<ReportViaticosPasajes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            return PartialView("_ViaticosPasajes", result);
        }

        public ActionResult ViaticosPasajes(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReportViaticosPasajes> result = new List<ReportViaticosPasajes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(query, new { anio, proyecto, area });
            }
            else
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(queryUser, new { anio, proyecto, area, idusuario });
            }

            if (proyecto.Count() == 1 && area.Count() == 1)
            {
                if (rolAdmin.EsAdministrador())
                {
                    string areaSingle = area.FirstOrDefault();
                    var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                    ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                    ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();
                }
                else
                {
                    var usuario = Identidad.Usuario();
                    ViewBag.UsuarioU = "";
                    //ViewBag.UsuarioU = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
                }
            }else{
                ViewBag.UsuarioU = "NoUser";
            }
            
           

            dp.Close();

            string modalidad = "Poa_ViaticosPasajes" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult ViaticosPasajesXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReportViaticosPasajes> result = new List<ReportViaticosPasajes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();


            string modalidad = "Poa_ViaticosPasajes_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.Añomir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }



    }
}