﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.POA.SistemasConstantes
{
    public class PoaSistemaConstantesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: SistemaConstantes
        public ActionResult Index()
        {
            return PartialView(db.Poa_SistemaConstantes.ToList());
        }

        // GET: SistemaConstantes/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_SistemaConstantes poa_SistemaConstantes = db.Poa_SistemaConstantes.Find(id);
            if (poa_SistemaConstantes == null)
            {
                return HttpNotFound();
            }
            return View(poa_SistemaConstantes);
        }

        // GET: SistemaConstantes/Create
        public ActionResult Create()
        {
            return PartialView();
        }

        // POST: SistemaConstantes/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdSistemaConstantes,Constante,Valor")] Poa_SistemaConstantes poa_SistemaConstantes)
        {
            if (ModelState.IsValid)
            {
                var ConstantesRepetidas = db.Poa_SistemaConstantes.Where(g => g.Constante == poa_SistemaConstantes.Constante).ToArray();
                int valor = ConstantesRepetidas.Count();
                if (valor > 0)
                {

                    return Json(new { Valid = false, Message = "Ya existe una constante con el mismo nombre " });


                }

                else
                {

                    try
                    {

                        db.Poa_SistemaConstantes.Add(poa_SistemaConstantes);
                        db.SaveChanges();
                        return Json(new { Valid = true, Message = "La constante ha sido creado exitosamente" });
                    }
                    catch (Exception e)
                    {
                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        // all changes will be rolled back
                    }

                    return Json(new { Valid = true, Message = "La constante ha sido creado exitosamente" });
                    //return Redirect("~/Poa_Proyectos/Index");

                }

                
                //return Redirect("~/Poa_Proyectos/Index");
                //return RedirectToAction("Index");
            }

            string messages = string.Join("  ", ModelState.Values
                                          .SelectMany(x => x.Errors)
                                          .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }

        // GET: SistemaConstantes/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_SistemaConstantes poa_SistemaConstantes = db.Poa_SistemaConstantes.Find(id);
            if (poa_SistemaConstantes == null)
            {
                return HttpNotFound();
            }
            return View(poa_SistemaConstantes);
        }

        // POST: SistemaConstantes/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdSistemaConstantes,Constante,Valor")] Poa_SistemaConstantes poa_SistemaConstantes)
        {
            if (ModelState.IsValid)
            {
                try
                {

                    db.Entry(poa_SistemaConstantes).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    return Json(new { Valid = true, Message = "La constante ha sido modificado exitosamente" });
                }
                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    // all changes will be rolled back
                }

                return Json(new { Valid = true, Message = "La constante ha sido modificado exitosamente" });
                
              
            }
            string messages = string.Join("  ", ModelState.Values
                                         .SelectMany(x => x.Errors)
                                         .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }

        // GET: SistemaConstantes/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_SistemaConstantes poa_SistemaConstantes = db.Poa_SistemaConstantes.Find(id);
            if (poa_SistemaConstantes == null)
            {
                return HttpNotFound();
            }
            return View(poa_SistemaConstantes);
        }

        // POST: SistemaConstantes/Delete/5
       [HttpPost, ActionName("DeleteConfirmed")]
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(short id)
        {
            Poa_SistemaConstantes poa_SistemaConstantes = db.Poa_SistemaConstantes.Find(id);
            db.Poa_SistemaConstantes.Remove(poa_SistemaConstantes);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
        //    return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
