﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.Poa.Seguimiento;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.SeguimientoMetas
{
    public class PoaAvanceTrimestralController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();



        // GET: AvanceTrimestral
        public ActionResult Index()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre");


            return View();
        }

        public ActionResult AvanceTrimestral()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //string anio = Request["Anio"];
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                var mesesindicador = result.Where(m => m.IdIndicadores == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (mesesindicador != null)
                {
                    foreach (var registro in mesesindicador)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                        }

                    }
                }
                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }

                LindicadoresProgramadoRealizado.Add(avance);
            }

            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }


            return PartialView("_pvAvanceTrimestral", LindicadoresProgramadoRealizado);
        }

        public ActionResult AvanceTrimestralPdf()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //string anio = Request["Anio"];
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);

            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                var mesesindicador = result.Where(mes => mes.IdIndicadores == idindi && (mes.Mes == Mes1 || mes.Mes == Mes2 || mes.Mes == Mes3));
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (mesesindicador != null)
                {
                    foreach (var registro in mesesindicador)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                        }

                    }
                }
                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }

                LindicadoresProgramadoRealizado.Add(avance);
            }

            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }

            string modalidad = "Poa_AvanceTrimestral" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new PartialViewAsPdf("_AvanceTrimestralPdf", LindicadoresProgramadoRealizado) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };



        }

        public ActionResult AvanceTrimestralXls()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;


            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });
            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                var mesesindicador = result.Where(m => m.IdIndicadores == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (mesesindicador != null)
                {
                    foreach (var registro in mesesindicador)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                            //var poaot =
                            //       (from ot in db.Poa_CalendarioObservacionTrimestral
                            //        join ca in db.Poa_Calendario on ot.IdCalendario equals ca.IdCalendario
                            //        join ic in db.Poa_Indicadores on ca.IdIndicadores equals ic.IdIndicadores
                            //        join m in db.Catalogos_ctMes on ca.IdMes equals m.IdMes
                            //        where ic.IdIndicadores == registro.IdIndicadores && m.Mes == Mes3
                            //        select ot.Observacion).FirstOrDefault();

                            //if (poaot != null)
                            //{
                            //    avance.Observacion = poaot.ToString();
                            //}
                        }

                    }
                }


                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }


                LindicadoresProgramadoRealizado.Add(avance);
            }


            string modalidad = "AvanceTrimestralXls_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);


            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }

            return View(LindicadoresProgramadoRealizado);
        }

        public ActionResult AvanceTrimestralPdfPrueba()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //string anio = Request["Anio"];
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query);

            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                var mesesindicador = result.Where(mes => mes.IdIndicadores == idindi && (mes.Mes == Mes1 || mes.Mes == Mes2 || mes.Mes == Mes3));
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (mesesindicador != null)
                {
                    foreach (var registro in mesesindicador)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                        }

                    }
                }
                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }

                LindicadoresProgramadoRealizado.Add(avance);
            }

            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }

            string modalidad = "Poa_AvanceTrimestral" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new PartialViewAsPdf("_AvanceTrimestralPdfPrueba", LindicadoresProgramadoRealizado) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };



        }

        public ActionResult Actividades()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre");


            return View();
        }
        public ActionResult AvanceTrimestralActividades()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //string anio = Request["Anio"];
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = String.Empty, Mes2 = String.Empty, Mes3 = String.Empty;
            bool EsAnual = false;
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    EsAnual = true;
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);

            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos='Actividad'
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos='Actividad'
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                IEnumerable<AvanceTrimestral> mesesindicador;
                if (!EsAnual)
                    mesesindicador = result.Where(m => m.IdIndicadores == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                else
                    mesesindicador = result.Where(m => m.IdIndicadores == idindi);

                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (!EsAnual)
                {
                    if (mesesindicador != null)
                    {
                        foreach (var registro in mesesindicador)
                        {
                            if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                            {
                                avance.Valor1Programado = registro.Valor;
                                avance.Mes1Programado = Mes1;
                            }
                            if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                            {
                                avance.Valor1Realizado = registro.Valor;
                                avance.Mes1Realizado = Mes1;
                            }
                            if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                            {
                                avance.Valor2Programado = registro.Valor;
                                avance.Mes2Programado = Mes2;
                            }
                            if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                            {
                                avance.Valor2Realizado = registro.Valor;
                                avance.Mes2Realizado = Mes2;
                            }
                            if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                            {
                                avance.Valor3Programado = registro.Valor;
                                avance.Mes3Programado = Mes3;
                            }
                            if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                            {
                                avance.Valor3Realizado = registro.Valor;
                                avance.Mes3Realizado = Mes3;
                            }

                        }
                    }
                }
                else
                {

                    if (mesesindicador != null)
                    {
                        foreach (var registro in mesesindicador)
                        {
                            if (registro.CalendarioElemento == "Programado")
                            {
                                avance.Valor1Programado = registro.Valor;
                                avance.Mes1Programado = registro.Mes;
                            }
                            if (registro.CalendarioElemento == "Realizado")
                            {
                                avance.Valor1Realizado = registro.Valor;
                                avance.Mes1Realizado = registro.Mes;
                            }
                        }
                    }
                }
                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }

                LindicadoresProgramadoRealizado.Add(avance);
            }

            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }


            return PartialView("_pvAvanceTrimestral", LindicadoresProgramadoRealizado);
        }
        public ActionResult AvanceTrimestralActividadesPdf()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            bool EsAnual = false;
            //string anio = Request["Anio"];
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);

            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    EsAnual = true;
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos='Actividad'
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos='Actividad'
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                IEnumerable<AvanceTrimestral> mesesindicador;
                if (!EsAnual)
                    mesesindicador = result.Where(i => i.IdIndicadores == idindi && (i.Mes == Mes1 || i.Mes == Mes2 || i.Mes == Mes3));
                else
                    mesesindicador = result.Where(i => i.IdIndicadores == idindi);
                //var mesesindicador = result.Where(mes => mes.IdIndicadores == idindi && (mes.Mes == Mes1 || mes.Mes == Mes2 || mes.Mes == Mes3));
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (!EsAnual)
                {
                    if (mesesindicador != null)
                    {
                        foreach (var registro in mesesindicador)
                        {
                            if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                        }

                    }
                }
            }
                else
                {

                    if (mesesindicador != null)
                    {
                        foreach (var registro in mesesindicador)
                        {
                            if (registro.CalendarioElemento == "Programado")
                            {
                                avance.Valor1Programado = registro.Valor;
                                avance.Mes1Programado = registro.Mes;
                            }
                            if (registro.CalendarioElemento == "Realizado")
                            {
                                avance.Valor1Realizado = registro.Valor;
                                avance.Mes1Realizado = registro.Mes;
                            }
                        }
                    }
                }
                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }

                LindicadoresProgramadoRealizado.Add(avance);
            }

            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }

            string modalidad = "Poa_AvanceTrimestral" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new PartialViewAsPdf("_AvanceTrimestralActividadesPdf", LindicadoresProgramadoRealizado) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };



        }

        public ActionResult AvanceTrimestralActividadesXls()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            bool EsAnual = false;
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                case 5:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    EsAnual = true;
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos='Actividad'
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos='Actividad'
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });
            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                //var mesesindicador = result.Where(m => m.IdIndicadores == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                IEnumerable<AvanceTrimestral> mesesindicador;
                if (!EsAnual)
                    mesesindicador = result.Where(m => m.IdIndicadores == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                else
                    mesesindicador = result.Where(m => m.IdIndicadores == idindi);
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (!EsAnual)
                {
                    if (mesesindicador != null)
                {
                    foreach (var registro in mesesindicador)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                            //var poaot =
                            //       (from ot in db.Poa_CalendarioObservacionTrimestral
                            //        join ca in db.Poa_Calendario on ot.IdCalendario equals ca.IdCalendario
                            //        join ic in db.Poa_Indicadores on ca.IdIndicadores equals ic.IdIndicadores
                            //        join m in db.Catalogos_ctMes on ca.IdMes equals m.IdMes
                            //        where ic.IdIndicadores == registro.IdIndicadores && m.Mes == Mes3
                            //        select ot.Observacion).FirstOrDefault();

                            //if (poaot != null)
                            //{
                            //    avance.Observacion = poaot.ToString();
                            //}
                        }

                    }
                }
            }
                else
                {

                    if (mesesindicador != null)
                    {
                        foreach (var registro in mesesindicador)
                        {
                            if (registro.CalendarioElemento == "Programado")
                            {
                                avance.Valor1Programado = registro.Valor;
                                avance.Mes1Programado = registro.Mes;
                            }
                            if (registro.CalendarioElemento == "Realizado")
                            {
                                avance.Valor1Realizado = registro.Valor;
                                avance.Mes1Realizado = registro.Mes;
                            }
                        }
                    }
                }

                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                }


                LindicadoresProgramadoRealizado.Add(avance);
            }


            string modalidad = "AvanceTrimestralXls_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);


            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }

            return View(LindicadoresProgramadoRealizado);
        }
    }
}