﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.Poa.Seguimiento;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.SeguimientoMetas
{
    public class AvanceTrimestralEstatalController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: AvanceTrimestralEstatal
        public ActionResult Index()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");

            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre.Where(a => a.Trimestre != "ANUAL"), "IdPoaTrimestre", "Trimestre");
            //ViewBag.anio = añoviogente;
            return View();

        }
        public ActionResult AvanceTrimestralEstatal()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            //string anio = Request["Anio"];
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);

            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select d.ProyectoEstatal,d.Actividad,b.Meta,b.MetaDescripcion,h.Mes,c.Valor,ce.CalendarioElemento,f.IdIndicadores from Poa_EstructuraProgramaticaEstatal a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on b.IdEstructuraProgramaticaEstatalActividadAño =c.IdEstructuraProgramaticaEstatalActividadAño
inner join Poa_ProyectosEstatales d on a.IdProyectosEstatales = d.IdProyectosEstatales
inner join Poa_Mir e on a.IdMir = e.IdMir
inner join Poa_Indicadores f on e.IdMir = f.IdMir
inner join Poa_MirEstatus g on e.IdMirEstatus = g.IdMirEstatus
left join Poa_CalendarioElemento ce on c.IdCalendarioElemento = ce.IdCalendarioElemento
left join Catalogos_ctMes h on h.IdMes = c.IdMes
where g.EstatusMir='Indicadores Autorizados' and a.Año = @anioSeleccionado
and (ce.CalendarioElemento='Programado' or ce.CalendarioElemento='Realizado')
order by d.ProyectoEstatal,d.Actividad,h.Orden,c.IdCalendarioElemento desc";



            string queryUser = @"select d.ProyectoEstatal,d.Actividad,b.Meta,b.MetaDescripcion,h.Mes,c.Valor,ce.CalendarioElemento,f.IdIndicadores from Poa_EstructuraProgramaticaEstatal a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on b.IdEstructuraProgramaticaEstatalActividadAño =c.IdEstructuraProgramaticaEstatalActividadAño
inner join Poa_ProyectosEstatales d on a.IdProyectosEstatales = d.IdProyectosEstatales
inner join Poa_Mir e on a.IdMir = e.IdMir
inner join Poa_Indicadores f on e.IdMir = f.IdMir
inner join Poa_MirEstatus g on e.IdMirEstatus = g.IdMirEstatus
left join Poa_CalendarioElemento ce on c.IdCalendarioElemento = ce.IdCalendarioElemento
left join Catalogos_ctMes h on h.IdMes = c.IdMes
where g.EstatusMir='Indicadores Autorizados' and a.Año = @anioSeleccionado
and (ce.CalendarioElemento='Programado' or ce.CalendarioElemento='Realizado')
and f.IdConvenioLaboralTrabajadorCategoria =  @idusuario
order by d.ProyectoEstatal,d.Actividad,h.Orden,c.IdCalendarioElemento desc";






            //var result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(query, new { anioSeleccionado });

            List<AvanceTrimestralEstatal> result = new List<AvanceTrimestralEstatal>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();

            var grupoactividades = result.GroupBy(f => new { f.Actividad, f.IdIndicadores}).Select(r => new {actividad=r.Key.Actividad,idindicador=r.Key.IdIndicadores }).ToList();
            List<AvanceTrimestralEstatalProgramadoRealizado> LactividadesProgramadoRealizado = new List<AvanceTrimestralEstatalProgramadoRealizado>();
            foreach (var idindi in grupoactividades)
            {
                var mesesactividad = result.Where(m => m.Actividad == idindi.actividad && idindi.idindicador==m.IdIndicadores && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                AvanceTrimestralEstatalProgramadoRealizado avance = new AvanceTrimestralEstatalProgramadoRealizado();
                var actividadactual = result.Where(x => x.Actividad == idindi.actividad && x.IdIndicadores==idindi.idindicador).FirstOrDefault();
                avance.CalendarioElemento = actividadactual.CalendarioElemento;
                avance.Actividad = actividadactual.Actividad;
                avance.Meta = actividadactual.Meta;
                avance.MetaDescripcion = actividadactual.MetaDescripcion;
                avance.ProyectoEstatal = actividadactual.ProyectoEstatal;
                // falta la observaación del trimestre
                if (mesesactividad != null)
                {
                    foreach (var registro in mesesactividad)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                            
                        }
                        var poaot =
                                   (from ot in db.Poa_CalendarioObservacionTrimestralEstatal
                                    join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
                                    where ic.IdIndicadores == registro.IdIndicadores && ot.IdPoaTrimestre == idTrimestre
                                    select ot.Observacion).FirstOrDefault();

                        if (poaot != null)
                        {
                            avance.Observacion = poaot.ToString();
                        }
                    }
                }
                LactividadesProgramadoRealizado.Add(avance);
            }

            return PartialView("_pvAvanceTrimestralEstatal", LactividadesProgramadoRealizado.Distinct().ToList());
        }
        public ActionResult AvanceTrimestralEstatalPdf()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            //string anio = Request["Anio"];
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);

            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select d.ProyectoEstatal,d.Actividad,b.Meta,b.MetaDescripcion,h.Mes,c.Valor,ce.CalendarioElemento,f.IdIndicadores from Poa_EstructuraProgramaticaEstatal a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on b.IdEstructuraProgramaticaEstatalActividadAño =c.IdEstructuraProgramaticaEstatalActividadAño
inner join Poa_ProyectosEstatales d on a.IdProyectosEstatales = d.IdProyectosEstatales
inner join Poa_Mir e on a.IdMir = e.IdMir
inner join Poa_Indicadores f on e.IdMir = f.IdMir
inner join Poa_MirEstatus g on e.IdMirEstatus = g.IdMirEstatus
left join Poa_CalendarioElemento ce on c.IdCalendarioElemento = ce.IdCalendarioElemento
left join Catalogos_ctMes h on h.IdMes = c.IdMes
where g.EstatusMir='Indicadores Autorizados' and a.Año = @anioSeleccionado
and (ce.CalendarioElemento='Programado' or ce.CalendarioElemento='Realizado')
order by d.ProyectoEstatal,d.Actividad,h.Orden,c.IdCalendarioElemento desc";



            string queryUser = @"select d.ProyectoEstatal,d.Actividad,b.Meta,b.MetaDescripcion,h.Mes,c.Valor,ce.CalendarioElemento,f.IdIndicadores from Poa_EstructuraProgramaticaEstatal a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on b.IdEstructuraProgramaticaEstatalActividadAño =c.IdEstructuraProgramaticaEstatalActividadAño
inner join Poa_ProyectosEstatales d on a.IdProyectosEstatales = d.IdProyectosEstatales
inner join Poa_Mir e on a.IdMir = e.IdMir
inner join Poa_Indicadores f on e.IdMir = f.IdMir
inner join Poa_MirEstatus g on e.IdMirEstatus = g.IdMirEstatus
left join Poa_CalendarioElemento ce on c.IdCalendarioElemento = ce.IdCalendarioElemento
left join Catalogos_ctMes h on h.IdMes = c.IdMes
where g.EstatusMir='Indicadores Autorizados' and a.Año = @anioSeleccionado
and (ce.CalendarioElemento='Programado' or ce.CalendarioElemento='Realizado')
and f.IdConvenioLaboralTrabajadorCategoria =  @idusuario
order by d.ProyectoEstatal,d.Actividad,h.Orden,c.IdCalendarioElemento desc";






            //var result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(query, new { anioSeleccionado });

            List<AvanceTrimestralEstatal> result = new List<AvanceTrimestralEstatal>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();

            var grupoactividades = result.GroupBy(f => new { f.Actividad, f.IdIndicadores }).Select(r => new { actividad = r.Key.Actividad, idindicador = r.Key.IdIndicadores }).ToList();
            List<AvanceTrimestralEstatalProgramadoRealizado> LactividadesProgramadoRealizado = new List<AvanceTrimestralEstatalProgramadoRealizado>();
            foreach (var idindi in grupoactividades)
            {
                var mesesactividad = result.Where(z => z.Actividad == idindi.actividad && idindi.idindicador == z.IdIndicadores && (z.Mes == Mes1 || z.Mes == Mes2 || z.Mes == Mes3));
                AvanceTrimestralEstatalProgramadoRealizado avance = new AvanceTrimestralEstatalProgramadoRealizado();
                var actividadactual = result.Where(x => x.Actividad == idindi.actividad && x.IdIndicadores == idindi.idindicador).FirstOrDefault();
                avance.CalendarioElemento = actividadactual.CalendarioElemento;
                avance.Actividad = actividadactual.Actividad;
                avance.Meta = actividadactual.Meta;
                avance.MetaDescripcion = actividadactual.MetaDescripcion;
                avance.ProyectoEstatal = actividadactual.ProyectoEstatal;
                // falta la observaación del trimestre
                if (mesesactividad != null)
                {
                    foreach (var registro in mesesactividad)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;

                        }
                        var poaot =
                                   (from ot in db.Poa_CalendarioObservacionTrimestralEstatal
                                    join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
                                    where ic.IdIndicadores == registro.IdIndicadores && ot.IdPoaTrimestre == idTrimestre
                                    select ot.Observacion).FirstOrDefault();

                        if (poaot != null)
                        {
                            avance.Observacion = poaot.ToString();
                        }
                    }
                }
                LactividadesProgramadoRealizado.Add(avance);
            }
            string modalidad = "Poa_AvanceTrimestralEstatal" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;

            //return PartialView("_pvAvanceTrimestralEstatal", LactividadesProgramadoRealizado);
            return new PartialViewAsPdf("_pvAvanceTrimestralEstatalPdf", LactividadesProgramadoRealizado.Distinct().ToList()) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult AvanceTrimestralEstatalXls()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            //string anio = Request["Anio"];
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);

            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select d.ProyectoEstatal,d.Actividad,b.Meta,b.MetaDescripcion,h.Mes,c.Valor,ce.CalendarioElemento,f.IdIndicadores from Poa_EstructuraProgramaticaEstatal a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on b.IdEstructuraProgramaticaEstatalActividadAño =c.IdEstructuraProgramaticaEstatalActividadAño
inner join Poa_ProyectosEstatales d on a.IdProyectosEstatales = d.IdProyectosEstatales
inner join Poa_Mir e on a.IdMir = e.IdMir
inner join Poa_Indicadores f on e.IdMir = f.IdMir
inner join Poa_MirEstatus g on e.IdMirEstatus = g.IdMirEstatus
left join Poa_CalendarioElemento ce on c.IdCalendarioElemento = ce.IdCalendarioElemento
left join Catalogos_ctMes h on h.IdMes = c.IdMes
where g.EstatusMir='Indicadores Autorizados' and a.Año = @anioSeleccionado
and (ce.CalendarioElemento='Programado' or ce.CalendarioElemento='Realizado')
order by d.ProyectoEstatal,d.Actividad,h.Orden,c.IdCalendarioElemento desc";



            string queryUser = @"select d.ProyectoEstatal,d.Actividad,b.Meta,b.MetaDescripcion,h.Mes,c.Valor,ce.CalendarioElemento,f.IdIndicadores from Poa_EstructuraProgramaticaEstatal a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on b.IdEstructuraProgramaticaEstatalActividadAño =c.IdEstructuraProgramaticaEstatalActividadAño
inner join Poa_ProyectosEstatales d on a.IdProyectosEstatales = d.IdProyectosEstatales
inner join Poa_Mir e on a.IdMir = e.IdMir
inner join Poa_Indicadores f on e.IdMir = f.IdMir
inner join Poa_MirEstatus g on e.IdMirEstatus = g.IdMirEstatus
left join Poa_CalendarioElemento ce on c.IdCalendarioElemento = ce.IdCalendarioElemento
left join Catalogos_ctMes h on h.IdMes = c.IdMes
where g.EstatusMir='Indicadores Autorizados' and a.Año = @anioSeleccionado
and (ce.CalendarioElemento='Programado' or ce.CalendarioElemento='Realizado')
and f.IdConvenioLaboralTrabajadorCategoria =  @idusuario
order by d.ProyectoEstatal,d.Actividad,h.Orden,c.IdCalendarioElemento desc";






            //var result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(query, new { anioSeleccionado });

            List<AvanceTrimestralEstatal> result = new List<AvanceTrimestralEstatal>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestralEstatal>)dp.connection.Query<AvanceTrimestralEstatal>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();

            var grupoactividades = result.GroupBy(f => f.Actividad).Select(r => r.Key).ToList();
            List<AvanceTrimestralEstatalProgramadoRealizado> LactividadesProgramadoRealizado = new List<AvanceTrimestralEstatalProgramadoRealizado>();
            foreach (var idindi in grupoactividades)
            {
                var mesesactividad = result.Where(m => m.Actividad == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                AvanceTrimestralEstatalProgramadoRealizado avance = new AvanceTrimestralEstatalProgramadoRealizado();
                var actividadactual = result.Where(x => x.Actividad == idindi).FirstOrDefault();
                avance.CalendarioElemento = actividadactual.CalendarioElemento;
                avance.Actividad = actividadactual.Actividad;
                avance.Meta = actividadactual.Meta;
                avance.MetaDescripcion = actividadactual.MetaDescripcion;
                avance.ProyectoEstatal = actividadactual.ProyectoEstatal;
                // falta la observaación del trimestre
                if (mesesactividad != null)
                {
                    foreach (var registro in mesesactividad)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                            var poaot =
                                   (from ot in db.Poa_CalendarioObservacionTrimestral
                                    join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
                                    where ic.IdIndicadores == registro.IdIndicadores && ot.IdPoaTrimestre == idTrimestre
                                    select ot.Observacion).FirstOrDefault();

                            if (poaot != null)
                            {
                                avance.Observacion = poaot.ToString();
                            }
                        }

                    }
                }
                LactividadesProgramadoRealizado.Add(avance);
            }


            string modalidad = "AvanceTrimestralXls_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(LactividadesProgramadoRealizado.Distinct().ToList());
        }

    }
}