﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using Rotativa;
using System.Transactions;

namespace Nova.Controllers.POA.ReportePresupuestoCalendarizado
{
    public class PoaReportePresupuestoCalendarizadoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        //  where a.esConsolidada=1 
        string query = @"SELECT e.AñoProyectos as Año,max (f.Proyecto) as Proyecto,max(h.EstructuraOrganica) EstructuraOrganica ,c.Indicador, a.IdProductos,z.Productos,max(PrecioProducto) PrecioProducto
                            ,sum(case when a.idmes=1 then CantidadProducto else 0 end) EneroCantidad
                            ,sum(case when a.idmes=2 then CantidadProducto else 0 end) FebCantidad
                            ,sum(case when a.idmes=3 then CantidadProducto else 0 end) MarCantidad
                            ,sum(case when a.idmes=4 then CantidadProducto else 0 end) AbrCantidad
                            ,sum(case when a.idmes=5 then CantidadProducto else 0 end) MayCantidad
                            ,sum(case when a.idmes=6 then CantidadProducto else 0 end) JunCantidad
                            ,sum(case when a.idmes=7 then CantidadProducto else 0 end) JulCantidad
                            ,sum(case when a.idmes=8 then CantidadProducto else 0 end) AgoCantidad
                            ,sum(case when a.idmes=9 then CantidadProducto else 0 end) SepCantidad
                            ,sum(case when a.idmes=10 then CantidadProducto else 0 end) OctCantidad
                            ,sum(case when a.idmes=11 then CantidadProducto else 0 end) NovCantidad
                            ,sum(case when a.idmes=12 then CantidadProducto else 0 end) DicCantidad
                            , sum (case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then CantidadProducto else 0 end) TotalProductos 
                            ,sum(case when a.idmes=1 then Total else 0 end) EneroTotal
                            ,sum(case when a.idmes=2 then Total else 0 end) FebTotal
                            ,sum(case when a.idmes=3 then Total else 0 end) MarTotal
                            ,sum(case when a.idmes=4 then Total else 0 end) AbrTotal
                            ,sum(case when a.idmes=5 then Total else 0 end) MayTotal
                            ,sum(case when a.idmes=6 then Total else 0 end) JunTotal
                            ,sum(case when a.idmes=7 then Total else 0 end) JulTotal
                            ,sum(case when a.idmes=8 then Total else 0 end) AgoTotal
                            ,sum(case when a.idmes=9 then Total else 0 end) SepTotal
                            ,sum(case when a.idmes=10 then Total else 0 end) OctTotal
                            ,sum(case when a.idmes=11 then Total else 0 end) NovTotal
                            ,sum(case when a.idmes=12 then Total else 0 end) DicTotal
                            , sum (case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then Total else 0 end) TotalImporte

                              FROM  Poa_Presupuesto a 
                              inner join poa_productos z on z.idProductos=a.idProductos
                              inner join poa_Calendario b on a.IdCalendario=b.IdCalendario and b.IdCalendarioElemento =(select IdCalendarioElemento from Poa_CalendarioElemento where CalendarioElemento='Presupuesto')
                              inner join poa_Indicadores c on c.IdIndicadores=b.IdIndicadores
                              inner join poa_mir d on d.IdMIr=c.Idmir
                              inner join poa_proyectoArbol e on e.IdProyectoArbol=d.IdProyectoArbol
                              inner join poa_proyectos f on f.IdProyectos=e.IdProyectos
                              inner join Convenios_stConvenioLaboralTrabajadorCategoria g on g.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoria
                              inner join Catalogos_ctEstructuraOrganica h on h.IdEstructuraOrganica=g.IdEstructuraOrganica
                                where   e.AñoProyectos in @anio
                                        and f.Proyecto in @proyecto
                                        and h.EstructuraOrganica in @area
                              group by  e.AñoProyectos,e.IdProyectos,h.IdEstructuraOrganica,c.Indicador,a.IdProductos,z.Productos


                            ";

                        Int16[] anio = { };
                        String[] proyecto = { };
                        String[] area = { };

        // GET: PoaReportePresupuestoCalendarizado
        public ActionResult Index()
        {
            var poa_Mir = db.Poa_Mir.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_MirEstatus).Include(p => p.Poa_ProyectoArbol);


            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
                                      Año
                                  FROM Poa_ProyectoArbol
                                  group by Año
                                  order by 1 desc";
            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
                       b.Proyecto
                  FROM Poa_ProyectoArbol a
                  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
                  group by a.IdProyectos, b.Proyecto
                  order by a.IdProyectos desc";

            var proy = (List<string>)dp.connection.Query<string>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.ToString(),
                Text = x.ToString()
            });


            string queryAreas = @" select c.EstructuraOrganica 
                                  from Poa_ProyectoArbol a
                                  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
                                  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
                                  group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();


            return View();
        }

        [HttpPost]
        public ActionResult ReportePresupuestoCalendarizadoView(String[] anios, String[] proyectos, String[] areas)
        //String[] proyectos,
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            var result = (List<PoaReportePresupuestoCalendarizado>)dp.connection.Query<PoaReportePresupuestoCalendarizado>(query, new { anio, proyecto, area });

            dp.Close();
            return PartialView("_ReportePresupuestoCalendarizado", result.ToList());

        }

        public ActionResult ReportePresupuestoCalendarizado(String[] anios, String[] proyectos, String[] areas)
        //String[] proyectos,
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


            var result = (List<PoaReportePresupuestoCalendarizado>)dp.connection.Query<PoaReportePresupuestoCalendarizado>(query, new { anio, proyecto, area });
            dp.Close();
            string modalidad = "Poa_PresupuestoCalendarizado" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;

            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }


        public ActionResult ReportePresupuestoCalendarizadoXls(String[] anios, String[] proyectos, String[] areas)
        //String[] proyectos,
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


            var result = (List<PoaReportePresupuestoCalendarizado>)dp.connection.Query<PoaReportePresupuestoCalendarizado>(query, new { anio, proyecto, area });
            dp.Close();
            string modalidad = "Poa_PresupuestoCalendarizado_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

        // GET: PoaReportePresupuestoCalendarizado/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);
            if (poa_Presupuesto == null)
            {
                return HttpNotFound();
            }
            return View(poa_Presupuesto);
        }

        // GET: PoaReportePresupuestoCalendarizado/Create
        public ActionResult Create()
        {
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes");
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno");
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion");
            return View();
        }

        // POST: PoaReportePresupuestoCalendarizado/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPresupuesto,CantidadProducto,IdMes,IdCalendario,IdProductos,PrecioProducto,Total,EsConsolidada")] Poa_Presupuesto poa_Presupuesto)
        {
            if (ModelState.IsValid)
            {
                db.Poa_Presupuesto.Add(poa_Presupuesto);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_Presupuesto.IdMes);
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno", poa_Presupuesto.IdProductos);
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_Presupuesto.IdCalendario);
            return View(poa_Presupuesto);
        }

        // GET: PoaReportePresupuestoCalendarizado/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);
            if (poa_Presupuesto == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_Presupuesto.IdMes);
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno", poa_Presupuesto.IdProductos);
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_Presupuesto.IdCalendario);
            return View(poa_Presupuesto);
        }

        // POST: PoaReportePresupuestoCalendarizado/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPresupuesto,CantidadProducto,IdMes,IdCalendario,IdProductos,PrecioProducto,Total,EsConsolidada")] Poa_Presupuesto poa_Presupuesto)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_Presupuesto).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_Presupuesto.IdMes);
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno", poa_Presupuesto.IdProductos);
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_Presupuesto.IdCalendario);
            return View(poa_Presupuesto);
        }

        // GET: PoaReportePresupuestoCalendarizado/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);
            if (poa_Presupuesto == null)
            {
                return HttpNotFound();
            }
            return View(poa_Presupuesto);
        }

        // POST: PoaReportePresupuestoCalendarizado/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);
            db.Poa_Presupuesto.Remove(poa_Presupuesto);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
