﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Transactions;

namespace Nova.Controllers.POA.ProyectosEstatales
{
    public class PoaProyectosEstatalesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: ProyectosEstatales
        public ActionResult Index()
        {
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string query;

            //query = @"select * from Poa_ProyectosEstatales
            //            where IdProyectosEstatales  not in (select IdProyectosEstatales from Poa_EstructuraProgramaticaEstatal)
            //        ";
            query = @"select * from Poa_ProyectosEstatales ";
            var t = (List<Poa_ProyectosEstatales>)dp.connection.Query<Poa_ProyectosEstatales>(query);
                        dp.Close();
            return PartialView(t.ToList());
            //return PartialView(db.Poa_ProyectosEstatales.ToList());
        }

        // GET: ProyectosEstatales/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);
            if (poa_ProyectosEstatales == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectosEstatales);
        }

        // GET: ProyectosEstatales/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: ProyectosEstatales/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProyectosEstatales,Actividad,Programa,ProyectoEstatal,SubPrograma")] Poa_ProyectosEstatales poa_ProyectosEstatales)
        {
            if (ModelState.IsValid)
            {
                db.Poa_ProyectosEstatales.Add(poa_ProyectosEstatales);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(poa_ProyectosEstatales);
        }

        // GET: ProyectosEstatales/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);
            if (poa_ProyectosEstatales == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectosEstatales);
        }

        // POST: ProyectosEstatales/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProyectosEstatales,Actividad,Programa,ProyectoEstatal,SubPrograma")] Poa_ProyectosEstatales poa_ProyectosEstatales)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_ProyectosEstatales).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(poa_ProyectosEstatales);
        }

        // GET: ProyectosEstatales/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);
            if (poa_ProyectosEstatales == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectosEstatales);
        }

        // POST: ProyectosEstatales/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);
            db.Poa_ProyectosEstatales.Remove(poa_ProyectosEstatales);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
