﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Data.Entity;

namespace Nova.Controllers 
{
    public class PoaProductosController : BaseController
    {
        // GET: PoaProductos
        bdNovaEntities db = new bdNovaEntities();
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult LoadData()
        {
            return View(db.Poa_Productos.ToList());
        }
        public ActionResult Create()
        {
            string[] Capitulos = { "2000", "3000" };
            ViewBag.IdPartidas = new SelectList((from s in db.Poa_Partidas.Where(a => Capitulos.Contains(a.Capitulo)  && a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año && (a.IdPartidas != 338 && a.IdPartidas != 339 && a.IdPartidas != 352)).OrderBy(o => o.PartidaEspecifica).ToList() select new { IdPartidas = s.IdPartidas, Partida = s.Capitulo + "|" + s.PartidaGenerica + "|" + s.PartidaEspecifica + "|" + s.Partida }), "IdPartidas", "Partida");
            return PartialView();
        }


        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProductos,CapituloInterno,Partida,PartidaEspecifica,PartidaGenerica,Precio,Productos,Descripcion,UnidadMedida,ClaveCUCOP,Año,IdPartidas")] Poa_ProductosAux poa_ProductosAux)
     
        {
            
            
            
            Poa_Partidas DatosPartida = db.Poa_Partidas.Find(poa_ProductosAux.IdPartidas); 

            Poa_Productos poaProductos = new Poa_Productos();


            

            poaProductos.Año=db.Poa_SistemaAñoVigente.Select(a => a.Año).FirstOrDefault();
            poaProductos.ClaveCUCOP = poa_ProductosAux.ClaveCUCOP.ToUpper();
            poaProductos.Productos = poa_ProductosAux.Productos.ToUpper();
            poaProductos.Precio = poa_ProductosAux.Precio;
            poaProductos.UnidadMedida = poa_ProductosAux.UnidadMedida.ToUpper();
            poaProductos.CapituloInterno = DatosPartida.Capitulo;
            poaProductos.Partida = DatosPartida.Partida;
            poaProductos.PartidaEspecifica = DatosPartida.PartidaEspecifica;
            poaProductos.PartidaGenerica = DatosPartida.PartidaGenerica;
            poaProductos.Descripcion = poa_ProductosAux.Descripcion.ToUpper();


            if (ModelState.IsValid)
            {

                try
                {

                    db.Poa_Productos.Add(poaProductos);
                    db.SaveChanges();
                }
                catch (Exception e)
                {

                    //return JsonView(false, ExceptionExtensions.GetOriginalException(e).Message, "Create", poa_ProductosAux);
                    //return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message, });
                    string msg = ExceptionExtensions.GetOriginalException(e).Message;
                    if (msg.Contains("duplicada"))
                        msg = "El producto ya existe, favor de verificarlo.";
                    return Json(new { Valid = false, Message = msg, });
                }

                return JsonView(ModelState.IsValid, "Se han agregado los datos exitosamente");
            }
            string messages = string.Join("; ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));

            //return JsonView(ModelState.IsValid, messages, "Create", poa_ProductosAux);


            return JsonView(ModelState.IsValid, messages);
        }

        public ActionResult CrearProducto()
        {
            return PartialView();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult CrearProducto([Bind(Include = "IdProductos,CapituloInterno,Partida,PartidaEspecifica,PartidaGenerica,Precio,Productos,UnidadMedida,ClaveCUCOP,Año")] Poa_Productos poa_Productos)
        {
            if (ModelState.IsValid)
            {

                try
                {

                    db.Poa_Productos.Add(poa_Productos);
                    db.SaveChanges();
                }
                catch (Exception e)
                {

                    return JsonView(false, ExceptionExtensions.GetOriginalException(e).Message);
                    //return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message, });
                }

                return JsonView(ModelState.IsValid, "Se han agregado los datos exitosamente");
            }
            string messages = string.Join("; ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages);
        }

        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Productos poa_Productos = db.Poa_Productos.Find(id);
            if (poa_Productos == null)
            {
                return HttpNotFound();
            }
            return View(poa_Productos);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProductos,CapituloInterno,Partida,PartidaEspecifica,PartidaGenerica,Precio,Productos,UnidadMedida,ClaveCUCOP,Año")] Poa_Productos poa_Productos)
        {

            if (ModelState.IsValid)
            {

                try
                {

                    db.Entry(poa_Productos).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return JsonView(ModelState.IsValid, "Se han actualizado los datos exitosamente");
            }
            string messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));
            return JsonView(ModelState.IsValid, messages, "Edit", poa_Productos);
        }
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Productos poa_Productos = db.Poa_Productos.Find(id);
            if (poa_Productos == null)
            {
                return HttpNotFound();
            }
            return View(poa_Productos);
        }

        // POST: Poa_Productos/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]

        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Productos poa_Productos = db.Poa_Productos.Find(id);
            if (ModelState.IsValid)
            {


                try
                {


                    db.Poa_Productos.Remove(poa_Productos);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return JsonView(ModelState.IsValid, "Registro eliminado exitosamente");
            }

            return JsonView(ModelState.IsValid, null, "Delete", poa_Productos);
        }



        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


    }
}