﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Transactions;
using ExcelDataReader;

using Excel = Microsoft.Office.Interop.Excel;

namespace Nova.Controllers
{
    public class PoaCargaProductosController : Controller
    {
       
        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index()
        {
            return View(db.Poa_Productos.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        }
        [HttpPost]
        public ActionResult Importar(HttpPostedFileBase excelfile)
        {
            if (excelfile == null)
                throw new SystemException("Debe seleccionar un archivo.");

            // ExcelDataReader works with the binary Excel file, so it needs a FileStream
            // to get started. This is how we avoid dependencies on ACE or Interop:
            System.IO.Stream stream = excelfile.InputStream;
            // We return the interface, so that
            IExcelDataReader reader = null;

            if (excelfile.FileName.EndsWith(".xls"))
            {
                reader = ExcelReaderFactory.CreateBinaryReader(stream);
            }
            else if (excelfile.FileName.EndsWith(".xlsx"))
            {
                reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
            }
            else
            {
                throw new SystemException("Formato de archivo no soportado.");
            }
            //reader.IsFirstRowAsColumnNames = true;

            //DataSet result = new DataSet();

            List<Poa_Productos> list = new List<Poa_Productos>();
            int contador = 0;
            while (reader.Read())
            {
                if (contador == 0)
                    reader.Read();
                Poa_Productos newlist = new Poa_Productos();

                newlist.CapituloInterno = System.Convert.ToString(reader.GetValue(0));
                newlist.Partida = System.Convert.ToString(reader.GetValue(1));
                newlist.PartidaEspecifica = System.Convert.ToString(reader.GetValue(2));
                newlist.PartidaGenerica = System.Convert.ToString(reader.GetValue(3));
                newlist.Precio = System.Convert.ToDecimal(reader.GetValue(4));
                newlist.Productos = System.Convert.ToString(reader.GetValue(5));
                newlist.UnidadMedida = System.Convert.ToString(reader.GetValue(6));
                newlist.ClaveCUCOP = System.Convert.ToString(reader.GetValue(7));
                newlist.Año = System.Convert.ToInt16(reader.GetValue(8));

                list.Add(newlist);

                contador++;
            }
            reader.Close();


            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    //eliminar el conjunto de datos
                    Int16 anio = db.Poa_SistemaAñoVigente.Select(x => x.Año).FirstOrDefault();

                    db.Poa_Productos.RemoveRange(db.Poa_Productos.Where(x => x.Año == anio).ToList());
                    db.SaveChanges();

                    //gurdar datos en base de datos
                    db.Poa_Productos.AddRange(list);
                    db.SaveChanges();

                    scope.Complete();

                }
            }
            catch (Exception e)
            {
                throw new SystemException("Error relacionado a: "+e.Message);
            }


            return RedirectToAction("Index");
        }

        //public ActionResult Importar_Anterior(HttpPostedFileBase excelfile)
        //{
        //    if (excelfile == null)
        //        throw new SystemException("Debe seleccionar un archivo.");

        //    Microsoft.Office.Interop.Excel.Application aplicacion = new Excel.Application();
        //    string ruta = Server.MapPath("~/Content/Productos/" + excelfile.FileName);
        //    Excel.Workbook workbook = null; Excel.Worksheet worksheet; Excel.Range rango;



        //    if (excelfile.FileName.EndsWith("xls") || excelfile.FileName.EndsWith("xlsx"))
        //    {
        //        try
        //        {

        //            if (excelfile == null || excelfile.ContentLength < 9930)
        //            {
        //                System.IO.File.Delete(ruta);

        //                throw new SystemException("El archivo que intenta cargar no tiene el formato incorrecto.");

        //            }
        //            else
        //            {
        //                if (System.IO.File.Exists(ruta))
        //                    System.IO.File.Delete(ruta);
        //                excelfile.SaveAs(ruta);
        //                workbook = aplicacion.Workbooks.Open(ruta);
        //                worksheet = workbook.ActiveSheet;
        //                rango = worksheet.UsedRange;
        //                List<Poa_Productos> listaproductos = new List<Poa_Productos>();

        //                // leer datos archivo de excel
        //                for (int row = 2; row <= rango.Rows.Count; row++)
        //                {
        //                    Poa_Productos p = new Poa_Productos();
        //                    p.CapituloInterno = System.Convert.ToString(((Excel.Range)rango.Cells[row, 1]).Text);
        //                    p.Partida = System.Convert.ToString(((Excel.Range)rango.Cells[row, 2]).Text);
        //                    p.PartidaEspecifica = System.Convert.ToString(((Excel.Range)rango.Cells[row, 3]).Text);
        //                    p.PartidaGenerica = System.Convert.ToString(((Excel.Range)rango.Cells[row, 4]).Text);
        //                    p.Precio = decimal.Parse(((Excel.Range)rango.Cells[row, 5]).Text);
        //                    p.Productos = System.Convert.ToString(((Excel.Range)rango.Cells[row, 6]).Text);
        //                    p.UnidadMedida = System.Convert.ToString(((Excel.Range)rango.Cells[row, 7]).Text);
        //                    p.ClaveCUCOP = System.Convert.ToString(((Excel.Range)rango.Cells[row, 8]).Text);
        //                    p.Año = short.Parse(((Excel.Range)rango.Cells[row, 9]).Text);

        //                    listaproductos.Add(p);
        //                }
        //                workbook.Close();
        //                excelfile.InputStream.Dispose();
        //                excelfile.InputStream.Close();
        //                System.IO.File.Delete(ruta);

        //                if (listaproductos.Count() == 0)
        //                    throw new SystemException("El archivo que intenta cargar está vacío, intente cargar otro.");

        //                if (GuardarTabla(listaproductos))
        //                {
        //                    ViewBag.Success = "Archivo importado correctamente.";
        //                    return View("Index", db.Poa_Productos.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        //                }
        //                else
        //                {



        //                    ViewBag.Error = "Error de importación de datos";
        //                    return View("Index", db.Poa_Productos.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        //                }


        //            }

        //        }
        //        catch (Exception ex)
        //        {
        //            if (workbook != null)
        //                if (ex.Message != "Error al cargar el archivo. No se pueden borrar productos ya asignados al presupuesto.")
        //                    workbook.Close();

        //            excelfile.InputStream.Dispose();
        //            excelfile.InputStream.Close();
        //            System.IO.File.Delete(ruta);

        //            throw new SystemException(ex.Message);
        //        }

        //    }
        //    else
        //    {


        //        throw new SystemException("El archivo que intenta cargar tiene el formato incorrecto.");

        //    }

        //}


        public bool GuardarTabla(List<Poa_Productos> listaproductos)
        {

            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
            {
                TransactionOptions Grabar = new TransactionOptions();
                Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                {


                    try
                    {

                        db.Poa_Productos.RemoveRange(db.Poa_Productos.Where(x => x.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año));
                        db.Poa_Productos.AddRange(listaproductos);
                        db.SaveChanges();


                    }
                    catch (Exception ex)
                    {
                        var mensaje = ExceptionExtensions.GetOriginalException(ex).Message;
                        if (mensaje.IndexOf("FK_") > -1)
                        {
                            mensaje = "Error al cargar el archivo. No se pueden borrar productos ya asignados al presupuesto.";
                        }

                        throw new SystemException( mensaje);
                    }

                    scope.Complete();

                    return true;
                }
                //return JsonView(ModelState.IsValid, "El proyecto ha sido asignado exitosamente");
            }


        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}