﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using Dapper;
using Nova.Models.Poa.Seguimiento;

namespace Nova.Controllers.Poa.PoaCalendarioObsTrimestral
{
    public class PoaCalendarioObservacionTrimestralController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaCalendarioObservacionTrimestral
        public ActionResult Index()
        {
            //int AñoVigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            //var poa_CalendarioObservacionTrimestral = db.Poa_CalendarioObservacionTrimestral.Where(x=>x.Poa_Indicadores.Poa_Mir.AñoMir== AñoVigente).OrderBy(o=>o.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Numero).ThenBy(t=>t.FechaActualizacion).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Indicadores).Include(p => p.Poa_Trimestre);
            //return View(poa_CalendarioObservacionTrimestral.ToList());

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre.Where(a => a.Trimestre != "ANUAL"), "IdPoaTrimestre", "Trimestre");


            return View();
        }
        public ActionResult AvanceTrimestral()
        {
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //string anio = Request["Anio"];
            int anioSeleccionado = System.Convert.ToInt32(Request["anios"]);
            int idTrimestre = System.Convert.ToInt32(Request["IdPoaTrimestre"]);
            string trimestre = db.Poa_Trimestre.Find(idTrimestre).Trimestre;
            string Mes1 = "", Mes2 = "", Mes3 = "";
            ViewBag.Anio = anioSeleccionado;
            ViewBag.Trimestre = trimestre;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            switch (idTrimestre)
            {
                case 1:
                    Mes1 = "ENERO";
                    Mes2 = "FEBRERO";
                    Mes3 = "MARZO";
                    break;
                case 2:
                    Mes1 = "ABRIL";
                    Mes2 = "MAYO";
                    Mes3 = "JUNIO";
                    break;
                case 3:
                    Mes1 = "JULIO";
                    Mes2 = "AGOSTO";
                    Mes3 = "SEPTIEMBRE";
                    break;
                case 4:
                    Mes1 = "OCTUBRE";
                    Mes2 = "NOVIEMBRE";
                    Mes3 = "DICIEMBRE";
                    break;
                default:
                    throw new Exception("No existe el configurado el trimestre seleccionado " + idTrimestre);
                    break;
            }
            string filtromes = "(h.mes = Mes1 or h.mes = Mes2 or h.mes = Mes3)";
            string query = @"select b.IdIndicadores,p.Numero,f.TipoElementoObjetivos,p.Proyecto,m.ResumenNarrativo as DescripcionMeta
,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador 
        from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            string queryUser = @"select b.IdIndicadores,p.Numero,f.TipoElementoObjetivos,p.Proyecto,
m.ResumenNarrativo as DescripcionMeta,b.IdIndicadores,b.Indicador as UnidadMedida,
        b.MetaAnual as Anual,h.Mes, ca.Valor,c.CalendarioElemento, g.TipoIndicador from  Poa_Mir m
        inner join Poa_MirEstatus me on m.IdMirEstatus = me.IdMirEstatus   and m.AñoMir = @anioSeleccionado
        inner join Poa_ProyectoArbol e on m.IdProyectoArbol = e.IdProyectoArbol  and e.AñoArbol = @anioSeleccionado
        inner join Poa_Proyectos p on e.IdProyectos = p.IdProyectos
        inner join Poa_TipoElementoObjetivos f on e.IdTipoElementoObjetivos=f.IdTipoElementoObjetivos
        inner join Poa_Indicadores b on m.IdMir = b.IdMir
        inner join Poa_TipoIndicador g on b.IdTipoIndicador = g.IdTipoIndicador
        left join Poa_Calendario ca on b.IdIndicadores = ca.IdIndicadores
        left join Poa_CalendarioElemento c on ca.IdCalendarioElemento = c.IdCalendarioElemento
        left join Catalogos_ctMes h on h.IdMes = ca.IdMes
        where f.TipoElementoObjetivos in ('Fin','Propósito','Componente')
        and me.EstatusMir='Indicadores Autorizados'
        and (c.CalendarioElemento='Programado' or c.CalendarioElemento='Realizado')
        and b.IdConvenioLaboralTrabajadorCategoria = @idusuario
        order by p.Numero,f.OrdenMir,b.Indicador,h.Orden,c.IdCalendarioElemento desc";

            List<AvanceTrimestral> result = new List<AvanceTrimestral>();

            PoaMir rolAdmin = new PoaMir();
            if (rolAdmin.EsAdministrador())
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(query, new { anioSeleccionado });

            }
            else
            {
                result = (List<AvanceTrimestral>)dp.connection.Query<AvanceTrimestral>(queryUser, new { idusuario, anioSeleccionado });
            }

            dp.Close();


            var grupoindicadores = result.GroupBy(f => f.IdIndicadores).Select(r => r.Key).ToList();
            List<AvanceTrimestralProgramadoRealizado> LindicadoresProgramadoRealizado = new List<AvanceTrimestralProgramadoRealizado>();
            foreach (var idindi in grupoindicadores)
            {
                var mesesindicador = result.Where(m => m.IdIndicadores == idindi && (m.Mes == Mes1 || m.Mes == Mes2 || m.Mes == Mes3));
                AvanceTrimestralProgramadoRealizado avance = new AvanceTrimestralProgramadoRealizado();
                var indicadoractual = result.Where(x => x.IdIndicadores == idindi).FirstOrDefault();
                avance.IdIndicadores = indicadoractual.IdIndicadores;
                avance.IdPoaTrimestre = idTrimestre;
                avance.CalendarioElemento = indicadoractual.CalendarioElemento;
                avance.DescripcionMeta = indicadoractual.DescripcionMeta;
                avance.Anual = indicadoractual.Anual;
                avance.Numero = indicadoractual.Numero;
                avance.Proyecto = indicadoractual.Proyecto;
                avance.TipoElementoObjetivos = indicadoractual.TipoElementoObjetivos;
                avance.TipoIndicador = indicadoractual.TipoIndicador;
                avance.UnidadMedida = indicadoractual.UnidadMedida;
                // falta la observaación del trimestre
                if (mesesindicador != null)
                {
                    foreach (var registro in mesesindicador)
                    {
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor1Programado = registro.Valor;
                            avance.Mes1Programado = Mes1;
                        }
                        if (registro.Mes == Mes1 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor1Realizado = registro.Valor;
                            avance.Mes1Realizado = Mes1;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor2Programado = registro.Valor;
                            avance.Mes2Programado = Mes2;
                        }
                        if (registro.Mes == Mes2 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor2Realizado = registro.Valor;
                            avance.Mes2Realizado = Mes2;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Programado")
                        {
                            avance.Valor3Programado = registro.Valor;
                            avance.Mes3Programado = Mes3;
                        }
                        if (registro.Mes == Mes3 && registro.CalendarioElemento == "Realizado")
                        {
                            avance.Valor3Realizado = registro.Valor;
                            avance.Mes3Realizado = Mes3;
                        }

                    }
                }
                var poaot =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.Observacion).FirstOrDefault();
                var esAutorizada =
       (from ot in db.Poa_CalendarioObservacionTrimestral
        join ic in db.Poa_Indicadores on ot.IdIndicadores equals ic.IdIndicadores
        where ic.IdIndicadores == idindi && ot.IdPoaTrimestre == idTrimestre
        select ot.EsAutorizada).FirstOrDefault();

                if (poaot != null)
                {
                    avance.Observacion = poaot.ToString();
                    avance.EsAutorizada = esAutorizada;
                }

                LindicadoresProgramadoRealizado.Add(avance);
            }

            List<AvanceTrimestralProgramadoRealizado> filaVacia = LindicadoresProgramadoRealizado.Where(t => t.Valor1Programado <= 0 && t.Valor2Programado <= 0 && t.Valor3Programado <= 0 && t.Valor1Realizado <= 0 && t.Valor2Realizado <= 0 && t.Valor3Realizado <= 0).ToList();

            foreach (var f in filaVacia)
            {
                LindicadoresProgramadoRealizado.Remove(f);
            }


            return PartialView("_pvAvanceTrimestral", LindicadoresProgramadoRealizado);
        }
        // GET: PoaCalendarioObservacionTrimestral/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral = db.Poa_CalendarioObservacionTrimestral.Find(id);
            if (poa_CalendarioObservacionTrimestral == null)
            {
                return HttpNotFound();
            }
            return View(poa_CalendarioObservacionTrimestral);
        }

        // GET: PoaCalendarioObservacionTrimestral/Create
        public ActionResult Create(int id, int idpoatrimestre)
        {
            Poa_CalendarioObservacionTrimestral model = new Poa_CalendarioObservacionTrimestral();
            int Ide = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            model.IdIndicadores = id;
            model.IdPoaTrimestre = idpoatrimestre;
            model.IdConvenioLaboralTrabajadorCategoria = Ide;
            model.FechaActualizacion = DateTime.Now;
            decimal SumaTrimestreProgramadoFederal = 0;
            decimal SumaTrimestreRealizadoFederal = 0;

            var tipoindicador = from a in db.Poa_Indicadores
                                where a.IdIndicadores == id
                                select new { indicador = a.Poa_TipoIndicador.TipoIndicador };

            string indicador = tipoindicador.FirstOrDefault().indicador;

            if (indicador == "Incremental")
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal1 != null)
                        {

                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal1.Valor;
                        }

                        if (datosSumaRealizadoFederal1 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal1.Valor;
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal2 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal2.Valor;
                        }
                        if (datosSumaRealizadoFederal2 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal2.Valor;
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal3 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal3.Valor;
                        }
                        if (datosSumaRealizadoFederal3 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal3.Valor;
                        }


                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal4 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal4.Valor;
                        }
                        if (datosSumaRealizadoFederal4 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal4.Valor;
                        }
                        break;
                    case 5:
                       
                        var datosSumaProgramadoFederal5 = db.Poa_Calendario.Where(t =>  t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal5 = db.Poa_Calendario.Where(t =>  t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal5 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal5.Valor;
                        }
                        if (datosSumaRealizadoFederal5 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal5.Valor;
                        }

                        break;
                }
            }

            if (indicador == "Promedio")
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal1 != null)
                        {
                            if (valorSumaProgramadoFederal1 > 0)
                            { 
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal1.Sum(t => t.Valor))/ valorSumaProgramadoFederal1;
                            }
                        }

                        if (datosSumaRealizadoFederal1 != null)
                        {
                            if (valorSumaRealizadoFederal1 > 0)
                            { 
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal1.Sum(t => t.Valor)) / valorSumaRealizadoFederal1;
                            }
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal2 != null)
                        {
                            if (valorSumaProgramadoFederal2 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal2.Sum(t => t.Valor)) / valorSumaProgramadoFederal2;
                            }
                        }
                        if (datosSumaRealizadoFederal2 != null)
                        {
                            if (valorSumaRealizadoFederal2 > 0)
                            { 
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal2.Sum(t => t.Valor)) / valorSumaRealizadoFederal2;
                            }
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal3 != null)
                        {
                            if (valorSumaProgramadoFederal3 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal3.Sum(t => t.Valor)) / valorSumaProgramadoFederal3;
                            }
                        }
                        if (datosSumaRealizadoFederal3 != null)
                        {
                            if (valorSumaRealizadoFederal3 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal3.Sum(t => t.Valor)) / valorSumaRealizadoFederal3;
                            }
                        }


                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal4 != null)
                        {
                            if (valorSumaProgramadoFederal4 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal4.Sum(t => t.Valor)) / valorSumaProgramadoFederal4;
                            }
                        }
                        if (datosSumaRealizadoFederal4 != null)
                        {
                            if (valorSumaRealizadoFederal4 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal4.Sum(t => t.Valor)) / valorSumaRealizadoFederal4;
                            }
                        }


                        break;
                    case 5:
                       
                        var datosSumaProgramadoFederal5 = db.Poa_Calendario.Where(t =>  t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal5 = db.Poa_Calendario.Where(t =>   t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal5 = db.Poa_Calendario.Where(t =>   t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal5 = db.Poa_Calendario.Where(t =>   t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal5 != null)
                        {
                            if (valorSumaProgramadoFederal5 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal5.Sum(t => t.Valor)) / valorSumaProgramadoFederal5;
                            }
                        }
                        if (datosSumaRealizadoFederal5 != null)
                        {
                            if (valorSumaRealizadoFederal5 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal5.Sum(t => t.Valor)) / valorSumaRealizadoFederal5;
                            }
                        }


                        break;
                }
            }


            else
            {

                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id).ToList();
                        var datosSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id).ToList();
                        if (datosSumaProgramadoFederal1 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal1.Sum(t => t.Valor);
                        }

                        if (datosSumaRealizadoFederal1 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal1.Sum(t => t.Valor);
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id).ToList();
                        var datosSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id).ToList();
                        if (datosSumaProgramadoFederal2 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal2.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal2 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal2.Sum(t => t.Valor);
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id).ToList();
                        var datosSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id).ToList();
                        if (datosSumaProgramadoFederal3 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal3.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal3 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal3.Sum(t => t.Valor);
                        }


                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id).ToList();
                        var datosSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id).ToList();
                        if (datosSumaProgramadoFederal4 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal4.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal4 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal4.Sum(t => t.Valor);
                        }


                        break;
                    case 5:
                        var datosSumaProgramadoFederal5 = db.Poa_Calendario.Where(t =>  t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == id).ToList();
                        var datosSumaRealizadoFederal5 = db.Poa_Calendario.Where(t =>  t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == id).ToList();
                        if (datosSumaProgramadoFederal5 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal5.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal5 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal5.Sum(t => t.Valor);
                        }


                        break;
                }

            }


            ViewBag.SumaTrimestreProgramadoFederal = SumaTrimestreProgramadoFederal;
            ViewBag.SumaTrimestreRealizadoFederal = SumaTrimestreRealizadoFederal;




            var año = from a in db.Poa_Mir
                      join b in db.Poa_Indicadores on a.IdMir equals b.IdMir
                      where b.IdIndicadores == id
                      select new { Año = a.AñoMir };


            //var año = db.Poa_Mir.Join(db.Poa_Indicadores.Where(c=> c.IdIndicadores== id), a=> a.IdMir, b=> b.IdMir, (a,b) => new { año= a.AñoMir});


            short anio = año.FirstOrDefault().Año;
            ViewBag.AñoFederal = anio;


            ViewBag.IdIndicadores = id;
            ViewBag.idpoatrimestre = idpoatrimestre;

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Observacion");
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre");
            return PartialView("_Create",model);
        }

        // POST: PoaCalendarioObservacionTrimestral/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost, ActionName("Create")]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPoaCalendarioTrimestral,IdIndicadores,IdPoaTrimestre,IdConvenioLaboralTrabajadorCategoria,Observacion,FechaActualizacion")] Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral)
        {
            if (ModelState.IsValid)
            {
                db.Poa_CalendarioObservacionTrimestral.Add(poa_CalendarioObservacionTrimestral);

                try
                {
                    db.SaveChanges();
                    //return Json(new { Valid = true, Message = "El Area ha sido asignada exitosamente" });
                }
                catch (Exception e)
                {

                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return Json(new { Valid = true, Message = "Observación enviada a revisión" });
              
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestral.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Observacion", poa_CalendarioObservacionTrimestral.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestral.IdPoaTrimestre);
            return new JsonResult() { Data = "Observación enviada a revisión" };
        }

        // GET: PoaCalendarioObservacionTrimestral/Edit/5
        public ActionResult Edit(int idindicador, int idpoatrimestre)
        {
            
            Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral = db.Poa_CalendarioObservacionTrimestral.Where(d=>d.IdIndicadores==idindicador && d.IdPoaTrimestre==idpoatrimestre).FirstOrDefault();
            if (poa_CalendarioObservacionTrimestral == null)
            {
                return HttpNotFound();
            }
            decimal SumaTrimestreProgramadoFederal = 0;
            decimal SumaTrimestreRealizadoFederal = 0;
            var tipoindicador = from a in db.Poa_Indicadores
                                where a.IdIndicadores == idindicador
                                select new { indicador = a.Poa_TipoIndicador.TipoIndicador };

            string indicador = tipoindicador.FirstOrDefault().indicador;

            if (indicador == "Incremental")
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal1 != null)
                        {

                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal1.Valor;
                        }

                        if (datosSumaRealizadoFederal1 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal1.Valor;
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal2 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal2.Valor;
                        }
                        if (datosSumaRealizadoFederal2 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal2.Valor;
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal3 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal3.Valor;
                        }
                        if (datosSumaRealizadoFederal3 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal3.Valor;
                        }


                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramadoFederal4 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal4.Valor;
                        }
                        if (datosSumaRealizadoFederal4 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal4.Valor;
                        }


                        break;
                }
            }

            if (indicador == "Promedio")
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal1 != null)
                        {
                            if (valorSumaProgramadoFederal1 > 0)
                            { 
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal1.Sum(t => t.Valor))/ valorSumaProgramadoFederal1;
                            }
                        }

                        if (datosSumaRealizadoFederal1 != null)
                        {
                            if (valorSumaRealizadoFederal1 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal1.Sum(t => t.Valor)) / valorSumaRealizadoFederal1;
                            }
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal2 != null)
                        {
                            if (valorSumaProgramadoFederal2 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal2.Sum(t => t.Valor)) / valorSumaProgramadoFederal2;
                            }
                        }
                        if (datosSumaRealizadoFederal2 != null)
                        {
                            if (valorSumaRealizadoFederal2 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal2.Sum(t => t.Valor)) / valorSumaRealizadoFederal2;
                            }
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal3 != null)
                        {
                            if (valorSumaProgramadoFederal3 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal3.Sum(t => t.Valor)) / valorSumaProgramadoFederal3;
                            }
                        }
                        if (datosSumaRealizadoFederal3 != null)
                        {
                            if (valorSumaRealizadoFederal3 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal3.Sum(t => t.Valor)) / valorSumaRealizadoFederal3;
                            }
                        }


                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        var datosSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador && t.Valor > 0).ToList();
                        int valorSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador && t.Valor > 0).Count();
                        if (datosSumaProgramadoFederal4 != null)
                        {
                            if (valorSumaProgramadoFederal4 > 0)
                            {
                                SumaTrimestreProgramadoFederal = (datosSumaProgramadoFederal4.Sum(t => t.Valor)) / valorSumaProgramadoFederal4;
                            }
                        }
                        if (datosSumaRealizadoFederal4 != null)
                        {
                            if (valorSumaRealizadoFederal4 > 0)
                            {
                                SumaTrimestreRealizadoFederal = (datosSumaRealizadoFederal4.Sum(t => t.Valor)) / valorSumaRealizadoFederal4;
                            }
                        }


                        break;
                }
            }

            else
            {

                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador).ToList();
                        var datosSumaRealizadoFederal1 = db.Poa_Calendario.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador).ToList();
                        if (datosSumaProgramadoFederal1 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal1.Sum(t => t.Valor);
                        }

                        if (datosSumaRealizadoFederal1 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal1.Sum(t => t.Valor);
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador).ToList();
                        var datosSumaRealizadoFederal2 = db.Poa_Calendario.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador).ToList();
                        if (datosSumaProgramadoFederal2 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal2.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal2 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal2.Sum(t => t.Valor);
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador).ToList();
                        var datosSumaRealizadoFederal3 = db.Poa_Calendario.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador).ToList();
                        if (datosSumaProgramadoFederal3 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal3.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal3 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal3.Sum(t => t.Valor);
                        }


                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdIndicadores == idindicador).ToList();
                        var datosSumaRealizadoFederal4 = db.Poa_Calendario.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdIndicadores == idindicador).ToList();
                        if (datosSumaProgramadoFederal4 != null)
                        {
                            SumaTrimestreProgramadoFederal = datosSumaProgramadoFederal4.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizadoFederal4 != null)
                        {
                            SumaTrimestreRealizadoFederal = datosSumaRealizadoFederal4.Sum(t => t.Valor);
                        }


                        break;

                }
            }


            ViewBag.SumaTrimestreProgramadoFederal = SumaTrimestreProgramadoFederal;
            ViewBag.SumaTrimestreRealizadoFederal = SumaTrimestreRealizadoFederal;




            var año = from a in db.Poa_Mir
                      join b in db.Poa_Indicadores on a.IdMir equals b.IdMir
                      where b.IdIndicadores == idindicador
                      select new { Año = a.AñoMir };


            //var año = db.Poa_Mir.Join(db.Poa_Indicadores.Where(c=> c.IdIndicadores== id), a=> a.IdMir, b=> b.IdMir, (a,b) => new { año= a.AñoMir});


            short anio = año.FirstOrDefault().Año;
            ViewBag.AñoFederal = anio;


            ViewBag.IdIndicadores = idindicador;
            ViewBag.idpoatrimestre = idpoatrimestre;

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestral.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Observacion", poa_CalendarioObservacionTrimestral.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestral.IdPoaTrimestre);
            return View(poa_CalendarioObservacionTrimestral);
        }


        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult EditAdministrador([Bind(Include = "IdPoaCalendarioTrimestral,IdIndicadores,IdPoaTrimestre,IdConvenioLaboralTrabajadorCategoria,Observacion,ObservacionAutorizacion,FechaActualizacion")] Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral)
        {
            if (ModelState.IsValid)
            {
                try
                {
                    //poa_CalendarioObservacionTrimestral.FechaActualizacion = DateTime.Now;
                    if (poa_CalendarioObservacionTrimestral.ObservacionAutorizacion == null)
                        poa_CalendarioObservacionTrimestral.EsAutorizada = true;

                    db.Entry(poa_CalendarioObservacionTrimestral).State = EntityState.Modified;
                    db.SaveChanges();
                    return Json(new { Valid = true, Message = "La observación ha sido modificado exitosamente" });
                }
                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    // all changes will be rolled back
                }

                return Json(new { Valid = true, Message = "La observación ha sido modificado exitosamente" });
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestral.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Observacion", poa_CalendarioObservacionTrimestral.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestral.IdPoaTrimestre);
            string messages = string.Join("  ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }



        // POST: PoaCalendarioObservacionTrimestral/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPoaCalendarioTrimestral,IdIndicadores,IdPoaTrimestre,IdConvenioLaboralTrabajadorCategoria,Observacion,FechaActualizacion")] Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral)
        {
            if (ModelState.IsValid)
            {
                 try
                {
                    poa_CalendarioObservacionTrimestral.FechaActualizacion = DateTime.Now;
                    //if (poa_CalendarioObservacionTrimestral.ObservacionAutorizacion == null)
                    //    poa_CalendarioObservacionTrimestral.EsAutorizada = true;

                    db.Entry(poa_CalendarioObservacionTrimestral).State = EntityState.Modified;
                    db.SaveChanges();
                    return Json(new { Valid = true, Message = "La observación ha sido modificado exitosamente" });
                }
                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    // all changes will be rolled back
                }

                 return Json(new { Valid = true, Message = "La observación ha sido modificado exitosamente" });
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestral.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Observacion", poa_CalendarioObservacionTrimestral.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestral.IdPoaTrimestre);
            string messages = string.Join("  ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }

        // GET: PoaCalendarioObservacionTrimestral/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral = db.Poa_CalendarioObservacionTrimestral.Find(id);
            if (poa_CalendarioObservacionTrimestral == null)
            {
                return HttpNotFound();
            }
            return View(poa_CalendarioObservacionTrimestral);
        }

        // POST: PoaCalendarioObservacionTrimestral/Delete/5

        [HttpPost, ActionName("DeleteConfirmed")]
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_CalendarioObservacionTrimestral poa_CalendarioObservacionTrimestral = db.Poa_CalendarioObservacionTrimestral.Find(id);
            db.Poa_CalendarioObservacionTrimestral.Remove(poa_CalendarioObservacionTrimestral);
            db.SaveChanges();
            //return new JsonResult() { Data = "Registro eliminado exitosamente" };
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
