﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.POA.PeriodoSexenal
{
    public class PoaPeriodoSexenalController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PeriodoSexenal
        public ActionResult Index()
        {
            return View(db.Poa_PeriodoSexenal.ToList());
        }

        // GET: PeriodoSexenal/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_PeriodoSexenal poa_PeriodoSexenal = db.Poa_PeriodoSexenal.Find(id);
            if (poa_PeriodoSexenal == null)
            {
                return HttpNotFound();
            }
            return View(poa_PeriodoSexenal);
        }

        // GET: PeriodoSexenal/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: PeriodoSexenal/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPeriodoSexenal,AñoFinal,AñoInicial")] Poa_PeriodoSexenal poa_PeriodoSexenal)
        {
            if (ModelState.IsValid)
            {

                var PeriodoSexenalRepetidos = db.Poa_PeriodoSexenal.Where(g => g.AñoInicial == poa_PeriodoSexenal.AñoInicial && g.AñoFinal == poa_PeriodoSexenal.AñoFinal).ToArray();

                int valor = PeriodoSexenalRepetidos.Count();
                int anosexenal = poa_PeriodoSexenal.AñoFinal - poa_PeriodoSexenal.AñoInicial;

                if (valor > 0)
                {

                    return Json(new { Valid = false, Message = "Ya existe un período sexenal" });
                    //throw new ArgumentException(" ");


                }
                else
                {
                    if (anosexenal == 6) { 
                    try
                    {

                        db.Poa_PeriodoSexenal.Add(poa_PeriodoSexenal);
                        db.SaveChanges();
                        return Json(new { Valid = true, Message = "El período sexenal ha sido creado exitosamente" });
                    }
                    catch (Exception e)
                    {
                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        // all changes will be rolled back
                    }

                    return JsonView(ModelState.IsValid, "El período sexenal ha sido creado exitosamente");
                    }
                    else
                    {
                        return Json(new { Valid = false, Message = "El período sexenal no válido" });
                        //throw new ArgumentException(" ");
                    }
                    //return Redirect("~/Poa_Proyectos/Index");
                }

               
            }

            string messages = string.Join("  ", ModelState.Values
                                         .SelectMany(x => x.Errors)
                                         .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }

        // GET: PeriodoSexenal/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_PeriodoSexenal poa_PeriodoSexenal = db.Poa_PeriodoSexenal.Find(id);
            if (poa_PeriodoSexenal == null)
            {
                return HttpNotFound();
            }
            return View(poa_PeriodoSexenal);
        }

        // POST: PeriodoSexenal/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPeriodoSexenal,AñoFinal,AñoInicial")] Poa_PeriodoSexenal poa_PeriodoSexenal)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_PeriodoSexenal).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(poa_PeriodoSexenal);
        }

        // GET: PeriodoSexenal/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_PeriodoSexenal poa_PeriodoSexenal = db.Poa_PeriodoSexenal.Find(id);
            if (poa_PeriodoSexenal == null)
            {
                return HttpNotFound();
            }
            return View(poa_PeriodoSexenal);
        }

        // POST: PeriodoSexenal/Delete/5
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(short id)
        {
            try
            {

                Poa_PeriodoSexenal poa_PeriodoSexenal = db.Poa_PeriodoSexenal.Find(id);
                db.Poa_PeriodoSexenal.Remove(poa_PeriodoSexenal);
                db.SaveChanges();
                return new JsonResult() { Data = "Registro eliminado exitosamente" };
                
            }
            catch (Exception e)
            {
                return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                // all changes will be rolled back
            }
           
            //return RedirectToAction("Index");
        }




        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
