﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using Seguridad;
using Dapper;

namespace Nova.Controllers
{
    public class PoaPartidasPresupuestalesReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        string query = @"select  EstructuraOrganica,CapituloInterno,Capitulo,Concepto,PartidaGenerica,PartidaEspecifica,Partida,Tipo='Productos',
                        ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE
                        ,TOTAL=ENERO+FEBRERO + MARZO + ABRIL+ MAYO+JUNIO+JULIO+AGOSTO+SEPTIEMBRE+OCTUBRE+NOVIEMBRE+DICIEMBRE
                        ,PresupuestoCerrado, Proyecto
                        from 
                        ( 
                        select 
                         EstructuraOrganica
                         ,CapituloInterno,Capitulo,Concepto,PartidaGenerica,PartidaEspecifica,Partida
                        ,case when ENERO IS null then 0 else ENERO end ENERO
                        ,case when FEBRERO IS null then 0 else FEBRERO end FEBRERO
                        ,case when MARZO IS null then 0 else MARZO end MARZO
                        ,case when ABRIL IS null then 0 else ABRIL end ABRIL
                        ,case when MAYO IS null then 0 else MAYO end MAYO
                        ,case when JUNIO IS null then 0 else JUNIO end JUNIO
                        ,case when JULIO IS null then 0 else JULIO end JULIO
                        ,case when AGOSTO IS null then 0 else AGOSTO end AGOSTO
                        ,case when SEPTIEMBRE IS null then 0 else SEPTIEMBRE end SEPTIEMBRE
                        ,case when OCTUBRE IS null then 0 else OCTUBRE end OCTUBRE
                        ,case when NOVIEMBRE IS null then 0 else NOVIEMBRE end NOVIEMBRE
                        ,case when DICIEMBRE IS null then 0 else DICIEMBRE end DICIEMBRE
                        ,PresupuestoCerrado, Proyecto
                        FROM 
                        (
                        select   e2.EstructuraOrganica,h.CapituloInterno,i.Capitulo,i.Concepto,i.PartidaGenerica,i.PartidaEspecifica,i.Partida,max(g.Mes) as Mes,sum(z.Total) as Total
                        ,b.PresupuestoCerrado, x.Proyecto 
                        from Poa_Presupuesto z
                        inner join Poa_Calendario a on z.IdCalendario=a.IdCalendario and a.IdCalendarioElemento =(select IdCalendarioElemento from Poa_CalendarioElemento where CalendarioElemento='Presupuesto')
                        inner join Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
                        inner join Poa_Mir c on c.IdMir=b.IdMir and c.AñoMir in @anio
                        inner join Poa_ProyectoArbol d on d.IdProyectoArbol=c.IdProyectoArbol and d.AñoArbol in @anio
                        inner join Convenios_stConvenioLaboralTrabajadorCategoria e on c.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoria  
                        inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=e.IdConvenioLaboralTrabajador
                        inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
                        inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
                        inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=e.IdEstructuraOrganica
                        inner join Catalogos_ctMes g on z.IdMes=g.IdMes
                        inner join Poa_Productos h on z.IdProductos=h.IdProductos and h.Año in @anio
                        inner join Poa_Partidas i on  i.PartidaEspecifica=h.PartidaEspecifica and i.Capitulo=h.CapituloInterno and i.Año=(select Año from Poa_SistemaAñoVigente) 
                        inner join Poa_Proyectos x on x.IdProyectos = d.IdProyectos
                        inner join Poa_ProyectosAño xx on xx.IdProyectos=x.IdProyectos and xx.AñoProyectos in @anio
                        where e2.EstructuraOrganica in @area
                        and x.Proyecto in @proyecto
                        group by z.IdMes,h.CapituloInterno,i.Capitulo,i.Concepto,i.PartidaGenerica,i.PartidaEspecifica,i.Partida,e2.EstructuraOrganica, b.PresupuestoCerrado, x.Proyecto 
                        ) Universo
                        pivot
                        (
                        sum(Total)
                        for Mes
                        in 
                        (ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE)
                        )piv
                         ) as Total 
                        union all
                        select (EstructuraOrganica),(CapituloInterno),(Capitulo),(Concepto),(PartidaGenerica),(PartidaEspecifica),Partida,Tipo='Viáticos',
                        ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE
                        ,TOTAL=ENERO+FEBRERO + MARZO + ABRIL+ MAYO+JUNIO+JULIO+AGOSTO+SEPTIEMBRE+OCTUBRE+NOVIEMBRE+DICIEMBRE
                        ,(PresupuestoCerrado), (Proyecto)
                         from (
                         select Max(g.EstructuraOrganica) EstructuraOrganica ,'3000' CapituloInterno, '3000' Capitulo, '4100' Concepto, '411' PartidaGenerica, '374' PartidaEspecifica, 'VIÁTICOS EN EL PAÍS' Partida
,SUM(case when  a.idmes=1 then  (z.TotalViaticos) ELSE 0 end)  Enero
,SUM(case when  a.idmes=2 then  (z.TotalViaticos) else 0 end)  Febrero
,SUM(case when  a.idmes=3 then  (z.TotalViaticos) else 0 end)   Marzo
,SUM(case when  a.idmes=4 then  (z.TotalViaticos) else 0 end)   Abril
,SUM(case when  a.idmes=5 then  (z.TotalViaticos) else 0 end)   Mayo
,SUM(case when  a.idmes=6 then  (z.TotalViaticos) else 0 end)   Junio
,SUM(case when  a.idmes=7 then  (z.TotalViaticos) else 0 end)   Julio
,SUM(case when  a.idmes=8 then  (z.TotalViaticos) else 0 end)   Agosto
,SUM(case when  a.idmes=9 then  (z.TotalViaticos) else 0 end)   Septiembre
,SUM(case when  a.idmes=10 then (z.TotalViaticos) else 0 end)   Octubre
,SUM(case when  a.idmes=11 then (z.TotalViaticos) else 0 end)   Noviembre
,SUM(case when  a.idmes=12 then (z.TotalViaticos) else 0 end)  Diciembre
,Max(case when c.PresupuestoCerrado=0 then 0 else 1 end) PresupuestoCerrado
,h.Proyecto
--SELECT *
from Poa_ViaticosPasajes z
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir in @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol and e.AñoArbol in @anio
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria f on f.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica = f.IdEstructuraOrganica
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
where d.AñoMir in @anio
and g.EstructuraOrganica in @area
and h.Proyecto in @proyecto
Group by Proyecto) as xx
union all
select (EstructuraOrganica),(CapituloInterno),(Capitulo),(Concepto),(PartidaGenerica),(PartidaEspecifica),Partida,Tipo='Pasajes',
                        ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE
                        ,TOTAL=ENERO+FEBRERO + MARZO + ABRIL+ MAYO+JUNIO+JULIO+AGOSTO+SEPTIEMBRE+OCTUBRE+NOVIEMBRE+DICIEMBRE
                        ,(PresupuestoCerrado), (Proyecto)
                         from (
select Max(g.EstructuraOrganica) EstructuraOrganica 
,'3000' CapituloInterno
,case when z2.TipoPasaje = 'Avión' then '3000' else '3000' end Capitulo
,'4100' Concepto
,case when z2.TipoPasaje = 'Avión' then '411' else '411' end PartidaGenerica
,case when z2.TipoPasaje = 'Avión' then '369' else '370' end PartidaEspecifica
,case when z2.TipoPasaje = 'Avión' then 'PASAJES AÉREOS' else 'PASAJES TERRESTRES' end Partida
,SUM(case when  a.idmes=1 then  (z.TotalPasaje) ELSE 0 end)  Enero
,SUM(case when  a.idmes=2 then  (z.TotalPasaje) else 0 end)  Febrero
,SUM(case when  a.idmes=3 then  (z.TotalPasaje) else 0 end)   Marzo
,SUM(case when  a.idmes=4 then  (z.TotalPasaje) else 0 end)   Abril
,SUM(case when  a.idmes=5 then  (z.TotalPasaje) else 0 end)   Mayo
,SUM(case when  a.idmes=6 then  (z.TotalPasaje) else 0 end)   Junio
,SUM(case when  a.idmes=7 then  (z.TotalPasaje) else 0 end)   Julio
,SUM(case when  a.idmes=8 then  (z.TotalPasaje) else 0 end)   Agosto
,SUM(case when  a.idmes=9 then  (z.TotalPasaje) else 0 end)   Septiembre
,SUM(case when  a.idmes=10 then (z.TotalPasaje) else 0 end)   Octubre
,SUM(case when  a.idmes=11 then (z.TotalPasaje) else 0 end)   Noviembre
,SUM(case when  a.idmes=12 then (z.TotalPasaje) else 0 end)  Diciembre
,Max(case when c.PresupuestoCerrado=0 then 0 else 1 end) PresupuestoCerrado
,h.Proyecto

from Poa_ViaticosPasajes z
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir in @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol and e.AñoArbol in @anio
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria f on f.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica = f.IdEstructuraOrganica
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
inner join Poa_ProyectosAño ii on ii.IdProyectos=h.IdProyectos and  ii.AñoProyectos in @anio
where z2.TipoPasaje <> 'Vehículo oficial' 
and d.AñoMir in @anio
and g.EstructuraOrganica in @area
and h.Proyecto in @proyecto
Group by Proyecto, z2.TipoPasaje) as xy
";

        string queryUser = @"select  EstructuraOrganica,CapituloInterno,Capitulo,Concepto,PartidaGenerica,PartidaEspecifica,Partida,Tipo='Productos',
                        ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE
                        ,TOTAL=ENERO+FEBRERO + MARZO + ABRIL+ MAYO+JUNIO+JULIO+AGOSTO+SEPTIEMBRE+OCTUBRE+NOVIEMBRE+DICIEMBRE
                        ,PresupuestoCerrado, Proyecto
                        from 
                        ( 
                        select 
                         EstructuraOrganica
                         ,CapituloInterno,Capitulo,Concepto,PartidaGenerica,PartidaEspecifica,Partida
                        ,case when ENERO IS null then 0 else ENERO end ENERO
                        ,case when FEBRERO IS null then 0 else FEBRERO end FEBRERO
                        ,case when MARZO IS null then 0 else MARZO end MARZO
                        ,case when ABRIL IS null then 0 else ABRIL end ABRIL
                        ,case when MAYO IS null then 0 else MAYO end MAYO
                        ,case when JUNIO IS null then 0 else JUNIO end JUNIO
                        ,case when JULIO IS null then 0 else JULIO end JULIO
                        ,case when AGOSTO IS null then 0 else AGOSTO end AGOSTO
                        ,case when SEPTIEMBRE IS null then 0 else SEPTIEMBRE end SEPTIEMBRE
                        ,case when OCTUBRE IS null then 0 else OCTUBRE end OCTUBRE
                        ,case when NOVIEMBRE IS null then 0 else NOVIEMBRE end NOVIEMBRE
                        ,case when DICIEMBRE IS null then 0 else DICIEMBRE end DICIEMBRE
                        ,PresupuestoCerrado, Proyecto
                        FROM 
                        (
                        select   e2.EstructuraOrganica,h.CapituloInterno,i.Capitulo,i.Concepto,i.PartidaGenerica,i.PartidaEspecifica,i.Partida,max(g.Mes) as Mes,sum(z.Total) as Total
                        ,b.PresupuestoCerrado, x.Proyecto 
                        from Poa_Presupuesto z
                        inner join Poa_Calendario a on z.IdCalendario=a.IdCalendario and a.IdCalendarioElemento =(select IdCalendarioElemento from Poa_CalendarioElemento where CalendarioElemento='Presupuesto')
                        inner join Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
                        inner join Poa_Mir c on c.IdMir=b.IdMir
                        inner join Poa_ProyectoArbol d on c.AñoMir in @anio and d.IdProyectoArbol=c.IdProyectoArbol
                        inner join Convenios_stConvenioLaboralTrabajadorCategoria e on c.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoria  
                        inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=e.IdConvenioLaboralTrabajador
                        inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
                        inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
                        inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=e.IdEstructuraOrganica
                        inner join Catalogos_ctMes g on z.IdMes=g.IdMes
                        inner join Poa_Productos h on z.IdProductos=h.IdProductos
                        inner join Poa_Partidas i on i.PartidaEspecifica=h.PartidaEspecifica and i.Capitulo=h.CapituloInterno and i.Año=(select Año from Poa_SistemaAñoVigente) 
                        inner join Poa_Proyectos x on x.IdProyectos = d.IdProyectos
                        where e2.EstructuraOrganica in @area
                        and x.Proyecto in @proyecto
                        and (c.IdConvenioLaboralTrabajadorCategoria=@idusuario or b.IdConvenioLaboralTrabajadorCategoria = @idusuario or d.IdConvenioLaboralTrabajadorCategoria=@idusuario)
                        group by z.IdMes,h.CapituloInterno,i.Capitulo,i.Concepto,i.PartidaGenerica,i.PartidaEspecifica,i.Partida,e2.EstructuraOrganica, b.PresupuestoCerrado, x.Proyecto 
                        ) Universo
                        pivot
                        (
                        sum(Total)
                        for Mes
                        in 
                        (ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE)
                        )piv
                         ) as Total 
                        union all
                        select (EstructuraOrganica),(CapituloInterno),(Capitulo),(Concepto),(PartidaGenerica),(PartidaEspecifica),Partida,Tipo='Viáticos',
                        ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE
                        ,TOTAL=ENERO+FEBRERO + MARZO + ABRIL+ MAYO+JUNIO+JULIO+AGOSTO+SEPTIEMBRE+OCTUBRE+NOVIEMBRE+DICIEMBRE
                        ,(PresupuestoCerrado), (Proyecto)
                         from (
                         select Max(g.EstructuraOrganica) EstructuraOrganica ,'3000' CapituloInterno, '3000' Capitulo, '4100' Concepto, '411' PartidaGenerica, '374' PartidaEspecifica, 'VIÁTICOS EN EL PAÍS' Partida
,SUM(case when  a.idmes=1 then  (z.TotalViaticos) ELSE 0 end)  Enero
,SUM(case when  a.idmes=2 then  (z.TotalViaticos) else 0 end)  Febrero
,SUM(case when  a.idmes=3 then  (z.TotalViaticos) else 0 end)   Marzo
,SUM(case when  a.idmes=4 then  (z.TotalViaticos) else 0 end)   Abril
,SUM(case when  a.idmes=5 then  (z.TotalViaticos) else 0 end)   Mayo
,SUM(case when  a.idmes=6 then  (z.TotalViaticos) else 0 end)   Junio
,SUM(case when  a.idmes=7 then  (z.TotalViaticos) else 0 end)   Julio
,SUM(case when  a.idmes=8 then  (z.TotalViaticos) else 0 end)   Agosto
,SUM(case when  a.idmes=9 then  (z.TotalViaticos) else 0 end)   Septiembre
,SUM(case when  a.idmes=10 then (z.TotalViaticos) else 0 end)   Octubre
,SUM(case when  a.idmes=11 then (z.TotalViaticos) else 0 end)   Noviembre
,SUM(case when  a.idmes=12 then (z.TotalViaticos) else 0 end)  Diciembre
,Max(case when c.PresupuestoCerrado=0 then 0 else 1 end) PresupuestoCerrado
,h.Proyecto
--SELECT *
from Poa_ViaticosPasajes z
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria f on f.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica = f.IdEstructuraOrganica
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
where d.AñoMir in @anio
and g.EstructuraOrganica in @area
and h.Proyecto in @proyecto
and (d.IdConvenioLaboralTrabajadorCategoria=@idusuario or c.IdConvenioLaboralTrabajadorCategoria = @idusuario or e.IdConvenioLaboralTrabajadorCategoria=@idusuario)
Group by Proyecto) as xx
union all
select (EstructuraOrganica),(CapituloInterno),(Capitulo),(Concepto),(PartidaGenerica),(PartidaEspecifica),Partida,Tipo='Pasajes',
                        ENERO,FEBRERO,MARZO,ABRIL,MAYO,JUNIO,JULIO,AGOSTO,SEPTIEMBRE,OCTUBRE,NOVIEMBRE,DICIEMBRE
                        ,TOTAL=ENERO+FEBRERO + MARZO + ABRIL+ MAYO+JUNIO+JULIO+AGOSTO+SEPTIEMBRE+OCTUBRE+NOVIEMBRE+DICIEMBRE
                        ,(PresupuestoCerrado), (Proyecto)
                         from (
select Max(g.EstructuraOrganica) EstructuraOrganica 
,'3000' CapituloInterno
,case when z2.TipoPasaje = 'Avión' then '3000' else '3000' end Capitulo
,'4100' Concepto
,case when z2.TipoPasaje = 'Avión' then '411' else '411' end PartidaGenerica
,case when z2.TipoPasaje = 'Avión' then '369' else '370' end PartidaEspecifica
,case when z2.TipoPasaje = 'Avión' then 'PASAJES AÉREOS' else 'PASAJES TERRESTRES' end Partida
,SUM(case when  a.idmes=1 then  (z.TotalPasaje) ELSE 0 end)  Enero
,SUM(case when  a.idmes=2 then  (z.TotalPasaje) else 0 end)  Febrero
,SUM(case when  a.idmes=3 then  (z.TotalPasaje) else 0 end)   Marzo
,SUM(case when  a.idmes=4 then  (z.TotalPasaje) else 0 end)   Abril
,SUM(case when  a.idmes=5 then  (z.TotalPasaje) else 0 end)   Mayo
,SUM(case when  a.idmes=6 then  (z.TotalPasaje) else 0 end)   Junio
,SUM(case when  a.idmes=7 then  (z.TotalPasaje) else 0 end)   Julio
,SUM(case when  a.idmes=8 then  (z.TotalPasaje) else 0 end)   Agosto
,SUM(case when  a.idmes=9 then  (z.TotalPasaje) else 0 end)   Septiembre
,SUM(case when  a.idmes=10 then (z.TotalPasaje) else 0 end)   Octubre
,SUM(case when  a.idmes=11 then (z.TotalPasaje) else 0 end)   Noviembre
,SUM(case when  a.idmes=12 then (z.TotalPasaje) else 0 end)  Diciembre
,Max(case when c.PresupuestoCerrado=0 then 0 else 1 end) PresupuestoCerrado
,h.Proyecto

from Poa_ViaticosPasajes z
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria f on f.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica = f.IdEstructuraOrganica
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
where z2.TipoPasaje <> 'Vehículo oficial' 
and d.AñoMir in @anio
and g.EstructuraOrganica in @area
and h.Proyecto in @proyecto
and (d.IdConvenioLaboralTrabajadorCategoria=@idusuario or c.IdConvenioLaboralTrabajadorCategoria = @idusuario or e.IdConvenioLaboralTrabajadorCategoria=@idusuario)
Group by Proyecto, z2.TipoPasaje) as xy
";

        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };


        public ActionResult Index()
        {
            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaPartidasPresupuestalesReporte");

            }

            return View();
        }

        public ActionResult Admin()
        {
            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Index", "PoaPartidasPresupuestalesReporte");
            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      [AñoArbol]
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by b.Numero";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


  //          string queryAreas = @" select c.EstructuraOrganica 
  //from Poa_ProyectoArbol a
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  //inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  //group by c.EstructuraOrganica";

            string queryAreas = @" select c.EstructuraOrganica 
  from Poa_Mir a
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult PartidasPresupuestalesView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            PoaMir rolAdmin = new PoaMir();
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PartidasPresupuestales> result = new List<Models.PartidasPresupuestales>();



            if (rolAdmin.EsAdministrador())
            {
                result = (List<PartidasPresupuestales>)dp.connection.Query<PartidasPresupuestales>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PartidasPresupuestales>)dp.connection.Query<PartidasPresupuestales>(queryUser, new { anio, proyecto, area, idusuario });
            }

            dp.Close();

            return PartialView("_PartidasPresupuestales", result.ToList());
        }


        public ActionResult PartidasPresupuestales(String[] anios, String[] proyectos, String[] areas)
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            PoaMir rolAdmin = new PoaMir();
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PartidasPresupuestales> result = new List<Models.PartidasPresupuestales>();



            if (rolAdmin.EsAdministrador())
            {
                result = (List<PartidasPresupuestales>)dp.connection.Query<PartidasPresupuestales>(query, new { anio, proyecto, area });
            }
            else
            {
                result = (List<PartidasPresupuestales>)dp.connection.Query<PartidasPresupuestales>(queryUser, new { anio, proyecto, area, idusuario });
            }

            if (proyecto.Count() == 1 && area.Count() == 1)
            {
                //if (rolAdmin.EsAdministrador())
                //{
                    string areaSingle = area.FirstOrDefault();
                    var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                    ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                    ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();
                //}
                //else
                //{
                //    var usuario = Seguridad.Identidad.Usuario();
                //    ViewBag.UsuarioU = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
                //}
            }
            else
            {
                ViewBag.UsuarioU = "NoUser";
            }

            dp.Close();

            string modalidad = "PartidasPresupuestales_" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;

            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }


        public ActionResult PartidasPresupuestalesXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            PoaMir rolAdmin = new PoaMir();
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PartidasPresupuestales> result = new List<Models.PartidasPresupuestales>();



            if (rolAdmin.EsAdministrador())
            {
                result = (List<PartidasPresupuestales>)dp.connection.Query<PartidasPresupuestales>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PartidasPresupuestales>)dp.connection.Query<PartidasPresupuestales>(queryUser, new { anio, proyecto, area, idusuario });
            }
            dp.Close();
            string modalidad = "PartidasPresupuestales_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }


        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }



    }
}