﻿using System;
using System.Collections.Generic;
 
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class PoaOrigenDestinoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaOrigenDestino
        public ActionResult Index()
        {
            var año = db.Poa_SistemaAñoVigente.SingleOrDefault().Año;
            return View(db.Poa_OrigenDestino.Where(a=>a.Año==año).OrderBy(o=>o.OrigenDestino).ToList());
        }

        // GET: PoaOrigenDestino/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_OrigenDestino poa_OrigenDestino = db.Poa_OrigenDestino.Find(id);
            if (poa_OrigenDestino == null)
            {
                return HttpNotFound();
            }
            return View(poa_OrigenDestino);
        }

        // GET: PoaOrigenDestino/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: PoaOrigenDestino/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdOrigenDestino,OrigenDestino,Tarifa,Año")] Poa_OrigenDestino poa_OrigenDestino)
        {
            if (ModelState.IsValid)
            {
                db.Poa_OrigenDestino.Add(poa_OrigenDestino);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(poa_OrigenDestino);
        }

        // GET: PoaOrigenDestino/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_OrigenDestino poa_OrigenDestino = db.Poa_OrigenDestino.Find(id);
            if (poa_OrigenDestino == null)
            {
                return HttpNotFound();
            }
            return View(poa_OrigenDestino);
        }

        // POST: PoaOrigenDestino/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdOrigenDestino,OrigenDestino,Tarifa,Año")] Poa_OrigenDestino poa_OrigenDestino)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_OrigenDestino).State =EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(poa_OrigenDestino);
        }

        // GET: PoaOrigenDestino/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_OrigenDestino poa_OrigenDestino = db.Poa_OrigenDestino.Find(id);
            if (poa_OrigenDestino == null)
            {
                return HttpNotFound();
            }
            return View(poa_OrigenDestino);
        }

        // POST: PoaOrigenDestino/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(short id)
        {
            Poa_OrigenDestino poa_OrigenDestino = db.Poa_OrigenDestino.Find(id);
            db.Poa_OrigenDestino.Remove(poa_OrigenDestino);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
