﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.POA.MirHistoriaEstatus
{
    public class PoaMirHistorialEstatusController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MirHistorialEstatus
        public ActionResult Index()
        {
            var poa_MirHistorialEstatus = db.Poa_MirHistorialEstatus.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_MirEstatus);
            return View(poa_MirHistorialEstatus.ToList());
        }


        public ActionResult Historial(int? id)
        {
            var poa_MirHistorialEstatus2 = db.Poa_MirHistorialEstatus.Where(a => a.IdMir == id).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_MirEstatus);
            return View(poa_MirHistorialEstatus2.ToList());
        }

        // GET: MirHistorialEstatus/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_MirHistorialEstatus poa_MirHistorialEstatus = db.Poa_MirHistorialEstatus.Find(id);
            if (poa_MirHistorialEstatus == null)
            {
                return HttpNotFound();
            }
            return View(poa_MirHistorialEstatus);
        }

        // GET: MirHistorialEstatus/Create
        public ActionResult Create()
        {
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo");
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir");
            return View();
        }

        // POST: MirHistorialEstatus/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdMirHistorialEstatus,FechaEstatus,IdConvenioLaboralTrabajadorCategoria,IdMir,IdMirEstatus,ObservacionEstatus")] Poa_MirHistorialEstatus poa_MirHistorialEstatus)
        {
            if (ModelState.IsValid)
            {
                db.Poa_MirHistorialEstatus.Add(poa_MirHistorialEstatus);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_MirHistorialEstatus.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_MirHistorialEstatus.IdMir);
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_MirHistorialEstatus.IdMirEstatus);
            return View(poa_MirHistorialEstatus);
        }

        // GET: MirHistorialEstatus/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_MirHistorialEstatus poa_MirHistorialEstatus = db.Poa_MirHistorialEstatus.Find(id);
            if (poa_MirHistorialEstatus == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_MirHistorialEstatus.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_MirHistorialEstatus.IdMir);
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_MirHistorialEstatus.IdMirEstatus);
            return View(poa_MirHistorialEstatus);
        }

        // POST: MirHistorialEstatus/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdMirHistorialEstatus,FechaEstatus,IdConvenioLaboralTrabajadorCategoria,IdMir,IdMirEstatus,ObservacionEstatus")] Poa_MirHistorialEstatus poa_MirHistorialEstatus)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_MirHistorialEstatus).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_MirHistorialEstatus.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_MirHistorialEstatus.IdMir);
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_MirHistorialEstatus.IdMirEstatus);
            return View(poa_MirHistorialEstatus);
        }

        // GET: MirHistorialEstatus/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_MirHistorialEstatus poa_MirHistorialEstatus = db.Poa_MirHistorialEstatus.Find(id);
            if (poa_MirHistorialEstatus == null)
            {
                return HttpNotFound();
            }
            return View(poa_MirHistorialEstatus);
        }

        // POST: MirHistorialEstatus/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(short id)
        {
            Poa_MirHistorialEstatus poa_MirHistorialEstatus = db.Poa_MirHistorialEstatus.Find(id);
            db.Poa_MirHistorialEstatus.Remove(poa_MirHistorialEstatus);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
