﻿using Nova.Libraries;
using Nova.Models;
using Seguridad;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.Mir
{
    public class PoaMirController : BaseController
    {
        bdNovaEntities bd = new bdNovaEntities();
        [HttpPost]
        public ActionResult ReasignarUsuario()
        {
            int idmir = Libraries.ConvertToInt.ConvertToInt32(Request.Form["IdMirusuario"]);
            
            Poa_Mir model = bd.Poa_Mir.Find(idmir);
            int idtrabajadoranterior = model.IdConvenioLaboralTrabajadorCategoria;

            model.IdConvenioLaboralTrabajadorCategoria = Libraries.ConvertToInt.ConvertToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            bd.Entry(model).State = System.Data.Entity.EntityState.Modified;
            //try
            //{
    var db = new bdNovaEntities();

    var DatosEstructuraOrganicaAsignar = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(model.IdConvenioLaboralTrabajadorCategoria);

            bool validar = false;
            string NombreUsuario = DatosEstructuraOrganicaAsignar.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
            NombreUsuario += " " + DatosEstructuraOrganicaAsignar.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno;
            NombreUsuario += " " + DatosEstructuraOrganicaAsignar.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
           
              AltaUsuarioRol altaRol = new AltaUsuarioRol();

          
            //if (db.Poa_ProyectosAñoAreas.Where(x => x.IdEstructuraOrganica == DatosEstructuraOrganicaAsignar.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).Count() == 0)
            //    return JsonView(validar, "Error. El Administrador aún no asigna el Área  " + DatosEstructuraOrganicaAsignar.Catalogos_ctEstructuraOrganica.EstructuraOrganica + " al Proyecto.", null, null, null);


              validar = altaRol.AltaGrupoUsuarioRol(idtrabajadoranterior, model.IdConvenioLaboralTrabajadorCategoria, TiposGrupoRol.GResponsablePoa, db);

            
            
            
            if(!validar)
                throw  new Exception ("Error en la asignación de Rol de Usuario. Valide que el usuario " + NombreUsuario + " tenga su cuenta activa en el sistema. ");

             

                bd.SaveChanges();
             
            //}
            //catch (Exception e)
            //{
                //var mensaje = ExceptionExtensions.GetOriginalException(e).Message;
                //if (mensaje.IndexOf("FK_") > -1)
                //{
                //    mensaje = "No se puede actualizar el resumen narrativo";
                //}

               

            //}
            return RedirectToAction("Index");
        }
        // GET: PoaMir
        public ActionResult Index(int pagenum = 0, int RecordsPerPage = 0, string filter = null, int AñoTrabajando = 0)
        {
            //BEGIN Region Modificado
            //se añadio el parametro a: getMir
            if (!Request.IsAjaxRequest())
                AñoTrabajando = System.Convert.ToInt32(Request["AnioTrabajando"]);


            if (pagenum == 0)
                pagenum = 1;

            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;

            PoaMir poa = new PoaMir();
            string usuariorol = poa.setRol();

            var ListAños = bd.Poa_Mir.GroupBy(s => s.AñoMir).Select(t=> new SelectListItem {
            Text = t.Key.ToString(),
            Value = t.Key.ToString()
            }).OrderByDescending(x=>x.Text);
            
            ViewBag.Rol = usuariorol;
            ViewBag.SelectAño = new SelectList(ListAños,"Text","Value");
            

            if (AñoTrabajando == 0) {
                ViewBag.AñoDefault = bd.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            }
            else
            {
                ViewBag.AñoDefault = AñoTrabajando;
            }
            

            if (Request.IsAjaxRequest())
            {
                return View("_tablaMir", poa.getMir(pagenum, RecordsPerPage, filter, usuariorol,AñoTrabajando));
            }
            else
                return View(poa.getMir(pagenum, RecordsPerPage, null, usuariorol,AñoTrabajando));
            //END Region Modificado
        }



        public ActionResult CambioStatuslMail(int id)
        {
            PoaMir poamir = new PoaMir();

            var mir = bd.Poa_Mir.Find(id);

            List<Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria> listadestinatarios = new List<Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria>();
           // var t1 = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => f.IdConvenioLaboralTrabajadorCategoria == 1764).FirstOrDefault();

            if (mir.Poa_MirEstatus.EsAdministrador==false)
            {
                listadestinatarios = poamir.AdministradoresPoa();

                //listadestinatarios.Add(t1);
                //listadestinatarios.Add(bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => f.IdConvenioLaboralTrabajadorCategoria == 1889).FirstOrDefault());
            }
            else {
                listadestinatarios.Add(mir.Convenios_stConvenioLaboralTrabajadorCategoria);

                
                //listadestinatarios.Add(bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => f.IdConvenioLaboralTrabajadorCategoria == 1889).FirstOrDefault());
            }
            //string
            



            //Convenios_stConvenioLaboralTrabajadorCategoria cltc = new Models.Convenios_stConvenioLaboralTrabajadorCategoria();
            string descripcion = " <p>Proyecto: " + mir.Poa_ProyectoArbol.Poa_Proyectos.Proyecto + " </p> <p>Area :" + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica + " </p><p>Responsable " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</p><p>" + mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos+": "+mir.ResumenNarrativo+"</p><p>Estatus: "+mir.Poa_MirEstatus.EstatusMir+"</p><p>"+DateTime.Now;

            string _Usuario = mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            int idProyectoArbol = mir.Poa_ProyectoArbol.IdPadreElementoObjetivos;
            string _Componente = bd.Poa_Mir.Where(t => t.IdProyectoArbol == idProyectoArbol).Select(s => s.ResumenNarrativo).FirstOrDefault();


            var bander = poamir.EnviarNotificacionMail("Cambio de Estatus MIR", descripcion, listadestinatarios,_Usuario,_Componente,DateTime.Now.ToShortDateString());

            

            return View();
        }

        public ActionResult Admin(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;

            if (RecordsPerPage == 0)
                RecordsPerPage = 100;

            PoaMir poa = new PoaMir();
            string usuariorol = poa.setRol();
            ViewBag.Rol = usuariorol;

            if (Request.IsAjaxRequest())
            {
                return View("_tablaMir", poa.getMir(pagenum, RecordsPerPage, filter, usuariorol));
            }
            else
                return View("Index", poa.getMir(pagenum, RecordsPerPage, null, usuariorol));
        }
    }
}