﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Data.Entity;
using System.Transactions;

namespace Nova.Controllers
{
    public class PoaParametrosConfiguracionController : BaseController
    {

        bdNovaEntities db = new bdNovaEntities();


        // GET: PoaParametrosConfiguracion
        public ActionResult Index()
        {

            return View(db.Poa_Mir.ToList());
        }

        public ActionResult Modal()
        {

            return View();
        }

        //public class AllowJsonGetAttribute : ActionFilterAttribute
        //{
        //    public override void OnResultExecuting(ResultExecutingContext filterContext)
        //    {
        //        var jsonResult = filterContext.Result as JsonResult;

        //        if (jsonResult == null)
        //            throw new ArgumentException("Action does not return a JsonResult,attribute AllowJsonGet is not allowed");


        //        jsonResult.JsonRequestBehavior = JsonRequestBehavior.AllowGet;

        //        base.OnResultExecuting(filterContext);
        //    }
        //}


        //[AllowJsonGet]
        public ActionResult Edit(int id)
        {
            Poa_Indicadores poa_Indicadores = db.Poa_Indicadores.Find(id);
            ViewBag.DeshabilitaNumerador = false;
            ViewBag.ListaIndicadoresActividad = null;
            int IdProyectoArbol = db.Poa_Mir.Find(poa_Indicadores.Poa_Mir.IdMir).IdProyectoArbol;
            int IdPadreElementosObjetivos = db.Poa_ProyectoArbol.Find(IdProyectoArbol).IdPadreElementoObjetivos;
            int IdMirComponente = 0;



            if (poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente")
            {



                var IndicadorComponenteEsAlimentado = db.Poa_Indicadores.Where(x => x.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && x.IdIndicadorComponente == poa_Indicadores.IdIndicadores).ToList();
                if (IndicadorComponenteEsAlimentado.Count > 0)
                {


                    ViewBag.DeshabilitaNumerador = true;
                    ViewBag.ListaIndicadoresActividad = IndicadorComponenteEsAlimentado;
                    ViewBag.MetaAnualNumerador = IndicadorComponenteEsAlimentado.Sum(x => x.MetaAnualNumerador); 

                    if (poa_Indicadores.MetaAnualNumerador == 0)
                        poa_Indicadores.MetaAnualNumerador = IndicadorComponenteEsAlimentado.Sum(x => x.MetaAnualNumerador);
                    else {
                        switch (poa_Indicadores.Poa_TipoIndicador.TipoIndicador)
                        {
                            case "Promedio":
                            case "Acumulativo":
                                poa_Indicadores.MetaAnualNumerador=IndicadorComponenteEsAlimentado.Sum(x => x.MetaAnualNumerador);
                                break;

                            case "Incremental":
                                poa_Indicadores.MetaAnualNumerador = IndicadorComponenteEsAlimentado.Sum(x => x.MetaAnualNumerador) + poa_Indicadores.LineaBaseNumerador;
                                break;
                            case "Indice":
                                poa_Indicadores.MetaAnualNumerador = IndicadorComponenteEsAlimentado.Sum(x => x.MetaAnualNumerador);

                                break;
                        }
                       
                    }
                }
                else
                    //throw new ApplicationException("No existe actividad asignada al Componente");

                    return Json("Debe existir un indicador de tipo Actividad que alimente al componente antes de su configuración ...", JsonRequestBehavior.AllowGet);
                //return Json("No existe un indicador de tipo Actividad que alimente al componente");


            }
            if (poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
            {
                IdMirComponente = db.Poa_Mir.Where(i => i.IdProyectoArbol == IdPadreElementosObjetivos).FirstOrDefault().IdMir;

                poa_Indicadores.UnidadMedidaIndicador = poa_Indicadores.Numerador;

                ViewBag.IdIndicadorComponente = new SelectList(db.Poa_Indicadores.Where(i => i.Poa_Mir.IdMir == IdMirComponente).ToList(), "IdIndicadores", "Indicador");
            }
            else
                poa_Indicadores.UnidadMedidaIndicador = poa_Indicadores.Indicador;

            //if (poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente")
            //    if (!ValidaExistenciaActividad(poa_Indicadores))

            //        throw new ApplicationException("No existe actividad asignada al Componente");

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador", poa_Indicadores.IdDimensionIndicador);
            ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion", poa_Indicadores.IdFrecuenciaMedicionIndicador);
            ViewBag.Constante = new SelectList(getConstantesSistema(), "Constante", "Valor");
            ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador", poa_Indicadores.IdSentidoIndicador);
            ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador", poa_Indicadores.IdTipoIndicador);
            ViewBag.IdIndicadorComponente = new SelectList(db.Poa_Indicadores.Where(i => i.Poa_Mir.IdMir == IdMirComponente).ToList(), "IdIndicadores", "Indicador", poa_Indicadores.IdIndicadorComponente);


            return PartialView(poa_Indicadores);
        }

        [HttpPost]
        public ActionResult Edit(Poa_Indicadores poa_Indicadores)
        {

            Poa_Indicadores poaindicadores = new Poa_Indicadores();
            poaindicadores = db.Poa_Indicadores.Find(poa_Indicadores.IdIndicadores);
            var IndicadorComponenteEsAlimentado = db.Poa_Indicadores.Where(x => x.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && x.IdIndicadorComponente == poa_Indicadores.IdIndicadores).ToList();


            poaindicadores.IdConvenioLaboralTrabajadorCategoria = poa_Indicadores.IdConvenioLaboralTrabajadorCategoria;
            poaindicadores.EsPdi = poa_Indicadores.EsPdi;
            poaindicadores.AlimentaComponente = poa_Indicadores.AlimentaComponente;
            poaindicadores.Denominador = poa_Indicadores.Denominador;
            poaindicadores.FuentesMediosVerificacion = poa_Indicadores.FuentesMediosVerificacion;
            poaindicadores.IdDimensionIndicador = poa_Indicadores.IdDimensionIndicador;
            poaindicadores.IdIndicadorComponente = poa_Indicadores.IdIndicadorComponente;
            poaindicadores.IdMir = poa_Indicadores.IdMir;
            poaindicadores.IdFrecuenciaMedicionIndicador = poa_Indicadores.IdFrecuenciaMedicionIndicador;
            poaindicadores.IdSentidoIndicador = poa_Indicadores.IdSentidoIndicador;
            poaindicadores.IdTipoIndicador = poa_Indicadores.IdTipoIndicador;
            poaindicadores.Indicador = poa_Indicadores.Indicador;
            poaindicadores.LineaBase = poa_Indicadores.LineaBase;
            poaindicadores.LineaBaseDenominador = poa_Indicadores.LineaBaseDenominador;
            poaindicadores.LineaBaseNumerador = poa_Indicadores.LineaBaseNumerador;

            poaindicadores.MetaAnual = poa_Indicadores.MetaAnual;


            poaindicadores.MetaAnualDenominador = poa_Indicadores.MetaAnualDenominador;
            poaindicadores.MetaAnualNumerador = poa_Indicadores.MetaAnualNumerador;
            poaindicadores.Numerador = poa_Indicadores.Numerador;
            poaindicadores.PresupuestoCerrado = poa_Indicadores.PresupuestoCerrado;
            poaindicadores.Supuestos = poa_Indicadores.Supuestos;
            poaindicadores.UnidadMedidaIndicador = poa_Indicadores.UnidadMedidaIndicador;

            if (poaindicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente")
            {
                decimal metaanualnumerador = IndicadorComponenteEsAlimentado.Sum(x => x.MetaAnualNumerador),
            metaanualdenomindaor = poa_Indicadores.MetaAnualDenominador;

                switch (db.Poa_TipoIndicador.Find(poaindicadores.IdTipoIndicador).TipoIndicador)
                {
                    case "Promedio":
                    case "Acumulativo":
                        poaindicadores.MetaAnual = (metaanualnumerador / metaanualdenomindaor) * 100;
                        poaindicadores.MetaAnualNumerador = (int)metaanualnumerador;
                        break;
                    case "Incremental":
                        metaanualnumerador += poa_Indicadores.LineaBaseNumerador;

                        poaindicadores.MetaAnualNumerador = (int)metaanualnumerador;

                        poaindicadores.MetaAnual = (metaanualnumerador / metaanualdenomindaor) * 100M;
                        break;
                    case "Indice":
                        poaindicadores.MetaAnual = metaanualnumerador / metaanualdenomindaor;
                        poaindicadores.MetaAnualNumerador = (int)metaanualnumerador;
                        break;
                    default:
                        poaindicadores.MetaAnual = 0;
                        break;
                }


            }


            var url =
                new UriBuilder(Request.Url.AbsoluteUri)
                {
                    Path = Url.Action("Index", "PoaMIr")
                }.ToString();

            if (ModelState.IsValid)
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {


                    try
                    {
                        db.Entry(poaindicadores).State = EntityState.Modified;
                        db.SaveChanges();


                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }
                    scope.Complete();
                    return JsonView(ModelState.IsValid, "Se ha guardado la configuración exitosamente", null, null, url);
                }
            }
            string messages = string.Join(";", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null, url);

        }

        public ActionResult Crear()
        {
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador");
            ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion");
            ViewBag.Constante = new SelectList(db.Poa_SistemaConstantes, "IdSistemaConstantes", "Constante");
            ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador");
            ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador");
            //ViewBag.IdUnidadMedidaIndicador = new SelectList(db.Poa_UnidadMedidaIndicador, "IdUnidadMedidaIndicador", "UnidadMedida");

            return PartialView();
        }



        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Crear([Bind(Include = "IdIndicadores,AlimentaComponente,Denominador,EsPdi,FuentesMediosVerificacion,IdConvenioLaboralTrabajadorCategoria,IdDimensionIndicador,IdFrecuenciaMedicionIndicador,IdMir,IdSentidoIndicador,IdTipoIndicador,IdUnidadMedidaIndicador,Indicador,LineaBase,LineaBaseDenominador,LineaBaseNumerador,MetaAnual,MetaAnualDenominador,MetaAnualNumerador,Numerador,Supuestos")] Poa_Indicadores poa_Indicadores)
        {
            if (ModelState.IsValid)
            {
                db.Poa_Indicadores.Add(poa_Indicadores);
                //db.SaveChanges();
                return RedirectToAction("Index");
            }
            return HttpNotFound();
        }

        private System.Collections.IEnumerable getConstantesSistema()
        {
            return db.Poa_SistemaConstantes.Select(t => new { Constante = t.Valor, Valor = t.Valor.ToString() + "  (" + t.Constante + ")" });
        }

        private bool ValidaExistenciaActividad(Poa_Indicadores p)
        {
            List<Poa_ProyectoArbol> parbol = db.Poa_ProyectoArbol.Where(a => a.IdPadreElementoObjetivos == p.Poa_Mir.IdProyectoArbol && a.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad").Take(1).ToList();

            if (parbol.Count() > 0)
                return true;

            return false;
        }
    }
}














//using System;
//using System.Collections.Generic;
//using System.Linq;
//using System.Web;
//using System.Web.Mvc;
//using Nova.Models;
//using System.Data.Entity;
//using System.Transactions;

//namespace Nova.Controllers
//{
//    public class PoaParametrosConfiguracionController : BaseController
//    {

//        bdNovaEntities db = new bdNovaEntities();


//        // GET: PoaParametrosConfiguracion
//        public ActionResult Index()
//        {

//            return View(db.Poa_Mir.ToList());
//        }

//        public ActionResult Modal()
//        {

//            return View();
//        }


//        public ActionResult Edit(int id)
//        {
//            Poa_Indicadores poa_Indicadores = db.Poa_Indicadores.Find(id);
//            ViewBag.DeshabilitaNumerador = false;
//            ViewBag.ListaIndicadoresActividad = null;
//            int IdProyectoArbol = db.Poa_Mir.Find(poa_Indicadores.Poa_Mir.IdMir).IdProyectoArbol;
//            int IdPadreElementosObjetivos = db.Poa_ProyectoArbol.Find(IdProyectoArbol).IdPadreElementoObjetivos;
//            int IdMirComponente =0;
//            if (poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente")
//            {

//                var IndicadorComponenteEsAlimentado = db.Poa_Indicadores.Where(x => x.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && x.IdIndicadorComponente == poa_Indicadores.IdIndicadores).ToList();
//                if (IndicadorComponenteEsAlimentado.Count>0)
//                {
//                    ViewBag.DeshabilitaNumerador = true;
//                    ViewBag.ListaIndicadoresActividad = IndicadorComponenteEsAlimentado;
//                    //poa_Indicadores.MetaAnualNumerador = IndicadorComponenteEsAlimentado.Sum(x=>x.MetaAnualNumerador);
//                }
//                //else
//                //    return Json(new { Valid = false, Message = "No existe un indicador de actividad que alimente al componente" });


//            }
//            if (poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
//            {
//                IdMirComponente = db.Poa_Mir.Where(i => i.IdProyectoArbol == IdPadreElementosObjetivos).FirstOrDefault().IdMir;

//                poa_Indicadores.UnidadMedidaIndicador = poa_Indicadores.Numerador;

//                ViewBag.IdIndicadorComponente = new SelectList(db.Poa_Indicadores.Where(i => i.Poa_Mir.IdMir == IdMirComponente).ToList(), "IdIndicadores", "Indicador");
//            }
//            else
//                poa_Indicadores.UnidadMedidaIndicador = poa_Indicadores.Indicador;

//            //if (poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente")
//            //    if (!ValidaExistenciaActividad(poa_Indicadores))

//            //        throw new ApplicationException("No existe actividad asignada al Componente");

//            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
//            ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador",poa_Indicadores.IdDimensionIndicador);
//            ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion", poa_Indicadores.IdFrecuenciaMedicionIndicador);
//            ViewBag.Constante = new SelectList(getConstantesSistema(), "Constante", "Valor");
//            ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador", poa_Indicadores.IdSentidoIndicador);
//            ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador", poa_Indicadores.IdTipoIndicador);
//            ViewBag.IdIndicadorComponente = new SelectList(db.Poa_Indicadores.Where(i => i.Poa_Mir.IdMir == IdMirComponente).ToList(), "IdIndicadores", "Indicador", poa_Indicadores.IdIndicadorComponente);


//            return PartialView(poa_Indicadores);
//        }

//        [HttpPost]
//        public ActionResult Edit(Poa_Indicadores poa_Indicadores)
//        {

//            Poa_Indicadores poaindicadores = new Poa_Indicadores();
//            poaindicadores = db.Poa_Indicadores.Find(poa_Indicadores.IdIndicadores);

//            poaindicadores.IdConvenioLaboralTrabajadorCategoria = poa_Indicadores.IdConvenioLaboralTrabajadorCategoria;
//            poaindicadores.EsPdi = poa_Indicadores.EsPdi;
//            poaindicadores.AlimentaComponente = poa_Indicadores.AlimentaComponente;
//            poaindicadores.Denominador = poa_Indicadores.Denominador;
//            poaindicadores.FuentesMediosVerificacion = poa_Indicadores.FuentesMediosVerificacion;
//            poaindicadores.IdDimensionIndicador = poa_Indicadores.IdDimensionIndicador;
//            poaindicadores.IdIndicadorComponente = poa_Indicadores.IdIndicadorComponente;
//            poaindicadores.IdMir = poa_Indicadores.IdMir;
//            poaindicadores.IdFrecuenciaMedicionIndicador = poa_Indicadores.IdFrecuenciaMedicionIndicador;
//            poaindicadores.IdSentidoIndicador = poa_Indicadores.IdSentidoIndicador;
//            poaindicadores.IdTipoIndicador = poa_Indicadores.IdTipoIndicador;
//            poaindicadores.Indicador = poa_Indicadores.Indicador;
//            poaindicadores.LineaBase = poa_Indicadores.LineaBase;
//            poaindicadores.LineaBaseDenominador = poa_Indicadores.LineaBaseDenominador;
//            poaindicadores.LineaBaseNumerador = poa_Indicadores.LineaBaseNumerador;

//            poaindicadores.MetaAnual = poa_Indicadores.MetaAnual;


//            poaindicadores.MetaAnualDenominador = poa_Indicadores.MetaAnualDenominador;
//            poaindicadores.MetaAnualNumerador = poa_Indicadores.MetaAnualNumerador;
//            poaindicadores.Numerador = poa_Indicadores.Numerador;
//            poaindicadores.PresupuestoCerrado = poa_Indicadores.PresupuestoCerrado;
//            poaindicadores.Supuestos = poa_Indicadores.Supuestos;
//            poaindicadores.UnidadMedidaIndicador = poa_Indicadores.UnidadMedidaIndicador;

//            var url =
//                new UriBuilder(Request.Url.AbsoluteUri)
//                {
//                    Path = Url.Action("Index", "PoaMIr")
//                }.ToString();

//            if (ModelState.IsValid)
//            {
//                TransactionOptions transactionoptions1 = new TransactionOptions();
//                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
//               using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
//                {


//                try
//                {
//                    db.Entry(poaindicadores).State = EntityState.Modified;
//                    db.SaveChanges();


//                }
//                catch (Exception e)
//                {

//                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
//                }
//                scope.Complete();
//                return JsonView(ModelState.IsValid, "Se ha guardado la configuración exitosamente", null, null, url);
//            }
//            }
//            string messages = string.Join(";", ModelState.Values
//                                       .SelectMany(x => x.Errors)
//                                       .Select(x => x.ErrorMessage));

//            return JsonView(ModelState.IsValid, messages, null, null, url);

//        }

//        public ActionResult Crear()
//        {
//            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
//            ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador");
//            ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion");
//            ViewBag.Constante = new SelectList(db.Poa_SistemaConstantes, "IdSistemaConstantes", "Constante");
//            ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador");
//            ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador");
//            //ViewBag.IdUnidadMedidaIndicador = new SelectList(db.Poa_UnidadMedidaIndicador, "IdUnidadMedidaIndicador", "UnidadMedida");

//            return PartialView();
//        }



//        [HttpPost]
//        [ValidateAntiForgeryToken]
//        public ActionResult Crear([Bind(Include = "IdIndicadores,AlimentaComponente,Denominador,EsPdi,FuentesMediosVerificacion,IdConvenioLaboralTrabajadorCategoria,IdDimensionIndicador,IdFrecuenciaMedicionIndicador,IdMir,IdSentidoIndicador,IdTipoIndicador,IdUnidadMedidaIndicador,Indicador,LineaBase,LineaBaseDenominador,LineaBaseNumerador,MetaAnual,MetaAnualDenominador,MetaAnualNumerador,Numerador,Supuestos")] Poa_Indicadores poa_Indicadores) 
//        {
//            if (ModelState.IsValid)
//            {
//                db.Poa_Indicadores.Add(poa_Indicadores);
//                //db.SaveChanges();
//                return RedirectToAction("Index");
//            }
//            return HttpNotFound();
//        }

//        private System.Collections.IEnumerable getConstantesSistema()
//        {
//            return db.Poa_SistemaConstantes.Select(t => new { Constante=t.Valor, Valor= t.Valor.ToString() +"  ("+ t.Constante + ")" });
//        }

//        private bool ValidaExistenciaActividad(Poa_Indicadores p)
//        { 
//           List<Poa_ProyectoArbol> parbol = db.Poa_ProyectoArbol.Where(a=>a.IdPadreElementoObjetivos==p.Poa_Mir.IdProyectoArbol && a.Poa_TipoElementoObjetivos.TipoElementoObjetivos=="Actividad").Take(1).ToList();

//            if (parbol.Count() > 0)
//               return true;

//            return false;
//        }
//    }
//}