﻿using System;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web.Mvc;
using Nova.Libraries;
using Nova.Models;

namespace Nova.Controllers
{
    public class PoaIndicadoresController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaIndicadores
        public ActionResult Index(int idmir)
        {
            ViewBag.idmir = idmir;
            ViewBag.JerarquiaIndicador = db.Poa_Indicadores.Where(p => p.IdMir == idmir).Select(z => z.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos).FirstOrDefault().TipoElementoObjetivos;
            ViewBag.IdConvenioLaboralTrabajadorCategoria = db.Poa_Indicadores.Where(p => p.IdMir == idmir).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            ViewBag.ResumenNarrativo = db.Poa_Mir.Where(p => p.IdMir == idmir).FirstOrDefault().ResumenNarrativo;
            return View();
        }
        public ActionResult IndexAdmin(int idmir)
        {
            ViewBag.idmir = idmir;
            ViewBag.JerarquiaIndicador = db.Poa_Indicadores.Where(p => p.IdMir == idmir).Select(z => z.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos).FirstOrDefault().TipoElementoObjetivos;
            ViewBag.IdConvenioLaboralTrabajadorCategoria = db.Poa_Indicadores.Where(p => p.IdMir == idmir).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            ViewBag.ResumenNarrativo = db.Poa_Mir.Where(p => p.IdMir == idmir).FirstOrDefault().ResumenNarrativo;
            return View("IndexAdmin");
        }

        public ActionResult IndicadoresMir(int id)
        {
            ViewBag.IdMir = id;
            PoaMir poa = new PoaMir();
            string rol = poa.setRol();
            ViewBag.Rol = rol;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            //string query2;

            //query2 = @"select a.Idmes,a.CantidadProducto,a.IdMes,a.IdCalendario,a.IdProductos,a.PrecioProducto,a.Total from Poa_Presupuesto a
            //        inner join Poa_Productos e on a.IdProductos = e.IdProductos
            //        inner join Poa_Calendario b on a.IdCalendario = b.IdCalendario
            //        inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores
            //        inner join Poa_Mir f on c.IdMir = f.IdMir
            //        inner join Poa_ProyectoArbol g on f.IdProyectoArbol = g.IdProyectoArbol
            //        inner join Catalogos_ctMes d on a.idmes = d.idmes
            //        where   c.IdIndicadores=" + idindicador + " and g.año=(select año from dbo.Poa_SistemaAñoVigente) and b.idcalendarioelemento=3";
            //var poa_Presupuesto = (List<Poa_Presupuesto>)dp.connection.Query<Poa_Presupuesto>(query2);
            //dp.Close();
            var miractual = db.Poa_Mir.Find(id);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = miractual.IdConvenioLaboralTrabajadorCategoria;
            var idestructuraorganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(x => x.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).FirstOrDefault();

            var añovigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            var poa_Indicadores = db.Poa_Indicadores.Where(p => p.IdMir == id).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_DimensionIndicador).Include(p => p.Poa_FrecuenciaMedicionIndicador).Include(p => p.Poa_Mir).Include(p => p.Poa_SentidoIndicador).Include(p => p.Poa_TipoIndicador);
            var usuariosalta = db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.IdModalidadEstudio == 0);
            if (rol == "Administrador")
            {
                ViewBag.ListaUsuarios = new SelectList((from s in usuariosalta.Where(s => s.FechaTermino == null || s.FechaTermino > DateTime.Now).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Nombre + " | " + s.ApellidoPaterno + " | " + s.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario").OrderBy(x => x.Text);

            }
            if (rol == "Responsable"){
                
                ViewBag.ListaUsuarios = new SelectList((from s in usuariosalta.Where(s=> s.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria || s.IdEstructuraOrganica == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Nombre + " | " + s.ApellidoPaterno + " | " + s.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario").OrderBy(x => x.Text);

                 }

            ViewBag.EsEdicion = false;
            PoaMir Mir = new PoaMir();

            if (Mir.EsAdministrador())
            {
                if (miractual.Poa_MirEstatus.EstatusMir != "Mir autorizada")
                    ViewBag.EsEdicion = true;
            }
            else
            {
                if (miractual.Poa_MirEstatus.EstatusMir == "En edición" || miractual.Poa_MirEstatus.EstatusMir == "Actividad Nueva")
                    ViewBag.EsEdicion = true;
            }

            return PartialView("IndicadoresMir", poa_Indicadores.ToList());

        }

        // GET: PoaIndicadores/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Indicadores poa_Indicadores = db.Poa_Indicadores.Find(id);
            if (poa_Indicadores == null)
            {
                return HttpNotFound();
            }
            return View(poa_Indicadores);
        }
        public ActionResult CrearIndicador(int id)
        {
            ViewBag.IdMir = id;
            PoaMir poa = new PoaMir();
            string rol = poa.setRol();
            ViewBag.Rol = rol;

            var miractual = db.Poa_Mir.Find(id);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = miractual.IdConvenioLaboralTrabajadorCategoria;
            var idestructuraorganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(x => x.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).FirstOrDefault();
            var usuariosalta = db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.IdModalidadEstudio == 0);
            if (rol == "Administrador")
            {
                ViewBag.ListaUsuarios = new SelectList((from s in usuariosalta.Where(s => s.FechaTermino == null || s.FechaTermino > DateTime.Now).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Nombre + " | " + s.ApellidoPaterno + " | " + s.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario").OrderBy(x => x.Text);

            }
            if (rol == "Responsable")
            {

                ViewBag.ListaUsuarios = new SelectList((from s in usuariosalta.Where(s => s.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria || s.IdEstructuraOrganica == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Nombre + " | " + s.ApellidoPaterno + " | " + s.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario").OrderBy(x => x.Text);

            }

                //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList((from s in db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => s.IdConvenioLaboralTrabajadorCategoria == indicadoractual.IdConvenioLaboralTrabajadorCategoria || s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario");

            //if (rol== "Administrador")
            //{
            //    ViewBag.ListaUsuarios = new SelectList((from s in db.Convenios_stConvenioLaboralTrabajadorCategoria.ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario");
            //}
            //else
            //    if (rol== "Responsable")
            //        ViewBag.ListaUsuarios = new SelectList((from s in db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => s.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria || s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario");

            //ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador");
            //ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion");
            //ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo");
            //ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador");
            //ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador");

            //List<Poa_Indicadores> poa_Indicadores = db.Poa_Indicadores.Where(p => p.IdMir == idmir).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_DimensionIndicador).Include(p => p.Poa_FrecuenciaMedicionIndicador).Include(p => p.Poa_Mir).Include(p => p.Poa_SentidoIndicador).Include(p => p.Poa_TipoIndicador).ToList();
            ViewBag.EsEdicion = false;
            PoaMir Mir = new PoaMir();

            if (Mir.EsAdministrador())
            {
                if (miractual.Poa_MirEstatus.EstatusMir != "Mir autorizada")
                    ViewBag.EsEdicion = true;
            }
            else
            {
                if (miractual.Poa_MirEstatus.EstatusMir == "En edición" || miractual.Poa_MirEstatus.EstatusMir== "Actividad Nueva")
                    ViewBag.EsEdicion = true;
            }
            
            return PartialView("CrearIndicador");
        }
        public ActionResult CrearIndicadorAdmin(int id)
        {
            ViewBag.IdMir = id;
            var miractual = db.Poa_Mir.Find(id);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = miractual.IdConvenioLaboralTrabajadorCategoria;
            var idestructuraorganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(x => x.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).FirstOrDefault();
            ViewBag.NombreUsuario = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(x => x.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno).FirstOrDefault();
            //ViewBag.ListaUsuarios = new SelectList((from s in db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => s.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria || s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario");
            //ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador");
            //ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion");
            //ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo");
            //ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador");
            //ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador");

            //List<Poa_Indicadores> poa_Indicadores = db.Poa_Indicadores.Where(p => p.IdMir == idmir).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_DimensionIndicador).Include(p => p.Poa_FrecuenciaMedicionIndicador).Include(p => p.Poa_Mir).Include(p => p.Poa_SentidoIndicador).Include(p => p.Poa_TipoIndicador).ToList();
            return PartialView("CrearIndicadorAdmin");
        }


        // GET: PoaIndicadores/Create
        public ActionResult Create()
        {
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador");
            ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion");
            ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo");
            ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador");
            ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador");
            return View();
        }

        // POST: PoaIndicadores/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdIndicadores,AlimentaComponente,EsPdi,IdConvenioLaboralTrabajadorCategoria,IdDimensionIndicador,IdFrecuenciaMedicionIndicador,IdMir,IdSentidoIndicador,IdTipoIndicador,LineaBase,LineaBaseDenominador,LineaBaseNumerador,MetaAnual,MetaAnualDenominador,MetaAnualNumerador,Denominador,FuentesMediosVerificacion,Numerador,Supuestos,UnidadMedidaIndicador,Indicador")] Poa_Indicadores poa_Indicadores)
        {
            PoaMir poamirx = new PoaMir();
            string resultadoaltarolusuario = poamirx.AltaRolUsuario(poa_Indicadores.IdConvenioLaboralTrabajadorCategoria, db);
            if (resultadoaltarolusuario  != "OK")
                ModelState.AddModelError("Error",resultadoaltarolusuario);
            if (ModelState.IsValid)
            {
                db.Poa_Indicadores.Add(poa_Indicadores);
               

                try
                {

                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }

                var url =
                    new UriBuilder(Request.Url.AbsoluteUri)
                    {
                        Path = Url.Action("Index", "PoaMIr")
                    }.ToString();

                return JsonView(ModelState.IsValid, "Se han actualizado los Indicadores exitosamente",null,null, url);
            }

             
                 
   
            

            ViewBag.IdMir = poa_Indicadores.IdMir;
            var miractual = db.Poa_Mir.Find(poa_Indicadores.IdMir);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = miractual.IdConvenioLaboralTrabajadorCategoria;
            var idestructuraorganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(x => x.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre).FirstOrDefault();
            ViewBag.ListaUsuarios = new SelectList((from s in db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(s => s.IdConvenioLaboralTrabajadorCategoria == miractual.IdConvenioLaboralTrabajadorCategoria || s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno+ " | " + s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario");
            //ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador", poa_Indicadores.IdDimensionIndicador);
            //ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion", poa_Indicadores.IdFrecuenciaMedicionIndicador);
            //ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_Indicadores.IdMir);
            //ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador", poa_Indicadores.IdSentidoIndicador);
            //ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador", poa_Indicadores.IdTipoIndicador);
            //return View(poa_Indicadores);
       
                                                                     
        return JsonView(ModelState.IsValid, resultadoaltarolusuario, "CrearIndicador", poa_Indicadores);
    }

        // GET: PoaIndicadores/Edit/5
        public ActionResult EditResumenNarrativo(int? id)
        {
            
   
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Mir poa_mir = db.Poa_Mir.Find(id);
            if (poa_mir == null)
            {
                return HttpNotFound();
            }
            ViewBag.JerarquiaIndicador = " Indicadores de "+poa_mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos;
            ViewBag.ResumenNarrativo = db.Poa_Mir.Where(p => p.IdMir == id).FirstOrDefault().ResumenNarrativo;

            ViewBag.IdMir = poa_mir.IdMir;
            ViewBag.IdConvenioLaboralTrabajadorCategoria = poa_mir.IdConvenioLaboralTrabajadorCategoria;
            ViewBag.IdMirEstatus = poa_mir.IdMirEstatus;
            ViewBag.IdProyectoArbol = poa_mir.IdProyectoArbol;
            //ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador", poa_Indicadores.IdDimensionIndicador);
            //ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion", poa_Indicadores.IdFrecuenciaMedicionIndicador);
            //ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_Indicadores.IdMir);
            //ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador", poa_Indicadores.IdSentidoIndicador);
            //ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador", poa_Indicadores.IdTipoIndicador);

            ViewBag.EsEdicion = false;
            PoaMir Mir = new PoaMir();

            if (Mir.EsAdministrador())
            {
                if (poa_mir.Poa_MirEstatus.EstatusMir != "Mir autorizada")
                    ViewBag.EsEdicion = true;
            }
            else 
            {
                if (poa_mir.Poa_MirEstatus.EstatusMir == "En edición" || poa_mir.Poa_MirEstatus.EstatusMir == "Actividad Nueva")
                    ViewBag.EsEdicion = true;
            }
            
            
            return View("vpResumenNarrativo",poa_mir);
        }

        // POST: PoaIndicadores/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdMir,IdConvenioLaboralTrabajadorCategoria,IdMirEstatus,IdProyectoArbol,ResumenNarrativo")] Poa_Mir poa_mir)
        {
            if (ModelState.IsValid)
            {
                Poa_Mir poa_mirx = db.Poa_Mir.Find(poa_mir.IdMir);
                poa_mirx.ResumenNarrativo = poa_mir.ResumenNarrativo;
                db.Entry(poa_mirx).State = System.Data.Entity.EntityState.Modified;
                try
                {

                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    var mensaje = ExceptionExtensions.GetOriginalException(e).Message;
                    if (mensaje.IndexOf("FK_") > -1)
                    {
                        mensaje = "No se puede actualizar el resumen narrativo";
                    }

                    return Json(new { Valid = false, Message = mensaje });
                }



                return JsonView(ModelState.IsValid, "Se han actualizado el resumen narrativo exitosamente", null, null, Url.Action("Index","PoaMir"));
              //  return JsonView(ModelState.IsValid, "Se han actualizado los Indicadores exitosamente", null, null, url);

            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = poa_mir.IdConvenioLaboralTrabajadorCategoria;
            ViewBag.IdMirEstatus = poa_mir.IdMirEstatus;
            ViewBag.IdProyectoArbol = poa_mir.IdProyectoArbol;
            return View(poa_mir);
        }

        // GET: PoaIndicadores/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Indicadores poa_Indicadores = db.Poa_Indicadores.Find(id);
            if (poa_Indicadores == null)
            {
                return HttpNotFound();
            }
            return View(poa_Indicadores);
        }

        // POST: PoaIndicadores/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Indicadores poa_Indicadores = db.Poa_Indicadores.Find(id);
            db.Poa_Indicadores.Remove(poa_Indicadores);

            try
            {

                db.SaveChanges();
            }
            catch (Exception e)
            {
                var mensaje = ExceptionExtensions.GetOriginalException(e).Message;
                if (mensaje.IndexOf("FK_") > -1)
                {
                    mensaje = "No se puede eliminar el registro porque ya está calendarizado";
                }

                return Json(new { Valid = false, Message = mensaje });
            }



            return JsonView(ModelState.IsValid, "Se han actualizado los Indicadores exitosamente", null, null, Url.Action("Index", "PoaMir"));

            //db.SaveChanges();
            //return RedirectToAction("Index");
        }
        // GET: PoaIndicadores/EditarIndicador/5
        public ActionResult EditarIndicador(int? id)
        {
            ViewBag.IdIndicadores = id;
            PoaMir poa = new PoaMir();
            string rol = poa.setRol();
            ViewBag.Rol = rol;

            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Indicadores poa_Indicadores = db.Poa_Indicadores.Find(id);
            if (poa_Indicadores == null)
            {
                return HttpNotFound();
            }


            var indicadoractual = db.Poa_Indicadores.Find(id);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = indicadoractual.IdConvenioLaboralTrabajadorCategoria;
            var idestructuraorganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(x => x.IdConvenioLaboralTrabajadorCategoria == indicadoractual.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).FirstOrDefault();

            var usuariosalta = db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.IdModalidadEstudio == 0);
            if (rol == "Administrador")
            {
                ViewBag.ListaUsuarios = new SelectList((from s in usuariosalta.Where(s => s.FechaTermino == null || s.FechaTermino > DateTime.Now).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Nombre + " | " + s.ApellidoPaterno + " | " + s.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario").OrderBy(x => x.Text);

            }
            if (rol == "Responsable")
            {

                ViewBag.ListaUsuarios = new SelectList((from s in usuariosalta.Where(s => s.IdConvenioLaboralTrabajadorCategoria == indicadoractual.IdConvenioLaboralTrabajadorCategoria || s.IdEstructuraOrganica == idestructuraorganica).ToList() select new { IdConvenioLaboralTrabajadorCategoria = s.IdConvenioLaboralTrabajadorCategoria, NombreUsuario = s.Nombre + " | " + s.ApellidoPaterno + " | " + s.ApellidoMaterno }), "IdConvenioLaboralTrabajadorCategoria", "NombreUsuario").OrderBy(x => x.Text);

            }

            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_Indicadores.IdConvenioLaboralTrabajadorCategoria);
            //ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador", poa_Indicadores.IdDimensionIndicador);
            //ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion", poa_Indicadores.IdFrecuenciaMedicionIndicador);
            //ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_Indicadores.IdMir);
            //ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador", poa_Indicadores.IdSentidoIndicador);
            //ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador", poa_Indicadores.IdTipoIndicador);
            return View(poa_Indicadores);
        }

        // POST: PoaIndicadores/EditarIndicador/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult EditarIndicador([Bind(Include = "IdIndicadores,IdConvenioLaboralTrabajadorCategoria,Denominador,FuentesMediosVerificacion,Numerador,Supuestos,Indicador")] Poa_Indicadores poa_Indicadores)
        {
            PoaMir poamirx = new PoaMir();


            string resultadoaltarolusuario = poamirx.AltaRolUsuario(poa_Indicadores.IdConvenioLaboralTrabajadorCategoria, db );
            if (resultadoaltarolusuario != "OK")
                ModelState.AddModelError("Error", resultadoaltarolusuario);

            if (ModelState.IsValid)
            {
                db.Entry(poa_Indicadores).State = System.Data.Entity.EntityState.Modified;
                db.Entry(poa_Indicadores).Property(x => x.AlimentaComponente).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.EsPdi).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.IdDimensionIndicador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.IdFrecuenciaMedicionIndicador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.IdMir).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.IdSentidoIndicador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.IdTipoIndicador).IsModified = false;
                
                db.Entry(poa_Indicadores).Property(x => x.LineaBase).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.LineaBaseDenominador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.LineaBaseNumerador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.MetaAnual).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.MetaAnualDenominador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.MetaAnualNumerador).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.PresupuestoCerrado).IsModified = false;
                db.Entry(poa_Indicadores).Property(x => x.UnidadMedidaIndicador).IsModified = false;
                try
                {

                    db.SaveChanges();
                    return JsonView(ModelState.IsValid, "Se han actualizado el indicador exitosamente", null, null, Url.Action("Index", "PoaMir"));
                }
                catch (Exception e)
                {
                    var mensaje = ExceptionExtensions.GetOriginalException(e).Message;
                    if (mensaje.IndexOf("FK_") > -1)
                    {
                        mensaje = "No se puede actualizar el indicador";
                    }

                    return Json(new { Valid = false, Message = mensaje });
                }
            }





            //db.SaveChanges();
            //return RedirectToAction("Index");

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_Indicadores.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdDimensionIndicador = new SelectList(db.Poa_DimensionIndicador, "IdDimensionIndicador", "DimensionIndicador", poa_Indicadores.IdDimensionIndicador);
            ViewBag.IdFrecuenciaMedicionIndicador = new SelectList(db.Poa_FrecuenciaMedicionIndicador, "IdFrecuenciaMedicionIndicador", "FrecuenciaMedicion", poa_Indicadores.IdFrecuenciaMedicionIndicador);
            ViewBag.IdMir = new SelectList(db.Poa_Mir, "IdMir", "ResumenNarrativo", poa_Indicadores.IdMir);
            ViewBag.IdSentidoIndicador = new SelectList(db.Poa_SentidoIndicador, "IdSentidoIndicador", "SentidoIndicador", poa_Indicadores.IdSentidoIndicador);
            ViewBag.IdTipoIndicador = new SelectList(db.Poa_TipoIndicador, "IdTipoIndicador", "TipoIndicador", poa_Indicadores.IdTipoIndicador);
            //return View(poa_Indicadores);
            return JsonView(false, ModelState.Values.SelectMany(m => m.Errors)
            .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j), "Edit", poa_Indicadores);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
