﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using Rotativa;
namespace Nova.Controllers.Poa.Dashboard
{
    public class PoaDashboardAvanceMensualController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index(int? id, int Anios = 0)
        {
            Tuple<List<Poa_Calendario>, List<Catalogos_ctMes>, List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas>> model = null;

            int AñoDefault = 0;
            if (Anios != 0)
            {
                AñoDefault = Anios;
            }
            else
            {
                AñoDefault = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            }
            if (id.HasValue)
            {
                if (id != 0 || id != null)
                {
                    model = GetIndicadores(id.Value, AñoDefault);
                }
                else
                {
                    model = GetIndicadores(DateTime.Now.Month, AñoDefault);
                }
            }

            else
            {
                model = GetIndicadores(DateTime.Now.Month, AñoDefault);
            }

            //agrupar los años de la Mir para realizar el dropdownlist en la vista Index
            var ListAños = db.Poa_Mir.GroupBy(s => s.AñoMir).Select(t => new SelectListItem
            {
                Text = t.Key.ToString(),
                Value = t.Key.ToString()
            });


            ViewBag.Anios = new SelectList(ListAños.OrderByDescending(x=>x.Value), "Text", "Value", AñoDefault);
            ViewBag.AnioSelected = AñoDefault;

            return View(model);
        }

        [HttpPost]
        public ActionResult Index(int id = 0, int Anios = 0)
        {
            Tuple<List<Poa_Calendario>, List<Catalogos_ctMes>, List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas>> model = null;

            int AñoDefault = 0;
            if (Anios != 0)
            {
                AñoDefault = Anios;
            }
            else
            {
                AñoDefault = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            }

            if (id != 0)
            {
                model = GetIndicadores(id, AñoDefault);
            }
            else
            {
                model = GetIndicadores(DateTime.Now.Month, AñoDefault);
            }

            //agrupar los años de la Mir para realizar el dropdownlist en la vista Index
            var ListAños = db.Poa_Mir.GroupBy(s => s.AñoMir).Select(t => new SelectListItem
            {
                Text = t.Key.ToString(),
                Value = t.Key.ToString()
            });


            ViewBag.Anios = new SelectList(ListAños.OrderByDescending(x => x.Value), "Text", "Value", AñoDefault);
            ViewBag.AnioSelected = AñoDefault;


            return View(model);
        }


        public Tuple<List<Poa_Calendario>, List<Catalogos_ctMes>, List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas>> GetIndicadores(int IdMes, int Anio)
        {
            int AñoPoa = Anio;
            List<Poa_Calendario> ListaIndicadoresAux = new List<Poa_Calendario>();
            List<Poa_Calendario> ListaIndicadores = new List<Poa_Calendario>();
            List<string> CalendarioElementos = new List<string>() { "Programado", "Realizado" };

            ListaIndicadoresAux = db.Poa_Calendario.Include("Poa_Indicadores").Where(c => c.IdMes == IdMes && c.Poa_Indicadores.Poa_Mir.AñoMir == AñoPoa && CalendarioElementos.Contains(c.Poa_CalendarioElemento.CalendarioElemento)).OrderBy(o => o.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Numero).ToList();

            foreach (var item in ListaIndicadoresAux)
            {

                var Programado = (ListaIndicadoresAux.Where(t => t.IdIndicadores == item.IdIndicadores && t.IdMes == item.IdMes && t.Poa_CalendarioElemento.CalendarioElemento == "Programado").SingleOrDefault() != null) ? ListaIndicadoresAux.Where(t => t.IdIndicadores == item.IdIndicadores && t.Poa_CalendarioElemento.CalendarioElemento == "Programado").FirstOrDefault().Valor : 0;
                var Realizado = item.Valor;

                if ((Programado == 0 && Realizado > 0) || (Programado > 0 && Realizado == 0) || (Programado > 0 && Realizado > 0))
                {
                    ListaIndicadores.Add(item);
                }
            }

            List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas> ActividadesEstatales = new List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas>();

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {

                //ActividadesEstatales = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(m => m.Poa_EstructuraProgramaticaEstatalActividadAño.Año == AñoPoa && m.IdMes == IdMes && CalendarioElementos.Contains(m.Poa_CalendarioElemento.CalendarioElemento)).ToList();
                ActividadesEstatales = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(m => m.Poa_EstructuraProgramaticaEstatalActividadAño.Año == AñoPoa && m.IdMes == IdMes).ToList();
            }
            else
            {
                //ListaIndicadores = ListaIndicadores.Where(y=>y.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria == idusuario).OrderBy(x => x.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Numero).ThenBy(x => x.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria).ToList();
                ListaIndicadores = ListaIndicadores.Where(y => y.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria == idusuario).ToList();
                ActividadesEstatales = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(m => m.Poa_EstructuraProgramaticaEstatalActividadAño.Poa_EstructuraProgramaticaEstatal.Poa_ProyectosEstatales.IdConvenioLaboralTrabajadorCategoriaResponsable == idusuario && m.Poa_EstructuraProgramaticaEstatalActividadAño.Año == AñoPoa && m.IdMes == IdMes).ToList();

            }


            var modelo = Tuple.Create<List<Poa_Calendario>, List<Catalogos_ctMes>, List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas>>(ListaIndicadores, db.Catalogos_ctMes.ToList(), ActividadesEstatales);
            return modelo;
        }

        [HttpPost]
        public ActionResult IndicadoresUsuario(int id, int mes, int Año)
        {
            int IdConvenioLaboral = id;
            

            List<Poa_Calendario> ListaIndicadores = new List<Poa_Calendario>();
            List<Poa_Calendario> ListaIndicadoresAux = new List<Poa_Calendario>();
            List<string> CalendarioElementos = new List<string>() { "Realizado", "Programado" };

            ListaIndicadoresAux = db.Poa_Calendario.Include("Poa_Indicadores").Where(c => c.Poa_Indicadores.Poa_Mir.AñoMir == Año  && c.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboral && c.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos != "Componente" && CalendarioElementos.Contains(c.Poa_CalendarioElemento.CalendarioElemento) && c.IdMes == mes).ToList();

            foreach (var item in ListaIndicadoresAux)
            {
                var Programado = (ListaIndicadoresAux.Where(t => t.IdIndicadores == item.IdIndicadores && t.IdMes == item.IdMes && t.Poa_CalendarioElemento.CalendarioElemento == "Programado").SingleOrDefault() != null) ? ListaIndicadoresAux.Where(t => t.IdIndicadores == item.IdIndicadores && t.Poa_CalendarioElemento.CalendarioElemento == "Programado").FirstOrDefault().Valor : 0;
                var Realizado = item.Valor;

                if ((Programado == 0 && Realizado > 0) || (Programado > 0 && Realizado == 0) || (Programado > 0 && Realizado > 0))
                {
                    ListaIndicadores.Add(item);
                }
            }


            var model = ListaIndicadores.OrderBy(x => x.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Numero).ThenBy(x => x.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("_IndicadoresUsuario", model);
        }


        [HttpPost]
        public ActionResult IndicadoresEstatalUsuario(int id, int mes, int Año)
        {
            int IdConvenioLaboral = id;
            List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas> ListaIndicadores = new List<Poa_EstructuraProgramaticaEstatalActividadAñoMetas>();
            List<string> CalendarioElementos = new List<string>() { "Realizado", "Programado" };
            ListaIndicadores = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(e => e.Poa_EstructuraProgramaticaEstatalActividadAño.Año == Año && e.IdMes == mes && e.Poa_EstructuraProgramaticaEstatalActividadAño.Poa_EstructuraProgramaticaEstatal.Poa_ProyectosEstatales.IdConvenioLaboralTrabajadorCategoriaResponsable == id && CalendarioElementos.Contains(e.Poa_CalendarioElemento.CalendarioElemento)).ToList();
            //ListaIndicadores = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(e => e.IdMes == mes && e.IdConvenioLaboralTrabajadorCategoria == id && e.Poa_EstructuraProgramaticaEstatalActividadAño.Poa_EstructuraProgramaticaEstatal.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente" && CalendarioElementos.Contains(e.Poa_CalendarioElemento.CalendarioElemento)).ToList();

            //db.Poa_Calendario.Include("Poa_Indicadores").Where(c => c.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboral && c.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos != "Componente" && CalendarioElementos.Contains(c.Poa_CalendarioElemento.CalendarioElemento) && c.IdMes == mes).ToList();
            //var model = ListaIndicadores.OrderBy(x => x.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Numero).ThenBy(x => x.Poa_Indicadores.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("_IndicadoresEstatalUsuario", ListaIndicadores);
        }


        [AllowAnonymous]
        public ActionResult getFotografiaTrabajador(string Id)
        {
            bdNovaEntities db = new bdNovaEntities();

            byte[] image = null; string tipo = "jpg";
            int idkardex = int.Parse(Id);

            image = db.Kardex_ctDatosPersonalesFotografias.Where(k => k.IdKardex == idkardex).FirstOrDefault().Fotografia;

            if (image == null)
                //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                return File("~/App_Themes/Nova/img/user.jpg", "image/jpg");
            else
            {

                return File(ResizeImage(image, 120, 100), tipo);
            }

        }
        [AllowAnonymous]
        public static byte[] ResizeImage(byte[] image, int width, int height)
        {
            System.IO.MemoryStream myMemStream = new System.IO.MemoryStream(image);
            System.Drawing.Image fullsizeImage = System.Drawing.Image.FromStream(myMemStream);
            System.Drawing.Image newImage = fullsizeImage.GetThumbnailImage(width, height, null, IntPtr.Zero);
            System.IO.MemoryStream myResult = new System.IO.MemoryStream();
            newImage.Save(myResult, System.Drawing.Imaging.ImageFormat.Jpeg);  //Or whatever format you want.
            return myResult.ToArray();
        }

        public ActionResult SetObservacionAdministrador(int id)
        {
            Poa_Calendario poa_Calendario = db.Poa_Calendario.Find(id);

            return PartialView("_FormIndicadorUser", poa_Calendario);
        }

        public ActionResult SetObservacionEstatalAdministrador(int id)
        {
            Poa_EstructuraProgramaticaEstatalActividadAñoMetas EstructuraProgramaticaEstatalActividadAñoMetas = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Find(id);

            return PartialView("_FormIndicadorEstatalUser", EstructuraProgramaticaEstatalActividadAñoMetas);
        }




        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult EditEstatal([Bind(Include = "IdEstructuraProgramaticaEstatalActividadAñoMetas,IdEstructuraProgramaticaEstatalActividadAño,IdMes,Valor,IdCalendarioElemento,Observacion,IdConvenioLaboralTrabajadorCategoria,FechaUltimaModificacion,ObservacionAdministrador,ObservacionAnterior,EsAutorizado,EsObservado")] Poa_EstructuraProgramaticaEstatalActividadAñoMetas EstructuraProgramaticaEstatalActividadAñoMetas)
        {

            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                return Json(new { Valid = false, Message = "Usuario No autorizado" });
            }

            if (EstructuraProgramaticaEstatalActividadAñoMetas.ObservacionAdministrador != null)
                if (EstructuraProgramaticaEstatalActividadAñoMetas.ObservacionAdministrador.Trim() != "")
                    EstructuraProgramaticaEstatalActividadAñoMetas.EsObservado = true;


            if (EstructuraProgramaticaEstatalActividadAñoMetas.EsAutorizado)
            {
                EstructuraProgramaticaEstatalActividadAñoMetas.EsObservado = false;
                EstructuraProgramaticaEstatalActividadAñoMetas.ObservacionAnterior = (EstructuraProgramaticaEstatalActividadAñoMetas != null) ? EstructuraProgramaticaEstatalActividadAñoMetas.ObservacionAdministrador : null;
                EstructuraProgramaticaEstatalActividadAñoMetas.ObservacionAdministrador = null;
            }


            if (ModelState.IsValid)
            {

                try
                {
                    db.Entry(EstructuraProgramaticaEstatalActividadAñoMetas).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();


                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }




                return JsonView(ModelState.IsValid, "Se ha agregado la Observación a l Indicador", null, null, Url.Action("Index", "PoaDashboardAvanceMensual", new { id = EstructuraProgramaticaEstatalActividadAñoMetas.IdMes }));

            }

            string messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, "Index", GetIndicadores(EstructuraProgramaticaEstatalActividadAñoMetas.IdMes,EstructuraProgramaticaEstatalActividadAñoMetas.Poa_EstructuraProgramaticaEstatalActividadAño.Año));




        }




        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCalendario,IdCalendarioElemento,IdIndicadores,IdMes,Observacion,Valor,ObservacionAdministrador,EsAutorizado")] Poa_Calendario poa_Calendario)
        {

            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                return Json(new { Valid = false, Message = "Usuario No autorizado" });
            }

            if (poa_Calendario.ObservacionAdministrador != null)
                if (poa_Calendario.ObservacionAdministrador.Trim() != "")
                    poa_Calendario.EsObservado = true;


            if (poa_Calendario.EsAutorizado)
            {
                poa_Calendario.EsObservado = false;
            }


            if (ModelState.IsValid)
            {

                try
                {
                    db.Entry(poa_Calendario).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();


                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                var poa_Calendario2 = db.Poa_Calendario.Include("Poa_Indicadores").Where(t => t.IdCalendario == poa_Calendario.IdCalendario); return JsonView(ModelState.IsValid, "Se ha agregado la Observación al Indicador", null, null, Url.Action("Index", "PoaDashboardAvanceMensual", new { id = poa_Calendario.IdMes }));

            }

            string messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));


            return JsonView(ModelState.IsValid, messages, "Index", GetIndicadores(poa_Calendario.IdMes, poa_Calendario.Poa_Indicadores.Poa_Mir.AñoMir));




        }

        public ActionResult dashboardpdf(int id, int Anio)
        {
            //id = mes
            var model = GetIndicadores(id,Anio);

            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf("_DashboadPdf", model)
            {
                PageSize = Rotativa.Options.Size.Letter,
                PageOrientation = Rotativa.Options.Orientation.Portrait,
                PageMargins = m,
                FileName = "Poa_Avance_Usuario" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf"

            };

        }

    }
}