﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using Seguridad;
using Dapper;

namespace Nova.Controllers
{
    public class PoaComprasConsolidadasReportController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        string query = @"
SELECT max(f.Numero) as NumeroProyecto,max(f.Proyecto) as Proyecto,max(h.EstructuraOrganica) EstructuraOrganica , a.IdProductos,z.Productos,max(PrecioProducto) PrecioProducto
,MAX( z.PartidaGenerica) as PartidaGenerica
, z.PartidaEspecifica
,MAX( z.Partida) as Partida
,sum(case when a.idmes=1 then CantidadProducto else 0 end) EneroCantidad
,sum(case when a.idmes=2 then CantidadProducto else 0 end) FebCantidad
,sum(case when a.idmes=3 then CantidadProducto else 0 end) MarCantidad
,sum(case when a.idmes=4 then CantidadProducto else 0 end) AbrCantidad
,sum(case when a.idmes=5 then CantidadProducto else 0 end) MayCantidad
,sum(case when a.idmes=6 then CantidadProducto else 0 end) JunCantidad
,sum(case when a.idmes=7 then CantidadProducto else 0 end) JulCantidad
,sum(case when a.idmes=8 then CantidadProducto else 0 end) AgoCantidad
,sum(case when a.idmes=9 then CantidadProducto else 0 end) SepCantidad
,sum(case when a.idmes=10 then CantidadProducto else 0 end) OctCantidad
,sum(case when a.idmes=11 then CantidadProducto else 0 end) NovCantidad
,sum(case when a.idmes=12 then CantidadProducto else 0 end) DicCantidad
,sum(case when a.idmes=1 then Total else 0 end) EneroTotal
,sum(case when a.idmes=2 then Total else 0 end) FebTotal
,sum(case when a.idmes=3 then Total else 0 end) MarTotal
,sum(case when a.idmes=4 then Total else 0 end) AbrTotal
,sum(case when a.idmes=5 then Total else 0 end) MayTotal
,sum(case when a.idmes=6 then Total else 0 end) JunTotal
,sum(case when a.idmes=7 then Total else 0 end) JulTotal
,sum(case when a.idmes=8 then Total else 0 end) AgoTotal
,sum(case when a.idmes=9 then Total else 0 end) SepTotal
,sum(case when a.idmes=10 then Total else 0 end) OctTotal
,sum(case when a.idmes=11 then Total else 0 end) NovTotal
,sum(case when a.idmes=12 then Total else 0 end) DicTotal
  FROM  Poa_Presupuesto a 
  inner join poa_productos z on z.idProductos=a.idProductos and z.Año in @anio
  inner join Poa_Partidas w on w.PartidaEspecifica = z.PartidaEspecifica and w.Capitulo=z.CapituloInterno and w.Año in @anio
  inner join poa_Calendario b on a.IdCalendario=b.IdCalendario
  inner join poa_Indicadores c on c.IdIndicadores=b.IdIndicadores
  inner join poa_mir d on d.IdMIr=c.Idmir
  inner join poa_proyectoArbol e on e.IdProyectoArbol=d.IdProyectoArbol
  inner join poa_proyectos f on f.IdProyectos=e.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria g on g.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica h on h.IdEstructuraOrganica=g.IdEstructuraOrganica
  where
  z.PartidaEspecifica in (
  
  --select PartidaEspecifica from Poa_Partidas a
  --inner join Poa_ComprasConsolidadas b on a.IdPartidas=b.IdPartidas
  --where a.Año in @anio
  --group by PartidaEspecifica

    select PartidaEspecifica from Poa_Partidas a
    inner join Poa_ComprasConsolidadas b on a.IdPartidas=b.IdPartidas and b.Año=a.Año
    where a.Año in @anio
    group by PartidaEspecifica


  ) and  d.AñoMir in @anio
  and f.Proyecto in @proyecto
  and h.EstructuraOrganica in @area
   group by  e.IdProyectos,h.IdEstructuraOrganica,a.IdProductos,z.Productos, z.PartidaEspecifica
    order by  max(h.EstructuraOrganica),z.PartidaEspecifica";

        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };


        // GET: PoaComprasConsolidadasReport
        public ActionResult Index()
        {
            PoaMir rol = new PoaMir();
            if (rol.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaComprasConsolidadasReport");
            }

            return View();
        }

        public ActionResult Admin()
        {
            PoaMir rol = new PoaMir();
            if (!rol.EsAdministrador())
            {
                return RedirectToAction("Index", "PoaComprasConsolidadasReportController");
            }
            return View();
        }

        [HttpPost]
        public ActionResult ComprasConsolidadasView(String[] anios, String[] proyectos, String[] areas)
        {


            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;


            DapperQuery dp = new DapperQuery("bdNovaEntities");


            var result = (List<ComprasCosolidadas>)dp.connection.Query<ComprasCosolidadas>(query, new { anio, proyecto, area });

            dp.Close();

            return PartialView("_ComprasConsolidadas", result.ToList());
        }


        public ActionResult ComprasConsolidadas(String[] anios, String[] proyectos, String[] areas)
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var result = (List<ComprasCosolidadas>)dp.connection.Query<ComprasCosolidadas>(query, new { anio, proyecto, area });

            if (proyecto.Count() == 1 && area.Count() == 1)
            {

                string areaSingle = area.FirstOrDefault();
                var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();

            }
            else
            {
                ViewBag.UsuarioU = "NoUser";
            }


            dp.Close();
            //Poa_ComprasConsolidadas com = new Poa_ComprasConsolidadas();
            string modalidad = "Poa_ComprasConsolidadas" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;

            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }


        public ActionResult ComprasConsolidadasXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");


            var result = (List<ComprasCosolidadas>)dp.connection.Query<ComprasCosolidadas>(query, new { anio, proyecto, area });
            dp.Close();
            string modalidad = "Poa_ComprasConsolidadas_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);

            if (rol.EsAdministrador())
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  WHERE b.AñoProyectos = @año
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  WHERE b.AñoProyectos = @año
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }



    }
}