﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Transactions;
//using Excel = Microsoft.Office.Interop.Excel;
using ExcelDataReader;

namespace Nova.Controllers
{
    public class PoaClasesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index()
        {
            return View(db.Poa_Clases.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        }

        [HttpPost]
        public ActionResult Importar(HttpPostedFileBase upload)
        {

            if (upload == null && upload.ContentLength < 0)
                throw new SystemException("Debe seleccionar un archivo.");

            // ExcelDataReader works with the binary Excel file, so it needs a FileStream
            // to get started. This is how we avoid dependencies on ACE or Interop:
            System.IO.Stream stream = upload.InputStream;
            // We return the interface, so that
            IExcelDataReader reader = null;

            if (upload.FileName.EndsWith(".xls"))
            {
                reader = ExcelReaderFactory.CreateBinaryReader(stream);
            }
            else if (upload.FileName.EndsWith(".xlsx"))
            {
                reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
            }
            else
            {
                //ModelState.AddModelError("File", "Formato de archivo no soportado. ");
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "Formato de archivo no soportado. ");
            }
            //reader.IsFirstRowAsColumnNames = true;

            //DataSet result = new DataSet();

            List<Poa_Clases> list = new List<Poa_Clases>();
            int contador = 0;
            while (reader.Read())
            {
                if (contador == 0)
                    reader.Read();
                Poa_Clases newlist = new Poa_Clases();

                newlist.Nombre = System.Convert.ToString(reader.GetValue(0));
                newlist.Estatal = System.Convert.ToInt16(reader.GetValue(1));
                newlist.Federal = System.Convert.ToInt32(reader.GetValue(2));
                newlist.Partida = System.Convert.ToString(reader.GetValue(3));
                newlist.Año = System.Convert.ToInt16(reader.GetValue(4));




                list.Add(newlist);

                contador++;
            }
            reader.Close();

            if (list.Count() <= 0)
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "Error al cargar los datos. Probablemente el archivo este vací ");

            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    //eliminar el conjunto de datos
                    db.Poa_Clases.RemoveRange(db.Poa_Clases.Where(x => x.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año));

                    //gurdar datos en base de datos
                    db.Poa_Clases.AddRange(list);
                    db.SaveChanges();

                    scope.Complete();

                }
            }
            catch (Exception e)
            {
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "Error al cargar los datos: " + e.ToString());
            }



            return View(db.Poa_Clases.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}