﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Transactions;





namespace Nova.Controllers.POA.CatalogoProyectosPoa
{
    public class Poa_AñosSexenio 
    {

        public int IdPeriodoSexenal;
        public int Año;
        public String Sexenio;

        public Poa_AñosSexenio()
        {
            IdPeriodoSexenal=0;
            Año=0;
            Sexenio = "";
        }
        public Poa_AñosSexenio(int _IdPeriodoSexenal, int _Año, String _Sexenio)
            {
                IdPeriodoSexenal = _IdPeriodoSexenal;
                Año = _Año;
                Sexenio = _Sexenio;
            }

    }


    public class PoaProyectosController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Poa_Proyectos

        
        public ActionResult Index()
        {
            var AñosSexenio =   db.Poa_PeriodoSexenal.ToList();

            List<Poa_AñosSexenio> Años = new List<Poa_AñosSexenio>();


            foreach (var item in AñosSexenio)
            {

                for (int i = item.AñoInicial; i <= item.AñoFinal; i++)
                {
                    Poa_AñosSexenio Año = new Poa_AñosSexenio();
                    Año.IdPeriodoSexenal = item.IdPeriodoSexenal;
                    Año.Año = i;
                    Año.Sexenio = i.ToString()+"  (" + item.AñoInicial.ToString() + "-" + item.AñoFinal.ToString() + ")";
                    Años.Add(Año);
                }

            }

            List<SelectListItem> CategorySelectList = new List<SelectListItem>(
                Años.Select(x => new SelectListItem() { Text = x.IdPeriodoSexenal.ToString(), Value = x.Sexenio }));


            ViewBag.TodosAños = CategorySelectList;
           






            return View(db.Poa_Proyectos.ToList());
        
        }


        [HttpPost, ActionName("AgregarProyecto")]
        public ActionResult AgregarProyecto(short? IdProyecto, int? IdSexenio, String Año)
        {

            Nova.Models.Poa_ProyectosAño modelo = new Nova.Models.Poa_ProyectosAño();

            String AñoDigitos4 = Año.Substring(0, 4);
            short AñoCompleto = Convert.ToInt16(AñoDigitos4);
            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.Poa_ProyectosAño.Where(g => g.AñoProyectos == AñoCompleto && g.IdProyectos == IdProyecto).ToArray();
                int valor = RegistrosRepetidos.Count();

                if ( valor > 0)
                   
                    
                {
                  
                    return Json(new { Valid = false, Message = "Ya existe un proyecto en este año " });

                    
                }

                else 
                {  
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                        {
                            try
                            {

                                modelo.AñoProyectos= AñoCompleto;
                                modelo.EsCerradoArbolObjetivos = false;
                                modelo.EsCerradoArbolProblemas = false;
                                modelo.IdProyectos = Convert.ToInt16(IdProyecto);
                                modelo.IdPeriodoSexenal = Convert.ToInt16(IdSexenio);
                                db.Poa_ProyectosAño.Add(modelo);
                                db.SaveChanges();
                                trans.Complete();
                                
                            }
                            catch (Exception e)
                            {
                                
                                return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                                //return new JsonResult() { Data = "Valid=false" + ", Message=" + e.Message };
                                // all changes will be rolled back
                            }
                            scope.Complete();
                            return Json(new { Valid = true, Message = "El proyecto ha sido asignada  al área exitosamente" });
                        }
                        //return JsonView(ModelState.IsValid, "El proyecto ha sido asignado exitosamente");
                    }
                }
                
            }
            string messages = string.Join("  ", ModelState.Values
                                         .SelectMany(x => x.Errors)
                                         .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });

          

        }
         
        
        // GET: Poa_Proyectos/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Proyectos poa_Proyectos = db.Poa_Proyectos.Find(id);
            if (poa_Proyectos == null)
            {
                return HttpNotFound();
            }
            return View(poa_Proyectos);
        }

        // GET: Poa_Proyectos/Create
        public ActionResult Create()
        {
            return PartialView();
        }

        // POST: Poa_Proyectos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProyectos,Numero,Objetivo,Proyecto")] Poa_Proyectos poa_Proyectos)
        {
            
            if (ModelState.IsValid)
            {
                var ProyectosRepetidos = db.Poa_Proyectos.Where(g => g.Numero == poa_Proyectos.Numero && g.Proyecto == poa_Proyectos.Proyecto).ToArray();

                int valor = ProyectosRepetidos.Count();
                if (valor > 0)
                {
                    
                    return Json(new { Valid = false, Message = "Ya existe un proyecto igual " });
                    //throw new ArgumentException(" ");


                }
                else {

                    try
                    {

                        db.Poa_Proyectos.Add(poa_Proyectos);
                        db.SaveChanges();
                        return Json(new { Valid = true, Message = "El proyecto ha sido creado exitosamente" });
                    }
                    catch (Exception e)
                    {
                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        // all changes will be rolled back
                    }

                    return JsonView(ModelState.IsValid, "El proyecto ha sido creado exitosamente");
                //return Redirect("~/Poa_Proyectos/Index");

                }
            //    return RedirectToAction("Index");
            }

            string messages = string.Join("  ", ModelState.Values
                                          .SelectMany(x => x.Errors)
                                          .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }

        // GET: Poa_Proyectos/Edit/5
        public ActionResult Edit(short? idedit)
        {
            if (idedit == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Proyectos poa_Proyectos = db.Poa_Proyectos.Find(idedit);
            if (poa_Proyectos == null)
            {
                return HttpNotFound();
            }
            return View(poa_Proyectos);
        }

        // POST: Poa_Proyectos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProyectos,Numero,Objetivo,Proyecto")] Poa_Proyectos poa_Proyectos)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_Proyectos).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(poa_Proyectos);
        }

        // GET: Poa_Proyectos/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Proyectos poa_Proyectos = db.Poa_Proyectos.Find(id);
            if (poa_Proyectos == null)
            {
                return HttpNotFound();
            }
            return View(poa_Proyectos);
        }

        // POST: Poa_Proyectos/Delete/5
       [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(short id)
        {

            try
            {

                Poa_Proyectos poa_Proyectos = db.Poa_Proyectos.Find(id);
                db.Poa_Proyectos.Remove(poa_Proyectos);
                db.SaveChanges();
                return Json(new { Valid = true, Message = "Registro eliminado exitosamente" });

            }
            catch (Exception e)
            {

                var mensaje = ExceptionExtensions.GetOriginalException(e).Message;
                if (mensaje.IndexOf("FK_") > -1)
                {
                    mensaje = "No se puede borrar el Proyecto porque ha sido asignado";
                }
                return Json(new { Valid = false, Message = mensaje });
                // all changes will be rolled back
            }


            //return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
