﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Data.Entity;
using System.Transactions;

namespace Nova.Controllers.Poa.PoaCambiarEstatusMIR
{
    public class PoaCambiarStatusController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: CambiarStatus
        public ActionResult Index()
        {
            return View();
        }
        // GET: Poa_MirHistorialEstatus/Create
        public ActionResult CambiarStatus(int id, int idcltc, string nombreestatus)
        {
            PoaMir poa = new PoaMir();
            var rolusuario = poa.setRol();

            Poa_MirHistorialEstatus MirHistorial = new Poa_MirHistorialEstatus();
            MirHistorial.IdConvenioLaboralTrabajadorCategoria = idcltc;
            MirHistorial.IdMir = id;
            MirHistorial.FechaEstatus = System.DateTime.Now;
            if (nombreestatus == "" || nombreestatus==null)
            {
                if (rolusuario == "Administrador")
                    ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus.Where(d => d.EsAdministrador == true).ToList(), "IdMirEstatus", "EstatusMir");
                else
                    ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus.Where(d => d.EsAdministrador == false).ToList(), "IdMirEstatus", "EstatusMir");
            }
            else
            {
                if (rolusuario == "Administrador")
                    ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus.Where(d => d.EsAdministrador == true).ToList(), "IdMirEstatus", "EstatusMir");
                else
                ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus.Where(d => d.EstatusMir == nombreestatus).ToList(), "IdMirEstatus", "EstatusMir");

            }
            return View(MirHistorial);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdMirHistorialEstatus,FechaEstatus,IdConvenioLaboralTrabajadorCategoria,IdMir,IdMirEstatus,ObservacionEstatus")] Poa_MirHistorialEstatus poa_MirHistorialEstatus)
        {
            var componente = db.Poa_Mir.Where(z=>z.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Componente" && z.IdMir == poa_MirHistorialEstatus.IdMir).FirstOrDefault();
            if (componente != null)
            {
                 
                 string Estatus = db.Poa_MirEstatus.Find(poa_MirHistorialEstatus.IdMirEstatus).EstatusMir;
                 int IdRevisarMIRAdministrador = db.Poa_MirEstatus.Where(x => x.EstatusMir == "Revisar MIR por el administrador").FirstOrDefault().IdMirEstatus;
                 int IdMirAutorizada = db.Poa_MirEstatus.Where(x => x.EstatusMir == "Mir autorizada").FirstOrDefault().IdMirEstatus;
                 var MirActiviades = db.Poa_Mir.Where(a => a.Poa_MirEstatus.EstatusMir != "Cancelado" && a.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && a.Poa_ProyectoArbol.IdPadreElementoObjetivos == componente.Poa_ProyectoArbol.IdProyectoArbol);


                 switch (Estatus)
                {
                     case "Revisar MIR por el administrador":
                     var mirsarevisar = db.Poa_Mir.Where(a => a.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && a.Poa_ProyectoArbol.IdPadreElementoObjetivos == componente.Poa_ProyectoArbol.IdProyectoArbol && a.Poa_MirEstatus.EstatusMir != "Cancelado").Select(k => k.IdMir);
                     var mirsautorizadas = db.Poa_MirHistorialEstatus.Where(a => mirsarevisar.Contains(a.IdMir) && a.Poa_MirEstatus.EstatusMir == "Mir autorizada").GroupBy(s=>s.IdMir).ToList();
                        if (MirActiviades.Count() == 0)
                            return Json(new { Valid = false, Message = "No  existen actividades para este componente." }, null, null);
                        if (mirsautorizadas.Count() != MirActiviades.Count())
                            return Json(new { Valid = false, Message = "Todas las actividades de este componente deberán tener el estatus: MIR AUTORIZADA para poder procesar su solicitud." }, null, null);

                        break;
                     case "Mir autorizada":
                        var MirActiviadesAutorizadas = db.Poa_Mir.Where(a => a.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && a.Poa_ProyectoArbol.IdPadreElementoObjetivos == componente.Poa_ProyectoArbol.IdProyectoArbol && a.Poa_MirEstatus.EstatusMir == "Mir autorizada");
                        var mirsarevisar2 = db.Poa_Mir.Where(a => a.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && a.Poa_ProyectoArbol.IdPadreElementoObjetivos == componente.Poa_ProyectoArbol.IdProyectoArbol && a.Poa_MirEstatus.EstatusMir != "Cancelado").Select(k => k.IdMir);
                        var mirsautorizadas2 = db.Poa_MirHistorialEstatus.Where(a => mirsarevisar2.Contains(a.IdMir) && a.Poa_MirEstatus.EstatusMir== "Mir autorizada"  ).GroupBy(s=>s.IdMir).ToList();
                        if (MirActiviades.Count() == 0 )
                                return Json(new { Valid = false, Message = "No  existen actividades para este componente." }, null, null);
                        if (mirsautorizadas2.Count() != MirActiviades.Count() )
                            return Json(new { Valid = false, Message = "Todas las actividades de este componente deberán tener el estatus: MIR AUTORIZADA para poder procesar su solicitud." }, null, null);

                     break;
                     case "Revisar Indicadores por el administrador":
                     var MirIndicadoresAutorizadas = db.Poa_Mir.Where(a => a.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad" && a.Poa_ProyectoArbol.IdPadreElementoObjetivos == componente.Poa_ProyectoArbol.IdProyectoArbol && a.Poa_MirEstatus.EstatusMir == "Indicadores Autorizados").GroupBy(s=>s.IdMir).ToList();
                         
                        if(MirIndicadoresAutorizadas.Count() != MirActiviades.Count())
                             return Json(new { Valid = false, Message = "TodOs los INDICADORES de todas las ACTIVIDADES de este componenete deberán estar en estátus: INDICADORES AUTORIZADOS para poder procesar su solicitud." }, null, null);

                     break;
                    

                }
               

            }
            
            Poa_Mir mir = db.Poa_Mir.Find(poa_MirHistorialEstatus.IdMir);
            mir.IdMirEstatus = poa_MirHistorialEstatus.IdMirEstatus;


           

                if (ModelState.IsValid)
            {

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    try
                    {
                        db.Entry(mir).State = EntityState.Modified;
                        db.Poa_MirHistorialEstatus.Add(poa_MirHistorialEstatus);
                        db.SaveChanges();

                        PoaMir poamir= new PoaMir();

                        poamir.CambioStatuslMail(mir.IdMir);
                    }
                    catch (Exception e)
                    {


                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, null, null);
                    }
                
                scope.Complete();
                return JsonView(ModelState.IsValid, "Se han agregado los datos exitosamente");
                }
            }
             
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_MirHistorialEstatus.IdMirEstatus);
            return JsonView(ModelState.IsValid, null, "CambiarStatus", poa_MirHistorialEstatus);
        
            
        }

    }
}