﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Poa.Arbol
{
    public class PoaAsignarUsuarioArbolController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: AsignarUsuario
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult AsignarTrabajador(int id)
        {
            return PartialView(db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id));
        }
        public PartialViewResult BuscarTrabajador(String keyword)
        {
            List<vwDatosAspirantesTrabajadores> auxmodel = new List<vwDatosAspirantesTrabajadores>();
            List<vwDatosAspirantesTrabajadores> tipobusqueda = new List<vwDatosAspirantesTrabajadores>();
            
            if (Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.UsuarioKardex.FirstOrDefault().EsSuperUsuario)
                tipobusqueda=db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.IdModalidadEstudio == 0).ToList();
            else
                tipobusqueda = db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.IdModalidadEstudio == 0 && t.RelacionLaboral == "MANDO MEDIO").ToList();

            var model = tipobusqueda;

            var searchWords = keyword.Split(' ').Where(t => !String.IsNullOrWhiteSpace(t));

            keyword = keyword ?? String.Empty;

            if (keyword == "")
                return PartialView(model.OrderBy(x=>x.CURP));
            else
            {
                foreach (var item in searchWords)
                {
                    var modelaux = model.Where(x => x.Nombre.Contains(item.ToUpper()) || x.ApellidoPaterno.Contains(item.ToUpper()) || x.ApellidoMaterno.Contains(item.ToUpper())).ToList();
                    if (modelaux.Count() != 0)
                        auxmodel.AddRange(modelaux.OrderBy(x=>x.CURP));
                }
            }

            return PartialView(auxmodel.Distinct());
        }
        public ActionResult ActualizaArbolTrabajador(int idcn, int idA)
        {

            Poa_ProyectoArbol model = db.Poa_ProyectoArbol.Find(idA);
            
            var DatosEstructuraOrganicaAsignar = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idcn);

            bool validar = false;
            string NombreUsuario = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idcn).Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
            NombreUsuario += " " + db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idcn).Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno;
            NombreUsuario += " " + db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idcn).Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
           

            AltaUsuarioRol altaRol = new AltaUsuarioRol();

            if (db.Poa_ProyectosAñoAreas.Where(x => x.IdEstructuraOrganica == DatosEstructuraOrganicaAsignar.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).Count() == 0)
                return JsonView(validar, "Error. El Administrador aún no asigna el Área  " + DatosEstructuraOrganicaAsignar.Catalogos_ctEstructuraOrganica.EstructuraOrganica + " al Proyecto.", null, null, null);
            
            
            validar=altaRol.AltaGrupoUsuarioRol(model.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, idcn, TiposGrupoRol.GResponsablePoa, db);

            
            
            
            if(!validar)
                return JsonView(validar, "Error en la asignación de Rol de Usuario. Valide que el usuario " + NombreUsuario + " tenga su cuenta activa en el sistema. ", null, null, null);

            if (ModelState.IsValid && validar)
            {

                try
                {
                    model.IdConvenioLaboralTrabajadorCategoria = idcn;
                    db.Entry(model).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();

                }
                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });

                }

            }
            //return JsonView(ModelState.IsValid, "Datos actualizados exitosamente. ", null, null, Url.Action("ArbolAdmin", "PoaProyectoArbol"));
            return JsonView(ModelState.IsValid, "Datos actualizados exitosamente. ", null, null, null);
        }
        public JsonResult BuscarArbolTrabajador(int id)
        {
            var model = db.Poa_ProyectoArbol.Where(p => p.IdProyectoArbol == id).Select(x => new
            {
                Proyecto = x.Poa_Proyectos.Proyecto,
                Nombre = x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                         x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                         x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno,
                FechaCreacion = x.FechaCreacion

            }).ToArray();

            var JsonArbolTrabajador = Json(model, JsonRequestBehavior.AllowGet);

            return JsonArbolTrabajador;
        }
    }
}