﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Data.Entity;
using Nova.Libraries;
using Dapper;

namespace Nova.Controllers
{
    public class PoaActividadesProyectosEstatalesController : BaseController
    {

        private bdNovaEntities db = new bdNovaEntities();
        // GET: PoaProyectosEstatales
        public ActionResult Index()
        {
            return View();
        }
        public ActionResult LoadData()
        {
            return View(db.Poa_ProyectosEstatales.ToList());
        }
        public ActionResult Create()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryUsuariosPoa = @"select d.IdConvenioLaboralTrabajadorCategoria
,Max((g.Nombre +' '+ g.ApellidoPaterno + ' ' + g.ApellidoMaterno)) NombreCompleto from Poa_ProyectoArbol a
inner join Poa_Mir b on b.IdProyectoArbol = a.IdProyectoArbol
inner join Poa_Indicadores c on c.IdMir = b.IdMir
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria or d.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria or d.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador e on e.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador f on f.IdTrabajador = e.IdTrabajador
inner join Kardex_ctDatosPersonales g on g.IdKardex = f.IdKardex
group by d.IdConvenioLaboralTrabajadorCategoria
order by d.IdConvenioLaboralTrabajadorCategoria";

            var listUsuarios = (List<UsuariosListModel>)dp.connection.Query<UsuariosListModel>(queryUsuariosPoa);

            dp.Close();

            ViewBag.IdConvenioLaboralTrabajadorCategoriaResponsable = new SelectList(listUsuarios, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProyectosEstatales,Actividad,Programa,ProyectoEstatal,SubPrograma,IdConvenioLaboralTrabajadorCategoriaResponsable")] Poa_ProyectosEstatales poa_ProyectosEstatales)
        {
            if (ModelState.IsValid)
            {

                try
                {

                    db.Poa_ProyectosEstatales.Add(poa_ProyectosEstatales);
                    db.SaveChanges();
                }
                catch (Exception e)
                {

                    return JsonView(false, ExceptionExtensions.GetOriginalException(e).Message, "Create", poa_ProyectosEstatales);
                    //return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message, });
                }

                return JsonView(ModelState.IsValid, "Se han agregado los datos exitosamente");
            }
            string messages = string.Join("; ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, "Create", poa_ProyectosEstatales);
        }

        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);

            Poa_SistemaAñoVigente añoVigente = db.Poa_SistemaAñoVigente.FirstOrDefault();

            if (poa_ProyectosEstatales == null)
            {
                return HttpNotFound();
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryUsuariosPoa = $@"select d.IdConvenioLaboralTrabajadorCategoria
,Max((g.Nombre +' '+ g.ApellidoPaterno + ' ' + g.ApellidoMaterno)) NombreCompleto from Poa_ProyectoArbol a
inner join Poa_Mir b on b.IdProyectoArbol = a.IdProyectoArbol
inner join Poa_Indicadores c on c.IdMir = b.IdMir
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria or d.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria or d.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador e on e.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador f on f.IdTrabajador = e.IdTrabajador
inner join Kardex_ctDatosPersonales g on g.IdKardex = f.IdKardex
where b.AñoMir={añoVigente.Año}
group by d.IdConvenioLaboralTrabajadorCategoria
order by 2";
            

            var listUsuarios = (List<UsuariosListModel>)dp.connection.Query<UsuariosListModel>(queryUsuariosPoa);

            dp.Close();

            ViewBag.IdConvenioLaboralTrabajadorCategoriaResponsable = new SelectList(listUsuarios, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", poa_ProyectosEstatales.IdConvenioLaboralTrabajadorCategoriaResponsable);


            return View(poa_ProyectosEstatales);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProyectosEstatales,Actividad,Programa,ProyectoEstatal,SubPrograma,IdConvenioLaboralTrabajadorCategoriaResponsable")] Poa_ProyectosEstatales poa_ProyectosEstatales)
        {
            if (ModelState.IsValid)
            {

                try
                {

                    db.Entry(poa_ProyectosEstatales).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return JsonView(ModelState.IsValid, "Se han actualizado los datos exitosamente");
            }
            string messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));
            return JsonView(ModelState.IsValid, messages, "Edit", poa_ProyectosEstatales);
        }
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            //Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Include(testc => testc.Convenios_stConvenioLaboralTrabajadorCategoria1).Where(t => t.IdProyectosEstatales == id).FirstOrDefault();
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);
            if (poa_ProyectosEstatales == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectosEstatales);
        }

        // POST: Poa_Productos/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]

        public ActionResult DeleteConfirmed(int id)
        {
            Poa_ProyectosEstatales poa_ProyectosEstatales = db.Poa_ProyectosEstatales.Find(id);
            if (ModelState.IsValid)
            {


                try
                {


                    db.Poa_ProyectosEstatales.Remove(poa_ProyectosEstatales);
                    db.SaveChanges();
                }
                catch (Exception e)
                {

                    return JsonView(false, ExceptionExtensions.GetOriginalException(e).Message, null, null);

                }
                return JsonView(ModelState.IsValid, "Registro eliminado exitosamente");
            }

            return JsonView(ModelState.IsValid, null, "Delete", poa_ProyectosEstatales);
        }



        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


    }
}