﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class Percepciones_stPlantillaNominaPercepcionesRetroCategoriaController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Percepciones_stPlantillaNominaPercepcionesRetroCategoria
        public ActionResult Index()
        {
            var percepciones_stPlantillaNominaPercepcionesRetroCategoria = db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Include(p => p.Percepciones_stPlantillaNominaPercepciones).Include(p => p.Plazas_ctCategoria);
            return View(percepciones_stPlantillaNominaPercepcionesRetroCategoria.ToList());
        }

        // GET: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Percepciones_stPlantillaNominaPercepcionesRetroCategoria percepciones_stPlantillaNominaPercepcionesRetroCategoria = db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Find(id);
            if (percepciones_stPlantillaNominaPercepcionesRetroCategoria == null)
            {
                return HttpNotFound();
            }
            return View(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
        }

        // GET: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Create
        public ActionResult Create()
        {
            //ViewBag.IdKardex = new SelectList((from s in db.Kardex_ctDatosPersonales.ToList() select new { IdKardex = s.IdKardex, Nombre= s.Nombre + " " + s.ApellidoPaterno+ " " + s.ApellidoMaterno}), "IdKardex", "Nombre");

            ViewBag.IdPlantillaNominaPercepcion = new SelectList((from s in db.Percepciones_stPlantillaNominaPercepciones.ToList() select new {IdPlantillaNominaPercepcion=s.IdPlantillaNominaPercepcion, Nombre=s.Nomina_ctPlantillaNomina.Plantilla+"|"+s.Percepciones_ctPercepcion.Percepcion }), "IdPlantillaNominaPercepcion", "Nombre");
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria");
            return View();
        }

        // POST: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPlantillaNominaPercepcionRetroCategoria,IdPlantillaNominaPercepcion,IdCategoria,ImporteRetroActivo,PorcentajeRetroActivo")] Percepciones_stPlantillaNominaPercepcionesRetroCategoria percepciones_stPlantillaNominaPercepcionesRetroCategoria)
        {
            if (ModelState.IsValid)
            {
                db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Add(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdPlantillaNominaPercepcion = new SelectList(db.Percepciones_stPlantillaNominaPercepciones, "IdPlantillaNominaPercepcion", "IdPlantillaNominaPercepcion", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdPlantillaNominaPercepcion);
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdCategoria);
            return View(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
        }

        // GET: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Percepciones_stPlantillaNominaPercepcionesRetroCategoria percepciones_stPlantillaNominaPercepcionesRetroCategoria = db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Find(id);
            if (percepciones_stPlantillaNominaPercepcionesRetroCategoria == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdPlantillaNominaPercepcion = new SelectList((from s in db.Percepciones_stPlantillaNominaPercepciones.ToList() select new { IdPlantillaNominaPercepcion = s.IdPlantillaNominaPercepcion, Nombre = s.Nomina_ctPlantillaNomina.Plantilla +"|"+s.Percepciones_ctPercepcion.Percepcion }), "IdPlantillaNominaPercepcion", "Nombre", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdPlantillaNominaPercepcion);

            //ViewBag.IdPlantillaNominaPercepcion = new SelectList(db.Percepciones_stPlantillaNominaPercepciones, "IdPlantillaNominaPercepcion", "IdPlantillaNominaPercepcion", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdPlantillaNominaPercepcion);
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdCategoria);
            return View(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
        }

        // POST: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPlantillaNominaPercepcionRetroCategoria,IdPlantillaNominaPercepcion,IdCategoria,ImporteRetroActivo,PorcentajeRetroActivo")] Percepciones_stPlantillaNominaPercepcionesRetroCategoria percepciones_stPlantillaNominaPercepcionesRetroCategoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(percepciones_stPlantillaNominaPercepcionesRetroCategoria).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdPlantillaNominaPercepcion = new SelectList((from s in db.Percepciones_stPlantillaNominaPercepciones.ToList() select new { IdPlantillaNominaPercepcion = s.IdPlantillaNominaPercepcion, Nombre = s.Percepciones_ctPercepcion.Percepcion }), "IdPlantillaNominaPercepcion", "Nombre");

            //ViewBag.IdPlantillaNominaPercepcion = new SelectList(db.Percepciones_stPlantillaNominaPercepciones, "IdPlantillaNominaPercepcion", "IdPlantillaNominaPercepcion", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdPlantillaNominaPercepcion);
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria", percepciones_stPlantillaNominaPercepcionesRetroCategoria.IdCategoria);
            return View(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
        }

        // GET: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Percepciones_stPlantillaNominaPercepcionesRetroCategoria percepciones_stPlantillaNominaPercepcionesRetroCategoria = db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Find(id);
            if (percepciones_stPlantillaNominaPercepcionesRetroCategoria == null)
            {
                return HttpNotFound();
            }
            return View(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
        }

        // POST: Percepciones_stPlantillaNominaPercepcionesRetroCategoria/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(short id)
        {
            Percepciones_stPlantillaNominaPercepcionesRetroCategoria percepciones_stPlantillaNominaPercepcionesRetroCategoria = db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Find(id);
            db.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.Remove(percepciones_stPlantillaNominaPercepcionesRetroCategoria);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
