﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.PlantillaNominaDeduccion
{
    public class PlantillaNominaDeduccionController : Controller
    {
        // GET: PlantillaNominaDeduccion
        public ActionResult Index()
        {
            return View();
        }
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvPlantillaNominaDeducciones()
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            return PartialView("_pvPlantillaNominaDeducciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaDeduccionesAddNew(Nova.Models.Deducciones_stPlantillaNominaDeducciones item)
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPlantillaNominaDeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaDeduccionesUpdate(Nova.Models.Deducciones_stPlantillaNominaDeducciones item)
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNominaDeduccion == item.IdPlantillaNominaDeduccion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPlantillaNominaDeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaDeduccionesDelete(System.Int16 IdPlantillaNominaDeduccion)
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            if (IdPlantillaNominaDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNominaDeduccion == IdPlantillaNominaDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvPlantillaNominaDeducciones", model.ToList());
        }
    }
}