﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.PercepcionesFijas
{
    public class PercepcionesConcedidasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Guarderia(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            Session["UserSeleccionado_P_C"] = IdConvenioLaboralTrabajadorCategoria;

            //traer el IdTrabajador
            var OneTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(IdConvenioLaboralTrabajadorCategoria);
            int trabajadorId = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            int percepcionId = db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GUARDERIA").FirstOrDefault().IdPercepcion;

            var percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Where(t => t.IdTrabajador == trabajadorId && t.IdPercepcion == percepcionId).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Kardex_ctTrabajador).Include(p => p.Percepciones_ctPercepcion);

            ViewBag.TipoPercepcion = "GUARDERIA";
            return View("Index",percepciones_stPercepcionesConcedidas.ToList());
        }
        public ActionResult GastosAdministrativos(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            Session["UserSeleccionado_P_C"] = IdConvenioLaboralTrabajadorCategoria;

            //traer el IdTrabajador
            var OneTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(IdConvenioLaboralTrabajadorCategoria);
            int trabajadorId = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var vpercepcionId = db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GASTO ADMISTRATIVO").FirstOrDefault();
            int percepcionId = vpercepcionId.IdPercepcion;

            var percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Where(t => t.IdTrabajador == trabajadorId && t.IdPercepcion == percepcionId).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Kardex_ctTrabajador).Include(p => p.Percepciones_ctPercepcion);
            ViewBag.TipoPercepcion = "GASTOS ADMINISTRATIVOS";
            return View("Index",percepciones_stPercepcionesConcedidas.ToList());
        }
        // GET: PercepcionesConcedidas

        

        //public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria = 0)
        //{
        //    Session["UserSeleccionado_P_C"] = IdConvenioLaboralTrabajadorCategoria;

        //    //traer el IdTrabajador
        //    int trabajadorId = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).Select(s => s.Convenios_stConvenioLaboralTrabajador.IdConvenioLaboralTrabajador).FirstOrDefault();


        //    var percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Where(t=>t.IdTrabajador == trabajadorId).Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Kardex_ctTrabajador).Include(p => p.Percepciones_ctPercepcion);
        //    return View(percepciones_stPercepcionesConcedidas.ToList());
        //}

        // GET: PercepcionesConcedidas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Find(id);
            if (percepciones_stPercepcionesConcedidas == null)
            {
                return HttpNotFound();
            }
            return View(percepciones_stPercepcionesConcedidas);
        }

        // GET: PercepcionesConcedidas/Create
        public ActionResult NewDerechoGuarderia()
        {
            int idConvenioLaboralTrabajadorCategoria = (int)Session["UserSeleccionado_P_C"];
            if (idConvenioLaboralTrabajadorCategoria == 0)
            {
                throw new InvalidOperationException("No puede acceder a esta URL de manera directa.");
            }

            string convenio = db.vwDatosAspirantesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == idConvenioLaboralTrabajadorCategoria).FirstOrDefault().ConvenioLaboral;
            if (convenio != "BASE")
            {
                throw new Exception("ESTA OPCIÓN SOLO APLICA PARA TRABAJADORES DE BASE");
            }

            var OneTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idConvenioLaboralTrabajadorCategoria);
            int trabajadorId = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            int percepcionId = db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GUARDERIA").FirstOrDefault().IdPercepcion;

            var percepcionConcedida = db.Percepciones_stPercepcionesConcedidas.Where(t => t.IdTrabajador == trabajadorId && t.IdPercepcion == percepcionId && t.FechaTermino == null).ToList();
            if (percepcionConcedida != null)
            {
                if (percepcionConcedida.Count() > 0)
                {
                    Session["UserSeleccionado_P_C"] = 0;
                    throw new InvalidOperationException("Ya existe la percepción asignada al usuario.");
                }

            }


            
            
            string sexo = OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Sexo;
            if (sexo.Contains("H"))
            {
                Session["UserSeleccionado_P_C"] = 0;
                throw new InvalidOperationException("Unicamente se le puede brindar esta percepción a trabajadores de Sexo: Mujer.");
            }

            var list = new List<SelectListItem> {
                new SelectListItem {
                    Value = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString(),
                    Text = OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
                },
            };
                

            var ListTrabajador = list.Select(t =>new {
                IdTrabajador = t.Value,
                NombreCompleto = t.Text
            } );

            ViewBag.IdTrabajador = new SelectList(ListTrabajador, "IdTrabajador", "NombreCompleto");
            ViewBag.IdPercepcion = new SelectList(db.Percepciones_ctPercepcion.Where(t=>t.Percepcion == "GUARDERIA"), "IdPercepcion", "Percepcion");
            ViewBag.TipoPercepcion = "GUARDERIA";
            
            return View("Create");
        }

        public ActionResult NewDerechoGastosAministrativos()
        {
            int idConvenioLaboralTrabajadorCategoria = (int)Session["UserSeleccionado_P_C"];
            if (idConvenioLaboralTrabajadorCategoria == 0)
            {
                throw new InvalidOperationException("No puede acceder a esta URL de manera directa.");
            }
            string convenio = db.vwDatosAspirantesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == idConvenioLaboralTrabajadorCategoria).FirstOrDefault().ConvenioLaboral;
            if (convenio != "BASE")
            {
                throw new Exception("ESTA OPCIÓN SOLO APLICA PARA TRABAJADORES DE BASE");
            }

            var OneTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idConvenioLaboralTrabajadorCategoria);

            int trabajadorId = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            int percepcionId = db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GASTO ADMISTRATIVO").FirstOrDefault().IdPercepcion;

            var percepcionConcedida = db.Percepciones_stPercepcionesConcedidas.Where(t => t.IdTrabajador == trabajadorId && t.IdPercepcion == percepcionId && t.FechaTermino == null).ToList();
            if (percepcionConcedida != null)
            {
                if (percepcionConcedida.Count() > 0)
                {
                    Session["UserSeleccionado_P_C"] = 0;
                    throw new InvalidOperationException("Ya existe la percepción asignada al usuario.");
                }
                
            }

            
            var list = new List<SelectListItem> {
                new SelectListItem {
                    Value = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString(),
                    Text = OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
                },
            };


            var ListTrabajador = list.Select(t => new {
                IdTrabajador = t.Value,
                NombreCompleto = t.Text
            });

            ViewBag.IdTrabajador = new SelectList(ListTrabajador, "IdTrabajador", "NombreCompleto");
            ViewBag.IdPercepcion = new SelectList(db.Percepciones_ctPercepcion.Where(t=>t.Percepcion == "GASTO ADMISTRATIVO"), "IdPercepcion", "Percepcion");
            
            ViewBag.TipoPercepcion = "GASTOS ADMINISTRATIVOS";
            return View("Create");
        }

        // POST: PercepcionesConcedidas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult NewDerechoGuarderia([Bind(Include = "IdPercepcionesConcedidas,IdTrabajador,IdPercepcion,FechaInicio,FechaTermino,IdConvenioLaboralTrabajadorCategoriaMovimiento,FechaMovimiento")] Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas)
        {
            int idConvenioLaboralTrabajadorCategoria = (int)Session["UserSeleccionado_P_C"];

            percepciones_stPercepcionesConcedidas.IdConvenioLaboralTrabajadorCategoriaMovimiento = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            percepciones_stPercepcionesConcedidas.FechaMovimiento = DateTime.Today;

            if (ModelState.IsValid)
            {
                db.Percepciones_stPercepcionesConcedidas.Add(percepciones_stPercepcionesConcedidas);
                db.SaveChanges();
                return RedirectToAction("Guarderia", new { IdConvenioLaboralTrabajadorCategoria = idConvenioLaboralTrabajadorCategoria });
            }



            var OneTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idConvenioLaboralTrabajadorCategoria);

            
            var list = new List<SelectListItem> {
                new SelectListItem {
                    Value = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString(),
                    Text = OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
                },
            };


            var ListTrabajador = list.Select(t => new {
                IdTrabajador = t.Value,
                NombreCompleto = t.Text
            });

            ViewBag.IdTrabajador = new SelectList(ListTrabajador, "IdTrabajador", "NombreCompleto");
            ViewBag.IdPercepcion = new SelectList(db.Percepciones_ctPercepcion.Where(t=>t.Percepcion == "GUARDERIA"), "IdPercepcion", "Percepcion", percepciones_stPercepcionesConcedidas.IdPercepcion);
            ViewBag.TipoPercepcion = "GUARDERIA";
            
            return View("Create",percepciones_stPercepcionesConcedidas);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult NewDerechoGastosAministrativos([Bind(Include = "IdPercepcionesConcedidas,IdTrabajador,IdPercepcion,FechaInicio,FechaTermino,IdConvenioLaboralTrabajadorCategoriaMovimiento,FechaMovimiento")] Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas)
        {
            int idConvenioLaboralTrabajadorCategoria = (int)Session["UserSeleccionado_P_C"];

            percepciones_stPercepcionesConcedidas.IdConvenioLaboralTrabajadorCategoriaMovimiento = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            percepciones_stPercepcionesConcedidas.FechaMovimiento = DateTime.Today;

            if (ModelState.IsValid)
            {
                db.Percepciones_stPercepcionesConcedidas.Add(percepciones_stPercepcionesConcedidas);
                db.SaveChanges();
                return RedirectToAction("GastosAdministrativos", new { IdConvenioLaboralTrabajadorCategoria = idConvenioLaboralTrabajadorCategoria });
            }



            var OneTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idConvenioLaboralTrabajadorCategoria);


            var list = new List<SelectListItem> {
                new SelectListItem {
                    Value = OneTrabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString(),
                    Text = OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + OneTrabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
                },
            };


            var ListTrabajador = list.Select(t => new {
                IdTrabajador = t.Value,
                NombreCompleto = t.Text
            });

            ViewBag.IdTrabajador = new SelectList(ListTrabajador, "IdTrabajador", "NombreCompleto");
            ViewBag.IdPercepcion = new SelectList(db.Percepciones_ctPercepcion.Where(t=>t.Percepcion == "GASTO ADMISTRATIVO"), "IdPercepcion", "Percepcion", percepciones_stPercepcionesConcedidas.IdPercepcion);
            
            ViewBag.TipoPercepcion = "GASTOS ADMINISTRATIVOS";
            return View("Create",percepciones_stPercepcionesConcedidas);
        }

        // GET: PercepcionesConcedidas/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Find(id);
            if (percepciones_stPercepcionesConcedidas == null)
            {
                return HttpNotFound();
            }

            var trabajador = db.Kardex_ctTrabajador.Where(t => t.IdTrabajador == percepciones_stPercepcionesConcedidas.IdTrabajador).ToList();
            var ListTrabajador = trabajador.Select(t => new {
                IdTrabajador = t.IdTrabajador,
                NombreCompleto = t.Kardex_ctDatosPersonales.Nombre + " " + t.Kardex_ctDatosPersonales.ApellidoPaterno + " " + t.Kardex_ctDatosPersonales.ApellidoMaterno
            });
            ViewBag.IdTrabajador = new SelectList(ListTrabajador, "IdTrabajador", "NombreCompleto");


            ViewBag.IdPercepcion = new SelectList(db.Percepciones_ctPercepcion.Where(t=>t.IdPercepcion == percepciones_stPercepcionesConcedidas.IdPercepcion), "IdPercepcion", "Percepcion", percepciones_stPercepcionesConcedidas.IdPercepcion);
            return View(percepciones_stPercepcionesConcedidas);
        }

        // POST: PercepcionesConcedidas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPercepcionesConcedidas,IdTrabajador,IdPercepcion,FechaInicio,FechaTermino,IdConvenioLaboralTrabajadorCategoriaMovimiento,FechaMovimiento")] Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas)
        {
            int idConvenioLaboralTrabajadorCategoria = (int)Session["UserSeleccionado_P_C"];

            percepciones_stPercepcionesConcedidas.IdConvenioLaboralTrabajadorCategoriaMovimiento = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            percepciones_stPercepcionesConcedidas.FechaMovimiento = DateTime.Today;

            if (ModelState.IsValid)
            {
                db.Entry(percepciones_stPercepcionesConcedidas).State = EntityState.Modified;
                db.SaveChanges();

                var actionIndex = "";
                if (percepciones_stPercepcionesConcedidas.IdPercepcion == db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GUARDERIA").FirstOrDefault().IdPercepcion )
                {
                    actionIndex = "Guarderia";
                }else if (percepciones_stPercepcionesConcedidas.IdPercepcion == db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GASTO ADMISTRATIVO").FirstOrDefault().IdPercepcion)                 {
                    actionIndex = "GastosAdministrativos";
                }

                return RedirectToAction(actionIndex, new { IdConvenioLaboralTrabajadorCategoria  = idConvenioLaboralTrabajadorCategoria });
            }



            var trabajador = db.Kardex_ctTrabajador.Where(t => t.IdTrabajador == percepciones_stPercepcionesConcedidas.IdTrabajador).ToList();
            var ListTrabajador = trabajador.Select(t => new {
                IdTrabajador = t.IdTrabajador,
                NombreCompleto = t.Kardex_ctDatosPersonales.Nombre + " " + t.Kardex_ctDatosPersonales.ApellidoPaterno + " " + t.Kardex_ctDatosPersonales.ApellidoMaterno
            });

            ViewBag.IdTrabajador = new SelectList(ListTrabajador, "IdTrabajador", "NombreCompleto");
            ViewBag.IdPercepcion = new SelectList(db.Percepciones_ctPercepcion.Where(t=>t.IdPercepcion == percepciones_stPercepcionesConcedidas.IdPercepcion), "IdPercepcion", "Percepcion", percepciones_stPercepcionesConcedidas.IdPercepcion);
            return View(percepciones_stPercepcionesConcedidas);
        }

        // GET: PercepcionesConcedidas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Find(id);
            if (percepciones_stPercepcionesConcedidas == null)
            {
                return HttpNotFound();
            }
            return View(percepciones_stPercepcionesConcedidas);
        }

        // POST: PercepcionesConcedidas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Find(id);
            db.Percepciones_stPercepcionesConcedidas.Remove(percepciones_stPercepcionesConcedidas);
            db.SaveChanges();

            int idConvenioLaboralTrabajadorCategoria = (int)Session["UserSeleccionado_P_C"];
            var actionIndex = "";
            if (percepciones_stPercepcionesConcedidas.IdPercepcion == db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GUARDERIA").FirstOrDefault().IdPercepcion)
            {
                actionIndex = "Guarderia";
            }
            else if (percepciones_stPercepcionesConcedidas.IdPercepcion == db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GASTO ADMISTRATIVO").FirstOrDefault().IdPercepcion)
            {
                actionIndex = "GastosAdministrativos";
            }

            return RedirectToAction(actionIndex,new { IdConvenioLaboralTrabajadorCategoria = idConvenioLaboralTrabajadorCategoria });
        }

        //[HttpPost]
        //public ActionResult DeleteConfirmed(int id)
        //{
        //    var result = new { value_e = false, message_e = "" };
        //    try
        //    {
        //        Percepciones_stPercepcionesConcedidas percepciones_stPercepcionesConcedidas = db.Percepciones_stPercepcionesConcedidas.Find(id);
        //        db.Percepciones_stPercepcionesConcedidas.Remove(percepciones_stPercepcionesConcedidas);
        //        db.SaveChanges();
        //    }
        //    catch (Exception e)
        //    {
        //        result = new { value_e = false, message_e = e.Message };
        //        return Json(result, JsonRequestBehavior.AllowGet);
        //    }

        //    result = new { value_e = true, message_e = "Se ha eliminado el registro con éxito." };
        //    return Json(result, JsonRequestBehavior.AllowGet);
        //}

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        //public ActionResult ListaTrabajadores(string search)
        //{
        //    //var datosPersonales = db.Kardex_ctDatosPersonales.Where(t => SqlMethods.Like(t.Nombre, "%" + search + "%") ).ToList();
        //    var datosPersonales = db.Kardex_ctTrabajador.Where(t => t.Kardex_ctDatosPersonales.Nombre.Contains(search)).ToList();
        //    return PartialView("_ListaTrabajadores", datosPersonales);
        //}

        [HttpPost]
        public ActionResult ListaTrabajadores(int tipo)
        {
            int PercepcionId = 0;
            if (tipo == 1)
                PercepcionId = db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GUARDERIA").FirstOrDefault().IdPercepcion;
            else if(tipo == 2)
                PercepcionId = db.Percepciones_ctPercepcion.Where(t => t.Percepcion == "GASTO ADMISTRATIVO").FirstOrDefault().IdPercepcion;

            var result = db.Percepciones_stPercepcionesConcedidas.Where(t => t.IdPercepcion == PercepcionId).ToList();
            return PartialView("_ListaTrabajadores",result);
        }


    }
}
