﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class PercepcionPersonalizadaController : Controller
    {
        //
        // GET: /PercepcionPersonalizada/

        public ActionResult Index(int idtrabajador)
        {
            Session["idtrabajador"] = idtrabajador;
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        public ActionResult pvDatosTrabajador()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);

            var LConvenios = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                        join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                        join c in db.Plazas_stDistribucionPlazaCategoria on a.IdDistribucionPlazaCategoria equals c.IdDistribucionPlazaCategoria
                        join j in db.Catalogos_ctEstructuraOrganica on c.IdEstructuraOrganica equals j.IdEstructuraOrganica
                        join d in db.Plazas_ctCategoria on c.IdCategoria equals d.IdCategoria
                        join e in db.Convenios_stRelacionConvenioLaboral on d.IdRelacionConvenioLaboral equals e.IdRelacionConvenioLaboral
                        join f in db.Catalogos_ctConvenioLaboral on e.IdConvenioLaboral equals f.IdConvenioLaboral
                        join g in db.Catalogos_ctRelacionLaboral on e.IdRelacionLaboral equals g.IdRelacionLaboral
                        join h in db.Kardex_ctTrabajador on b.IdTrabajador equals h.IdTrabajador
                        join i in db.Kardex_ctDatosPersonales on h.IdKardex equals i.IdKardex
                        where b.IdTrabajador == idtrabajador && a.EsCancelado == false
                        orderby a.FechaInicio descending
                        select  new
                        {
                            IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria,
                            Nombre = i.Nombre,
                            ApellidoPaterno = i.ApellidoPaterno,
                            ApellidoMaterno = i.ApellidoMaterno,
                            IdTrabajador = b.IdTrabajador,
                            ConvenioLaboral = f.ConvenioLaboral,
                            RelacionLaboral = g.RelacionLaboral,
                            Categoria = d.Categoria,
                            EstructuraOrganica = j.EstructuraOrganica,
                            FechaInicio = a.FechaInicio,
                            FechaTermino = a.FechaTermino,
                            IdConvenioLaboral = f.IdConvenioLaboral,
                            IdDistribucionPlazaCategoria = a.IdDistribucionPlazaCategoria,
                            IdRelacionConvenioLaboral = d.IdRelacionConvenioLaboral
                        };
            Session["UltimoIdConvenioLaboralTrabajadorCategoria"] = LConvenios.FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            var model = from a in LConvenios
                    select LConvenios.FirstOrDefault();
            return PartialView("_pvDatosTrabajador", model.ToList());
        }

        [ValidateInput(false)]
        public ActionResult pvPercepcionPersonalizada()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);

            //var model = from a in db.Percepciones_stPercepcionesPersonalizadas
            //            join b in db.Convenios_stConvenioLaboralTrabajadorCategoria on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
            //            join c in db.Convenios_stConvenioLaboralTrabajador on b.IdConvenioLaboralTrabajador equals c.IdConvenioLaboralTrabajador
            //            join d in db.Kardex_ctTrabajador on c.IdTrabajador equals d.IdTrabajador
            //            where c.IdTrabajador == idtrabajador
            //            select  new 
            //            {
            //                a.IdPercepcionesPersonalizadas,
            //                a.IdConvenioLaboralTrabajadorCategoria,
            //                a.IdPercepcion,
            //                a.IdPeriodoNomina,
            //                a.FechaInicioPercepcion,
            //                a.EsVigente,
            //                a.Importe
            //            };
            var model = db.Percepciones_stPercepcionesPersonalizadas.Where(s =>  s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador ==idtrabajador);
            return PartialView("_pvPercepcionPersonalizada", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionPersonalizadaAddNew(Nova.Models.Percepciones_stPercepcionesPersonalizadas item)
        {
            
            int UltimoIdCLTC = Convert.ToInt32(Session["UltimoIdConvenioLaboralTrabajadorCategoria"]);

            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            bdNovaEntities bd = new bdNovaEntities();

            int idtrabajadorcategoria =(int) bd.vwDatosAspirantesTrabajadores.Where(w => w.IdTrabajador == idtrabajador).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;

            item.IdConvenioLaboralTrabajadorCategoria = idtrabajadorcategoria;
            var modelt = db.Percepciones_stPercepcionesPersonalizadas.Where(w => w.IdConvenioLaboralTrabajadorCategoria == idtrabajadorcategoria);
            var model = db.Percepciones_stPercepcionesPersonalizadas;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPercepcionPersonalizada", modelt.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionPersonalizadaUpdate(Nova.Models.Percepciones_stPercepcionesPersonalizadas item)
        {
            
            var model = db.Percepciones_stPercepcionesPersonalizadas.Where(w => w.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPercepcionesPersonalizadas == item.IdPercepcionesPersonalizadas);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPercepcionPersonalizada", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionPersonalizadaDelete(System.Int32 IdPercepcionesPersonalizadas)
        {

            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            bdNovaEntities bd = new bdNovaEntities();

            int idtrabajadorcategoria = (int)bd.vwDatosAspirantesTrabajadores.Where(w => w.IdTrabajador == idtrabajador).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;


            var modelt = db.Percepciones_stPercepcionesPersonalizadas.Where(w => w.IdConvenioLaboralTrabajadorCategoria == idtrabajadorcategoria);
            var model = db.Percepciones_stPercepcionesPersonalizadas;
            if (IdPercepcionesPersonalizadas != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPercepcionesPersonalizadas == IdPercepcionesPersonalizadas);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvPercepcionPersonalizada", modelt.ToList());
        }
    }
}
