﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Libraries;
using DevExpress.Web.Mvc;
using Nova.Models;
using System.Data.Entity;

namespace Nova.Controllers.Pensiones
{
    public class PensionesTrabajadorController : Controller
    {
        // GET: PensionesTrabajador

        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index(int IdTrabajador = 0)
        {
            
            if (IdTrabajador > 0)
            {
                var model = db.Pensiones_stPensionesTrabajador.Where(x => x.IdTrabajador==IdTrabajador).ToList();
                if(db.Pensiones_ctTipoPension.Count()>0 && db.Catalogos_ctInstitucionFinanciera.Count()>0)
                {         
                       
                    Session["IdTrabajador"] = IdTrabajador;
                    return View(model);
                }
                else
                    throw new ApplicationException("Catálogos vacíos [Tipos de pensión | Institución financiera]");
            }
            else
                throw new ApplicationException("No hay un convenio laboral vigente para este trabajador");
        }


        public ActionResult pvDatosTrabajador()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);

            var LConvenios = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                             join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                             join c in db.Plazas_stDistribucionPlazaCategoria on a.IdDistribucionPlazaCategoria equals c.IdDistribucionPlazaCategoria
                             join j in db.Catalogos_ctEstructuraOrganica on c.IdEstructuraOrganica equals j.IdEstructuraOrganica
                             join d in db.Plazas_ctCategoria on c.IdCategoria equals d.IdCategoria
                             join e in db.Convenios_stRelacionConvenioLaboral on d.IdRelacionConvenioLaboral equals e.IdRelacionConvenioLaboral
                             join f in db.Catalogos_ctConvenioLaboral on e.IdConvenioLaboral equals f.IdConvenioLaboral
                             join g in db.Catalogos_ctRelacionLaboral on e.IdRelacionLaboral equals g.IdRelacionLaboral
                             join h in db.Kardex_ctTrabajador on b.IdTrabajador equals h.IdTrabajador
                             join i in db.Kardex_ctDatosPersonales on h.IdKardex equals i.IdKardex
                             where b.IdTrabajador == idtrabajador && a.EsCancelado == false
                             orderby a.FechaInicio descending
                             select new
                             {
                                 IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria,
                                 Nombre = i.Nombre,
                                 ApellidoPaterno = i.ApellidoPaterno,
                                 ApellidoMaterno = i.ApellidoMaterno,
                                 IdTrabajador = b.IdTrabajador,
                                 ConvenioLaboral = f.ConvenioLaboral,
                                 RelacionLaboral = g.RelacionLaboral,
                                 Categoria = d.Categoria,
                                 EstructuraOrganica = j.EstructuraOrganica,
                                 FechaInicio = a.FechaInicio,
                                 FechaTermino = a.FechaTermino,
                                 IdConvenioLaboral = f.IdConvenioLaboral,
                                 IdDistribucionPlazaCategoria = a.IdDistribucionPlazaCategoria,
                                 IdRelacionConvenioLaboral = d.IdRelacionConvenioLaboral
                             };
            Session["UltimoIdConvenioLaboralTrabajadorCategoria"] = LConvenios.FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            var model = from a in LConvenios
                        select LConvenios.FirstOrDefault();
            return PartialView("_pvDatosTrabajador", model.ToList());
        }

        [ValidateInput(false)]
        public ActionResult pvPensionesTrabajador()
        {
            int IdTrabajador = (int)Session["IdTrabajador"];
            var model = db.Pensiones_stPensionesTrabajador.Where(i=>i.IdTrabajador==IdTrabajador);
            
            return PartialView("_pvPensionesTrabajador", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPensionesTrabajadorAddNew(Nova.Models.Pensiones_stPensionesTrabajador item)
        {
          //  var model = db.Pensiones_stPensionesTrabajador.Where(x => x.IdTrabajador == item.IdTrabajador).ToList();
            if (item.ValidaModelo().IsValid)
            {
                if (ModelState.IsValid)
                {
                    try
                    {
                        //item.IdTrabajador = (int)Session["IdTrabajador"];
                        
                        db.Pensiones_stPensionesTrabajador.Add(item);
                        db.SaveChanges();

                        
                        
                    }
                    catch (Exception e)
                    {
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                    ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            }
            else
                ViewData["EditError"] = item.ValidaModelo().Mensaje;

            var model = db.Pensiones_stPensionesTrabajador.Where(v => v.IdTrabajador == item.IdTrabajador).ToList();
            return PartialView("_pvPensionesTrabajador", model.ToList());
        }


        [HttpPost, ValidateInput(false)]
        public ActionResult pvPensionesTrabajadorUpdate(Nova.Models.Pensiones_stPensionesTrabajador item)
        {
          
            if (ModelState.IsValid)
            {
                try
                {
                    //var modelItem = model.FirstOrDefault(it => it.IdCreditoTrabajador == item.IdCreditoTrabajador);
                   // if (modelItem != null)
                    //{
                       
                    db.Pensiones_stPensionesTrabajador.Attach(item);
                    db.Entry(item).State = EntityState.Modified;
                    db.SaveChanges();
                    //}
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

           
            var model = db.Pensiones_stPensionesTrabajador.Where(v=> v.IdTrabajador==item.IdTrabajador).ToList();
            return PartialView("_pvPensionesTrabajador", model);
        }

        [HttpPost, ValidateInput(false)]

        public ActionResult pvPensionesTrabajadorDelete(System.Int32 IdPensionTrabajador)
        {
            Pensiones_stPensionesTrabajador ele = db.Pensiones_stPensionesTrabajador.Where(x => x.IdPensionTrabajador== IdPensionTrabajador).FirstOrDefault();
          
            if (IdPensionTrabajador != 0)
                if (ModelState.IsValid)
                {
                    try
                    {
                        //var item = db.FirstOrDefault(it => it.IdPensionTrabajador == IdPensionTrabajador);
                        // if (item != null)
                        db.Pensiones_stPensionesTrabajador.Attach(ele);
                        db.Pensiones_stPensionesTrabajador.Remove(ele);
                        
                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                    ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            var model = db.Pensiones_stPensionesTrabajador.Where(x => x.IdTrabajador == ele.IdTrabajador).ToList();
            return PartialView("_pvPensionesTrabajador", model.ToList());
        }


    }
}