﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Data.Entity;
namespace Nova.Controllers.Mst.Ticket
{
    public class MstTipoTicketController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: MstTipoTicket
        public ActionResult Index()
        {
            return View(db.Mst_TipoTicket.OrderBy(t => t.TipoTicket).ToList());
        }
        public ActionResult Create()
        {
            return View();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdTipoTicket,TipoTicket")] Mst_TipoTicket mst_TipoTicket)
        {
            if (ModelState.IsValid)
            {
                db.Mst_TipoTicket.Add(mst_TipoTicket);
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mst_TipoTicket);
        }

        [HttpPost]
        public ActionResult Delete(int id)

        {
            var result = new { value = "", msg = "" };
            Mst_TipoTicket mst_TipoTicket = db.Mst_TipoTicket.Find(id);
            db.Mst_TipoTicket.Remove(mst_TipoTicket);
            try
            {
                result = new { value = "esuccess", msg = "Servicio eliminado correctamente" };
                db.SaveChanges();

            }
            catch (Exception e)
            {
                var msg = ExceptionExtensions.GetOriginalException(e).Message;
                if (msg.Contains("DELETE en conflicto"))
                    msg = "No se puede eliminar un servicio que ya está asignado o en uso.";
                result = new { value = "efailed", msg };
            }
            return Json(result, JsonRequestBehavior.AllowGet);
        }
        public ActionResult Edit(int id)
        {
            var tipoTicket = db.Mst_TipoTicket.Find(id);
            return View(tipoTicket);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdTipoTicket,TipoTicket")] Mst_TipoTicket mst_TipoTicket)
        {
            db.Entry(mst_TipoTicket).State = EntityState.Modified;
            try
            {
                db.SaveChanges();
            }
            catch (Exception ex)
            {
                throw new Exception( ExceptionExtensions.GetOriginalException(ex).Message);
            }
           
            
            return RedirectToAction("Index");
        }

    }
}
 