﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;


namespace Nova.Controllers.Mst
{
    public class MstComentariosTicketController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstComentariosTicket
        //public ActionResult Index()
        //{
        //    var mst_ComentariosTicket = db.Mst_ComentariosTicket.Include(m => m.Mst_Ticket).Include(m => m.Mst_EstatusTicket).Include(m => m.Mst_PrioridadTicket).Include(m => m.Mst_ProcesoAtencionTicket);
        //    return View(mst_ComentariosTicket.ToList());
        //}

        // GET: MstComentariosTicket/Details/5
        //public ActionResult Details(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_ComentariosTicket mst_ComentariosTicket = db.Mst_ComentariosTicket.Find(id);
        //    if (mst_ComentariosTicket == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(mst_ComentariosTicket);
        //}

        // GET: MstComentariosTicket/Create
        //public ActionResult Create()
        //{
        //    ViewBag.IdTicket = new SelectList(db.Mst_Ticket, "IdTicket", "Incidente");
        //    ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket");
        //    ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket");
        //    ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket");
        //    return View();
        //}

        // POST: MstComentariosTicket/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdComentarioMv,Comentario,FechaComentarioMv,Publico,IdUsuarioComentarioMv,IdTicket,IdProcesoAtencionTicket,IdPrioridadTicket,IdEstatusTicket,IdUsuarioAsignado")] Mst_ComentariosTicket mst_ComentariosTicket)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            if (mst_ComentariosTicket.Comentario == null || mst_ComentariosTicket.Comentario == "")
            {
                ModelState.AddModelError("Comentario", "El campo Comentario es Requerido.");
            }

            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(mst_ComentariosTicket.IdTicket);

            if (mst_Ticket == null)
            {
                ModelState.AddModelError(string.Empty, "No fue posible referenciar el Ticket seleccionado");
            }

            mst_ComentariosTicket.FechaComentarioMv = DateTime.Now;
            mst_ComentariosTicket.Publico = true;
            mst_ComentariosTicket.IdUsuarioComentarioMv = idUser;
            mst_ComentariosTicket.IdEstatusTicket = mst_Ticket.IdEstatusTicket;

            if (mst_Ticket.IdPrioridadTicket.HasValue)
            {
                mst_ComentariosTicket.IdProcesoAtencionTicket = mst_Ticket.IdProcesoAtencionTicket.Value;
                mst_ComentariosTicket.IdPrioridadTicket = mst_Ticket.IdPrioridadTicket.Value;
                mst_ComentariosTicket.IdUsuarioAsignado = mst_Ticket.IdUsuarioAsignado.Value;
            }
            else
            {
                mst_ComentariosTicket.IdProcesoAtencionTicket = db.Mst_ProcesoAtencionTicket.Where(t => t.ProcesoAtencionTicket == "En línea").Select(s => s.IdProcesoAtencionTicket).FirstOrDefault();
                mst_ComentariosTicket.IdPrioridadTicket = db.Mst_PrioridadTicket.Where(t => t.PrioridadTicket == "Baja").Select(s => s.IdPrioridadTicket).FirstOrDefault();
                mst_ComentariosTicket.IdUsuarioAsignado = idUser;
            }

            ModelState["IdProcesoAtencionTicket"].Errors.Clear();
            ModelState["IdPrioridadTicket"].Errors.Clear();
            ModelState["IdEstatusTicket"].Errors.Clear();
            ModelState["IdUsuarioAsignado"].Errors.Clear();

            
            //ModelState["IdUsuarioAsignado"].Errors.Clear();
            if (ModelState.IsValid)
            {
                
                db.Mst_ComentariosTicket.Add(mst_ComentariosTicket);
                db.SaveChanges();

                var result = new { value_e = "esuccess", msg = "Se ha añadido un comentario.", IdTicket=mst_Ticket.IdTicket };
                return Json(result, JsonRequestBehavior.AllowGet);

            }

            foreach (var item in ModelState.Values.SelectMany(v => v.Errors).Select(v => v.ErrorMessage + " " + v.Exception).ToList())
            {
                ModelState.AddModelError(string.Empty, item.ToString());
            }


            return PartialView("_ChatsUserForm",mst_ComentariosTicket);
        }

        // GET: MstComentariosTicket/Edit/5
        //public ActionResult Edit(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_ComentariosTicket mst_ComentariosTicket = db.Mst_ComentariosTicket.Find(id);
        //    if (mst_ComentariosTicket == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    ViewBag.IdTicket = new SelectList(db.Mst_Ticket, "IdTicket", "Incidente", mst_ComentariosTicket.IdTicket);
        //    ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket", mst_ComentariosTicket.IdEstatusTicket);
        //    ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket", mst_ComentariosTicket.IdPrioridadTicket);
        //    ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_ComentariosTicket.IdProcesoAtencionTicket);
        //    return View(mst_ComentariosTicket);
        //}

        // POST: MstComentariosTicket/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        //[HttpPost]
        //[ValidateAntiForgeryToken]
        //public ActionResult Edit([Bind(Include = "IdComentarioMv,Comentario,FechaComentarioMv,Publico,IdUsuarioComentarioMv,IdTicket,IdProcesoAtencionTicket,IdPrioridadTicket,IdEstatusTicket,IdUsuarioAsignado")] Mst_ComentariosTicket mst_ComentariosTicket)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        db.Entry(mst_ComentariosTicket).State = EntityState.Modified;
        //        db.SaveChanges();
        //        return RedirectToAction("Index");
        //    }
        //    ViewBag.IdTicket = new SelectList(db.Mst_Ticket, "IdTicket", "Incidente", mst_ComentariosTicket.IdTicket);
        //    ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket", mst_ComentariosTicket.IdEstatusTicket);
        //    ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket", mst_ComentariosTicket.IdPrioridadTicket);
        //    ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_ComentariosTicket.IdProcesoAtencionTicket);
        //    return View(mst_ComentariosTicket);
        //}

        // GET: MstComentariosTicket/Delete/5
        //public ActionResult Delete(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_ComentariosTicket mst_ComentariosTicket = db.Mst_ComentariosTicket.Find(id);
        //    if (mst_ComentariosTicket == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(mst_ComentariosTicket);
        //}

        // POST: MstComentariosTicket/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        //public ActionResult DeleteConfirmed(int id)
        //{
        //    Mst_ComentariosTicket mst_ComentariosTicket = db.Mst_ComentariosTicket.Find(id);
        //    db.Mst_ComentariosTicket.Remove(mst_ComentariosTicket);
        //    db.SaveChanges();
        //    return RedirectToAction("Index");
        //}

        //protected override void Dispose(bool disposing)
        //{
        //    if (disposing)
        //    {
        //        db.Dispose();
        //    }
        //    base.Dispose(disposing);
        //}


        //consultar comentarios que se conversan con el usuario
        public ActionResult GetComentariosUser(int id)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var comentario = db.Mst_ComentariosTicket.Where(t => t.IdTicket == id && t.Publico == true);

            MstComentariosUserTicket modelo = new MstComentariosUserTicket();
            modelo.Comentarios = comentario.ToList();
            modelo.EstatusTicket = db.Mst_Ticket.Find(id).Mst_EstatusTicket.EstatusTicket;
            modelo.IdTicket = db.Mst_Ticket.Find(id).IdTicket;


            ViewBag.IdUsuarioLogin = idUser;
            return PartialView("_ComentariosUser", modelo);
        }

        public ActionResult GetComentariosUserUpdate(int id)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var comentario = db.Mst_ComentariosTicket.Where(t => t.IdTicket == id && t.Publico == true);

            //MstComentariosUserTicket modelo = new MstComentariosUserTicket();
            //modelo.Comentarios = comentario.ToList();
            //modelo.EstatusTicket = db.Mst_Ticket.Find(id).Mst_EstatusTicket.EstatusTicket;


            ViewBag.IdUsuarioLogin = idUser;
            return PartialView("_ComentariosUserUpdate", comentario);
        }


    }
}
